/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.jdbc;

import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnection;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcMigrationEngine;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class ClickhouseLiquibaseJdbcMigrationEngine
implements JdbcMigrationEngine,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClickhouseLiquibaseJdbcMigrationEngine.class);
    private static volatile boolean isLiquibaseActivated = false;
    private final JdbcConnection jdbcConnection;

    public ClickhouseLiquibaseJdbcMigrationEngine(JdbcConnection jdbcConnection) {
        this.jdbcConnection = jdbcConnection;
    }

    private static void prepareLiquibase(Database database, List<String> locations, LiquibaseRunner liquibaseConsumer) {
        try {
            boolean julEnabled;
            List<String> changeLogLocations;
            List<String> list = changeLogLocations = locations.isEmpty() ? List.of("db/changelog.sql") : locations;
            if (!isLiquibaseActivated && (julEnabled = Optional.ofNullable(System.getenv("TEST_CONTAINERS_EXTENSION_JDBC_JUL_ENABLED")).map(Boolean::parseBoolean).orElse(true).booleanValue())) {
                SLF4JBridgeHandler.removeHandlersForRootLogger();
                SLF4JBridgeHandler.install();
                isLiquibaseActivated = true;
            }
            try (ClassLoaderResourceAccessor classLoaderResourceAccessor = new ClassLoaderResourceAccessor();){
                for (String changeLog : changeLogLocations) {
                    Liquibase liquibase = new Liquibase(changeLog, (ResourceAccessor)classLoaderResourceAccessor, database);
                    Path tmpFile = Files.createTempFile("liquibase-changelog-output", ".txt", new FileAttribute[0]);
                    try (FileWriter writer = new FileWriter(tmpFile.toFile());){
                        liquibaseConsumer.apply(liquibase, writer);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void migrateLiquibase(Database database, List<String> locations) {
        ClickhouseLiquibaseJdbcMigrationEngine.prepareLiquibase(database, locations, (liquibase, writer) -> {
            Contexts contexts = new Contexts();
            LabelExpression labelExpression = new LabelExpression();
            List changeSetStatuses = liquibase.getChangeSetStatuses(contexts, labelExpression, true);
            if (!changeSetStatuses.isEmpty()) {
                liquibase.update();
                database.commit();
            }
        });
    }

    private static void dropLiquibase(Database database, List<String> locations) {
        ClickhouseLiquibaseJdbcMigrationEngine.prepareLiquibase(database, locations, (liquibase, writer) -> {
            liquibase.dropAll();
            database.commit();
        });
    }

    public void apply(@NotNull List<String> locations) {
        logger.debug("Starting migration apply for engine '{}' for connection: {}", (Object)this.getClass().getSimpleName(), (Object)this.jdbcConnection);
        try {
            Connection connection = this.jdbcConnection.openConnection();
            try (Database database = this.getLiquiDatabase(connection);){
                ClickhouseLiquibaseJdbcMigrationEngine.migrateLiquibase(database, locations);
            }
        }
        catch (Exception e) {
            try {
                Thread.sleep(250L);
                Connection connection = this.jdbcConnection.openConnection();
                try (Database database = this.getLiquiDatabase(connection);){
                    ClickhouseLiquibaseJdbcMigrationEngine.migrateLiquibase(database, locations);
                }
            }
            catch (Exception ex) {
                logger.error("Failed migration apply for engine '{}' for connection: {}", (Object)this.getClass().getSimpleName(), (Object)this.jdbcConnection);
                throw new IllegalStateException(ex);
            }
        }
        logger.info("Finished migration apply for engine '{}' for connection: {}", (Object)this.getClass().getSimpleName(), (Object)this.jdbcConnection);
    }

    public void drop(@NotNull List<String> locations) {
        logger.debug("Starting migration dropping for engine '{}' for connection: {}", (Object)this.getClass().getSimpleName(), (Object)this.jdbcConnection);
        String query = String.format("TRUNCATE DATABASE IF EXISTS %s;", this.jdbcConnection.params().database());
        try (Connection connection = this.jdbcConnection.openConnection();){
            Statement statement = connection.createStatement();
            statement.execute(query);
        }
        catch (Exception e) {
            try {
                Thread.sleep(250L);
                try (Connection connection2 = this.jdbcConnection.openConnection();){
                    Statement statement = connection2.createStatement();
                    statement.execute(query);
                }
            }
            catch (Exception ex) {
                logger.error("Failed migration drop for engine '{}' for connection: {}", (Object)this.getClass().getSimpleName(), (Object)this.jdbcConnection);
                throw new IllegalStateException(ex);
            }
        }
        logger.info("Finished migration dropping for engine '{}' for connection: {}", (Object)this.getClass().getSimpleName(), (Object)this.jdbcConnection);
    }

    private Database getLiquiDatabase(Connection connection) {
        try {
            liquibase.database.jvm.JdbcConnection liquiConnection = new liquibase.database.jvm.JdbcConnection(connection);
            return DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)liquiConnection);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
    }

    @FunctionalInterface
    private static interface LiquibaseRunner {
        public void apply(Liquibase var1, Writer var2) throws LiquibaseException;
    }
}

