/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.jdbc;

import io.goodforgod.testcontainers.extensions.ContainerContext;
import io.goodforgod.testcontainers.extensions.jdbc.ClickhouseConnectionImpl;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnection;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.clickhouse.ClickHouseContainer;

@ApiStatus.Internal
final class ClickhouseContext
implements ContainerContext<JdbcConnection> {
    private static final String PROTOCOL = "clickhouse";
    private static final int PORT = 8123;
    private static final String EXTERNAL_TEST_CLICKHOUSE_JDBC_URL = "EXTERNAL_TEST_CLICKHOUSE_JDBC_URL";
    private static final String EXTERNAL_TEST_CLICKHOUSE_USERNAME = "EXTERNAL_TEST_CLICKHOUSE_USERNAME";
    private static final String EXTERNAL_TEST_CLICKHOUSE_PASSWORD = "EXTERNAL_TEST_CLICKHOUSE_PASSWORD";
    private static final String EXTERNAL_TEST_CLICKHOUSE_HOST = "EXTERNAL_TEST_CLICKHOUSE_HOST";
    private static final String EXTERNAL_TEST_CLICKHOUSE_PORT = "EXTERNAL_TEST_CLICKHOUSE_PORT";
    private static final String EXTERNAL_TEST_CLICKHOUSE_DATABASE = "EXTERNAL_TEST_CLICKHOUSE_DATABASE";
    private volatile ClickhouseConnectionImpl connection;
    private final ClickHouseContainer container;

    ClickhouseContext(ClickHouseContainer container) {
        this.container = container;
    }

    @NotNull
    public JdbcConnection connection() {
        if (this.connection == null) {
            Optional<JdbcConnection> connectionExternal = ClickhouseContext.getConnectionExternal();
            if (connectionExternal.isEmpty() && !this.container.isRunning()) {
                throw new IllegalStateException("ClickhouseConnection can't be create for container that is not running");
            }
            JdbcConnection containerConnection = connectionExternal.orElseGet(() -> {
                String alias = (String)this.container.getNetworkAliases().get(this.container.getNetworkAliases().size() - 1);
                return ClickhouseConnectionImpl.forJDBC(this.container.getJdbcUrl(), this.container.getHost(), this.container.getMappedPort(8123), alias, 8123, this.container.getDatabaseName(), this.container.getUsername(), this.container.getPassword());
            });
            this.connection = (ClickhouseConnectionImpl)containerConnection;
        }
        return this.connection;
    }

    public void start() {
        Optional<JdbcConnection> connectionExternal = ClickhouseContext.getConnectionExternal();
        if (connectionExternal.isEmpty()) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.connection != null) {
            this.connection.stop();
            this.connection = null;
        }
        this.container.stop();
    }

    @NotNull
    private static Optional<JdbcConnection> getConnectionExternal() {
        String url = System.getenv(EXTERNAL_TEST_CLICKHOUSE_JDBC_URL);
        String host = System.getenv(EXTERNAL_TEST_CLICKHOUSE_HOST);
        String port = System.getenv(EXTERNAL_TEST_CLICKHOUSE_PORT);
        String user = System.getenv(EXTERNAL_TEST_CLICKHOUSE_USERNAME);
        String password = System.getenv(EXTERNAL_TEST_CLICKHOUSE_PASSWORD);
        String db = Optional.ofNullable(System.getenv(EXTERNAL_TEST_CLICKHOUSE_DATABASE)).orElse("default");
        if (url != null) {
            if (host != null && port != null) {
                return Optional.of(ClickhouseConnectionImpl.forJDBC(url, host, Integer.parseInt(port), null, null, db, user, password));
            }
            return Optional.of(ClickhouseConnectionImpl.forExternal(url, user, password));
        }
        if (host != null && port != null) {
            return Optional.of(ClickhouseConnectionImpl.forProtocol(PROTOCOL, host, Integer.parseInt(port), db, user, password));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.container.getDockerImageName();
    }
}

