/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.jdbc;

import io.goodforgod.testcontainers.extensions.jdbc.ClickhouseLiquibaseJdbcMigrationEngine;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnection;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnectionImpl;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcMigrationEngine;
import io.goodforgod.testcontainers.extensions.jdbc.Migration;
import java.net.URI;
import org.jetbrains.annotations.NotNull;

class ClickhouseConnectionImpl
extends JdbcConnectionImpl {
    private volatile ClickhouseLiquibaseJdbcMigrationEngine liquibaseJdbcMigrationEngine;

    ClickhouseConnectionImpl(JdbcConnection.Params params, JdbcConnection.Params network) {
        super(params, network);
    }

    static ClickhouseConnectionImpl forProtocol(String driverProtocol, String host, int port, String database, String username, String password) {
        String jdbcUrl = String.format("jdbc:%s://%s:%d/%s", driverProtocol, host, port, database);
        JdbcConnectionImpl.ParamsImpl params = new JdbcConnectionImpl.ParamsImpl(jdbcUrl, host, port, database, username, password);
        return new ClickhouseConnectionImpl((JdbcConnection.Params)params, null);
    }

    static ClickhouseConnectionImpl forJDBC(String jdbcUrl, String host, int port, String hostInNetwork, Integer portInNetwork, String database, String username, String password) {
        JdbcConnectionImpl.ParamsImpl network;
        JdbcConnectionImpl.ParamsImpl params = new JdbcConnectionImpl.ParamsImpl(jdbcUrl, host, port, database, username, password);
        if (hostInNetwork == null) {
            network = null;
        } else {
            String jdbcUrlInNetwork = jdbcUrl.replace(host + ":" + port, hostInNetwork + ":" + portInNetwork);
            network = new JdbcConnectionImpl.ParamsImpl(jdbcUrlInNetwork, hostInNetwork, portInNetwork.intValue(), database, username, password);
        }
        return new ClickhouseConnectionImpl((JdbcConnection.Params)params, (JdbcConnection.Params)network);
    }

    static ClickhouseConnectionImpl forExternal(String jdbcUrl, String username, String password) {
        URI uri = URI.create(jdbcUrl);
        String host = uri.getHost();
        int port = uri.getPort();
        int dbSeparator = uri.getPath().indexOf(59);
        String database = dbSeparator == -1 ? uri.getPath() : uri.getPath().substring(0, dbSeparator);
        JdbcConnectionImpl.ParamsImpl params = new JdbcConnectionImpl.ParamsImpl(jdbcUrl, host, port, database, username, password);
        return new ClickhouseConnectionImpl((JdbcConnection.Params)params, null);
    }

    @NotNull
    public JdbcMigrationEngine migrationEngine(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Migration.Engines engine) {
        if (engine == Migration.Engines.LIQUIBASE) {
            if (this.liquibaseJdbcMigrationEngine == null) {
                this.liquibaseJdbcMigrationEngine = new ClickhouseLiquibaseJdbcMigrationEngine((JdbcConnection)this);
            }
            return this.liquibaseJdbcMigrationEngine;
        }
        return super.migrationEngine(engine);
    }
}

