// Code generated by Wire protocol buffer compiler, do not edit.
// Source: stream.video.sfu.event.SfuEvent in video/sfu/event/events.proto
package stream.video.sfu.event

import com.squareup.wire.FieldEncoding
import com.squareup.wire.Message
import com.squareup.wire.ProtoAdapter
import com.squareup.wire.ProtoReader
import com.squareup.wire.ProtoWriter
import com.squareup.wire.ReverseProtoWriter
import com.squareup.wire.Syntax.PROTO_3
import com.squareup.wire.WireField
import com.squareup.wire.`internal`.countNonNull
import kotlin.Any
import kotlin.AssertionError
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.DeprecationLevel
import kotlin.Int
import kotlin.Long
import kotlin.Nothing
import kotlin.String
import kotlin.Unit
import kotlin.jvm.JvmField
import okio.ByteString
import stream.video.sfu.models.ICETrickle

/**
 * SFUEvent is a message that is sent from the SFU to the client.
 */
public class SfuEvent(
  /**
   * SubscriberOffer sends the SDP offer for establishing the
   * subscriber PeerConnection.
   */
  @field:WireField(
    tag = 1,
    adapter = "stream.video.sfu.event.SubscriberOffer#ADAPTER",
    jsonName = "subscriberOffer",
    oneofName = "event_payload",
  )
  public val subscriber_offer: SubscriberOffer? = null,
  /**
   * PublisherAnswer sends the SDP answer to the offer sent by
   * the client for establishing the Publisher PeerConnection.
   */
  @field:WireField(
    tag = 2,
    adapter = "stream.video.sfu.event.PublisherAnswer#ADAPTER",
    jsonName = "publisherAnswer",
    oneofName = "event_payload",
  )
  public val publisher_answer: PublisherAnswer? = null,
  /**
   * ConnectionQualityChanged is sent to inform the connection
   * quality of the participants in the call. It does not have
   * to contain the full list of call participants in it.
   */
  @field:WireField(
    tag = 3,
    adapter = "stream.video.sfu.event.ConnectionQualityChanged#ADAPTER",
    jsonName = "connectionQualityChanged",
    oneofName = "event_payload",
  )
  public val connection_quality_changed: ConnectionQualityChanged? = null,
  /**
   * AudioLevelChanged is sent for change in audio levels of
   * the participants.
   */
  @field:WireField(
    tag = 4,
    adapter = "stream.video.sfu.event.AudioLevelChanged#ADAPTER",
    jsonName = "audioLevelChanged",
    oneofName = "event_payload",
  )
  public val audio_level_changed: AudioLevelChanged? = null,
  /**
   * ICETrickle contains the ICE candidate required to establish
   * the ICE transport: part of establishing the PeerConnection
   * and also for ICE restarts.
   */
  @field:WireField(
    tag = 5,
    adapter = "stream.video.sfu.models.ICETrickle#ADAPTER",
    jsonName = "iceTrickle",
    oneofName = "event_payload",
  )
  public val ice_trickle: ICETrickle? = null,
  /**
   * ChangePublishQuality advises the publisher to switch on/off
   * various qualities of their video stream based on the subscription.
   * This is done to save the bandwidth and the CPU of the publisher.
   */
  @field:WireField(
    tag = 6,
    adapter = "stream.video.sfu.event.ChangePublishQuality#ADAPTER",
    jsonName = "changePublishQuality",
    oneofName = "event_payload",
  )
  public val change_publish_quality: ChangePublishQuality? = null,
  /**
   * ParticipantJoined notifies the client that a new participant
   * has joined the call. This is not sent for anonymous users.
   */
  @field:WireField(
    tag = 10,
    adapter = "stream.video.sfu.event.ParticipantJoined#ADAPTER",
    jsonName = "participantJoined",
    oneofName = "event_payload",
  )
  public val participant_joined: ParticipantJoined? = null,
  /**
   * ParticipantLeft notifies the client that a call participant
   * has left the call. This is not sent for anonymous users.
   */
  @field:WireField(
    tag = 11,
    adapter = "stream.video.sfu.event.ParticipantLeft#ADAPTER",
    jsonName = "participantLeft",
    oneofName = "event_payload",
  )
  public val participant_left: ParticipantLeft? = null,
  /**
   * DominantSpeakerChanged notifies the client about the current
   * dominant speaker. This is required for certain use cases like
   * the spotlight view.
   */
  @field:WireField(
    tag = 12,
    adapter = "stream.video.sfu.event.DominantSpeakerChanged#ADAPTER",
    jsonName = "dominantSpeakerChanged",
    oneofName = "event_payload",
  )
  public val dominant_speaker_changed: DominantSpeakerChanged? = null,
  /**
   * JoinResponse acknowledges a participant successfully joining
   * the call. This is sent in response to the JoinRequest.
   */
  @field:WireField(
    tag = 13,
    adapter = "stream.video.sfu.event.JoinResponse#ADAPTER",
    jsonName = "joinResponse",
    oneofName = "event_payload",
  )
  public val join_response: JoinResponse? = null,
  /**
   * HealthCheckResponse is sent in response to the HealthCheckRequest.
   * It contains the participant count in the call.
   */
  @field:WireField(
    tag = 14,
    adapter = "stream.video.sfu.event.HealthCheckResponse#ADAPTER",
    jsonName = "healthCheckResponse",
    oneofName = "event_payload",
  )
  public val health_check_response: HealthCheckResponse? = null,
  /**
   * TrackPublished is sent when a new track (like audio, video, screenshare)
   * is published by a participant in the call. It is also sent on mute/unmute.
   */
  @field:WireField(
    tag = 16,
    adapter = "stream.video.sfu.event.TrackPublished#ADAPTER",
    jsonName = "trackPublished",
    oneofName = "event_payload",
  )
  public val track_published: TrackPublished? = null,
  /**
   * TrackUnpublished is sent when a track (like audio, video, screenshare)
   * is no longer published. It is sent on muting a track or when the participant
   * is leaving the call.
   */
  @field:WireField(
    tag = 17,
    adapter = "stream.video.sfu.event.TrackUnpublished#ADAPTER",
    jsonName = "trackUnpublished",
    oneofName = "event_payload",
  )
  public val track_unpublished: TrackUnpublished? = null,
  /**
   * Error is used to communicate any error related to the participant. The
   * error code and the message explain what went wrong. Whether the participant
   * can retry is also indicated.
   */
  @field:WireField(
    tag = 18,
    adapter = "stream.video.sfu.event.Error#ADAPTER",
    oneofName = "event_payload",
  )
  public val error: Error? = null,
  /**
   * CallGrantsUpdated tells what tracks a participant is allowed to publish.
   */
  @field:WireField(
    tag = 19,
    adapter = "stream.video.sfu.event.CallGrantsUpdated#ADAPTER",
    jsonName = "callGrantsUpdated",
    oneofName = "event_payload",
  )
  public val call_grants_updated: CallGrantsUpdated? = null,
  /**
   * GoAway tells the client to migrate away from the SFU it is connected to.
   * The reason field indicates why this message was sent.
   */
  @field:WireField(
    tag = 20,
    adapter = "stream.video.sfu.event.GoAway#ADAPTER",
    jsonName = "goAway",
    oneofName = "event_payload",
  )
  public val go_away: GoAway? = null,
  /**
   * ICERestart tells the client to perform ICE restart.
   */
  @field:WireField(
    tag = 21,
    adapter = "stream.video.sfu.event.ICERestart#ADAPTER",
    jsonName = "iceRestart",
    oneofName = "event_payload",
  )
  public val ice_restart: ICERestart? = null,
  /**
   * PinsChanged is sent the list of pins in the call changes. This event contains the entire list
   * of pins.
   */
  @field:WireField(
    tag = 22,
    adapter = "stream.video.sfu.event.PinsChanged#ADAPTER",
    jsonName = "pinsUpdated",
    oneofName = "event_payload",
  )
  public val pins_updated: PinsChanged? = null,
  /**
   * CallEnded is sent by the SFU to the client to signal that the call has ended.
   * The reason may specify why the call has ended.
   */
  @field:WireField(
    tag = 23,
    adapter = "stream.video.sfu.event.CallEnded#ADAPTER",
    jsonName = "callEnded",
    oneofName = "event_payload",
  )
  public val call_ended: CallEnded? = null,
  /**
   * ParticipantUpdated is sent when user data is updated
   */
  @field:WireField(
    tag = 24,
    adapter = "stream.video.sfu.event.ParticipantUpdated#ADAPTER",
    jsonName = "participantUpdated",
    oneofName = "event_payload",
  )
  public val participant_updated: ParticipantUpdated? = null,
  unknownFields: ByteString = ByteString.EMPTY,
) : Message<SfuEvent, Nothing>(ADAPTER, unknownFields) {
  init {
    require(countNonNull(subscriber_offer, publisher_answer, connection_quality_changed,
        audio_level_changed, ice_trickle, change_publish_quality, participant_joined,
        participant_left, dominant_speaker_changed, join_response, health_check_response,
        track_published, track_unpublished, error, call_grants_updated, go_away, ice_restart,
        pins_updated, call_ended, participant_updated) <= 1) {
      "At most one of subscriber_offer, publisher_answer, connection_quality_changed, audio_level_changed, ice_trickle, change_publish_quality, participant_joined, participant_left, dominant_speaker_changed, join_response, health_check_response, track_published, track_unpublished, error, call_grants_updated, go_away, ice_restart, pins_updated, call_ended, participant_updated may be non-null"
    }
  }

  @Deprecated(
    message = "Shouldn't be used in Kotlin",
    level = DeprecationLevel.HIDDEN,
  )
  public override fun newBuilder(): Nothing = throw
      AssertionError("Builders are deprecated and only available in a javaInterop build; see https://square.github.io/wire/wire_compiler/#kotlin")

  public override fun equals(other: Any?): Boolean {
    if (other === this) return true
    if (other !is SfuEvent) return false
    if (unknownFields != other.unknownFields) return false
    if (subscriber_offer != other.subscriber_offer) return false
    if (publisher_answer != other.publisher_answer) return false
    if (connection_quality_changed != other.connection_quality_changed) return false
    if (audio_level_changed != other.audio_level_changed) return false
    if (ice_trickle != other.ice_trickle) return false
    if (change_publish_quality != other.change_publish_quality) return false
    if (participant_joined != other.participant_joined) return false
    if (participant_left != other.participant_left) return false
    if (dominant_speaker_changed != other.dominant_speaker_changed) return false
    if (join_response != other.join_response) return false
    if (health_check_response != other.health_check_response) return false
    if (track_published != other.track_published) return false
    if (track_unpublished != other.track_unpublished) return false
    if (error != other.error) return false
    if (call_grants_updated != other.call_grants_updated) return false
    if (go_away != other.go_away) return false
    if (ice_restart != other.ice_restart) return false
    if (pins_updated != other.pins_updated) return false
    if (call_ended != other.call_ended) return false
    if (participant_updated != other.participant_updated) return false
    return true
  }

  public override fun hashCode(): Int {
    var result = super.hashCode
    if (result == 0) {
      result = unknownFields.hashCode()
      result = result * 37 + (subscriber_offer?.hashCode() ?: 0)
      result = result * 37 + (publisher_answer?.hashCode() ?: 0)
      result = result * 37 + (connection_quality_changed?.hashCode() ?: 0)
      result = result * 37 + (audio_level_changed?.hashCode() ?: 0)
      result = result * 37 + (ice_trickle?.hashCode() ?: 0)
      result = result * 37 + (change_publish_quality?.hashCode() ?: 0)
      result = result * 37 + (participant_joined?.hashCode() ?: 0)
      result = result * 37 + (participant_left?.hashCode() ?: 0)
      result = result * 37 + (dominant_speaker_changed?.hashCode() ?: 0)
      result = result * 37 + (join_response?.hashCode() ?: 0)
      result = result * 37 + (health_check_response?.hashCode() ?: 0)
      result = result * 37 + (track_published?.hashCode() ?: 0)
      result = result * 37 + (track_unpublished?.hashCode() ?: 0)
      result = result * 37 + (error?.hashCode() ?: 0)
      result = result * 37 + (call_grants_updated?.hashCode() ?: 0)
      result = result * 37 + (go_away?.hashCode() ?: 0)
      result = result * 37 + (ice_restart?.hashCode() ?: 0)
      result = result * 37 + (pins_updated?.hashCode() ?: 0)
      result = result * 37 + (call_ended?.hashCode() ?: 0)
      result = result * 37 + (participant_updated?.hashCode() ?: 0)
      super.hashCode = result
    }
    return result
  }

  public override fun toString(): String {
    val result = mutableListOf<String>()
    if (subscriber_offer != null) result += """subscriber_offer=$subscriber_offer"""
    if (publisher_answer != null) result += """publisher_answer=$publisher_answer"""
    if (connection_quality_changed != null) result +=
        """connection_quality_changed=$connection_quality_changed"""
    if (audio_level_changed != null) result += """audio_level_changed=$audio_level_changed"""
    if (ice_trickle != null) result += """ice_trickle=$ice_trickle"""
    if (change_publish_quality != null) result +=
        """change_publish_quality=$change_publish_quality"""
    if (participant_joined != null) result += """participant_joined=$participant_joined"""
    if (participant_left != null) result += """participant_left=$participant_left"""
    if (dominant_speaker_changed != null) result +=
        """dominant_speaker_changed=$dominant_speaker_changed"""
    if (join_response != null) result += """join_response=$join_response"""
    if (health_check_response != null) result += """health_check_response=$health_check_response"""
    if (track_published != null) result += """track_published=$track_published"""
    if (track_unpublished != null) result += """track_unpublished=$track_unpublished"""
    if (error != null) result += """error=$error"""
    if (call_grants_updated != null) result += """call_grants_updated=$call_grants_updated"""
    if (go_away != null) result += """go_away=$go_away"""
    if (ice_restart != null) result += """ice_restart=$ice_restart"""
    if (pins_updated != null) result += """pins_updated=$pins_updated"""
    if (call_ended != null) result += """call_ended=$call_ended"""
    if (participant_updated != null) result += """participant_updated=$participant_updated"""
    return result.joinToString(prefix = "SfuEvent{", separator = ", ", postfix = "}")
  }

  public fun copy(
    subscriber_offer: SubscriberOffer? = this.subscriber_offer,
    publisher_answer: PublisherAnswer? = this.publisher_answer,
    connection_quality_changed: ConnectionQualityChanged? = this.connection_quality_changed,
    audio_level_changed: AudioLevelChanged? = this.audio_level_changed,
    ice_trickle: ICETrickle? = this.ice_trickle,
    change_publish_quality: ChangePublishQuality? = this.change_publish_quality,
    participant_joined: ParticipantJoined? = this.participant_joined,
    participant_left: ParticipantLeft? = this.participant_left,
    dominant_speaker_changed: DominantSpeakerChanged? = this.dominant_speaker_changed,
    join_response: JoinResponse? = this.join_response,
    health_check_response: HealthCheckResponse? = this.health_check_response,
    track_published: TrackPublished? = this.track_published,
    track_unpublished: TrackUnpublished? = this.track_unpublished,
    error: Error? = this.error,
    call_grants_updated: CallGrantsUpdated? = this.call_grants_updated,
    go_away: GoAway? = this.go_away,
    ice_restart: ICERestart? = this.ice_restart,
    pins_updated: PinsChanged? = this.pins_updated,
    call_ended: CallEnded? = this.call_ended,
    participant_updated: ParticipantUpdated? = this.participant_updated,
    unknownFields: ByteString = this.unknownFields,
  ): SfuEvent = SfuEvent(subscriber_offer, publisher_answer, connection_quality_changed,
      audio_level_changed, ice_trickle, change_publish_quality, participant_joined,
      participant_left, dominant_speaker_changed, join_response, health_check_response,
      track_published, track_unpublished, error, call_grants_updated, go_away, ice_restart,
      pins_updated, call_ended, participant_updated, unknownFields)

  public companion object {
    @JvmField
    public val ADAPTER: ProtoAdapter<SfuEvent> = object : ProtoAdapter<SfuEvent>(
      FieldEncoding.LENGTH_DELIMITED, 
      SfuEvent::class, 
      "type.googleapis.com/stream.video.sfu.event.SfuEvent", 
      PROTO_3, 
      null, 
      "video/sfu/event/events.proto"
    ) {
      public override fun encodedSize(`value`: SfuEvent): Int {
        var size = value.unknownFields.size
        size += SubscriberOffer.ADAPTER.encodedSizeWithTag(1, value.subscriber_offer)
        size += PublisherAnswer.ADAPTER.encodedSizeWithTag(2, value.publisher_answer)
        size += ConnectionQualityChanged.ADAPTER.encodedSizeWithTag(3,
            value.connection_quality_changed)
        size += AudioLevelChanged.ADAPTER.encodedSizeWithTag(4, value.audio_level_changed)
        size += ICETrickle.ADAPTER.encodedSizeWithTag(5, value.ice_trickle)
        size += ChangePublishQuality.ADAPTER.encodedSizeWithTag(6, value.change_publish_quality)
        size += ParticipantJoined.ADAPTER.encodedSizeWithTag(10, value.participant_joined)
        size += ParticipantLeft.ADAPTER.encodedSizeWithTag(11, value.participant_left)
        size += DominantSpeakerChanged.ADAPTER.encodedSizeWithTag(12,
            value.dominant_speaker_changed)
        size += JoinResponse.ADAPTER.encodedSizeWithTag(13, value.join_response)
        size += HealthCheckResponse.ADAPTER.encodedSizeWithTag(14, value.health_check_response)
        size += TrackPublished.ADAPTER.encodedSizeWithTag(16, value.track_published)
        size += TrackUnpublished.ADAPTER.encodedSizeWithTag(17, value.track_unpublished)
        size += Error.ADAPTER.encodedSizeWithTag(18, value.error)
        size += CallGrantsUpdated.ADAPTER.encodedSizeWithTag(19, value.call_grants_updated)
        size += GoAway.ADAPTER.encodedSizeWithTag(20, value.go_away)
        size += ICERestart.ADAPTER.encodedSizeWithTag(21, value.ice_restart)
        size += PinsChanged.ADAPTER.encodedSizeWithTag(22, value.pins_updated)
        size += CallEnded.ADAPTER.encodedSizeWithTag(23, value.call_ended)
        size += ParticipantUpdated.ADAPTER.encodedSizeWithTag(24, value.participant_updated)
        return size
      }

      public override fun encode(writer: ProtoWriter, `value`: SfuEvent): Unit {
        SubscriberOffer.ADAPTER.encodeWithTag(writer, 1, value.subscriber_offer)
        PublisherAnswer.ADAPTER.encodeWithTag(writer, 2, value.publisher_answer)
        ConnectionQualityChanged.ADAPTER.encodeWithTag(writer, 3, value.connection_quality_changed)
        AudioLevelChanged.ADAPTER.encodeWithTag(writer, 4, value.audio_level_changed)
        ICETrickle.ADAPTER.encodeWithTag(writer, 5, value.ice_trickle)
        ChangePublishQuality.ADAPTER.encodeWithTag(writer, 6, value.change_publish_quality)
        ParticipantJoined.ADAPTER.encodeWithTag(writer, 10, value.participant_joined)
        ParticipantLeft.ADAPTER.encodeWithTag(writer, 11, value.participant_left)
        DominantSpeakerChanged.ADAPTER.encodeWithTag(writer, 12, value.dominant_speaker_changed)
        JoinResponse.ADAPTER.encodeWithTag(writer, 13, value.join_response)
        HealthCheckResponse.ADAPTER.encodeWithTag(writer, 14, value.health_check_response)
        TrackPublished.ADAPTER.encodeWithTag(writer, 16, value.track_published)
        TrackUnpublished.ADAPTER.encodeWithTag(writer, 17, value.track_unpublished)
        Error.ADAPTER.encodeWithTag(writer, 18, value.error)
        CallGrantsUpdated.ADAPTER.encodeWithTag(writer, 19, value.call_grants_updated)
        GoAway.ADAPTER.encodeWithTag(writer, 20, value.go_away)
        ICERestart.ADAPTER.encodeWithTag(writer, 21, value.ice_restart)
        PinsChanged.ADAPTER.encodeWithTag(writer, 22, value.pins_updated)
        CallEnded.ADAPTER.encodeWithTag(writer, 23, value.call_ended)
        ParticipantUpdated.ADAPTER.encodeWithTag(writer, 24, value.participant_updated)
        writer.writeBytes(value.unknownFields)
      }

      public override fun encode(writer: ReverseProtoWriter, `value`: SfuEvent): Unit {
        writer.writeBytes(value.unknownFields)
        ParticipantUpdated.ADAPTER.encodeWithTag(writer, 24, value.participant_updated)
        CallEnded.ADAPTER.encodeWithTag(writer, 23, value.call_ended)
        PinsChanged.ADAPTER.encodeWithTag(writer, 22, value.pins_updated)
        ICERestart.ADAPTER.encodeWithTag(writer, 21, value.ice_restart)
        GoAway.ADAPTER.encodeWithTag(writer, 20, value.go_away)
        CallGrantsUpdated.ADAPTER.encodeWithTag(writer, 19, value.call_grants_updated)
        Error.ADAPTER.encodeWithTag(writer, 18, value.error)
        TrackUnpublished.ADAPTER.encodeWithTag(writer, 17, value.track_unpublished)
        TrackPublished.ADAPTER.encodeWithTag(writer, 16, value.track_published)
        HealthCheckResponse.ADAPTER.encodeWithTag(writer, 14, value.health_check_response)
        JoinResponse.ADAPTER.encodeWithTag(writer, 13, value.join_response)
        DominantSpeakerChanged.ADAPTER.encodeWithTag(writer, 12, value.dominant_speaker_changed)
        ParticipantLeft.ADAPTER.encodeWithTag(writer, 11, value.participant_left)
        ParticipantJoined.ADAPTER.encodeWithTag(writer, 10, value.participant_joined)
        ChangePublishQuality.ADAPTER.encodeWithTag(writer, 6, value.change_publish_quality)
        ICETrickle.ADAPTER.encodeWithTag(writer, 5, value.ice_trickle)
        AudioLevelChanged.ADAPTER.encodeWithTag(writer, 4, value.audio_level_changed)
        ConnectionQualityChanged.ADAPTER.encodeWithTag(writer, 3, value.connection_quality_changed)
        PublisherAnswer.ADAPTER.encodeWithTag(writer, 2, value.publisher_answer)
        SubscriberOffer.ADAPTER.encodeWithTag(writer, 1, value.subscriber_offer)
      }

      public override fun decode(reader: ProtoReader): SfuEvent {
        var subscriber_offer: SubscriberOffer? = null
        var publisher_answer: PublisherAnswer? = null
        var connection_quality_changed: ConnectionQualityChanged? = null
        var audio_level_changed: AudioLevelChanged? = null
        var ice_trickle: ICETrickle? = null
        var change_publish_quality: ChangePublishQuality? = null
        var participant_joined: ParticipantJoined? = null
        var participant_left: ParticipantLeft? = null
        var dominant_speaker_changed: DominantSpeakerChanged? = null
        var join_response: JoinResponse? = null
        var health_check_response: HealthCheckResponse? = null
        var track_published: TrackPublished? = null
        var track_unpublished: TrackUnpublished? = null
        var error: Error? = null
        var call_grants_updated: CallGrantsUpdated? = null
        var go_away: GoAway? = null
        var ice_restart: ICERestart? = null
        var pins_updated: PinsChanged? = null
        var call_ended: CallEnded? = null
        var participant_updated: ParticipantUpdated? = null
        val unknownFields = reader.forEachTag { tag ->
          when (tag) {
            1 -> subscriber_offer = SubscriberOffer.ADAPTER.decode(reader)
            2 -> publisher_answer = PublisherAnswer.ADAPTER.decode(reader)
            3 -> connection_quality_changed = ConnectionQualityChanged.ADAPTER.decode(reader)
            4 -> audio_level_changed = AudioLevelChanged.ADAPTER.decode(reader)
            5 -> ice_trickle = ICETrickle.ADAPTER.decode(reader)
            6 -> change_publish_quality = ChangePublishQuality.ADAPTER.decode(reader)
            10 -> participant_joined = ParticipantJoined.ADAPTER.decode(reader)
            11 -> participant_left = ParticipantLeft.ADAPTER.decode(reader)
            12 -> dominant_speaker_changed = DominantSpeakerChanged.ADAPTER.decode(reader)
            13 -> join_response = JoinResponse.ADAPTER.decode(reader)
            14 -> health_check_response = HealthCheckResponse.ADAPTER.decode(reader)
            16 -> track_published = TrackPublished.ADAPTER.decode(reader)
            17 -> track_unpublished = TrackUnpublished.ADAPTER.decode(reader)
            18 -> error = Error.ADAPTER.decode(reader)
            19 -> call_grants_updated = CallGrantsUpdated.ADAPTER.decode(reader)
            20 -> go_away = GoAway.ADAPTER.decode(reader)
            21 -> ice_restart = ICERestart.ADAPTER.decode(reader)
            22 -> pins_updated = PinsChanged.ADAPTER.decode(reader)
            23 -> call_ended = CallEnded.ADAPTER.decode(reader)
            24 -> participant_updated = ParticipantUpdated.ADAPTER.decode(reader)
            else -> reader.readUnknownField(tag)
          }
        }
        return SfuEvent(
          subscriber_offer = subscriber_offer,
          publisher_answer = publisher_answer,
          connection_quality_changed = connection_quality_changed,
          audio_level_changed = audio_level_changed,
          ice_trickle = ice_trickle,
          change_publish_quality = change_publish_quality,
          participant_joined = participant_joined,
          participant_left = participant_left,
          dominant_speaker_changed = dominant_speaker_changed,
          join_response = join_response,
          health_check_response = health_check_response,
          track_published = track_published,
          track_unpublished = track_unpublished,
          error = error,
          call_grants_updated = call_grants_updated,
          go_away = go_away,
          ice_restart = ice_restart,
          pins_updated = pins_updated,
          call_ended = call_ended,
          participant_updated = participant_updated,
          unknownFields = unknownFields
        )
      }

      public override fun redact(`value`: SfuEvent): SfuEvent = value.copy(
        subscriber_offer = value.subscriber_offer?.let(SubscriberOffer.ADAPTER::redact),
        publisher_answer = value.publisher_answer?.let(PublisherAnswer.ADAPTER::redact),
        connection_quality_changed =
            value.connection_quality_changed?.let(ConnectionQualityChanged.ADAPTER::redact),
        audio_level_changed = value.audio_level_changed?.let(AudioLevelChanged.ADAPTER::redact),
        ice_trickle = value.ice_trickle?.let(ICETrickle.ADAPTER::redact),
        change_publish_quality =
            value.change_publish_quality?.let(ChangePublishQuality.ADAPTER::redact),
        participant_joined = value.participant_joined?.let(ParticipantJoined.ADAPTER::redact),
        participant_left = value.participant_left?.let(ParticipantLeft.ADAPTER::redact),
        dominant_speaker_changed =
            value.dominant_speaker_changed?.let(DominantSpeakerChanged.ADAPTER::redact),
        join_response = value.join_response?.let(JoinResponse.ADAPTER::redact),
        health_check_response =
            value.health_check_response?.let(HealthCheckResponse.ADAPTER::redact),
        track_published = value.track_published?.let(TrackPublished.ADAPTER::redact),
        track_unpublished = value.track_unpublished?.let(TrackUnpublished.ADAPTER::redact),
        error = value.error?.let(Error.ADAPTER::redact),
        call_grants_updated = value.call_grants_updated?.let(CallGrantsUpdated.ADAPTER::redact),
        go_away = value.go_away?.let(GoAway.ADAPTER::redact),
        ice_restart = value.ice_restart?.let(ICERestart.ADAPTER::redact),
        pins_updated = value.pins_updated?.let(PinsChanged.ADAPTER::redact),
        call_ended = value.call_ended?.let(CallEnded.ADAPTER::redact),
        participant_updated = value.participant_updated?.let(ParticipantUpdated.ADAPTER::redact),
        unknownFields = ByteString.EMPTY
      )
    }

    private const val serialVersionUID: Long = 0L
  }
}
