// Code generated by Wire protocol buffer compiler, do not edit.
// Source: stream.video.sfu.event.CallGrantsUpdated in video/sfu/event/events.proto
package stream.video.sfu.event

import com.squareup.wire.FieldEncoding
import com.squareup.wire.Message
import com.squareup.wire.ProtoAdapter
import com.squareup.wire.ProtoReader
import com.squareup.wire.ProtoWriter
import com.squareup.wire.ReverseProtoWriter
import com.squareup.wire.Syntax.PROTO_3
import com.squareup.wire.WireField
import com.squareup.wire.`internal`.sanitize
import kotlin.Any
import kotlin.AssertionError
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.DeprecationLevel
import kotlin.Int
import kotlin.Long
import kotlin.Nothing
import kotlin.String
import kotlin.Unit
import kotlin.jvm.JvmField
import okio.ByteString
import stream.video.sfu.models.CallGrants

/**
 * CallGrants is sent to users when there is a change in the call permissions
 * to publish audio, video or share the screen for a user or a role. This is
 * idempotent and can be sent at any time. Only the current_grants in the latest
 * message should be considered. In other words, this is not dependent on any
 * other message (including previous call_grants_updated message)
 *
 * When this message is received, the client (say, React component) should mute
 * the tracks which are not allowed anymore. For example, if the message has
 * grants {audio:true, video:false} while the user is publishing video, then the
 * client component should mute the video track and gray out the video button.
 * This way, the user will not be able to publish video until the permissions
 * are granted again. Also, muting the track on the client side will prevent
 * the SFU from receiving the video track and will save bandwidth.
 *
 * In simple words, this is exactly the same as muting a track on the client.
 * Here, instead of the user instructing the client, SFU would be doing it.
 */
public class CallGrantsUpdated(
  @field:WireField(
    tag = 1,
    adapter = "stream.video.sfu.models.CallGrants#ADAPTER",
    label = WireField.Label.OMIT_IDENTITY,
    jsonName = "currentGrants",
  )
  public val current_grants: CallGrants? = null,
  @field:WireField(
    tag = 2,
    adapter = "com.squareup.wire.ProtoAdapter#STRING",
    label = WireField.Label.OMIT_IDENTITY,
  )
  public val message: String = "",
  unknownFields: ByteString = ByteString.EMPTY,
) : Message<CallGrantsUpdated, Nothing>(ADAPTER, unknownFields) {
  @Deprecated(
    message = "Shouldn't be used in Kotlin",
    level = DeprecationLevel.HIDDEN,
  )
  public override fun newBuilder(): Nothing = throw
      AssertionError("Builders are deprecated and only available in a javaInterop build; see https://square.github.io/wire/wire_compiler/#kotlin")

  public override fun equals(other: Any?): Boolean {
    if (other === this) return true
    if (other !is CallGrantsUpdated) return false
    if (unknownFields != other.unknownFields) return false
    if (current_grants != other.current_grants) return false
    if (message != other.message) return false
    return true
  }

  public override fun hashCode(): Int {
    var result = super.hashCode
    if (result == 0) {
      result = unknownFields.hashCode()
      result = result * 37 + (current_grants?.hashCode() ?: 0)
      result = result * 37 + message.hashCode()
      super.hashCode = result
    }
    return result
  }

  public override fun toString(): String {
    val result = mutableListOf<String>()
    if (current_grants != null) result += """current_grants=$current_grants"""
    result += """message=${sanitize(message)}"""
    return result.joinToString(prefix = "CallGrantsUpdated{", separator = ", ", postfix = "}")
  }

  public fun copy(
    current_grants: CallGrants? = this.current_grants,
    message: String = this.message,
    unknownFields: ByteString = this.unknownFields,
  ): CallGrantsUpdated = CallGrantsUpdated(current_grants, message, unknownFields)

  public companion object {
    @JvmField
    public val ADAPTER: ProtoAdapter<CallGrantsUpdated> = object : ProtoAdapter<CallGrantsUpdated>(
      FieldEncoding.LENGTH_DELIMITED, 
      CallGrantsUpdated::class, 
      "type.googleapis.com/stream.video.sfu.event.CallGrantsUpdated", 
      PROTO_3, 
      null, 
      "video/sfu/event/events.proto"
    ) {
      public override fun encodedSize(`value`: CallGrantsUpdated): Int {
        var size = value.unknownFields.size
        if (value.current_grants != null) size += CallGrants.ADAPTER.encodedSizeWithTag(1,
            value.current_grants)
        if (value.message != "") size += ProtoAdapter.STRING.encodedSizeWithTag(2, value.message)
        return size
      }

      public override fun encode(writer: ProtoWriter, `value`: CallGrantsUpdated): Unit {
        if (value.current_grants != null) CallGrants.ADAPTER.encodeWithTag(writer, 1,
            value.current_grants)
        if (value.message != "") ProtoAdapter.STRING.encodeWithTag(writer, 2, value.message)
        writer.writeBytes(value.unknownFields)
      }

      public override fun encode(writer: ReverseProtoWriter, `value`: CallGrantsUpdated): Unit {
        writer.writeBytes(value.unknownFields)
        if (value.message != "") ProtoAdapter.STRING.encodeWithTag(writer, 2, value.message)
        if (value.current_grants != null) CallGrants.ADAPTER.encodeWithTag(writer, 1,
            value.current_grants)
      }

      public override fun decode(reader: ProtoReader): CallGrantsUpdated {
        var current_grants: CallGrants? = null
        var message: String = ""
        val unknownFields = reader.forEachTag { tag ->
          when (tag) {
            1 -> current_grants = CallGrants.ADAPTER.decode(reader)
            2 -> message = ProtoAdapter.STRING.decode(reader)
            else -> reader.readUnknownField(tag)
          }
        }
        return CallGrantsUpdated(
          current_grants = current_grants,
          message = message,
          unknownFields = unknownFields
        )
      }

      public override fun redact(`value`: CallGrantsUpdated): CallGrantsUpdated = value.copy(
        current_grants = value.current_grants?.let(CallGrants.ADAPTER::redact),
        unknownFields = ByteString.EMPTY
      )
    }

    private const val serialVersionUID: Long = 0L
  }
}
