// Code generated by Wire protocol buffer compiler, do not edit.
// Source: stream.video.sfu.models.CallState in video/sfu/models/models.proto
package stream.video.sfu.models

import com.squareup.wire.FieldEncoding
import com.squareup.wire.Instant
import com.squareup.wire.Message
import com.squareup.wire.ProtoAdapter
import com.squareup.wire.ProtoReader
import com.squareup.wire.ProtoWriter
import com.squareup.wire.ReverseProtoWriter
import com.squareup.wire.Syntax.PROTO_3
import com.squareup.wire.WireField
import com.squareup.wire.`internal`.immutableCopyOf
import com.squareup.wire.`internal`.redactElements
import kotlin.Any
import kotlin.AssertionError
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.DeprecationLevel
import kotlin.Int
import kotlin.Long
import kotlin.Nothing
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmField
import okio.ByteString

/**
 * CallState is the current state of the call
 * as seen by an SFU.
 */
public class CallState(
  participants: List<Participant> = emptyList(),
  /**
   * started_at is the time the call session actually started.
   */
  @field:WireField(
    tag = 2,
    adapter = "com.squareup.wire.ProtoAdapter#INSTANT",
    label = WireField.Label.OMIT_IDENTITY,
    jsonName = "startedAt",
  )
  public val started_at: Instant? = null,
  /**
   * participant_count contains the summary of the counts.
   */
  @field:WireField(
    tag = 3,
    adapter = "stream.video.sfu.models.ParticipantCount#ADAPTER",
    label = WireField.Label.OMIT_IDENTITY,
    jsonName = "participantCount",
  )
  public val participant_count: ParticipantCount? = null,
  pins: List<Pin> = emptyList(),
  unknownFields: ByteString = ByteString.EMPTY,
) : Message<CallState, Nothing>(ADAPTER, unknownFields) {
  /**
   * participants is the list of participants in the call.
   * In large calls, the list could be truncated in which
   * case, the list of participants contains fewer participants
   * than the counts returned in participant_count. Anonymous
   * participants are **NOT** included in the list.
   */
  @field:WireField(
    tag = 1,
    adapter = "stream.video.sfu.models.Participant#ADAPTER",
    label = WireField.Label.REPEATED,
  )
  public val participants: List<Participant> = immutableCopyOf("participants", participants)

  /**
   * the list of pins in the call.
   * Pins are ordered in descending order (most important first).
   */
  @field:WireField(
    tag = 4,
    adapter = "stream.video.sfu.models.Pin#ADAPTER",
    label = WireField.Label.REPEATED,
  )
  public val pins: List<Pin> = immutableCopyOf("pins", pins)

  @Deprecated(
    message = "Shouldn't be used in Kotlin",
    level = DeprecationLevel.HIDDEN,
  )
  public override fun newBuilder(): Nothing = throw
      AssertionError("Builders are deprecated and only available in a javaInterop build; see https://square.github.io/wire/wire_compiler/#kotlin")

  public override fun equals(other: Any?): Boolean {
    if (other === this) return true
    if (other !is CallState) return false
    if (unknownFields != other.unknownFields) return false
    if (participants != other.participants) return false
    if (started_at != other.started_at) return false
    if (participant_count != other.participant_count) return false
    if (pins != other.pins) return false
    return true
  }

  public override fun hashCode(): Int {
    var result = super.hashCode
    if (result == 0) {
      result = unknownFields.hashCode()
      result = result * 37 + participants.hashCode()
      result = result * 37 + (started_at?.hashCode() ?: 0)
      result = result * 37 + (participant_count?.hashCode() ?: 0)
      result = result * 37 + pins.hashCode()
      super.hashCode = result
    }
    return result
  }

  public override fun toString(): String {
    val result = mutableListOf<String>()
    if (participants.isNotEmpty()) result += """participants=$participants"""
    if (started_at != null) result += """started_at=$started_at"""
    if (participant_count != null) result += """participant_count=$participant_count"""
    if (pins.isNotEmpty()) result += """pins=$pins"""
    return result.joinToString(prefix = "CallState{", separator = ", ", postfix = "}")
  }

  public fun copy(
    participants: List<Participant> = this.participants,
    started_at: Instant? = this.started_at,
    participant_count: ParticipantCount? = this.participant_count,
    pins: List<Pin> = this.pins,
    unknownFields: ByteString = this.unknownFields,
  ): CallState = CallState(participants, started_at, participant_count, pins, unknownFields)

  public companion object {
    @JvmField
    public val ADAPTER: ProtoAdapter<CallState> = object : ProtoAdapter<CallState>(
      FieldEncoding.LENGTH_DELIMITED, 
      CallState::class, 
      "type.googleapis.com/stream.video.sfu.models.CallState", 
      PROTO_3, 
      null, 
      "video/sfu/models/models.proto"
    ) {
      public override fun encodedSize(`value`: CallState): Int {
        var size = value.unknownFields.size
        size += Participant.ADAPTER.asRepeated().encodedSizeWithTag(1, value.participants)
        if (value.started_at != null) size += ProtoAdapter.INSTANT.encodedSizeWithTag(2,
            value.started_at)
        if (value.participant_count != null) size += ParticipantCount.ADAPTER.encodedSizeWithTag(3,
            value.participant_count)
        size += Pin.ADAPTER.asRepeated().encodedSizeWithTag(4, value.pins)
        return size
      }

      public override fun encode(writer: ProtoWriter, `value`: CallState): Unit {
        Participant.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.participants)
        if (value.started_at != null) ProtoAdapter.INSTANT.encodeWithTag(writer, 2,
            value.started_at)
        if (value.participant_count != null) ParticipantCount.ADAPTER.encodeWithTag(writer, 3,
            value.participant_count)
        Pin.ADAPTER.asRepeated().encodeWithTag(writer, 4, value.pins)
        writer.writeBytes(value.unknownFields)
      }

      public override fun encode(writer: ReverseProtoWriter, `value`: CallState): Unit {
        writer.writeBytes(value.unknownFields)
        Pin.ADAPTER.asRepeated().encodeWithTag(writer, 4, value.pins)
        if (value.participant_count != null) ParticipantCount.ADAPTER.encodeWithTag(writer, 3,
            value.participant_count)
        if (value.started_at != null) ProtoAdapter.INSTANT.encodeWithTag(writer, 2,
            value.started_at)
        Participant.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.participants)
      }

      public override fun decode(reader: ProtoReader): CallState {
        val participants = mutableListOf<Participant>()
        var started_at: Instant? = null
        var participant_count: ParticipantCount? = null
        val pins = mutableListOf<Pin>()
        val unknownFields = reader.forEachTag { tag ->
          when (tag) {
            1 -> participants.add(Participant.ADAPTER.decode(reader))
            2 -> started_at = ProtoAdapter.INSTANT.decode(reader)
            3 -> participant_count = ParticipantCount.ADAPTER.decode(reader)
            4 -> pins.add(Pin.ADAPTER.decode(reader))
            else -> reader.readUnknownField(tag)
          }
        }
        return CallState(
          participants = participants,
          started_at = started_at,
          participant_count = participant_count,
          pins = pins,
          unknownFields = unknownFields
        )
      }

      public override fun redact(`value`: CallState): CallState = value.copy(
        participants = value.participants.redactElements(Participant.ADAPTER),
        started_at = value.started_at?.let(ProtoAdapter.INSTANT::redact),
        participant_count = value.participant_count?.let(ParticipantCount.ADAPTER::redact),
        pins = value.pins.redactElements(Pin.ADAPTER),
        unknownFields = ByteString.EMPTY
      )
    }

    private const val serialVersionUID: Long = 0L
  }
}
