/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.logging.file;

import io.getstream.log.Priority;
import io.getstream.log.StreamLogger;
import io.getstream.log.helper.StringifyKt;
import io.getstream.logging.file.FileStreamLogger;
import io.getstream.logging.file.FileStreamLoggerKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0014H\u0002J*\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u001a\u0010\"\u001a\u00020\u00142\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140$J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b&\u0010\u0018J\f\u0010'\u001a\u00020\u001e*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lio/getstream/logging/file/FileStreamLogger;", "Lio/getstream/log/StreamLogger;", "config", "Lio/getstream/logging/file/FileStreamLogger$Config;", "(Lio/getstream/logging/file/FileStreamLogger$Config;)V", "currentFile", "Ljava/io/File;", "currentWriter", "Ljava/io/Writer;", "dateFormat", "Ljava/text/DateFormat;", "executor", "Ljava/util/concurrent/Executor;", "internalFile0", "internalFile1", "internalFiles", "", "[Ljava/io/File;", "timeFormat", "clear", "", "generateShareableFile", "Lkotlin/Result;", "generateShareableFile-d1pmJ48", "()Ljava/lang/Object;", "initIfNeeded", "log", "priority", "Lio/getstream/log/Priority;", "tag", "", "message", "throwable", "", "share", "callback", "Lkotlin/Function1;", "swapFiles", "swapFiles-d1pmJ48", "buildHeader", "Config", "stream-log-file"})
@SourceDebugExtension(value={"SMAP\nFileStreamLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStreamLogger.kt\nio/getstream/logging/file/FileStreamLogger\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n603#2:173\n1855#3,2:174\n*S KotlinDebug\n*F\n+ 1 FileStreamLogger.kt\nio/getstream/logging/file/FileStreamLogger\n*L\n124#1:173\n125#1:174,2\n*E\n"})
public final class FileStreamLogger
implements StreamLogger {
    @NotNull
    private final Config config;
    @NotNull
    private final Executor executor;
    @NotNull
    private final DateFormat timeFormat;
    @NotNull
    private final DateFormat dateFormat;
    @NotNull
    private final File internalFile0;
    @NotNull
    private final File internalFile1;
    @NotNull
    private final File[] internalFiles;
    @Nullable
    private File currentFile;
    @Nullable
    private Writer currentWriter;

    public FileStreamLogger(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.executor = executorService;
        this.timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss''SSS", Locale.ENGLISH);
        this.dateFormat = new SimpleDateFormat("yyMMddHHmm_ss", Locale.ENGLISH);
        this.internalFile0 = new File(this.config.getFilesDir(), "internal_0.txt");
        this.internalFile1 = new File(this.config.getFilesDir(), "internal_1.txt");
        File[] fileArray = new File[]{this.internalFile0, this.internalFile1};
        this.internalFiles = fileArray;
    }

    public void log(@NotNull Priority priority, @NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Thread thread = Thread.currentThread();
        this.executor.execute(() -> FileStreamLogger.log$lambda$1(this, thread, priority, tag, message, throwable));
    }

    public final void share(@NotNull Function1<? super File, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.executor.execute(() -> FileStreamLogger.share$lambda$2(this, callback));
    }

    public final void clear() {
        this.executor.execute(() -> FileStreamLogger.clear$lambda$3(this));
    }

    private final void initIfNeeded() {
        if (this.currentFile == null) {
            File internalFile;
            this.currentFile = internalFile = !this.internalFile0.exists() || !this.internalFile1.exists() ? this.internalFile0 : (this.internalFile0.lastModified() > this.internalFile1.lastModified() ? this.internalFile0 : this.internalFile1);
            this.currentWriter = FileStreamLoggerKt.access$fileWriter(internalFile);
        }
    }

    private final Object swapFiles-d1pmJ48() {
        Object object;
        FileStreamLogger fileStreamLogger = this;
        try {
            long curLen;
            FileStreamLogger $this$swapFiles_d1pmJ48_u24lambda_u244 = fileStreamLogger;
            boolean bl = false;
            File file = $this$swapFiles_d1pmJ48_u24lambda_u244.currentFile;
            long l = curLen = file != null ? file.length() : 0L;
            if (curLen >= (long)($this$swapFiles_d1pmJ48_u24lambda_u244.config.getMaxLogSize() / 2)) {
                File file2 = $this$swapFiles_d1pmJ48_u24lambda_u244.currentFile = $this$swapFiles_d1pmJ48_u24lambda_u244.currentFile == $this$swapFiles_d1pmJ48_u24lambda_u244.internalFile0 ? $this$swapFiles_d1pmJ48_u24lambda_u244.internalFile1 : $this$swapFiles_d1pmJ48_u24lambda_u244.internalFile0;
                if (file2 != null) {
                    FilesKt.writeText$default((File)file2, (String)"", null, (int)2, null);
                }
                Writer writer = $this$swapFiles_d1pmJ48_u24lambda_u244.currentWriter;
                if (writer != null) {
                    Result.box-impl((Object)FileStreamLoggerKt.access$closeSilently(writer));
                }
                File file3 = $this$swapFiles_d1pmJ48_u24lambda_u244.currentFile;
                $this$swapFiles_d1pmJ48_u24lambda_u244.currentWriter = file3 != null ? FileStreamLoggerKt.access$fileWriter(file3) : null;
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object generateShareableFile-d1pmJ48() {
        Object object;
        FileStreamLogger fileStreamLogger = this;
        try {
            FileStreamLogger $this$generateShareableFile_d1pmJ48_u24lambda_u2410 = fileStreamLogger;
            boolean bl = false;
            Object object2 = "stream_log_%s.txt";
            Object[] objectArray = new Object[]{$this$generateShareableFile_d1pmJ48_u24lambda_u2410.dateFormat.format(new Date())};
            String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(this, *args)");
            String filename = string;
            Object $this$generateShareableFile_d1pmJ48_u24lambda_u2410_u24lambda_u249 = object2 = new File($this$generateShareableFile_d1pmJ48_u24lambda_u2410.config.getExternalFilesDir(), filename);
            boolean bl2 = false;
            Object object3 = $this$generateShareableFile_d1pmJ48_u24lambda_u2410_u24lambda_u249;
            Object object4 = Charsets.UTF_8;
            int n = 8192;
            Object object5 = object3;
            object5 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object5), (Charset)object4);
            object3 = object5 instanceof BufferedWriter ? (BufferedWriter)object5 : new BufferedWriter((Writer)object5, n);
            object4 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object3;
                boolean bl3 = false;
                writer.write($this$generateShareableFile_d1pmJ48_u24lambda_u2410.buildHeader($this$generateShareableFile_d1pmJ48_u24lambda_u2410.config));
                Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])$this$generateShareableFile_d1pmJ48_u24lambda_u2410.internalFiles), (Function1)generateShareableFile.1.1.1.files.1.INSTANCE);
                boolean $i$f$sortedBy = false;
                List files2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        File it = (File)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.lastModified());
                        it = (File)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.lastModified()));
                    }
                }));
                Iterable $this$forEach$iv = files2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl4 = false;
                    Object object6 = file;
                    Object object7 = Charsets.UTF_8;
                    int n2 = 8192;
                    Object object8 = object6;
                    object6 = (object8 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object8), (Charset)object7)) instanceof BufferedReader ? (BufferedReader)object8 : new BufferedReader((Reader)object8, n2);
                    object7 = null;
                    try {
                        BufferedReader reader = (BufferedReader)object6;
                        boolean bl5 = false;
                        TextStreamsKt.copyTo$default((Reader)reader, (Writer)writer, (int)0, (int)2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        object7 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object6, (Throwable)object7);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
            }
            object = Result.constructor-impl((Object)object2);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    private final String buildHeader(Config $this$buildHeader) {
        return StringsKt.trimMargin$default((String)("\n            |======================================================================\n            |Logs date time: " + this.timeFormat.format(new Date()) + "\n            |Version code: " + $this$buildHeader.getApp().getVersionCode() + "\n            |Version name: " + $this$buildHeader.getApp().getVersionName() + "\n            |API level: " + $this$buildHeader.getDevice().getAndroidApiLevel() + "\n            |Device: " + $this$buildHeader.getDevice().getModel() + "\n            |======================================================================\n            |\n    "), null, (int)1, null);
    }

    private static final void log$lambda$1(FileStreamLogger this$0, Thread $thread, Priority $priority, String $tag, String $message, Throwable $throwable) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$priority, (String)"$priority");
            Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
            Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
            this$0.initIfNeeded();
            this$0.swapFiles-d1pmJ48();
            Writer writer = this$0.currentWriter;
            if (writer == null) break block3;
            Writer writer2 = writer;
            try {
                Writer $this$log_u24lambda_u241_u24lambda_u240 = writer2;
                boolean bl = false;
                String formattedDateTime = this$0.timeFormat.format(new Date());
                String string = "%20s";
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)$thread, (String)"thread");
                objectArray[0] = StringifyKt.stringify((Thread)$thread);
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                String formattedThread = string2;
                String formattedPriority = StringifyKt.stringify((Priority)$priority);
                String formatterPrefix = formattedDateTime + ' ' + formattedPriority + '/' + formattedThread + " [" + $tag + "]: ";
                $this$log_u24lambda_u241_u24lambda_u240.write(formatterPrefix);
                $this$log_u24lambda_u241_u24lambda_u240.write($message);
                Intrinsics.checkNotNullExpressionValue((Object)((Appendable)$this$log_u24lambda_u241_u24lambda_u240).append('\n'), (String)"append('\\n')");
                if (FileStreamLoggerKt.access$write($this$log_u24lambda_u241_u24lambda_u240, $throwable)) {
                    Intrinsics.checkNotNullExpressionValue((Object)((Appendable)$this$log_u24lambda_u241_u24lambda_u240).append('\n'), (String)"append('\\n')");
                }
                $this$log_u24lambda_u241_u24lambda_u240.flush();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Result.box-impl((Object)object);
        }
    }

    private static final void share$lambda$2(FileStreamLogger this$0, Function1 $callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            Object object = this$0.generateShareableFile-d1pmJ48();
            File file = (File)(Result.isFailure-impl((Object)object) ? null : object);
            if (file == null) break block0;
            object = file;
            $callback.invoke(object);
        }
    }

    private static final void clear$lambda$3(FileStreamLogger this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FilesKt.writeText$default((File)this$0.internalFile0, (String)"", null, (int)2, null);
        FilesKt.writeText$default((File)this$0.internalFile1, (String)"", null, (int)2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002!\"B1\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lio/getstream/logging/file/FileStreamLogger$Config;", "", "maxLogSize", "", "filesDir", "Ljava/io/File;", "externalFilesDir", "app", "Lio/getstream/logging/file/FileStreamLogger$Config$App;", "device", "Lio/getstream/logging/file/FileStreamLogger$Config$Device;", "(ILjava/io/File;Ljava/io/File;Lio/getstream/logging/file/FileStreamLogger$Config$App;Lio/getstream/logging/file/FileStreamLogger$Config$Device;)V", "getApp", "()Lio/getstream/logging/file/FileStreamLogger$Config$App;", "getDevice", "()Lio/getstream/logging/file/FileStreamLogger$Config$Device;", "getExternalFilesDir", "()Ljava/io/File;", "getFilesDir", "getMaxLogSize", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "App", "Device", "stream-log-file"})
    public static final class Config {
        private final int maxLogSize;
        @NotNull
        private final File filesDir;
        @Nullable
        private final File externalFilesDir;
        @NotNull
        private final App app;
        @NotNull
        private final Device device;

        public Config(int maxLogSize, @NotNull File filesDir, @Nullable File externalFilesDir, @NotNull App app, @NotNull Device device) {
            Intrinsics.checkNotNullParameter((Object)filesDir, (String)"filesDir");
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            this.maxLogSize = maxLogSize;
            this.filesDir = filesDir;
            this.externalFilesDir = externalFilesDir;
            this.app = app;
            this.device = device;
        }

        public /* synthetic */ Config(int n, File file, File file2, App app, Device device, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0xC00000;
            }
            this(n, file, file2, app, device);
        }

        public final int getMaxLogSize() {
            return this.maxLogSize;
        }

        @NotNull
        public final File getFilesDir() {
            return this.filesDir;
        }

        @Nullable
        public final File getExternalFilesDir() {
            return this.externalFilesDir;
        }

        @NotNull
        public final App getApp() {
            return this.app;
        }

        @NotNull
        public final Device getDevice() {
            return this.device;
        }

        public final int component1() {
            return this.maxLogSize;
        }

        @NotNull
        public final File component2() {
            return this.filesDir;
        }

        @Nullable
        public final File component3() {
            return this.externalFilesDir;
        }

        @NotNull
        public final App component4() {
            return this.app;
        }

        @NotNull
        public final Device component5() {
            return this.device;
        }

        @NotNull
        public final Config copy(int maxLogSize, @NotNull File filesDir, @Nullable File externalFilesDir, @NotNull App app, @NotNull Device device) {
            Intrinsics.checkNotNullParameter((Object)filesDir, (String)"filesDir");
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            return new Config(maxLogSize, filesDir, externalFilesDir, app, device);
        }

        public static /* synthetic */ Config copy$default(Config config, int n, File file, File file2, App app, Device device, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = config.maxLogSize;
            }
            if ((n2 & 2) != 0) {
                file = config.filesDir;
            }
            if ((n2 & 4) != 0) {
                file2 = config.externalFilesDir;
            }
            if ((n2 & 8) != 0) {
                app = config.app;
            }
            if ((n2 & 0x10) != 0) {
                device = config.device;
            }
            return config.copy(n, file, file2, app, device);
        }

        @NotNull
        public String toString() {
            return "Config(maxLogSize=" + this.maxLogSize + ", filesDir=" + this.filesDir + ", externalFilesDir=" + this.externalFilesDir + ", app=" + this.app + ", device=" + this.device + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.maxLogSize);
            result = result * 31 + this.filesDir.hashCode();
            result = result * 31 + (this.externalFilesDir == null ? 0 : this.externalFilesDir.hashCode());
            result = result * 31 + this.app.hashCode();
            result = result * 31 + this.device.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (this.maxLogSize != config.maxLogSize) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filesDir, (Object)config.filesDir)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.externalFilesDir, (Object)config.externalFilesDir)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.app, (Object)config.app)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.device, (Object)config.device);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/getstream/logging/file/FileStreamLogger$Config$App;", "", "versionCode", "", "versionName", "", "(JLjava/lang/String;)V", "getVersionCode", "()J", "getVersionName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "stream-log-file"})
        public static final class App {
            private final long versionCode;
            @NotNull
            private final String versionName;

            public App(long versionCode, @NotNull String versionName) {
                Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
                this.versionCode = versionCode;
                this.versionName = versionName;
            }

            public final long getVersionCode() {
                return this.versionCode;
            }

            @NotNull
            public final String getVersionName() {
                return this.versionName;
            }

            public final long component1() {
                return this.versionCode;
            }

            @NotNull
            public final String component2() {
                return this.versionName;
            }

            @NotNull
            public final App copy(long versionCode, @NotNull String versionName) {
                Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
                return new App(versionCode, versionName);
            }

            public static /* synthetic */ App copy$default(App app, long l, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    l = app.versionCode;
                }
                if ((n & 2) != 0) {
                    string = app.versionName;
                }
                return app.copy(l, string);
            }

            @NotNull
            public String toString() {
                return "App(versionCode=" + this.versionCode + ", versionName=" + this.versionName + ')';
            }

            public int hashCode() {
                int result = Long.hashCode(this.versionCode);
                result = result * 31 + this.versionName.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof App)) {
                    return false;
                }
                App app = (App)other;
                if (this.versionCode != app.versionCode) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.versionName, (Object)app.versionName);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/getstream/logging/file/FileStreamLogger$Config$Device;", "", "model", "", "androidApiLevel", "", "(Ljava/lang/String;I)V", "getAndroidApiLevel", "()I", "getModel", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "stream-log-file"})
        public static final class Device {
            @NotNull
            private final String model;
            private final int androidApiLevel;

            public Device(@NotNull String model, int androidApiLevel) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                this.model = model;
                this.androidApiLevel = androidApiLevel;
            }

            @NotNull
            public final String getModel() {
                return this.model;
            }

            public final int getAndroidApiLevel() {
                return this.androidApiLevel;
            }

            @NotNull
            public final String component1() {
                return this.model;
            }

            public final int component2() {
                return this.androidApiLevel;
            }

            @NotNull
            public final Device copy(@NotNull String model, int androidApiLevel) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                return new Device(model, androidApiLevel);
            }

            public static /* synthetic */ Device copy$default(Device device, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = device.model;
                }
                if ((n2 & 2) != 0) {
                    n = device.androidApiLevel;
                }
                return device.copy(string, n);
            }

            @NotNull
            public String toString() {
                return "Device(model=" + this.model + ", androidApiLevel=" + this.androidApiLevel + ')';
            }

            public int hashCode() {
                int result = this.model.hashCode();
                result = result * 31 + Integer.hashCode(this.androidApiLevel);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Device)) {
                    return false;
                }
                Device device = (Device)other;
                if (!Intrinsics.areEqual((Object)this.model, (Object)device.model)) {
                    return false;
                }
                return this.androidApiLevel == device.androidApiLevel;
            }
        }
    }
}

