/*
 * Decompiled with CFR 0.152.
 */
package shadowed.retrofit2;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import shadowed.okhttp3.Call;
import shadowed.okhttp3.HttpUrl;
import shadowed.okhttp3.OkHttpClient;
import shadowed.okhttp3.RequestBody;
import shadowed.okhttp3.ResponseBody;
import shadowed.retrofit2.BuiltInConverters;
import shadowed.retrofit2.CallAdapter;
import shadowed.retrofit2.Converter;
import shadowed.retrofit2.Platform;
import shadowed.retrofit2.ServiceMethod;

public final class Retrofit {
    private final Map<Method, ServiceMethod<?>> serviceMethodCache = new ConcurrentHashMap();
    final Call.Factory callFactory;
    final HttpUrl baseUrl;
    final List<Converter.Factory> converterFactories;
    final List<CallAdapter.Factory> callAdapterFactories;
    @Nullable
    final Executor callbackExecutor;
    final boolean validateEagerly;

    Retrofit(Call.Factory callFactory, HttpUrl baseUrl, List<Converter.Factory> converterFactories, List<CallAdapter.Factory> callAdapterFactories, @Nullable Executor callbackExecutor, boolean validateEagerly) {
        this.callFactory = callFactory;
        this.baseUrl = baseUrl;
        this.converterFactories = converterFactories;
        this.callAdapterFactories = callAdapterFactories;
        this.callbackExecutor = callbackExecutor;
        this.validateEagerly = validateEagerly;
    }

    public <T> T create(final Class<T> service) {
        this.validateServiceInterface(service);
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, new InvocationHandler(){
            private final Platform platform = Platform.get();
            private final Object[] emptyArgs = new Object[0];

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, @Nullable Object[] args2) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args2);
                }
                args2 = args2 != null ? args2 : this.emptyArgs;
                return this.platform.isDefaultMethod(method) ? this.platform.invokeDefaultMethod(method, service, proxy, args2) : Retrofit.this.loadServiceMethod(method).invoke(args2);
            }
        });
    }

    private void validateServiceInterface(Class<?> service) {
        if (!service.isInterface()) {
            throw new IllegalArgumentException("API declarations must be interfaces.");
        }
        ArrayDeque check2 = new ArrayDeque(1);
        check2.add(service);
        while (!check2.isEmpty()) {
            Class candidate = (Class)check2.removeFirst();
            if (candidate.getTypeParameters().length != 0) {
                StringBuilder message = new StringBuilder("Type parameters are unsupported on ").append(candidate.getName());
                if (candidate != service) {
                    message.append(" which is an interface of ").append(service.getName());
                }
                throw new IllegalArgumentException(message.toString());
            }
            Collections.addAll(check2, candidate.getInterfaces());
        }
        if (this.validateEagerly) {
            Platform platform = Platform.get();
            for (Method method : service.getDeclaredMethods()) {
                if (platform.isDefaultMethod(method) || Modifier.isStatic(method.getModifiers())) continue;
                this.loadServiceMethod(method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceMethod<?> loadServiceMethod(Method method) {
        ServiceMethod<Object> result = this.serviceMethodCache.get(method);
        if (result != null) {
            return result;
        }
        Map<Method, ServiceMethod<?>> map = this.serviceMethodCache;
        synchronized (map) {
            result = this.serviceMethodCache.get(method);
            if (result == null) {
                result = ServiceMethod.parseAnnotations(this, method);
                this.serviceMethodCache.put(method, result);
            }
        }
        return result;
    }

    public Call.Factory callFactory() {
        return this.callFactory;
    }

    public HttpUrl baseUrl() {
        return this.baseUrl;
    }

    public List<CallAdapter.Factory> callAdapterFactories() {
        return this.callAdapterFactories;
    }

    public CallAdapter<?, ?> callAdapter(Type returnType, Annotation[] annotations) {
        return this.nextCallAdapter(null, returnType, annotations);
    }

    public CallAdapter<?, ?> nextCallAdapter(@Nullable CallAdapter.Factory skipPast, Type returnType, Annotation[] annotations) {
        int i;
        int start;
        Objects.requireNonNull(returnType, "returnType == null");
        Objects.requireNonNull(annotations, "annotations == null");
        int count = this.callAdapterFactories.size();
        for (int i2 = start = this.callAdapterFactories.indexOf(skipPast) + 1; i2 < count; ++i2) {
            CallAdapter<?, ?> adapter = this.callAdapterFactories.get(i2).get(returnType, annotations, this);
            if (adapter == null) continue;
            return adapter;
        }
        StringBuilder builder = new StringBuilder("Could not locate call adapter for ").append(returnType).append(".\n");
        if (skipPast != null) {
            builder.append("  Skipped:");
            for (i = 0; i < start; ++i) {
                builder.append("\n   * ").append(this.callAdapterFactories.get(i).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.callAdapterFactories.size();
        for (i = start; i < count2; ++i) {
            builder.append("\n   * ").append(this.callAdapterFactories.get(i).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public List<Converter.Factory> converterFactories() {
        return this.converterFactories;
    }

    public <T> Converter<T, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations) {
        return this.nextRequestBodyConverter(null, type, parameterAnnotations, methodAnnotations);
    }

    public <T> Converter<T, RequestBody> nextRequestBodyConverter(@Nullable Converter.Factory skipPast, Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations) {
        int i;
        int start;
        Objects.requireNonNull(type, "type == null");
        Objects.requireNonNull(parameterAnnotations, "parameterAnnotations == null");
        Objects.requireNonNull(methodAnnotations, "methodAnnotations == null");
        int count = this.converterFactories.size();
        for (int i2 = start = this.converterFactories.indexOf(skipPast) + 1; i2 < count; ++i2) {
            Converter.Factory factory2 = this.converterFactories.get(i2);
            Converter<?, RequestBody> converter = factory2.requestBodyConverter(type, parameterAnnotations, methodAnnotations, this);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate RequestBody converter for ").append(type).append(".\n");
        if (skipPast != null) {
            builder.append("  Skipped:");
            for (i = 0; i < start; ++i) {
                builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.converterFactories.size();
        for (i = start; i < count2; ++i) {
            builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public <T> Converter<ResponseBody, T> responseBodyConverter(Type type, Annotation[] annotations) {
        return this.nextResponseBodyConverter(null, type, annotations);
    }

    public <T> Converter<ResponseBody, T> nextResponseBodyConverter(@Nullable Converter.Factory skipPast, Type type, Annotation[] annotations) {
        int i;
        int start;
        Objects.requireNonNull(type, "type == null");
        Objects.requireNonNull(annotations, "annotations == null");
        int count = this.converterFactories.size();
        for (int i2 = start = this.converterFactories.indexOf(skipPast) + 1; i2 < count; ++i2) {
            Converter<ResponseBody, ?> converter = this.converterFactories.get(i2).responseBodyConverter(type, annotations, this);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate ResponseBody converter for ").append(type).append(".\n");
        if (skipPast != null) {
            builder.append("  Skipped:");
            for (i = 0; i < start; ++i) {
                builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.converterFactories.size();
        for (i = start; i < count2; ++i) {
            builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public <T> Converter<T, String> stringConverter(Type type, Annotation[] annotations) {
        Objects.requireNonNull(type, "type == null");
        Objects.requireNonNull(annotations, "annotations == null");
        int count = this.converterFactories.size();
        for (int i = 0; i < count; ++i) {
            Converter<?, String> converter = this.converterFactories.get(i).stringConverter(type, annotations, this);
            if (converter == null) continue;
            return converter;
        }
        return BuiltInConverters.ToStringConverter.INSTANCE;
    }

    @Nullable
    public Executor callbackExecutor() {
        return this.callbackExecutor;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private final Platform platform;
        @Nullable
        private Call.Factory callFactory;
        @Nullable
        private HttpUrl baseUrl;
        private final List<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>();
        private final List<CallAdapter.Factory> callAdapterFactories = new ArrayList<CallAdapter.Factory>();
        @Nullable
        private Executor callbackExecutor;
        private boolean validateEagerly;

        Builder(Platform platform) {
            this.platform = platform;
        }

        public Builder() {
            this(Platform.get());
        }

        Builder(Retrofit retrofit) {
            int i;
            this.platform = Platform.get();
            this.callFactory = retrofit.callFactory;
            this.baseUrl = retrofit.baseUrl;
            int size = retrofit.converterFactories.size() - this.platform.defaultConverterFactoriesSize();
            for (i = 1; i < size; ++i) {
                this.converterFactories.add(retrofit.converterFactories.get(i));
            }
            size = retrofit.callAdapterFactories.size() - this.platform.defaultCallAdapterFactoriesSize();
            for (i = 0; i < size; ++i) {
                this.callAdapterFactories.add(retrofit.callAdapterFactories.get(i));
            }
            this.callbackExecutor = retrofit.callbackExecutor;
            this.validateEagerly = retrofit.validateEagerly;
        }

        public Builder client(OkHttpClient client) {
            return this.callFactory(Objects.requireNonNull(client, "client == null"));
        }

        public Builder callFactory(Call.Factory factory2) {
            this.callFactory = Objects.requireNonNull(factory2, "factory == null");
            return this;
        }

        public Builder baseUrl(URL baseUrl) {
            Objects.requireNonNull(baseUrl, "baseUrl == null");
            return this.baseUrl(HttpUrl.get(baseUrl.toString()));
        }

        public Builder baseUrl(String baseUrl) {
            Objects.requireNonNull(baseUrl, "baseUrl == null");
            return this.baseUrl(HttpUrl.get(baseUrl));
        }

        public Builder baseUrl(HttpUrl baseUrl) {
            Objects.requireNonNull(baseUrl, "baseUrl == null");
            List<String> pathSegments = baseUrl.pathSegments();
            if (!"".equals(pathSegments.get(pathSegments.size() - 1))) {
                throw new IllegalArgumentException("baseUrl must end in /: " + baseUrl);
            }
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder addConverterFactory(Converter.Factory factory2) {
            this.converterFactories.add(Objects.requireNonNull(factory2, "factory == null"));
            return this;
        }

        public Builder addCallAdapterFactory(CallAdapter.Factory factory2) {
            this.callAdapterFactories.add(Objects.requireNonNull(factory2, "factory == null"));
            return this;
        }

        public Builder callbackExecutor(Executor executor) {
            this.callbackExecutor = Objects.requireNonNull(executor, "executor == null");
            return this;
        }

        public List<CallAdapter.Factory> callAdapterFactories() {
            return this.callAdapterFactories;
        }

        public List<Converter.Factory> converterFactories() {
            return this.converterFactories;
        }

        public Builder validateEagerly(boolean validateEagerly) {
            this.validateEagerly = validateEagerly;
            return this;
        }

        public Retrofit build() {
            Executor callbackExecutor;
            if (this.baseUrl == null) {
                throw new IllegalStateException("Base URL required.");
            }
            Call.Factory callFactory = this.callFactory;
            if (callFactory == null) {
                callFactory = new OkHttpClient();
            }
            if ((callbackExecutor = this.callbackExecutor) == null) {
                callbackExecutor = this.platform.defaultCallbackExecutor();
            }
            ArrayList<CallAdapter.Factory> callAdapterFactories = new ArrayList<CallAdapter.Factory>(this.callAdapterFactories);
            callAdapterFactories.addAll(this.platform.defaultCallAdapterFactories(callbackExecutor));
            ArrayList<? extends Converter.Factory> converterFactories = new ArrayList<Converter.Factory>(1 + this.converterFactories.size() + this.platform.defaultConverterFactoriesSize());
            converterFactories.add(new BuiltInConverters());
            converterFactories.addAll(this.converterFactories);
            converterFactories.addAll(this.platform.defaultConverterFactories());
            return new Retrofit(callFactory, this.baseUrl, Collections.unmodifiableList(converterFactories), Collections.unmodifiableList(callAdapterFactories), callbackExecutor, this.validateEagerly);
        }
    }
}

