/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.io;

import shadowed.io.jsonwebtoken.io.Decoder;
import shadowed.io.jsonwebtoken.io.DecodingException;
import shadowed.io.jsonwebtoken.lang.Assert;

class ExceptionPropagatingDecoder<T, R>
implements Decoder<T, R> {
    private final Decoder<T, R> decoder;

    ExceptionPropagatingDecoder(Decoder<T, R> decoder) {
        Assert.notNull(decoder, "Decoder cannot be null.");
        this.decoder = decoder;
    }

    @Override
    public R decode(T t) throws DecodingException {
        Assert.notNull(t, "Decode argument cannot be null.");
        try {
            return this.decoder.decode(t);
        }
        catch (DecodingException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unable to decode input: " + e.getMessage();
            throw new DecodingException(msg, e);
        }
    }
}

