/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.SecretKey;
import shadowed.io.jsonwebtoken.impl.lang.IdRegistry;
import shadowed.io.jsonwebtoken.impl.security.DefaultMacAlgorithm;
import shadowed.io.jsonwebtoken.impl.security.EcSignatureAlgorithm;
import shadowed.io.jsonwebtoken.impl.security.EdSignatureAlgorithm;
import shadowed.io.jsonwebtoken.impl.security.NoneSignatureAlgorithm;
import shadowed.io.jsonwebtoken.impl.security.RsaSignatureAlgorithm;
import shadowed.io.jsonwebtoken.lang.Collections;
import shadowed.io.jsonwebtoken.security.Password;
import shadowed.io.jsonwebtoken.security.SecureDigestAlgorithm;

public final class StandardSecureDigestAlgorithms
extends IdRegistry<SecureDigestAlgorithm<?, ?>> {
    public static final String NAME = "JWS Digital Signature or MAC";

    public StandardSecureDigestAlgorithms() {
        super(NAME, Collections.of(NoneSignatureAlgorithm.INSTANCE, DefaultMacAlgorithm.HS256, DefaultMacAlgorithm.HS384, DefaultMacAlgorithm.HS512, RsaSignatureAlgorithm.RS256, RsaSignatureAlgorithm.RS384, RsaSignatureAlgorithm.RS512, RsaSignatureAlgorithm.PS256, RsaSignatureAlgorithm.PS384, RsaSignatureAlgorithm.PS512, EcSignatureAlgorithm.ES256, EcSignatureAlgorithm.ES384, EcSignatureAlgorithm.ES512, EdSignatureAlgorithm.INSTANCE));
    }

    public static <K extends Key> SecureDigestAlgorithm<K, ?> findBySigningKey(K key) {
        SecureDigestAlgorithm<SecretKey, SecretKey> alg = null;
        if (key instanceof SecretKey && !(key instanceof Password)) {
            alg = DefaultMacAlgorithm.findByKey(key);
        } else if (key instanceof PrivateKey) {
            PrivateKey pk = (PrivateKey)key;
            alg = RsaSignatureAlgorithm.findByKey(pk);
            if (alg == null) {
                alg = EcSignatureAlgorithm.findByKey(pk);
            }
            if (alg == null && EdSignatureAlgorithm.isSigningKey(pk)) {
                alg = EdSignatureAlgorithm.INSTANCE;
            }
        }
        return alg;
    }
}

