/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import javax.crypto.SecretKey;
import shadowed.io.jsonwebtoken.impl.lang.Bytes;
import shadowed.io.jsonwebtoken.impl.security.EdwardsCurve;
import shadowed.io.jsonwebtoken.impl.security.PasswordSpec;
import shadowed.io.jsonwebtoken.impl.security.ProvidedPrivateKeyBuilder;
import shadowed.io.jsonwebtoken.impl.security.ProvidedSecretKeyBuilder;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.lang.Strings;
import shadowed.io.jsonwebtoken.security.InvalidKeyException;
import shadowed.io.jsonwebtoken.security.KeySupplier;
import shadowed.io.jsonwebtoken.security.Password;
import shadowed.io.jsonwebtoken.security.PrivateKeyBuilder;
import shadowed.io.jsonwebtoken.security.SecretKeyBuilder;

public final class KeysBridge {
    private static final String SUNPKCS11_GENERIC_SECRET_CLASSNAME = "sun.security.pkcs11.P11Key$P11SecretKey";
    private static final String SUNPKCS11_GENERIC_SECRET_ALGNAME = "Generic Secret";

    private KeysBridge() {
    }

    public static Password password(char[] password) {
        return new PasswordSpec(password);
    }

    public static SecretKeyBuilder builder(SecretKey key) {
        return new ProvidedSecretKeyBuilder(key);
    }

    public static PrivateKeyBuilder builder(PrivateKey key) {
        return new ProvidedPrivateKeyBuilder(key);
    }

    public static <K extends Key> K root(K key) {
        return key instanceof KeySupplier ? KeysBridge.root((KeySupplier)((Object)key)) : key;
    }

    public static <K extends Key> K root(KeySupplier<K> supplier) {
        Assert.notNull(supplier, "KeySupplier canot be null.");
        return (K)((Key)Assert.notNull(KeysBridge.root(supplier.getKey()), "KeySupplier key cannot be null."));
    }

    public static String findAlgorithm(Key key) {
        return key != null ? Strings.clean(key.getAlgorithm()) : null;
    }

    public static byte[] findEncoded(Key key) {
        Assert.notNull(key, "Key cannot be null.");
        byte[] encoded = null;
        try {
            encoded = key.getEncoded();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return encoded;
    }

    public static boolean isSunPkcs11GenericSecret(Key key) {
        return key instanceof SecretKey && key.getClass().getName().equals(SUNPKCS11_GENERIC_SECRET_CLASSNAME) && SUNPKCS11_GENERIC_SECRET_ALGNAME.equals(key.getAlgorithm());
    }

    public static int findBitLength(Key key) {
        int bitlen = -1;
        if (key instanceof SecretKey) {
            byte[] encoded;
            SecretKey secretKey = (SecretKey)key;
            if ("RAW".equals(secretKey.getFormat()) && !Bytes.isEmpty(encoded = KeysBridge.findEncoded(secretKey))) {
                bitlen = (int)Bytes.bitLength(encoded);
                Bytes.clear(encoded);
            }
        } else if (key instanceof RSAKey) {
            RSAKey rsaKey = (RSAKey)((Object)key);
            bitlen = rsaKey.getModulus().bitLength();
        } else if (key instanceof ECKey) {
            ECKey ecKey = (ECKey)((Object)key);
            bitlen = ecKey.getParams().getOrder().bitLength();
        } else {
            EdwardsCurve curve = EdwardsCurve.findByKey(key);
            if (curve != null) {
                bitlen = curve.getKeyBitLength();
            }
        }
        return bitlen;
    }

    public static byte[] getEncoded(Key key) {
        byte[] encoded;
        Assert.notNull(key, "Key cannot be null.");
        try {
            encoded = key.getEncoded();
        }
        catch (Throwable t) {
            String msg = "Cannot obtain required encoded bytes from key [" + KeysBridge.toString(key) + "]: " + t.getMessage();
            throw new InvalidKeyException(msg, t);
        }
        if (Bytes.isEmpty(encoded)) {
            String msg = "Missing required encoded bytes for key [" + KeysBridge.toString(key) + "].";
            throw new InvalidKeyException(msg);
        }
        return encoded;
    }

    public static String toString(Key key) {
        if (key == null) {
            return "null";
        }
        if (key instanceof PublicKey) {
            return key.toString();
        }
        return "class: " + key.getClass().getName() + ", algorithm: " + key.getAlgorithm() + ", format: " + key.getFormat();
    }
}

