/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import javax.crypto.SecretKey;
import shadowed.io.jsonwebtoken.impl.security.DefaultKeyResult;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.security.DecryptionKeyRequest;
import shadowed.io.jsonwebtoken.security.KeyAlgorithm;
import shadowed.io.jsonwebtoken.security.KeyRequest;
import shadowed.io.jsonwebtoken.security.KeyResult;
import shadowed.io.jsonwebtoken.security.SecurityException;

public class DirectKeyAlgorithm
implements KeyAlgorithm<SecretKey, SecretKey> {
    static final String ID = "dir";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        SecretKey key = (SecretKey)Assert.notNull(request.getPayload(), "Encryption key cannot be null.");
        return new DefaultKeyResult(key);
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        return (SecretKey)Assert.notNull(request.getKey(), "Decryption key cannot be null.");
    }
}

