/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.security.KeyPair;
import java.security.spec.AlgorithmParameterSpec;
import shadowed.io.jsonwebtoken.impl.security.AbstractSecurityBuilder;
import shadowed.io.jsonwebtoken.impl.security.JcaTemplate;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.security.KeyPairBuilder;

public class DefaultKeyPairBuilder
extends AbstractSecurityBuilder<KeyPair, KeyPairBuilder>
implements KeyPairBuilder {
    private final String jcaName;
    private final int bitLength;
    private final AlgorithmParameterSpec params;

    public DefaultKeyPairBuilder(String jcaName) {
        this.jcaName = Assert.hasText(jcaName, "jcaName cannot be null or empty.");
        this.bitLength = 0;
        this.params = null;
    }

    public DefaultKeyPairBuilder(String jcaName, int bitLength) {
        this.jcaName = Assert.hasText(jcaName, "jcaName cannot be null or empty.");
        this.bitLength = Assert.gt(bitLength, 0, "bitLength must be a positive integer greater than 0");
        this.params = null;
    }

    public DefaultKeyPairBuilder(String jcaName, AlgorithmParameterSpec params) {
        this.jcaName = Assert.hasText(jcaName, "jcaName cannot be null or empty.");
        this.params = Assert.notNull(params, "AlgorithmParameterSpec params cannot be null.");
        this.bitLength = 0;
    }

    @Override
    public KeyPair build() {
        JcaTemplate template = new JcaTemplate(this.jcaName, this.provider, this.random);
        if (this.params != null) {
            return template.generateKeyPair(this.params);
        }
        if (this.bitLength > 0) {
            return template.generateKeyPair(this.bitLength);
        }
        return template.generateKeyPair();
    }
}

