/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.util.Set;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.lang.Collections;
import shadowed.io.jsonwebtoken.lang.Strings;
import shadowed.io.jsonwebtoken.security.KeyOperation;

final class DefaultKeyOperation
implements KeyOperation {
    private static final String CUSTOM_DESCRIPTION = "Custom key operation";
    static final KeyOperation SIGN = DefaultKeyOperation.of("sign", "Compute digital signature or MAC", "verify");
    static final KeyOperation VERIFY = DefaultKeyOperation.of("verify", "Verify digital signature or MAC", "sign");
    static final KeyOperation ENCRYPT = DefaultKeyOperation.of("encrypt", "Encrypt content", "decrypt");
    static final KeyOperation DECRYPT = DefaultKeyOperation.of("decrypt", "Decrypt content and validate decryption, if applicable", "encrypt");
    static final KeyOperation WRAP = DefaultKeyOperation.of("wrapKey", "Encrypt key", "unwrapKey");
    static final KeyOperation UNWRAP = DefaultKeyOperation.of("unwrapKey", "Decrypt key and validate decryption, if applicable", "wrapKey");
    static final KeyOperation DERIVE_KEY = DefaultKeyOperation.of("deriveKey", "Derive key", null);
    static final KeyOperation DERIVE_BITS = DefaultKeyOperation.of("deriveBits", "Derive bits not to be used as a key", null);
    final String id;
    final String description;
    final Set<String> related;

    static KeyOperation of(String id, String description, String related) {
        return new DefaultKeyOperation(id, description, Collections.setOf(related));
    }

    DefaultKeyOperation(String id) {
        this(id, null, null);
    }

    DefaultKeyOperation(String id, String description, Set<String> related) {
        this.id = Assert.hasText(id, "id cannot be null or empty.");
        this.description = Strings.hasText(description) ? description : CUSTOM_DESCRIPTION;
        this.related = related != null ? Collections.immutable(related) : Collections.emptySet();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isRelated(KeyOperation operation) {
        return this.equals(operation) || operation != null && this.related.contains(operation.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof KeyOperation && this.id.equals(((KeyOperation)obj).getId());
    }

    public String toString() {
        return "'" + this.id + "' (" + this.description + ")";
    }
}

