/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.net.URI;
import java.security.MessageDigest;
import shadowed.io.jsonwebtoken.io.Encoders;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.lang.Objects;
import shadowed.io.jsonwebtoken.lang.Strings;
import shadowed.io.jsonwebtoken.security.HashAlgorithm;
import shadowed.io.jsonwebtoken.security.JwkThumbprint;

class DefaultJwkThumbprint
implements JwkThumbprint {
    private static final String URI_PREFIX = "urn:ietf:params:oauth:jwk-thumbprint:";
    private final byte[] digest;
    private final HashAlgorithm alg;
    private final URI uri;
    private final int hashcode;
    private final String sval;

    DefaultJwkThumbprint(byte[] digest, HashAlgorithm alg) {
        this.digest = Assert.notEmpty(digest, "Thumbprint digest byte array cannot be null or empty.");
        this.alg = Assert.notNull(alg, "Thumbprint HashAlgorithm cannot be null.");
        String id = Assert.hasText(Strings.clean(alg.getId()), "Thumbprint HashAlgorithm id cannot be null or empty.");
        String base64Url = Encoders.BASE64URL.encode(digest);
        String s = URI_PREFIX + id + ":" + base64Url;
        this.uri = URI.create(s);
        this.hashcode = Objects.nullSafeHashCode(this.digest, this.alg);
        this.sval = Encoders.BASE64URL.encode(digest);
    }

    @Override
    public HashAlgorithm getHashAlgorithm() {
        return this.alg;
    }

    @Override
    public byte[] toByteArray() {
        return (byte[])this.digest.clone();
    }

    @Override
    public URI toURI() {
        return this.uri;
    }

    @Override
    public String toString() {
        return this.sval;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultJwkThumbprint) {
            DefaultJwkThumbprint other = (DefaultJwkThumbprint)obj;
            return this.alg.equals(other.alg) && MessageDigest.isEqual(this.digest, other.digest);
        }
        return false;
    }
}

