/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import shadowed.io.jsonwebtoken.impl.lang.CheckedFunction;
import shadowed.io.jsonwebtoken.impl.security.AesAlgorithm;
import shadowed.io.jsonwebtoken.impl.security.DefaultKeyResult;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.security.DecryptionKeyRequest;
import shadowed.io.jsonwebtoken.security.KeyRequest;
import shadowed.io.jsonwebtoken.security.KeyResult;
import shadowed.io.jsonwebtoken.security.SecretKeyAlgorithm;
import shadowed.io.jsonwebtoken.security.SecurityException;

public class AesWrapKeyAlgorithm
extends AesAlgorithm
implements SecretKeyAlgorithm {
    private static final String TRANSFORMATION = "AESWrap";

    public AesWrapKeyAlgorithm(int keyLen) {
        super("A" + keyLen + "KW", TRANSFORMATION, keyLen);
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        final SecretKey kek = this.assertKey((SecretKey)request.getPayload());
        final SecretKey cek = this.generateCek(request);
        byte[] ciphertext = this.jca(request).withCipher(new CheckedFunction<Cipher, byte[]>(){

            @Override
            public byte[] apply(Cipher cipher) throws Exception {
                cipher.init(3, kek);
                return cipher.wrap(cek);
            }
        });
        return new DefaultKeyResult(cek, ciphertext);
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        final SecretKey kek = this.assertKey((SecretKey)request.getKey());
        final byte[] cekBytes = Assert.notEmpty((byte[])request.getPayload(), "Request content (encrypted key) cannot be null or empty.");
        return this.jca(request).withCipher(new CheckedFunction<Cipher, SecretKey>(){

            @Override
            public SecretKey apply(Cipher cipher) throws Exception {
                cipher.init(4, kek);
                Key key = cipher.unwrap(cekBytes, "AES", 3);
                Assert.state(key instanceof SecretKey, "Cipher unwrap must return a SecretKey instance.");
                return (SecretKey)key;
            }
        });
    }
}

