/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.lang;

import java.net.URI;
import shadowed.io.jsonwebtoken.impl.lang.Converter;
import shadowed.io.jsonwebtoken.lang.Assert;

public class UriStringConverter
implements Converter<URI, CharSequence> {
    @Override
    public String applyTo(URI uri) {
        Assert.notNull(uri, "URI cannot be null.");
        return uri.toString();
    }

    @Override
    public URI applyFrom(CharSequence s) {
        Assert.hasText(s, "URI string cannot be null or empty.");
        try {
            return URI.create(s.toString());
        }
        catch (Exception e) {
            String msg = "Unable to convert String value '" + s + "' to URI instance: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

