/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.lang;

import java.util.Collection;
import shadowed.io.jsonwebtoken.Identifiable;
import shadowed.io.jsonwebtoken.impl.lang.Function;
import shadowed.io.jsonwebtoken.impl.lang.StringRegistry;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.lang.Strings;

public class IdRegistry<T extends Identifiable>
extends StringRegistry<T> {
    public static final Function<Identifiable, String> FN = new Function<Identifiable, String>(){

        @Override
        public String apply(Identifiable identifiable) {
            Assert.notNull(identifiable, "Identifiable argument cannot be null.");
            return Assert.notNull(Strings.clean(identifiable.getId()), "Identifier cannot be null or empty.");
        }
    };

    public static <T extends Identifiable> Function<T, String> fn() {
        return FN;
    }

    public IdRegistry(String name, Collection<T> instances) {
        this(name, instances, true);
    }

    public IdRegistry(String name, Collection<T> instances, boolean caseSensitive) {
        super(name, "id", Assert.notEmpty(instances, "Collection of Identifiable instances may not be null or empty."), IdRegistry.fn(), caseSensitive);
    }
}

