/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.lang;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import shadowed.io.jsonwebtoken.impl.lang.Converter;
import shadowed.io.jsonwebtoken.impl.lang.Converters;
import shadowed.io.jsonwebtoken.impl.lang.DefaultParameter;
import shadowed.io.jsonwebtoken.impl.lang.Parameter;
import shadowed.io.jsonwebtoken.impl.lang.ParameterBuilder;
import shadowed.io.jsonwebtoken.impl.lang.RedactedValueConverter;
import shadowed.io.jsonwebtoken.lang.Assert;

public class DefaultParameterBuilder<T>
implements ParameterBuilder<T> {
    private String id;
    private String name;
    private boolean secret;
    private final Class<T> type;
    private Converter<T, ?> converter;
    private Class<? extends Collection<T>> collectionType;

    public DefaultParameterBuilder(Class<T> type) {
        this.type = Assert.notNull(type, "Type cannot be null.");
    }

    @Override
    public ParameterBuilder<T> setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public ParameterBuilder<T> setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ParameterBuilder<T> setSecret(boolean secret) {
        this.secret = secret;
        return this;
    }

    @Override
    public ParameterBuilder<List<T>> list() {
        Class<List> clazz = List.class;
        this.collectionType = clazz;
        return this;
    }

    @Override
    public ParameterBuilder<Set<T>> set() {
        Class<Set> clazz = Set.class;
        this.collectionType = clazz;
        return this;
    }

    @Override
    public ParameterBuilder<T> setConverter(Converter<T, ?> converter) {
        this.converter = converter;
        return this;
    }

    @Override
    public Parameter<T> build() {
        Assert.notNull(this.type, "Type must be set.");
        Converter<Object, Object> conv = this.converter;
        if (conv == null) {
            conv = Converters.forType(this.type);
        }
        if (this.collectionType != null) {
            Converter<Collection<T>, Object> converter = conv = List.class.isAssignableFrom(this.collectionType) ? Converters.forList(conv) : Converters.forSet(conv);
        }
        if (this.secret) {
            conv = new RedactedValueConverter<T>(conv);
        }
        return new DefaultParameter<T>(this.id, this.name, this.secret, this.type, this.collectionType, conv);
    }
}

