/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.io;

import java.io.OutputStream;
import java.util.Map;
import shadowed.io.jsonwebtoken.io.AbstractSerializer;
import shadowed.io.jsonwebtoken.io.SerializationException;
import shadowed.io.jsonwebtoken.io.Serializer;
import shadowed.io.jsonwebtoken.lang.Assert;

public class NamedSerializer
extends AbstractSerializer<Map<String, ?>> {
    private final String name;
    private final Serializer<Map<String, ?>> DELEGATE;

    public NamedSerializer(String name, Serializer<Map<String, ?>> serializer) {
        this.DELEGATE = Assert.notNull(serializer, "JSON Serializer cannot be null.");
        this.name = Assert.hasText(name, "Name cannot be null or empty.");
    }

    @Override
    protected void doSerialize(Map<String, ?> m, OutputStream out) throws SerializationException {
        try {
            this.DELEGATE.serialize(m, out);
        }
        catch (Throwable t) {
            String msg = String.format("Cannot serialize %s to JSON. Cause: %s", this.name, t.getMessage());
            throw new SerializationException(msg, t);
        }
    }
}

