/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.io;

import java.io.InputStream;
import shadowed.io.jsonwebtoken.impl.io.FilteredInputStream;
import shadowed.io.jsonwebtoken.io.DecodingException;
import shadowed.io.jsonwebtoken.lang.Assert;

public class DecodingInputStream
extends FilteredInputStream {
    private final String codecName;
    private final String name;

    public DecodingInputStream(InputStream in, String codecName, String name) {
        super(in);
        this.codecName = Assert.hasText(codecName, "codecName cannot be null or empty.");
        this.name = Assert.hasText(name, "Name cannot be null or empty.");
    }

    @Override
    protected void onThrowable(Throwable t) {
        String msg = "Unable to " + this.codecName + "-decode " + this.name + ": " + t.getMessage();
        throw new DecodingException(msg, t);
    }
}

