/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.io;

import shadowed.io.jsonwebtoken.impl.lang.Converter;
import shadowed.io.jsonwebtoken.io.Decoder;
import shadowed.io.jsonwebtoken.io.Decoders;
import shadowed.io.jsonwebtoken.io.DecodingException;
import shadowed.io.jsonwebtoken.io.Encoder;
import shadowed.io.jsonwebtoken.io.Encoders;
import shadowed.io.jsonwebtoken.lang.Assert;

public class Codec
implements Converter<byte[], CharSequence> {
    public static final Codec BASE64 = new Codec(Encoders.BASE64, Decoders.BASE64);
    public static final Codec BASE64URL = new Codec(Encoders.BASE64URL, Decoders.BASE64URL);
    private final Encoder<byte[], String> encoder;
    private final Decoder<CharSequence, byte[]> decoder;

    public Codec(Encoder<byte[], String> encoder, Decoder<CharSequence, byte[]> decoder) {
        this.encoder = Assert.notNull(encoder, "Encoder cannot be null.");
        this.decoder = Assert.notNull(decoder, "Decoder cannot be null.");
    }

    @Override
    public String applyTo(byte[] a) {
        return this.encoder.encode(a);
    }

    @Override
    public byte[] applyFrom(CharSequence b) {
        try {
            return this.decoder.decode(b);
        }
        catch (DecodingException e) {
            String msg = "Cannot decode input String. Cause: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

