/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.Channel;
import io.getstream.chat.java.models.DeleteStrategy;
import io.getstream.chat.java.models.Device;
import io.getstream.chat.java.models.Flag;
import io.getstream.chat.java.models.Language;
import io.getstream.chat.java.models.LanguageDeserializer;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.Reaction;
import io.getstream.chat.java.models.Sort;
import io.getstream.chat.java.models.framework.RequestObjectBuilder;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.UserService;
import io.getstream.chat.java.services.framework.Client;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.crypto.spec.SecretKeySpec;
import shadowed.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadowed.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadowed.com.fasterxml.jackson.annotation.JsonIgnore;
import shadowed.com.fasterxml.jackson.annotation.JsonInclude;
import shadowed.com.fasterxml.jackson.annotation.JsonProperty;
import shadowed.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadowed.io.jsonwebtoken.JwtBuilder;
import shadowed.io.jsonwebtoken.Jwts;
import shadowed.io.jsonwebtoken.SignatureAlgorithm;
import shadowed.org.jetbrains.annotations.NotNull;
import shadowed.org.jetbrains.annotations.Nullable;
import shadowed.retrofit2.Call;

public class User {
    @JsonProperty(value="id")
    @NotNull
    private String id;
    @JsonProperty(value="name")
    @Nullable
    private String name;
    @JsonProperty(value="image")
    @Nullable
    private String image;
    @JsonProperty(value="role")
    @NotNull
    private String role;
    @JsonProperty(value="teams")
    @NotNull
    private List<String> teams;
    @JsonProperty(value="online")
    @NotNull
    private Boolean online;
    @JsonProperty(value="invisible")
    @NotNull
    private Boolean invisible;
    @JsonProperty(value="created_at")
    @Nullable
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Nullable
    private Date updatedAt;
    @JsonProperty(value="last_active")
    @Nullable
    private Date lastActive;
    @JsonProperty(value="deleted_at")
    @Nullable
    private Date deletedAt;
    @JsonProperty(value="deactivated_at")
    @Nullable
    private Date deactivatedAt;
    @JsonProperty(value="banned")
    @Nullable
    private Boolean banned;
    @JsonProperty(value="ban_expires")
    @Nullable
    private String banExpires;
    @JsonProperty(value="shadow_banned")
    @Nullable
    private Boolean shadowBanned;
    @JsonProperty(value="language")
    @JsonDeserialize(using=LanguageDeserializer.class)
    @Nullable
    private Language language;
    @JsonProperty(value="mutes")
    @Nullable
    private List<Mute> mutes;
    @JsonProperty(value="channel_mutes")
    @Nullable
    private List<ChannelMute> channelMutes;
    @JsonIgnore
    @NotNull
    private Map<String, Object> additionalFields = new HashMap<String, Object>();
    @JsonProperty(value="blocked_user_ids")
    @Nullable
    private List<String> blockedUserIDs;

    @JsonAnyGetter
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    @JsonAnySetter
    public void setAdditionalField(String name, Object value) {
        this.additionalFields.put(name, value);
    }

    @NotNull
    public static UserListRequestData.UserListRequest list() {
        return new UserListRequestData.UserListRequest();
    }

    @NotNull
    public static UserUpsertRequestData.UserUpsertRequest upsert() {
        return new UserUpsertRequestData.UserUpsertRequest();
    }

    @NotNull
    public static UserPartialUpdateRequestData.UserPartialUpdateRequest partialUpdate() {
        return new UserPartialUpdateRequestData.UserPartialUpdateRequest();
    }

    @NotNull
    public static UserBanRequestData.UserBanRequest ban() {
        return new UserBanRequestData.UserBanRequest();
    }

    @NotNull
    public static UserBanRequestData.UserBanRequest shadowBan() {
        return new UserBanRequestData.UserBanRequest().shadow(true);
    }

    @NotNull
    public static UserQueryBannedRequestData.UserQueryBannedRequest queryBanned() {
        return new UserQueryBannedRequestData.UserQueryBannedRequest();
    }

    @NotNull
    public static UserDeactivateRequestData.UserDeactivateRequest deactivate(@NotNull String userId) {
        return new UserDeactivateRequestData.UserDeactivateRequest(userId);
    }

    @NotNull
    public static UserDeleteRequest delete(@NotNull String userId) {
        return new UserDeleteRequest(userId);
    }

    @NotNull
    public static UserDeleteManyRequestData.UserDeleteManyRequest deleteMany(@NotNull List<String> userIds) {
        return new UserDeleteManyRequestData.UserDeleteManyRequest().userIds(userIds);
    }

    @NotNull
    public static UserReactivateRequestData.UserReactivateRequest reactivate(@NotNull String userId) {
        return new UserReactivateRequestData.UserReactivateRequest(userId);
    }

    @NotNull
    public static Flag.FlagCreateRequestData.FlagCreateRequest flag(@NotNull String userId) {
        return new Flag.FlagCreateRequestData.FlagCreateRequest().targetUserId(userId);
    }

    @NotNull
    public static Flag.FlagDeleteRequestData.FlagDeleteRequest unflag(@NotNull String userId) {
        return new Flag.FlagDeleteRequestData.FlagDeleteRequest().targetUserId(userId);
    }

    @NotNull
    public static UserMuteRequestData.UserMuteRequest mute() {
        return new UserMuteRequestData.UserMuteRequest();
    }

    @NotNull
    public static UserUnmuteRequestData.UserUnmuteRequest unmute() {
        return new UserUnmuteRequestData.UserUnmuteRequest();
    }

    @NotNull
    public static UserExportRequest export(@NotNull String userId) {
        return new UserExportRequest(userId);
    }

    @NotNull
    public static UserCreateGuestRequestData.UserCreateGuestRequest createGuest() {
        return new UserCreateGuestRequestData.UserCreateGuestRequest();
    }

    @NotNull
    public static UserUnbanRequest unban(@NotNull String targetUserId) {
        return new UserUnbanRequest(targetUserId);
    }

    @NotNull
    public static UserUnbanRequest removeShadowBan(@NotNull String targetUserId) {
        return new UserUnbanRequest(targetUserId).shadow(true);
    }

    @NotNull
    public static UserRevokeTokensRequest revokeToken(@NotNull String userId, @Nullable Date revokeTokensIssuedBefore) {
        return new UserRevokeTokensRequest(Arrays.asList(userId), revokeTokensIssuedBefore);
    }

    @NotNull
    public static UserRevokeTokensRequest revokeTokens(@NotNull List<String> userIds, @Nullable Date revokeTokensIssuedBefore) {
        return new UserRevokeTokensRequest(userIds, revokeTokensIssuedBefore);
    }

    @NotNull
    public static String createToken(@NotNull String userId, @Nullable Date expiresAt, @Nullable Date issuedAt) {
        return User.createToken(Client.getInstance().getApiSecret(), userId, expiresAt, issuedAt);
    }

    @NotNull
    public static String createToken(@NotNull String apiSecret, @NotNull String userId, @Nullable Date expiresAt, @Nullable Date issuedAt) {
        SecretKeySpec signingKey = new SecretKeySpec(apiSecret.getBytes(StandardCharsets.UTF_8), SignatureAlgorithm.HS256.getJcaName());
        if (issuedAt == null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.add(13, -5);
            issuedAt = calendar.getTime();
        }
        return ((JwtBuilder)((JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().claim("user_id", userId).setExpiration(expiresAt)).setIssuedAt(issuedAt)).setIssuer("Stream Chat Java SDK")).setSubject("Stream Chat Java SDK")).signWith(signingKey, SignatureAlgorithm.HS256).compact();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getImage() {
        return this.image;
    }

    @NotNull
    public String getRole() {
        return this.role;
    }

    @NotNull
    public List<String> getTeams() {
        return this.teams;
    }

    @NotNull
    public Boolean getOnline() {
        return this.online;
    }

    @NotNull
    public Boolean getInvisible() {
        return this.invisible;
    }

    @Nullable
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public Date getLastActive() {
        return this.lastActive;
    }

    @Nullable
    public Date getDeletedAt() {
        return this.deletedAt;
    }

    @Nullable
    public Date getDeactivatedAt() {
        return this.deactivatedAt;
    }

    @Nullable
    public Boolean getBanned() {
        return this.banned;
    }

    @Nullable
    public String getBanExpires() {
        return this.banExpires;
    }

    @Nullable
    public Boolean getShadowBanned() {
        return this.shadowBanned;
    }

    @Nullable
    public Language getLanguage() {
        return this.language;
    }

    @Nullable
    public List<Mute> getMutes() {
        return this.mutes;
    }

    @Nullable
    public List<ChannelMute> getChannelMutes() {
        return this.channelMutes;
    }

    @Nullable
    public List<String> getBlockedUserIDs() {
        return this.blockedUserIDs;
    }

    @JsonProperty(value="id")
    public void setId(@NotNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="name")
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @JsonProperty(value="image")
    public void setImage(@Nullable String image) {
        this.image = image;
    }

    @JsonProperty(value="role")
    public void setRole(@NotNull String role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    @JsonProperty(value="teams")
    public void setTeams(@NotNull List<String> teams) {
        if (teams == null) {
            throw new NullPointerException("teams is marked non-null but is null");
        }
        this.teams = teams;
    }

    @JsonProperty(value="online")
    public void setOnline(@NotNull Boolean online) {
        if (online == null) {
            throw new NullPointerException("online is marked non-null but is null");
        }
        this.online = online;
    }

    @JsonProperty(value="invisible")
    public void setInvisible(@NotNull Boolean invisible) {
        if (invisible == null) {
            throw new NullPointerException("invisible is marked non-null but is null");
        }
        this.invisible = invisible;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@Nullable Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(@Nullable Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="last_active")
    public void setLastActive(@Nullable Date lastActive) {
        this.lastActive = lastActive;
    }

    @JsonProperty(value="deleted_at")
    public void setDeletedAt(@Nullable Date deletedAt) {
        this.deletedAt = deletedAt;
    }

    @JsonProperty(value="deactivated_at")
    public void setDeactivatedAt(@Nullable Date deactivatedAt) {
        this.deactivatedAt = deactivatedAt;
    }

    @JsonProperty(value="banned")
    public void setBanned(@Nullable Boolean banned) {
        this.banned = banned;
    }

    @JsonProperty(value="ban_expires")
    public void setBanExpires(@Nullable String banExpires) {
        this.banExpires = banExpires;
    }

    @JsonProperty(value="shadow_banned")
    public void setShadowBanned(@Nullable Boolean shadowBanned) {
        this.shadowBanned = shadowBanned;
    }

    @JsonProperty(value="language")
    @JsonDeserialize(using=LanguageDeserializer.class)
    public void setLanguage(@Nullable Language language) {
        this.language = language;
    }

    @JsonProperty(value="mutes")
    public void setMutes(@Nullable List<Mute> mutes) {
        this.mutes = mutes;
    }

    @JsonProperty(value="channel_mutes")
    public void setChannelMutes(@Nullable List<ChannelMute> channelMutes) {
        this.channelMutes = channelMutes;
    }

    @JsonIgnore
    public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
        if (additionalFields == null) {
            throw new NullPointerException("additionalFields is marked non-null but is null");
        }
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="blocked_user_ids")
    public void setBlockedUserIDs(@Nullable List<String> blockedUserIDs) {
        this.blockedUserIDs = blockedUserIDs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$online = this.getOnline();
        Boolean other$online = other.getOnline();
        if (this$online == null ? other$online != null : !((Object)this$online).equals(other$online)) {
            return false;
        }
        Boolean this$invisible = this.getInvisible();
        Boolean other$invisible = other.getInvisible();
        if (this$invisible == null ? other$invisible != null : !((Object)this$invisible).equals(other$invisible)) {
            return false;
        }
        Boolean this$banned = this.getBanned();
        Boolean other$banned = other.getBanned();
        if (this$banned == null ? other$banned != null : !((Object)this$banned).equals(other$banned)) {
            return false;
        }
        Boolean this$shadowBanned = this.getShadowBanned();
        Boolean other$shadowBanned = other.getShadowBanned();
        if (this$shadowBanned == null ? other$shadowBanned != null : !((Object)this$shadowBanned).equals(other$shadowBanned)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        List<String> this$teams = this.getTeams();
        List<String> other$teams = other.getTeams();
        if (this$teams == null ? other$teams != null : !((Object)this$teams).equals(other$teams)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Date this$lastActive = this.getLastActive();
        Date other$lastActive = other.getLastActive();
        if (this$lastActive == null ? other$lastActive != null : !((Object)this$lastActive).equals(other$lastActive)) {
            return false;
        }
        Date this$deletedAt = this.getDeletedAt();
        Date other$deletedAt = other.getDeletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        Date this$deactivatedAt = this.getDeactivatedAt();
        Date other$deactivatedAt = other.getDeactivatedAt();
        if (this$deactivatedAt == null ? other$deactivatedAt != null : !((Object)this$deactivatedAt).equals(other$deactivatedAt)) {
            return false;
        }
        String this$banExpires = this.getBanExpires();
        String other$banExpires = other.getBanExpires();
        if (this$banExpires == null ? other$banExpires != null : !this$banExpires.equals(other$banExpires)) {
            return false;
        }
        Language this$language = this.getLanguage();
        Language other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language)) {
            return false;
        }
        List<Mute> this$mutes = this.getMutes();
        List<Mute> other$mutes = other.getMutes();
        if (this$mutes == null ? other$mutes != null : !((Object)this$mutes).equals(other$mutes)) {
            return false;
        }
        List<ChannelMute> this$channelMutes = this.getChannelMutes();
        List<ChannelMute> other$channelMutes = other.getChannelMutes();
        if (this$channelMutes == null ? other$channelMutes != null : !((Object)this$channelMutes).equals(other$channelMutes)) {
            return false;
        }
        Map<String, Object> this$additionalFields = this.getAdditionalFields();
        Map<String, Object> other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        List<String> this$blockedUserIDs = this.getBlockedUserIDs();
        List<String> other$blockedUserIDs = other.getBlockedUserIDs();
        return !(this$blockedUserIDs == null ? other$blockedUserIDs != null : !((Object)this$blockedUserIDs).equals(other$blockedUserIDs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $online = this.getOnline();
        result = result * 59 + ($online == null ? 43 : ((Object)$online).hashCode());
        Boolean $invisible = this.getInvisible();
        result = result * 59 + ($invisible == null ? 43 : ((Object)$invisible).hashCode());
        Boolean $banned = this.getBanned();
        result = result * 59 + ($banned == null ? 43 : ((Object)$banned).hashCode());
        Boolean $shadowBanned = this.getShadowBanned();
        result = result * 59 + ($shadowBanned == null ? 43 : ((Object)$shadowBanned).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        List<String> $teams = this.getTeams();
        result = result * 59 + ($teams == null ? 43 : ((Object)$teams).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Date $lastActive = this.getLastActive();
        result = result * 59 + ($lastActive == null ? 43 : ((Object)$lastActive).hashCode());
        Date $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        Date $deactivatedAt = this.getDeactivatedAt();
        result = result * 59 + ($deactivatedAt == null ? 43 : ((Object)$deactivatedAt).hashCode());
        String $banExpires = this.getBanExpires();
        result = result * 59 + ($banExpires == null ? 43 : $banExpires.hashCode());
        Language $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : ((Object)((Object)$language)).hashCode());
        List<Mute> $mutes = this.getMutes();
        result = result * 59 + ($mutes == null ? 43 : ((Object)$mutes).hashCode());
        List<ChannelMute> $channelMutes = this.getChannelMutes();
        result = result * 59 + ($channelMutes == null ? 43 : ((Object)$channelMutes).hashCode());
        Map<String, Object> $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        List<String> $blockedUserIDs = this.getBlockedUserIDs();
        result = result * 59 + ($blockedUserIDs == null ? 43 : ((Object)$blockedUserIDs).hashCode());
        return result;
    }

    public String toString() {
        return "User(id=" + this.getId() + ", name=" + this.getName() + ", image=" + this.getImage() + ", role=" + this.getRole() + ", teams=" + this.getTeams() + ", online=" + this.getOnline() + ", invisible=" + this.getInvisible() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", lastActive=" + this.getLastActive() + ", deletedAt=" + this.getDeletedAt() + ", deactivatedAt=" + this.getDeactivatedAt() + ", banned=" + this.getBanned() + ", banExpires=" + this.getBanExpires() + ", shadowBanned=" + this.getShadowBanned() + ", language=" + this.getLanguage() + ", mutes=" + this.getMutes() + ", channelMutes=" + this.getChannelMutes() + ", additionalFields=" + this.getAdditionalFields() + ", blockedUserIDs=" + this.getBlockedUserIDs() + ")";
    }

    public static class UserCreateGuestResponse
    extends StreamResponseObject {
        @JsonProperty(value="user")
        @NotNull
        private User user;
        @JsonProperty(value="access_token")
        @NotNull
        private String accessToken;

        @NotNull
        public User getUser() {
            return this.user;
        }

        @NotNull
        public String getAccessToken() {
            return this.accessToken;
        }

        @JsonProperty(value="user")
        public void setUser(@NotNull User user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
        }

        @JsonProperty(value="access_token")
        public void setAccessToken(@NotNull String accessToken) {
            if (accessToken == null) {
                throw new NullPointerException("accessToken is marked non-null but is null");
            }
            this.accessToken = accessToken;
        }

        @Override
        public String toString() {
            return "User.UserCreateGuestResponse(user=" + this.getUser() + ", accessToken=" + this.getAccessToken() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserCreateGuestResponse)) {
                return false;
            }
            UserCreateGuestResponse other = (UserCreateGuestResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            return !(this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserCreateGuestResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            return result;
        }
    }

    public static class UserExportResponse
    extends StreamResponseObject {
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="messages")
        @Nullable
        private List<Message> messages;
        @JsonProperty(value="reactions")
        @Nullable
        private List<Reaction> reactions;

        @Nullable
        public User getUser() {
            return this.user;
        }

        @Nullable
        public List<Message> getMessages() {
            return this.messages;
        }

        @Nullable
        public List<Reaction> getReactions() {
            return this.reactions;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty(value="messages")
        public void setMessages(@Nullable List<Message> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="reactions")
        public void setReactions(@Nullable List<Reaction> reactions) {
            this.reactions = reactions;
        }

        @Override
        public String toString() {
            return "User.UserExportResponse(user=" + this.getUser() + ", messages=" + this.getMessages() + ", reactions=" + this.getReactions() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserExportResponse)) {
                return false;
            }
            UserExportResponse other = (UserExportResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            List<Message> this$messages = this.getMessages();
            List<Message> other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            List<Reaction> this$reactions = this.getReactions();
            List<Reaction> other$reactions = other.getReactions();
            return !(this$reactions == null ? other$reactions != null : !((Object)this$reactions).equals(other$reactions));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserExportResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            List<Message> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            List<Reaction> $reactions = this.getReactions();
            result = result * 59 + ($reactions == null ? 43 : ((Object)$reactions).hashCode());
            return result;
        }
    }

    public static class UserMuteResponse
    extends StreamResponseObject {
        @JsonProperty(value="mute")
        @Nullable
        private UserMute mute;
        @JsonProperty(value="mutes")
        @Nullable
        private List<UserMute> mutes;
        @JsonProperty(value="own_user")
        @NotNull
        private OwnUser ownUser;

        @Nullable
        public UserMute getMute() {
            return this.mute;
        }

        @Nullable
        public List<UserMute> getMutes() {
            return this.mutes;
        }

        @NotNull
        public OwnUser getOwnUser() {
            return this.ownUser;
        }

        @JsonProperty(value="mute")
        public void setMute(@Nullable UserMute mute) {
            this.mute = mute;
        }

        @JsonProperty(value="mutes")
        public void setMutes(@Nullable List<UserMute> mutes) {
            this.mutes = mutes;
        }

        @JsonProperty(value="own_user")
        public void setOwnUser(@NotNull OwnUser ownUser) {
            if (ownUser == null) {
                throw new NullPointerException("ownUser is marked non-null but is null");
            }
            this.ownUser = ownUser;
        }

        @Override
        public String toString() {
            return "User.UserMuteResponse(mute=" + this.getMute() + ", mutes=" + this.getMutes() + ", ownUser=" + this.getOwnUser() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserMuteResponse)) {
                return false;
            }
            UserMuteResponse other = (UserMuteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UserMute this$mute = this.getMute();
            UserMute other$mute = other.getMute();
            if (this$mute == null ? other$mute != null : !((Object)this$mute).equals(other$mute)) {
                return false;
            }
            List<UserMute> this$mutes = this.getMutes();
            List<UserMute> other$mutes = other.getMutes();
            if (this$mutes == null ? other$mutes != null : !((Object)this$mutes).equals(other$mutes)) {
                return false;
            }
            OwnUser this$ownUser = this.getOwnUser();
            OwnUser other$ownUser = other.getOwnUser();
            return !(this$ownUser == null ? other$ownUser != null : !((Object)this$ownUser).equals(other$ownUser));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserMuteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            UserMute $mute = this.getMute();
            result = result * 59 + ($mute == null ? 43 : ((Object)$mute).hashCode());
            List<UserMute> $mutes = this.getMutes();
            result = result * 59 + ($mutes == null ? 43 : ((Object)$mutes).hashCode());
            OwnUser $ownUser = this.getOwnUser();
            result = result * 59 + ($ownUser == null ? 43 : ((Object)$ownUser).hashCode());
            return result;
        }
    }

    public static class UserReactivateResponse
    extends StreamResponseObject {
        @JsonProperty(value="user")
        @NotNull
        private User user;

        @NotNull
        public User getUser() {
            return this.user;
        }

        @JsonProperty(value="user")
        public void setUser(@NotNull User user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
        }

        @Override
        public String toString() {
            return "User.UserReactivateResponse(user=" + this.getUser() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserReactivateResponse)) {
                return false;
            }
            UserReactivateResponse other = (UserReactivateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserReactivateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }
    }

    public static class UserDeleteResponse
    extends StreamResponseObject {
        @JsonProperty(value="user")
        @NotNull
        private User user;

        @NotNull
        public User getUser() {
            return this.user;
        }

        @JsonProperty(value="user")
        public void setUser(@NotNull User user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
        }

        @Override
        public String toString() {
            return "User.UserDeleteResponse(user=" + this.getUser() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserDeleteResponse)) {
                return false;
            }
            UserDeleteResponse other = (UserDeleteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserDeleteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }
    }

    public static class UserDeactivateResponse
    extends StreamResponseObject {
        @JsonProperty(value="user")
        @NotNull
        private User user;

        @NotNull
        public User getUser() {
            return this.user;
        }

        @JsonProperty(value="user")
        public void setUser(@NotNull User user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
        }

        @Override
        public String toString() {
            return "User.UserDeactivateResponse(user=" + this.getUser() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserDeactivateResponse)) {
                return false;
            }
            UserDeactivateResponse other = (UserDeactivateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserDeactivateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }
    }

    public static class UserQueryBannedResponse
    extends StreamResponseObject {
        @JsonProperty(value="bans")
        @NotNull
        private List<Ban> bans;

        @NotNull
        public List<Ban> getBans() {
            return this.bans;
        }

        @JsonProperty(value="bans")
        public void setBans(@NotNull List<Ban> bans) {
            if (bans == null) {
                throw new NullPointerException("bans is marked non-null but is null");
            }
            this.bans = bans;
        }

        @Override
        public String toString() {
            return "User.UserQueryBannedResponse(bans=" + this.getBans() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserQueryBannedResponse)) {
                return false;
            }
            UserQueryBannedResponse other = (UserQueryBannedResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Ban> this$bans = this.getBans();
            List<Ban> other$bans = other.getBans();
            return !(this$bans == null ? other$bans != null : !((Object)this$bans).equals(other$bans));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserQueryBannedResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Ban> $bans = this.getBans();
            result = result * 59 + ($bans == null ? 43 : ((Object)$bans).hashCode());
            return result;
        }
    }

    public static class UserPartialUpdateResponse
    extends StreamResponseObject {
        @JsonProperty(value="users")
        @NotNull
        private Map<String, User> users;

        @NotNull
        public Map<String, User> getUsers() {
            return this.users;
        }

        @JsonProperty(value="users")
        public void setUsers(@NotNull Map<String, User> users) {
            if (users == null) {
                throw new NullPointerException("users is marked non-null but is null");
            }
            this.users = users;
        }

        @Override
        public String toString() {
            return "User.UserPartialUpdateResponse(users=" + this.getUsers() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserPartialUpdateResponse)) {
                return false;
            }
            UserPartialUpdateResponse other = (UserPartialUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, User> this$users = this.getUsers();
            Map<String, User> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserPartialUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, User> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }
    }

    public static class UserListResponse
    extends StreamResponseObject {
        @JsonProperty(value="users")
        @NotNull
        private List<User> users;

        @NotNull
        public List<User> getUsers() {
            return this.users;
        }

        @JsonProperty(value="users")
        public void setUsers(@NotNull List<User> users) {
            if (users == null) {
                throw new NullPointerException("users is marked non-null but is null");
            }
            this.users = users;
        }

        @Override
        public String toString() {
            return "User.UserListResponse(users=" + this.getUsers() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserListResponse)) {
                return false;
            }
            UserListResponse other = (UserListResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<User> this$users = this.getUsers();
            List<User> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserListResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<User> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }
    }

    public static class UserUpsertResponse
    extends StreamResponseObject {
        @JsonProperty(value="users")
        @NotNull
        private Map<String, User> users;

        @NotNull
        public Map<String, User> getUsers() {
            return this.users;
        }

        @JsonProperty(value="users")
        public void setUsers(@NotNull Map<String, User> users) {
            if (users == null) {
                throw new NullPointerException("users is marked non-null but is null");
            }
            this.users = users;
        }

        @Override
        public String toString() {
            return "User.UserUpsertResponse(users=" + this.getUsers() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserUpsertResponse)) {
                return false;
            }
            UserUpsertResponse other = (UserUpsertResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, User> this$users = this.getUsers();
            Map<String, User> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserUpsertResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, User> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }
    }

    public static class UserRevokeTokensRequest
    extends StreamRequest<UserPartialUpdateResponse> {
        @NotNull
        private List<String> userIds = new ArrayList<String>();
        @Nullable
        private Date revokeTokensIssuedBefore;

        @Override
        protected Call<UserPartialUpdateResponse> generateCall(Client client) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            return client.create(UserService.class).partialUpdate(new UserPartialUpdateRequestData.UserPartialUpdateRequest().users(this.userIds.stream().map(userId -> UserPartialUpdateRequestObject.builder().id((String)userId).setValue("revoke_tokens_issued_before", this.revokeTokensIssuedBefore == null ? null : formatter.format(this.revokeTokensIssuedBefore)).build()).collect(Collectors.toList())).internalBuild());
        }

        public UserRevokeTokensRequest(@NotNull List<String> userIds, @Nullable Date revokeTokensIssuedBefore) {
            if (userIds == null) {
                throw new NullPointerException("userIds is marked non-null but is null");
            }
            this.userIds = userIds;
            this.revokeTokensIssuedBefore = revokeTokensIssuedBefore;
        }
    }

    public static class UserUnbanRequest
    extends StreamRequest<StreamResponseObject> {
        @NotNull
        private String targetUserId;
        @Nullable
        private String type;
        @Nullable
        private String id;
        @Nullable
        private Boolean shadow;

        @NotNull
        public UserUnbanRequest type(@NotNull String type) {
            this.type = type;
            return this;
        }

        @NotNull
        public UserUnbanRequest id(@NotNull String id) {
            this.id = id;
            return this;
        }

        @NotNull
        public UserUnbanRequest shadow(@NotNull Boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        @Override
        protected Call<StreamResponseObject> generateCall(Client client) {
            return client.create(UserService.class).unban(this.targetUserId, this.type, this.id, this.shadow);
        }

        public UserUnbanRequest(@NotNull String targetUserId) {
            if (targetUserId == null) {
                throw new NullPointerException("targetUserId is marked non-null but is null");
            }
            this.targetUserId = targetUserId;
        }
    }

    public static class UserExportRequest
    extends StreamRequest<UserExportResponse> {
        @NotNull
        private String userId;

        @Override
        protected Call<UserExportResponse> generateCall(Client client) {
            return client.create(UserService.class).export(this.userId);
        }

        public UserExportRequest(@NotNull String userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
        }
    }

    public static class UserCreateGuestRequestData {
        @JsonProperty(value="user")
        @Nullable
        private UserRequestObject user;

        UserCreateGuestRequestData(@Nullable UserRequestObject user) {
            this.user = user;
        }

        public static class UserCreateGuestRequest
        extends StreamRequest<UserCreateGuestResponse> {
            private UserRequestObject user;

            @Override
            protected Call<UserCreateGuestResponse> generateCall(Client client) {
                return client.create(UserService.class).createGuest(this.internalBuild());
            }

            UserCreateGuestRequest() {
            }

            @JsonProperty(value="user")
            public UserCreateGuestRequest user(@Nullable UserRequestObject user) {
                this.user = user;
                return this;
            }

            public UserCreateGuestRequestData internalBuild() {
                return new UserCreateGuestRequestData(this.user);
            }

            public String toString() {
                return "User.UserCreateGuestRequestData.UserCreateGuestRequest(user=" + this.user + ")";
            }
        }
    }

    public static class UserUnmuteRequestData {
        @JsonProperty(value="target_id")
        @Nullable
        private String singleTargetId;
        @JsonProperty(value="target_ids")
        @Nullable
        private List<String> targetIds;
        @JsonProperty(value="timeout")
        @Nullable
        private Integer timeout;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private UserRequestObject user;

        UserUnmuteRequestData(@Nullable String singleTargetId, @Nullable List<String> targetIds, @Nullable Integer timeout2, @Nullable String userId, @Nullable UserRequestObject user) {
            this.singleTargetId = singleTargetId;
            this.targetIds = targetIds;
            this.timeout = timeout2;
            this.userId = userId;
            this.user = user;
        }

        public static class UserUnmuteRequest
        extends StreamRequest<StreamResponseObject> {
            private String singleTargetId;
            private ArrayList<String> targetIds;
            private Integer timeout;
            private String userId;
            private UserRequestObject user;

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(UserService.class).unmute(this.internalBuild());
            }

            UserUnmuteRequest() {
            }

            @JsonProperty(value="target_id")
            public UserUnmuteRequest singleTargetId(@Nullable String singleTargetId) {
                this.singleTargetId = singleTargetId;
                return this;
            }

            public UserUnmuteRequest targetId(String targetId) {
                if (this.targetIds == null) {
                    this.targetIds = new ArrayList();
                }
                this.targetIds.add(targetId);
                return this;
            }

            @JsonProperty(value="target_ids")
            public UserUnmuteRequest targetIds(Collection<? extends String> targetIds) {
                if (targetIds == null) {
                    throw new NullPointerException("targetIds cannot be null");
                }
                if (this.targetIds == null) {
                    this.targetIds = new ArrayList();
                }
                this.targetIds.addAll(targetIds);
                return this;
            }

            public UserUnmuteRequest clearTargetIds() {
                if (this.targetIds != null) {
                    this.targetIds.clear();
                }
                return this;
            }

            @JsonProperty(value="timeout")
            public UserUnmuteRequest timeout(@Nullable Integer timeout2) {
                this.timeout = timeout2;
                return this;
            }

            @JsonProperty(value="user_id")
            public UserUnmuteRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public UserUnmuteRequest user(@Nullable UserRequestObject user) {
                this.user = user;
                return this;
            }

            public UserUnmuteRequestData internalBuild() {
                List<String> targetIds;
                switch (this.targetIds == null ? 0 : this.targetIds.size()) {
                    case 0: {
                        targetIds = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        targetIds = Collections.singletonList(this.targetIds.get(0));
                        break;
                    }
                    default: {
                        targetIds = Collections.unmodifiableList(new ArrayList<String>(this.targetIds));
                    }
                }
                return new UserUnmuteRequestData(this.singleTargetId, targetIds, this.timeout, this.userId, this.user);
            }

            public String toString() {
                return "User.UserUnmuteRequestData.UserUnmuteRequest(singleTargetId=" + this.singleTargetId + ", targetIds=" + this.targetIds + ", timeout=" + this.timeout + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class UserMuteRequestData {
        @JsonProperty(value="target_id")
        @Nullable
        private String singleTargetId;
        @JsonProperty(value="target_ids")
        @Nullable
        private List<String> targetIds;
        @JsonProperty(value="timeout")
        @Nullable
        private Integer timeout;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private UserRequestObject user;

        UserMuteRequestData(@Nullable String singleTargetId, @Nullable List<String> targetIds, @Nullable Integer timeout2, @Nullable String userId, @Nullable UserRequestObject user) {
            this.singleTargetId = singleTargetId;
            this.targetIds = targetIds;
            this.timeout = timeout2;
            this.userId = userId;
            this.user = user;
        }

        public static class UserMuteRequest
        extends StreamRequest<UserMuteResponse> {
            private String singleTargetId;
            private ArrayList<String> targetIds;
            private Integer timeout;
            private String userId;
            private UserRequestObject user;

            @Override
            protected Call<UserMuteResponse> generateCall(Client client) {
                return client.create(UserService.class).mute(this.internalBuild());
            }

            UserMuteRequest() {
            }

            @JsonProperty(value="target_id")
            public UserMuteRequest singleTargetId(@Nullable String singleTargetId) {
                this.singleTargetId = singleTargetId;
                return this;
            }

            public UserMuteRequest targetId(String targetId) {
                if (this.targetIds == null) {
                    this.targetIds = new ArrayList();
                }
                this.targetIds.add(targetId);
                return this;
            }

            @JsonProperty(value="target_ids")
            public UserMuteRequest targetIds(Collection<? extends String> targetIds) {
                if (targetIds == null) {
                    throw new NullPointerException("targetIds cannot be null");
                }
                if (this.targetIds == null) {
                    this.targetIds = new ArrayList();
                }
                this.targetIds.addAll(targetIds);
                return this;
            }

            public UserMuteRequest clearTargetIds() {
                if (this.targetIds != null) {
                    this.targetIds.clear();
                }
                return this;
            }

            @JsonProperty(value="timeout")
            public UserMuteRequest timeout(@Nullable Integer timeout2) {
                this.timeout = timeout2;
                return this;
            }

            @JsonProperty(value="user_id")
            public UserMuteRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public UserMuteRequest user(@Nullable UserRequestObject user) {
                this.user = user;
                return this;
            }

            public UserMuteRequestData internalBuild() {
                List<String> targetIds;
                switch (this.targetIds == null ? 0 : this.targetIds.size()) {
                    case 0: {
                        targetIds = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        targetIds = Collections.singletonList(this.targetIds.get(0));
                        break;
                    }
                    default: {
                        targetIds = Collections.unmodifiableList(new ArrayList<String>(this.targetIds));
                    }
                }
                return new UserMuteRequestData(this.singleTargetId, targetIds, this.timeout, this.userId, this.user);
            }

            public String toString() {
                return "User.UserMuteRequestData.UserMuteRequest(singleTargetId=" + this.singleTargetId + ", targetIds=" + this.targetIds + ", timeout=" + this.timeout + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class UserReactivateRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="restore_messages")
        @Nullable
        private Boolean restoreMessages;
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="created_by_id")
        @Nullable
        private String createdById;

        UserReactivateRequestData(@Nullable String userId, @Nullable Boolean restoreMessages, @Nullable String name, @Nullable String createdById) {
            this.userId = userId;
            this.restoreMessages = restoreMessages;
            this.name = name;
            this.createdById = createdById;
        }

        public static class UserReactivateRequest
        extends StreamRequest<UserReactivateResponse> {
            private String userId;
            private Boolean restoreMessages;
            private String name;
            private String createdById;

            private UserReactivateRequest(@NotNull String userId) {
                this.userId = userId;
            }

            @Override
            protected Call<UserReactivateResponse> generateCall(Client client) {
                return client.create(UserService.class).reactivate(this.userId, this.internalBuild());
            }

            @JsonProperty(value="user_id")
            public UserReactivateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="restore_messages")
            public UserReactivateRequest restoreMessages(@Nullable Boolean restoreMessages) {
                this.restoreMessages = restoreMessages;
                return this;
            }

            @JsonProperty(value="name")
            public UserReactivateRequest name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="created_by_id")
            public UserReactivateRequest createdById(@Nullable String createdById) {
                this.createdById = createdById;
                return this;
            }

            public UserReactivateRequestData internalBuild() {
                return new UserReactivateRequestData(this.userId, this.restoreMessages, this.name, this.createdById);
            }

            public String toString() {
                return "User.UserReactivateRequestData.UserReactivateRequest(userId=" + this.userId + ", restoreMessages=" + this.restoreMessages + ", name=" + this.name + ", createdById=" + this.createdById + ")";
            }
        }
    }

    public static class UserDeleteManyResponse
    extends StreamResponseObject {
        @JsonProperty(value="task_id")
        private String taskId;

        @JsonProperty(value="task_id")
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public String toString() {
            return "User.UserDeleteManyResponse(taskId=" + this.getTaskId() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserDeleteManyResponse)) {
                return false;
            }
            UserDeleteManyResponse other = (UserDeleteManyResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            return !(this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserDeleteManyResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            return result;
        }

        public String getTaskId() {
            return this.taskId;
        }
    }

    public static class UserDeleteManyRequestData {
        @JsonProperty(value="user_ids")
        @NotNull
        private List<String> userIds;
        @JsonProperty(value="user")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private DeleteStrategy deleteUserStrategy;
        @JsonProperty(value="messages")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private DeleteStrategy deleteMessagesStrategy;
        @JsonProperty(value="conversations")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private DeleteStrategy deleteConversationsStrategy;

        UserDeleteManyRequestData(@NotNull List<String> userIds, DeleteStrategy deleteUserStrategy, DeleteStrategy deleteMessagesStrategy, DeleteStrategy deleteConversationsStrategy) {
            if (userIds == null) {
                throw new NullPointerException("userIds is marked non-null but is null");
            }
            this.userIds = userIds;
            this.deleteUserStrategy = deleteUserStrategy;
            this.deleteMessagesStrategy = deleteMessagesStrategy;
            this.deleteConversationsStrategy = deleteConversationsStrategy;
        }

        public static class UserDeleteManyRequest
        extends StreamRequest<UserDeleteManyResponse> {
            private List<String> userIds;
            private DeleteStrategy deleteUserStrategy;
            private DeleteStrategy deleteMessagesStrategy;
            private DeleteStrategy deleteConversationsStrategy;

            @Override
            protected Call<UserDeleteManyResponse> generateCall(Client client) throws StreamException {
                UserDeleteManyRequestData data = this.internalBuild();
                if (data.deleteUserStrategy == DeleteStrategy.HARD) {
                    boolean anyOtherOptionIsSoftDelete;
                    boolean bl = anyOtherOptionIsSoftDelete = data.deleteConversationsStrategy == DeleteStrategy.SOFT || data.deleteMessagesStrategy == DeleteStrategy.SOFT;
                    if (anyOtherOptionIsSoftDelete) {
                        throw StreamException.build("Users hard delete strategy cannot be combined with converstations or messages soft delete");
                    }
                }
                return client.create(UserService.class).deleteMany(data);
            }

            UserDeleteManyRequest() {
            }

            @JsonProperty(value="user_ids")
            public UserDeleteManyRequest userIds(@NotNull List<String> userIds) {
                if (userIds == null) {
                    throw new NullPointerException("userIds is marked non-null but is null");
                }
                this.userIds = userIds;
                return this;
            }

            @JsonProperty(value="user")
            public UserDeleteManyRequest deleteUserStrategy(DeleteStrategy deleteUserStrategy) {
                this.deleteUserStrategy = deleteUserStrategy;
                return this;
            }

            @JsonProperty(value="messages")
            public UserDeleteManyRequest deleteMessagesStrategy(DeleteStrategy deleteMessagesStrategy) {
                this.deleteMessagesStrategy = deleteMessagesStrategy;
                return this;
            }

            @JsonProperty(value="conversations")
            public UserDeleteManyRequest deleteConversationsStrategy(DeleteStrategy deleteConversationsStrategy) {
                this.deleteConversationsStrategy = deleteConversationsStrategy;
                return this;
            }

            public UserDeleteManyRequestData internalBuild() {
                return new UserDeleteManyRequestData(this.userIds, this.deleteUserStrategy, this.deleteMessagesStrategy, this.deleteConversationsStrategy);
            }

            public String toString() {
                return "User.UserDeleteManyRequestData.UserDeleteManyRequest(userIds=" + this.userIds + ", deleteUserStrategy=" + this.deleteUserStrategy + ", deleteMessagesStrategy=" + this.deleteMessagesStrategy + ", deleteConversationsStrategy=" + this.deleteConversationsStrategy + ")";
            }
        }
    }

    public static class UserDeleteRequest
    extends StreamRequest<UserDeleteResponse> {
        @NotNull
        private String userId;
        @Nullable
        private Boolean markMessagesDeleted;
        @Nullable
        private Boolean hardDelete;
        @Nullable
        private Boolean deleteConversationChannels;

        @NotNull
        public UserDeleteRequest markMessagesDeleted(@NotNull Boolean markMessagesDeleted) {
            this.markMessagesDeleted = markMessagesDeleted;
            return this;
        }

        @NotNull
        public UserDeleteRequest hardDelete(@NotNull Boolean hardDelete) {
            this.hardDelete = hardDelete;
            return this;
        }

        @NotNull
        public UserDeleteRequest deleteConversationChannels(@NotNull Boolean deleteConversationChannels) {
            this.deleteConversationChannels = deleteConversationChannels;
            return this;
        }

        @Override
        protected Call<UserDeleteResponse> generateCall(Client client) {
            return client.create(UserService.class).delete(this.userId, this.markMessagesDeleted, this.hardDelete, this.deleteConversationChannels);
        }

        public UserDeleteRequest(@NotNull String userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
        }
    }

    public static class UserDeactivateRequestData {
        @JsonProperty(value="user_id")
        @NotNull
        private String userId;
        @JsonProperty(value="mark_messages_deleted")
        @Nullable
        private Boolean markMessagesDeleted;
        @JsonProperty(value="created_by_id")
        @Nullable
        private String createdById;

        UserDeactivateRequestData(@NotNull String userId, @Nullable Boolean markMessagesDeleted, @Nullable String createdById) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            this.markMessagesDeleted = markMessagesDeleted;
            this.createdById = createdById;
        }

        public static class UserDeactivateRequest
        extends StreamRequest<UserDeactivateResponse> {
            private String userId;
            private Boolean markMessagesDeleted;
            private String createdById;

            private UserDeactivateRequest(@NotNull String userId) {
                this.userId = userId;
            }

            @Override
            protected Call<UserDeactivateResponse> generateCall(Client client) {
                return client.create(UserService.class).deactivate(this.userId, this.internalBuild());
            }

            @JsonProperty(value="user_id")
            public UserDeactivateRequest userId(@NotNull String userId) {
                if (userId == null) {
                    throw new NullPointerException("userId is marked non-null but is null");
                }
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="mark_messages_deleted")
            public UserDeactivateRequest markMessagesDeleted(@Nullable Boolean markMessagesDeleted) {
                this.markMessagesDeleted = markMessagesDeleted;
                return this;
            }

            @JsonProperty(value="created_by_id")
            public UserDeactivateRequest createdById(@Nullable String createdById) {
                this.createdById = createdById;
                return this;
            }

            public UserDeactivateRequestData internalBuild() {
                return new UserDeactivateRequestData(this.userId, this.markMessagesDeleted, this.createdById);
            }

            public String toString() {
                return "User.UserDeactivateRequestData.UserDeactivateRequest(userId=" + this.userId + ", markMessagesDeleted=" + this.markMessagesDeleted + ", createdById=" + this.createdById + ")";
            }
        }
    }

    public static class UserBanRequestData {
        @JsonProperty(value="target_user_id")
        @Nullable
        private String targetUserId;
        @JsonProperty(value="timeout")
        @Nullable
        private Integer timeout;
        @JsonProperty(value="reason")
        @Nullable
        private String reason;
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="shadow")
        @Nullable
        private Boolean shadow;
        @JsonProperty(value="ip_ban")
        @Nullable
        private Boolean ipBan;
        @JsonProperty(value="banned_by_id")
        @Nullable
        private String bannedById;
        @JsonProperty(value="banned_by")
        @Nullable
        private UserRequestObject bannedBy;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private UserRequestObject user;

        UserBanRequestData(@Nullable String targetUserId, @Nullable Integer timeout2, @Nullable String reason, @Nullable String type, @Nullable String id, @Nullable Boolean shadow, @Nullable Boolean ipBan, @Nullable String bannedById, @Nullable UserRequestObject bannedBy, @Nullable String userId, @Nullable UserRequestObject user) {
            this.targetUserId = targetUserId;
            this.timeout = timeout2;
            this.reason = reason;
            this.type = type;
            this.id = id;
            this.shadow = shadow;
            this.ipBan = ipBan;
            this.bannedById = bannedById;
            this.bannedBy = bannedBy;
            this.userId = userId;
            this.user = user;
        }

        public static class UserBanRequest
        extends StreamRequest<StreamResponseObject> {
            private String targetUserId;
            private Integer timeout;
            private String reason;
            private String type;
            private String id;
            private Boolean shadow;
            private Boolean ipBan;
            private String bannedById;
            private UserRequestObject bannedBy;
            private String userId;
            private UserRequestObject user;

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(UserService.class).ban(this.internalBuild());
            }

            UserBanRequest() {
            }

            @JsonProperty(value="target_user_id")
            public UserBanRequest targetUserId(@Nullable String targetUserId) {
                this.targetUserId = targetUserId;
                return this;
            }

            @JsonProperty(value="timeout")
            public UserBanRequest timeout(@Nullable Integer timeout2) {
                this.timeout = timeout2;
                return this;
            }

            @JsonProperty(value="reason")
            public UserBanRequest reason(@Nullable String reason) {
                this.reason = reason;
                return this;
            }

            @JsonProperty(value="type")
            public UserBanRequest type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="id")
            public UserBanRequest id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="shadow")
            public UserBanRequest shadow(@Nullable Boolean shadow) {
                this.shadow = shadow;
                return this;
            }

            @JsonProperty(value="ip_ban")
            public UserBanRequest ipBan(@Nullable Boolean ipBan) {
                this.ipBan = ipBan;
                return this;
            }

            @JsonProperty(value="banned_by_id")
            public UserBanRequest bannedById(@Nullable String bannedById) {
                this.bannedById = bannedById;
                return this;
            }

            @JsonProperty(value="banned_by")
            public UserBanRequest bannedBy(@Nullable UserRequestObject bannedBy) {
                this.bannedBy = bannedBy;
                return this;
            }

            @JsonProperty(value="user_id")
            public UserBanRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public UserBanRequest user(@Nullable UserRequestObject user) {
                this.user = user;
                return this;
            }

            public UserBanRequestData internalBuild() {
                return new UserBanRequestData(this.targetUserId, this.timeout, this.reason, this.type, this.id, this.shadow, this.ipBan, this.bannedById, this.bannedBy, this.userId, this.user);
            }

            public String toString() {
                return "User.UserBanRequestData.UserBanRequest(targetUserId=" + this.targetUserId + ", timeout=" + this.timeout + ", reason=" + this.reason + ", type=" + this.type + ", id=" + this.id + ", shadow=" + this.shadow + ", ipBan=" + this.ipBan + ", bannedById=" + this.bannedById + ", bannedBy=" + this.bannedBy + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class UserQueryBannedRequestData {
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;
        @JsonProperty(value="created_at_after_or_equal")
        @Nullable
        private Date createdAtAfterOrEqual;
        @JsonProperty(value="created_at_after")
        @Nullable
        private Date createdAtAfter;
        @JsonProperty(value="created_at_before_or_equal")
        @Nullable
        private Date createdAtBeforeOrEqual;
        @JsonProperty(value="created_at_before")
        @Nullable
        private Date createdAtBefore;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private UserRequestObject user;

        UserQueryBannedRequestData(@Nullable Map<String, Object> filterConditions, @Nullable List<Sort> sorts, @Nullable Integer limit, @Nullable Integer offset, @Nullable Date createdAtAfterOrEqual, @Nullable Date createdAtAfter, @Nullable Date createdAtBeforeOrEqual, @Nullable Date createdAtBefore, @Nullable String userId, @Nullable UserRequestObject user) {
            this.filterConditions = filterConditions;
            this.sorts = sorts;
            this.limit = limit;
            this.offset = offset;
            this.createdAtAfterOrEqual = createdAtAfterOrEqual;
            this.createdAtAfter = createdAtAfter;
            this.createdAtBeforeOrEqual = createdAtBeforeOrEqual;
            this.createdAtBefore = createdAtBefore;
            this.userId = userId;
            this.user = user;
        }

        public static class UserQueryBannedRequest
        extends StreamRequest<UserQueryBannedResponse> {
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private ArrayList<Sort> sorts;
            private Integer limit;
            private Integer offset;
            private Date createdAtAfterOrEqual;
            private Date createdAtAfter;
            private Date createdAtBeforeOrEqual;
            private Date createdAtBefore;
            private String userId;
            private UserRequestObject user;

            @Override
            protected Call<UserQueryBannedResponse> generateCall(Client client) {
                return client.create(UserService.class).queryBanned(this.internalBuild());
            }

            UserQueryBannedRequest() {
            }

            public UserQueryBannedRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public UserQueryBannedRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public UserQueryBannedRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            public UserQueryBannedRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public UserQueryBannedRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public UserQueryBannedRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            @JsonProperty(value="limit")
            public UserQueryBannedRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public UserQueryBannedRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            @JsonProperty(value="created_at_after_or_equal")
            public UserQueryBannedRequest createdAtAfterOrEqual(@Nullable Date createdAtAfterOrEqual) {
                this.createdAtAfterOrEqual = createdAtAfterOrEqual;
                return this;
            }

            @JsonProperty(value="created_at_after")
            public UserQueryBannedRequest createdAtAfter(@Nullable Date createdAtAfter) {
                this.createdAtAfter = createdAtAfter;
                return this;
            }

            @JsonProperty(value="created_at_before_or_equal")
            public UserQueryBannedRequest createdAtBeforeOrEqual(@Nullable Date createdAtBeforeOrEqual) {
                this.createdAtBeforeOrEqual = createdAtBeforeOrEqual;
                return this;
            }

            @JsonProperty(value="created_at_before")
            public UserQueryBannedRequest createdAtBefore(@Nullable Date createdAtBefore) {
                this.createdAtBefore = createdAtBefore;
                return this;
            }

            @JsonProperty(value="user_id")
            public UserQueryBannedRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public UserQueryBannedRequest user(@Nullable UserRequestObject user) {
                this.user = user;
                return this;
            }

            public UserQueryBannedRequestData internalBuild() {
                List<Sort> sorts;
                Map<Object, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new UserQueryBannedRequestData(filterConditions, sorts, this.limit, this.offset, this.createdAtAfterOrEqual, this.createdAtAfter, this.createdAtBeforeOrEqual, this.createdAtBefore, this.userId, this.user);
            }

            public String toString() {
                return "User.UserQueryBannedRequestData.UserQueryBannedRequest(filterConditions$key=" + this.filterConditions$key + ", filterConditions$value=" + this.filterConditions$value + ", sorts=" + this.sorts + ", limit=" + this.limit + ", offset=" + this.offset + ", createdAtAfterOrEqual=" + this.createdAtAfterOrEqual + ", createdAtAfter=" + this.createdAtAfter + ", createdAtBeforeOrEqual=" + this.createdAtBeforeOrEqual + ", createdAtBefore=" + this.createdAtBefore + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class UserPartialUpdateRequestData {
        @JsonProperty(value="users")
        @Nullable
        private List<UserPartialUpdateRequestObject> users;

        UserPartialUpdateRequestData(@Nullable List<UserPartialUpdateRequestObject> users) {
            this.users = users;
        }

        public static class UserPartialUpdateRequest
        extends StreamRequest<UserPartialUpdateResponse> {
            private ArrayList<UserPartialUpdateRequestObject> users;

            @Override
            protected Call<UserPartialUpdateResponse> generateCall(Client client) {
                return client.create(UserService.class).partialUpdate(this.internalBuild());
            }

            UserPartialUpdateRequest() {
            }

            public UserPartialUpdateRequest user(UserPartialUpdateRequestObject user) {
                if (this.users == null) {
                    this.users = new ArrayList();
                }
                this.users.add(user);
                return this;
            }

            @JsonProperty(value="users")
            public UserPartialUpdateRequest users(Collection<? extends UserPartialUpdateRequestObject> users) {
                if (users == null) {
                    throw new NullPointerException("users cannot be null");
                }
                if (this.users == null) {
                    this.users = new ArrayList();
                }
                this.users.addAll(users);
                return this;
            }

            public UserPartialUpdateRequest clearUsers() {
                if (this.users != null) {
                    this.users.clear();
                }
                return this;
            }

            public UserPartialUpdateRequestData internalBuild() {
                List<UserPartialUpdateRequestObject> users;
                switch (this.users == null ? 0 : this.users.size()) {
                    case 0: {
                        users = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        users = Collections.singletonList(this.users.get(0));
                        break;
                    }
                    default: {
                        users = Collections.unmodifiableList(new ArrayList<UserPartialUpdateRequestObject>(this.users));
                    }
                }
                return new UserPartialUpdateRequestData(users);
            }

            public String toString() {
                return "User.UserPartialUpdateRequestData.UserPartialUpdateRequest(users=" + this.users + ")";
            }
        }
    }

    public static class UserListRequestData {
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;
        @JsonProperty(value="presence")
        @Nullable
        private Boolean presence;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="connection_id")
        @Nullable
        private String connectionId;
        @JsonProperty(value="include_deactivated_users")
        @Nullable
        private Boolean includeDeactivatedUsers;

        UserListRequestData(@Nullable Map<String, Object> filterConditions, @Nullable List<Sort> sorts, @Nullable Boolean presence, @Nullable Integer limit, @Nullable Integer offset, @Nullable String userId, @Nullable User user, @Nullable String connectionId, @Nullable Boolean includeDeactivatedUsers) {
            this.filterConditions = filterConditions;
            this.sorts = sorts;
            this.presence = presence;
            this.limit = limit;
            this.offset = offset;
            this.userId = userId;
            this.user = user;
            this.connectionId = connectionId;
            this.includeDeactivatedUsers = includeDeactivatedUsers;
        }

        public static class UserListRequest
        extends StreamRequest<UserListResponse> {
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private ArrayList<Sort> sorts;
            private Boolean presence;
            private Integer limit;
            private Integer offset;
            private String userId;
            private User user;
            private String connectionId;
            private Boolean includeDeactivatedUsers;

            @Override
            protected Call<UserListResponse> generateCall(Client client) {
                return client.create(UserService.class).list(this.internalBuild());
            }

            UserListRequest() {
            }

            public UserListRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public UserListRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public UserListRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            public UserListRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public UserListRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public UserListRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            @JsonProperty(value="presence")
            public UserListRequest presence(@Nullable Boolean presence) {
                this.presence = presence;
                return this;
            }

            @JsonProperty(value="limit")
            public UserListRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public UserListRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            @JsonProperty(value="user_id")
            public UserListRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public UserListRequest user(@Nullable User user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="connection_id")
            public UserListRequest connectionId(@Nullable String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            @JsonProperty(value="include_deactivated_users")
            public UserListRequest includeDeactivatedUsers(@Nullable Boolean includeDeactivatedUsers) {
                this.includeDeactivatedUsers = includeDeactivatedUsers;
                return this;
            }

            public UserListRequestData internalBuild() {
                List<Sort> sorts;
                Map<Object, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new UserListRequestData(filterConditions, sorts, this.presence, this.limit, this.offset, this.userId, this.user, this.connectionId, this.includeDeactivatedUsers);
            }

            public String toString() {
                return "User.UserListRequestData.UserListRequest(filterConditions$key=" + this.filterConditions$key + ", filterConditions$value=" + this.filterConditions$value + ", sorts=" + this.sorts + ", presence=" + this.presence + ", limit=" + this.limit + ", offset=" + this.offset + ", userId=" + this.userId + ", user=" + this.user + ", connectionId=" + this.connectionId + ", includeDeactivatedUsers=" + this.includeDeactivatedUsers + ")";
            }
        }
    }

    public static class UserUpsertRequestData {
        @JsonProperty(value="users")
        @Nullable
        private Map<String, UserRequestObject> users;

        UserUpsertRequestData(@Nullable Map<String, UserRequestObject> users) {
            this.users = users;
        }

        public static class UserUpsertRequest
        extends StreamRequest<UserUpsertResponse> {
            private Map<String, UserRequestObject> users;

            @NotNull
            public UserUpsertRequest user(@NotNull UserRequestObject user) {
                if (user.getId() == null) {
                    throw new IllegalArgumentException("user id cannot be null");
                }
                if (this.users == null) {
                    this.users = new HashMap<String, UserRequestObject>();
                }
                this.users.put(user.getId(), user);
                return this;
            }

            @Override
            protected Call<UserUpsertResponse> generateCall(Client client) {
                return client.create(UserService.class).upsert(this.internalBuild());
            }

            UserUpsertRequest() {
            }

            @JsonProperty(value="users")
            public UserUpsertRequest users(@Nullable Map<String, UserRequestObject> users) {
                this.users = users;
                return this;
            }

            public UserUpsertRequestData internalBuild() {
                return new UserUpsertRequestData(this.users);
            }

            public String toString() {
                return "User.UserUpsertRequestData.UserUpsertRequest(users=" + this.users + ")";
            }
        }
    }

    public static class ChannelMuteRequestObject {
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;
        @JsonProperty(value="expires")
        @Nullable
        private Date expires;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updatedAt;

        @Nullable
        public static ChannelMuteRequestObject buildFrom(@Nullable ChannelMute channelMute) {
            return RequestObjectBuilder.build(ChannelMuteRequestObject.class, channelMute);
        }

        ChannelMuteRequestObject(@Nullable User user, @Nullable Channel channel, @Nullable Date expires, @Nullable Date createdAt, @Nullable Date updatedAt) {
            this.user = user;
            this.channel = channel;
            this.expires = expires;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
        }

        public static ChannelMuteRequestObjectBuilder builder() {
            return new ChannelMuteRequestObjectBuilder();
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @JsonProperty(value="expires")
        public void setExpires(@Nullable Date expires) {
            this.expires = expires;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        public static class ChannelMuteRequestObjectBuilder {
            private User user;
            private Channel channel;
            private Date expires;
            private Date createdAt;
            private Date updatedAt;

            ChannelMuteRequestObjectBuilder() {
            }

            @JsonProperty(value="user")
            public ChannelMuteRequestObjectBuilder user(@Nullable User user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="channel")
            public ChannelMuteRequestObjectBuilder channel(@Nullable Channel channel) {
                this.channel = channel;
                return this;
            }

            @JsonProperty(value="expires")
            public ChannelMuteRequestObjectBuilder expires(@Nullable Date expires) {
                this.expires = expires;
                return this;
            }

            @JsonProperty(value="created_at")
            public ChannelMuteRequestObjectBuilder createdAt(@Nullable Date createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @JsonProperty(value="updated_at")
            public ChannelMuteRequestObjectBuilder updatedAt(@Nullable Date updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            public ChannelMuteRequestObject build() {
                return new ChannelMuteRequestObject(this.user, this.channel, this.expires, this.createdAt, this.updatedAt);
            }

            public String toString() {
                return "User.ChannelMuteRequestObject.ChannelMuteRequestObjectBuilder(user=" + this.user + ", channel=" + this.channel + ", expires=" + this.expires + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
            }
        }
    }

    public static class UserMuteRequestObject {
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="target")
        @Nullable
        private User target;
        @JsonProperty(value="expires")
        @Nullable
        private Date expires;
        @JsonProperty(value="created_at")
        @Nullable
        private Date created_at;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updated_at;

        @Nullable
        public static UserMuteRequestObject buildFrom(@Nullable UserMute userMute) {
            return RequestObjectBuilder.build(UserMuteRequestObject.class, userMute);
        }

        UserMuteRequestObject(@Nullable User user, @Nullable User target, @Nullable Date expires, @Nullable Date created_at, @Nullable Date updated_at) {
            this.user = user;
            this.target = target;
            this.expires = expires;
            this.created_at = created_at;
            this.updated_at = updated_at;
        }

        public static UserMuteRequestObjectBuilder builder() {
            return new UserMuteRequestObjectBuilder();
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty(value="target")
        public void setTarget(@Nullable User target) {
            this.target = target;
        }

        @JsonProperty(value="expires")
        public void setExpires(@Nullable Date expires) {
            this.expires = expires;
        }

        @JsonProperty(value="created_at")
        public void setCreated_at(@Nullable Date created_at) {
            this.created_at = created_at;
        }

        @JsonProperty(value="updated_at")
        public void setUpdated_at(@Nullable Date updated_at) {
            this.updated_at = updated_at;
        }

        public static class UserMuteRequestObjectBuilder {
            private User user;
            private User target;
            private Date expires;
            private Date created_at;
            private Date updated_at;

            UserMuteRequestObjectBuilder() {
            }

            @JsonProperty(value="user")
            public UserMuteRequestObjectBuilder user(@Nullable User user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="target")
            public UserMuteRequestObjectBuilder target(@Nullable User target) {
                this.target = target;
                return this;
            }

            @JsonProperty(value="expires")
            public UserMuteRequestObjectBuilder expires(@Nullable Date expires) {
                this.expires = expires;
                return this;
            }

            @JsonProperty(value="created_at")
            public UserMuteRequestObjectBuilder created_at(@Nullable Date created_at) {
                this.created_at = created_at;
                return this;
            }

            @JsonProperty(value="updated_at")
            public UserMuteRequestObjectBuilder updated_at(@Nullable Date updated_at) {
                this.updated_at = updated_at;
                return this;
            }

            public UserMuteRequestObject build() {
                return new UserMuteRequestObject(this.user, this.target, this.expires, this.created_at, this.updated_at);
            }

            public String toString() {
                return "User.UserMuteRequestObject.UserMuteRequestObjectBuilder(user=" + this.user + ", target=" + this.target + ", expires=" + this.expires + ", created_at=" + this.created_at + ", updated_at=" + this.updated_at + ")";
            }
        }
    }

    public static class OwnUserRequestObject {
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="role")
        @Nullable
        private String role;
        @JsonProperty(value="roles")
        @Nullable
        private List<String> roles;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updatedAt;
        @JsonProperty(value="last_active")
        @Nullable
        private Date lastActive;
        @JsonProperty(value="deleted_at")
        @Nullable
        private Date deletedAt;
        @JsonProperty(value="deactivated_at")
        @Nullable
        private Date deactivatedAt;
        @JsonProperty(value="banned")
        @Nullable
        private Boolean banned;
        @JsonProperty(value="online")
        @Nullable
        private Boolean online;
        @JsonProperty(value="invisible")
        @Nullable
        private Boolean invisible;
        @JsonProperty(value="devices")
        @Nullable
        private List<Device.DeviceRequestObject> devices;
        @JsonProperty(value="mutes")
        @Nullable
        private List<UserMuteRequestObject> mutes;
        @JsonProperty(value="channel_mutes")
        @Nullable
        private List<ChannelMuteRequestObject> channelMutes;
        @JsonProperty(value="unread_count")
        @Nullable
        private Integer unreadCount;
        @JsonProperty(value="total_unread_count")
        @Nullable
        private Integer totalUnreadCount;
        @JsonProperty(value="unread_channels")
        @Nullable
        private Integer unreadChannels;
        @JsonProperty(value="language")
        @Nullable
        private Language language;
        @JsonProperty(value="teams")
        @Nullable
        private List<String> teams;
        @JsonProperty(value="latest_hidden_channels")
        @Nullable
        private List<String> latestHiddenChannels;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static OwnUserRequestObject buildFrom(@Nullable OwnUser ownUser) {
            return RequestObjectBuilder.build(OwnUserRequestObject.class, ownUser);
        }

        OwnUserRequestObject(@Nullable String id, @Nullable String role, @Nullable List<String> roles, @Nullable Date createdAt, @Nullable Date updatedAt, @Nullable Date lastActive, @Nullable Date deletedAt, @Nullable Date deactivatedAt, @Nullable Boolean banned, @Nullable Boolean online, @Nullable Boolean invisible, @Nullable List<Device.DeviceRequestObject> devices, @Nullable List<UserMuteRequestObject> mutes, @Nullable List<ChannelMuteRequestObject> channelMutes, @Nullable Integer unreadCount, @Nullable Integer totalUnreadCount, @Nullable Integer unreadChannels, @Nullable Language language, @Nullable List<String> teams, @Nullable List<String> latestHiddenChannels, @Nullable Map<String, Object> additionalFields) {
            this.id = id;
            this.role = role;
            this.roles = roles;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.lastActive = lastActive;
            this.deletedAt = deletedAt;
            this.deactivatedAt = deactivatedAt;
            this.banned = banned;
            this.online = online;
            this.invisible = invisible;
            this.devices = devices;
            this.mutes = mutes;
            this.channelMutes = channelMutes;
            this.unreadCount = unreadCount;
            this.totalUnreadCount = totalUnreadCount;
            this.unreadChannels = unreadChannels;
            this.language = language;
            this.teams = teams;
            this.latestHiddenChannels = latestHiddenChannels;
            this.additionalFields = additionalFields;
        }

        public static OwnUserRequestObjectBuilder builder() {
            return new OwnUserRequestObjectBuilder();
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="role")
        public void setRole(@Nullable String role) {
            this.role = role;
        }

        @JsonProperty(value="roles")
        public void setRoles(@Nullable List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="last_active")
        public void setLastActive(@Nullable Date lastActive) {
            this.lastActive = lastActive;
        }

        @JsonProperty(value="deleted_at")
        public void setDeletedAt(@Nullable Date deletedAt) {
            this.deletedAt = deletedAt;
        }

        @JsonProperty(value="deactivated_at")
        public void setDeactivatedAt(@Nullable Date deactivatedAt) {
            this.deactivatedAt = deactivatedAt;
        }

        @JsonProperty(value="banned")
        public void setBanned(@Nullable Boolean banned) {
            this.banned = banned;
        }

        @JsonProperty(value="online")
        public void setOnline(@Nullable Boolean online) {
            this.online = online;
        }

        @JsonProperty(value="invisible")
        public void setInvisible(@Nullable Boolean invisible) {
            this.invisible = invisible;
        }

        @JsonProperty(value="devices")
        public void setDevices(@Nullable List<Device.DeviceRequestObject> devices) {
            this.devices = devices;
        }

        @JsonProperty(value="mutes")
        public void setMutes(@Nullable List<UserMuteRequestObject> mutes) {
            this.mutes = mutes;
        }

        @JsonProperty(value="channel_mutes")
        public void setChannelMutes(@Nullable List<ChannelMuteRequestObject> channelMutes) {
            this.channelMutes = channelMutes;
        }

        @JsonProperty(value="unread_count")
        public void setUnreadCount(@Nullable Integer unreadCount) {
            this.unreadCount = unreadCount;
        }

        @JsonProperty(value="total_unread_count")
        public void setTotalUnreadCount(@Nullable Integer totalUnreadCount) {
            this.totalUnreadCount = totalUnreadCount;
        }

        @JsonProperty(value="unread_channels")
        public void setUnreadChannels(@Nullable Integer unreadChannels) {
            this.unreadChannels = unreadChannels;
        }

        @JsonProperty(value="language")
        public void setLanguage(@Nullable Language language) {
            this.language = language;
        }

        @JsonProperty(value="teams")
        public void setTeams(@Nullable List<String> teams) {
            this.teams = teams;
        }

        @JsonProperty(value="latest_hidden_channels")
        public void setLatestHiddenChannels(@Nullable List<String> latestHiddenChannels) {
            this.latestHiddenChannels = latestHiddenChannels;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        public static class OwnUserRequestObjectBuilder {
            private String id;
            private String role;
            private List<String> roles;
            private Date createdAt;
            private Date updatedAt;
            private Date lastActive;
            private Date deletedAt;
            private Date deactivatedAt;
            private Boolean banned;
            private Boolean online;
            private Boolean invisible;
            private ArrayList<Device.DeviceRequestObject> devices;
            private ArrayList<UserMuteRequestObject> mutes;
            private ArrayList<ChannelMuteRequestObject> channelMutes;
            private Integer unreadCount;
            private Integer totalUnreadCount;
            private Integer unreadChannels;
            private Language language;
            private List<String> teams;
            private List<String> latestHiddenChannels;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            OwnUserRequestObjectBuilder() {
            }

            @JsonProperty(value="id")
            public OwnUserRequestObjectBuilder id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="role")
            public OwnUserRequestObjectBuilder role(@Nullable String role) {
                this.role = role;
                return this;
            }

            @JsonProperty(value="roles")
            public OwnUserRequestObjectBuilder roles(@Nullable List<String> roles) {
                this.roles = roles;
                return this;
            }

            @JsonProperty(value="created_at")
            public OwnUserRequestObjectBuilder createdAt(@Nullable Date createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @JsonProperty(value="updated_at")
            public OwnUserRequestObjectBuilder updatedAt(@Nullable Date updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            @JsonProperty(value="last_active")
            public OwnUserRequestObjectBuilder lastActive(@Nullable Date lastActive) {
                this.lastActive = lastActive;
                return this;
            }

            @JsonProperty(value="deleted_at")
            public OwnUserRequestObjectBuilder deletedAt(@Nullable Date deletedAt) {
                this.deletedAt = deletedAt;
                return this;
            }

            @JsonProperty(value="deactivated_at")
            public OwnUserRequestObjectBuilder deactivatedAt(@Nullable Date deactivatedAt) {
                this.deactivatedAt = deactivatedAt;
                return this;
            }

            @JsonProperty(value="banned")
            public OwnUserRequestObjectBuilder banned(@Nullable Boolean banned) {
                this.banned = banned;
                return this;
            }

            @JsonProperty(value="online")
            public OwnUserRequestObjectBuilder online(@Nullable Boolean online) {
                this.online = online;
                return this;
            }

            @JsonProperty(value="invisible")
            public OwnUserRequestObjectBuilder invisible(@Nullable Boolean invisible) {
                this.invisible = invisible;
                return this;
            }

            public OwnUserRequestObjectBuilder device(Device.DeviceRequestObject device) {
                if (this.devices == null) {
                    this.devices = new ArrayList();
                }
                this.devices.add(device);
                return this;
            }

            @JsonProperty(value="devices")
            public OwnUserRequestObjectBuilder devices(Collection<? extends Device.DeviceRequestObject> devices) {
                if (devices == null) {
                    throw new NullPointerException("devices cannot be null");
                }
                if (this.devices == null) {
                    this.devices = new ArrayList();
                }
                this.devices.addAll(devices);
                return this;
            }

            public OwnUserRequestObjectBuilder clearDevices() {
                if (this.devices != null) {
                    this.devices.clear();
                }
                return this;
            }

            public OwnUserRequestObjectBuilder mute(UserMuteRequestObject mute) {
                if (this.mutes == null) {
                    this.mutes = new ArrayList();
                }
                this.mutes.add(mute);
                return this;
            }

            @JsonProperty(value="mutes")
            public OwnUserRequestObjectBuilder mutes(Collection<? extends UserMuteRequestObject> mutes) {
                if (mutes == null) {
                    throw new NullPointerException("mutes cannot be null");
                }
                if (this.mutes == null) {
                    this.mutes = new ArrayList();
                }
                this.mutes.addAll(mutes);
                return this;
            }

            public OwnUserRequestObjectBuilder clearMutes() {
                if (this.mutes != null) {
                    this.mutes.clear();
                }
                return this;
            }

            public OwnUserRequestObjectBuilder channelMute(ChannelMuteRequestObject channelMute) {
                if (this.channelMutes == null) {
                    this.channelMutes = new ArrayList();
                }
                this.channelMutes.add(channelMute);
                return this;
            }

            @JsonProperty(value="channel_mutes")
            public OwnUserRequestObjectBuilder channelMutes(Collection<? extends ChannelMuteRequestObject> channelMutes) {
                if (channelMutes == null) {
                    throw new NullPointerException("channelMutes cannot be null");
                }
                if (this.channelMutes == null) {
                    this.channelMutes = new ArrayList();
                }
                this.channelMutes.addAll(channelMutes);
                return this;
            }

            public OwnUserRequestObjectBuilder clearChannelMutes() {
                if (this.channelMutes != null) {
                    this.channelMutes.clear();
                }
                return this;
            }

            @JsonProperty(value="unread_count")
            public OwnUserRequestObjectBuilder unreadCount(@Nullable Integer unreadCount) {
                this.unreadCount = unreadCount;
                return this;
            }

            @JsonProperty(value="total_unread_count")
            public OwnUserRequestObjectBuilder totalUnreadCount(@Nullable Integer totalUnreadCount) {
                this.totalUnreadCount = totalUnreadCount;
                return this;
            }

            @JsonProperty(value="unread_channels")
            public OwnUserRequestObjectBuilder unreadChannels(@Nullable Integer unreadChannels) {
                this.unreadChannels = unreadChannels;
                return this;
            }

            @JsonProperty(value="language")
            public OwnUserRequestObjectBuilder language(@Nullable Language language) {
                this.language = language;
                return this;
            }

            @JsonProperty(value="teams")
            public OwnUserRequestObjectBuilder teams(@Nullable List<String> teams) {
                this.teams = teams;
                return this;
            }

            @JsonProperty(value="latest_hidden_channels")
            public OwnUserRequestObjectBuilder latestHiddenChannels(@Nullable List<String> latestHiddenChannels) {
                this.latestHiddenChannels = latestHiddenChannels;
                return this;
            }

            public OwnUserRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public OwnUserRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public OwnUserRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public OwnUserRequestObject build() {
                Map<Object, Object> additionalFields;
                List<ChannelMuteRequestObject> channelMutes;
                List<UserMuteRequestObject> mutes;
                List<Device.DeviceRequestObject> devices;
                switch (this.devices == null ? 0 : this.devices.size()) {
                    case 0: {
                        devices = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        devices = Collections.singletonList(this.devices.get(0));
                        break;
                    }
                    default: {
                        devices = Collections.unmodifiableList(new ArrayList<Device.DeviceRequestObject>(this.devices));
                    }
                }
                switch (this.mutes == null ? 0 : this.mutes.size()) {
                    case 0: {
                        mutes = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        mutes = Collections.singletonList(this.mutes.get(0));
                        break;
                    }
                    default: {
                        mutes = Collections.unmodifiableList(new ArrayList<UserMuteRequestObject>(this.mutes));
                    }
                }
                switch (this.channelMutes == null ? 0 : this.channelMutes.size()) {
                    case 0: {
                        channelMutes = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        channelMutes = Collections.singletonList(this.channelMutes.get(0));
                        break;
                    }
                    default: {
                        channelMutes = Collections.unmodifiableList(new ArrayList<ChannelMuteRequestObject>(this.channelMutes));
                    }
                }
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new OwnUserRequestObject(this.id, this.role, this.roles, this.createdAt, this.updatedAt, this.lastActive, this.deletedAt, this.deactivatedAt, this.banned, this.online, this.invisible, devices, mutes, channelMutes, this.unreadCount, this.totalUnreadCount, this.unreadChannels, this.language, this.teams, this.latestHiddenChannels, additionalFields);
            }

            public String toString() {
                return "User.OwnUserRequestObject.OwnUserRequestObjectBuilder(id=" + this.id + ", role=" + this.role + ", roles=" + this.roles + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", lastActive=" + this.lastActive + ", deletedAt=" + this.deletedAt + ", deactivatedAt=" + this.deactivatedAt + ", banned=" + this.banned + ", online=" + this.online + ", invisible=" + this.invisible + ", devices=" + this.devices + ", mutes=" + this.mutes + ", channelMutes=" + this.channelMutes + ", unreadCount=" + this.unreadCount + ", totalUnreadCount=" + this.totalUnreadCount + ", unreadChannels=" + this.unreadChannels + ", language=" + this.language + ", teams=" + this.teams + ", latestHiddenChannels=" + this.latestHiddenChannels + ", additionalFields$key=" + this.additionalFields$key + ", additionalFields$value=" + this.additionalFields$value + ")";
            }
        }
    }

    public static class UserPartialUpdateRequestObject {
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="set")
        @Nullable
        private Map<String, Object> setValues;
        @JsonProperty(value="unset")
        @Nullable
        private List<String> unsetValues;

        UserPartialUpdateRequestObject(@Nullable String id, @Nullable Map<String, Object> setValues, @Nullable List<String> unsetValues) {
            this.id = id;
            this.setValues = setValues;
            this.unsetValues = unsetValues;
        }

        public static UserPartialUpdateRequestObjectBuilder builder() {
            return new UserPartialUpdateRequestObjectBuilder();
        }

        public static class UserPartialUpdateRequestObjectBuilder {
            private String id;
            private ArrayList<String> setValues$key;
            private ArrayList<Object> setValues$value;
            private ArrayList<String> unsetValues;

            UserPartialUpdateRequestObjectBuilder() {
            }

            @JsonProperty(value="id")
            public UserPartialUpdateRequestObjectBuilder id(@Nullable String id) {
                this.id = id;
                return this;
            }

            public UserPartialUpdateRequestObjectBuilder setValue(String setValueKey, Object setValueValue) {
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                this.setValues$key.add(setValueKey);
                this.setValues$value.add(setValueValue);
                return this;
            }

            @JsonProperty(value="set")
            public UserPartialUpdateRequestObjectBuilder setValues(Map<? extends String, ? extends Object> setValues) {
                if (setValues == null) {
                    throw new NullPointerException("setValues cannot be null");
                }
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : setValues.entrySet()) {
                    this.setValues$key.add($lombokEntry.getKey());
                    this.setValues$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public UserPartialUpdateRequestObjectBuilder clearSetValues() {
                if (this.setValues$key != null) {
                    this.setValues$key.clear();
                    this.setValues$value.clear();
                }
                return this;
            }

            public UserPartialUpdateRequestObjectBuilder unsetValue(String unsetValue) {
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.add(unsetValue);
                return this;
            }

            @JsonProperty(value="unset")
            public UserPartialUpdateRequestObjectBuilder unsetValues(Collection<? extends String> unsetValues) {
                if (unsetValues == null) {
                    throw new NullPointerException("unsetValues cannot be null");
                }
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.addAll(unsetValues);
                return this;
            }

            public UserPartialUpdateRequestObjectBuilder clearUnsetValues() {
                if (this.unsetValues != null) {
                    this.unsetValues.clear();
                }
                return this;
            }

            public UserPartialUpdateRequestObject build() {
                List<String> unsetValues;
                Map<String, Object> setValues;
                switch (this.setValues$key == null ? 0 : this.setValues$key.size()) {
                    case 0: {
                        setValues = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        setValues = Collections.singletonMap(this.setValues$key.get(0), this.setValues$value.get(0));
                        break;
                    }
                    default: {
                        setValues = new LinkedHashMap(this.setValues$key.size() < 0x40000000 ? 1 + this.setValues$key.size() + (this.setValues$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.setValues$key.size(); ++$i) {
                            setValues.put(this.setValues$key.get($i), this.setValues$value.get($i));
                        }
                        setValues = Collections.unmodifiableMap(setValues);
                    }
                }
                switch (this.unsetValues == null ? 0 : this.unsetValues.size()) {
                    case 0: {
                        unsetValues = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        unsetValues = Collections.singletonList(this.unsetValues.get(0));
                        break;
                    }
                    default: {
                        unsetValues = Collections.unmodifiableList(new ArrayList<String>(this.unsetValues));
                    }
                }
                return new UserPartialUpdateRequestObject(this.id, setValues, unsetValues);
            }

            public String toString() {
                return "User.UserPartialUpdateRequestObject.UserPartialUpdateRequestObjectBuilder(id=" + this.id + ", setValues$key=" + this.setValues$key + ", setValues$value=" + this.setValues$value + ", unsetValues=" + this.unsetValues + ")";
            }
        }
    }

    public static class UserRequestObject {
        @JsonProperty(value="id")
        @NotNull
        private String id;
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="role")
        @Nullable
        private String role;
        @JsonProperty(value="banned")
        @Nullable
        private Boolean banned;
        @JsonProperty(value="ban_expires")
        @Nullable
        private String banExpires;
        @JsonProperty(value="language")
        @Nullable
        private Language language;
        @JsonProperty(value="teams")
        @Nullable
        private List<String> teams;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static UserRequestObject buildFrom(@Nullable User user) {
            return RequestObjectBuilder.build(UserRequestObject.class, user);
        }

        UserRequestObject(@NotNull String id, @Nullable String name, @Nullable String role, @Nullable Boolean banned, @Nullable String banExpires, @Nullable Language language, @Nullable List<String> teams, @Nullable Map<String, Object> additionalFields) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            this.name = name;
            this.role = role;
            this.banned = banned;
            this.banExpires = banExpires;
            this.language = language;
            this.teams = teams;
            this.additionalFields = additionalFields;
        }

        public static UserRequestObjectBuilder builder() {
            return new UserRequestObjectBuilder();
        }

        @JsonProperty(value="id")
        public void setId(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="role")
        public void setRole(@Nullable String role) {
            this.role = role;
        }

        @JsonProperty(value="banned")
        public void setBanned(@Nullable Boolean banned) {
            this.banned = banned;
        }

        @JsonProperty(value="ban_expires")
        public void setBanExpires(@Nullable String banExpires) {
            this.banExpires = banExpires;
        }

        @JsonProperty(value="language")
        public void setLanguage(@Nullable Language language) {
            this.language = language;
        }

        @JsonProperty(value="teams")
        public void setTeams(@Nullable List<String> teams) {
            this.teams = teams;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        public static class UserRequestObjectBuilder {
            private String id;
            private String name;
            private String role;
            private Boolean banned;
            private String banExpires;
            private Language language;
            private List<String> teams;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            UserRequestObjectBuilder() {
            }

            @JsonProperty(value="id")
            public UserRequestObjectBuilder id(@NotNull String id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                this.id = id;
                return this;
            }

            @JsonProperty(value="name")
            public UserRequestObjectBuilder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="role")
            public UserRequestObjectBuilder role(@Nullable String role) {
                this.role = role;
                return this;
            }

            @JsonProperty(value="banned")
            public UserRequestObjectBuilder banned(@Nullable Boolean banned) {
                this.banned = banned;
                return this;
            }

            @JsonProperty(value="ban_expires")
            public UserRequestObjectBuilder banExpires(@Nullable String banExpires) {
                this.banExpires = banExpires;
                return this;
            }

            @JsonProperty(value="language")
            public UserRequestObjectBuilder language(@Nullable Language language) {
                this.language = language;
                return this;
            }

            @JsonProperty(value="teams")
            public UserRequestObjectBuilder teams(@Nullable List<String> teams) {
                this.teams = teams;
                return this;
            }

            public UserRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public UserRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public UserRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public UserRequestObject build() {
                Map<String, Object> additionalFields;
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new UserRequestObject(this.id, this.name, this.role, this.banned, this.banExpires, this.language, this.teams, additionalFields);
            }

            public String toString() {
                return "User.UserRequestObject.UserRequestObjectBuilder(id=" + this.id + ", name=" + this.name + ", role=" + this.role + ", banned=" + this.banned + ", banExpires=" + this.banExpires + ", language=" + this.language + ", teams=" + this.teams + ", additionalFields$key=" + this.additionalFields$key + ", additionalFields$value=" + this.additionalFields$value + ")";
            }
        }
    }

    public static class UserMute {
        @JsonProperty(value="user")
        @NotNull
        private User user;
        @JsonProperty(value="target")
        @NotNull
        private User target;
        @JsonProperty(value="expires")
        @Nullable
        private Date expires;
        @JsonProperty(value="created_at")
        @NotNull
        private Date created_at;
        @JsonProperty(value="updated_at")
        @NotNull
        private Date updated_at;

        @NotNull
        public User getUser() {
            return this.user;
        }

        @NotNull
        public User getTarget() {
            return this.target;
        }

        @Nullable
        public Date getExpires() {
            return this.expires;
        }

        @NotNull
        public Date getCreated_at() {
            return this.created_at;
        }

        @NotNull
        public Date getUpdated_at() {
            return this.updated_at;
        }

        @JsonProperty(value="user")
        public void setUser(@NotNull User user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
        }

        @JsonProperty(value="target")
        public void setTarget(@NotNull User target) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.target = target;
        }

        @JsonProperty(value="expires")
        public void setExpires(@Nullable Date expires) {
            this.expires = expires;
        }

        @JsonProperty(value="created_at")
        public void setCreated_at(@NotNull Date created_at) {
            if (created_at == null) {
                throw new NullPointerException("created_at is marked non-null but is null");
            }
            this.created_at = created_at;
        }

        @JsonProperty(value="updated_at")
        public void setUpdated_at(@NotNull Date updated_at) {
            if (updated_at == null) {
                throw new NullPointerException("updated_at is marked non-null but is null");
            }
            this.updated_at = updated_at;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserMute)) {
                return false;
            }
            UserMute other = (UserMute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            User this$target = this.getTarget();
            User other$target = other.getTarget();
            if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
                return false;
            }
            Date this$expires = this.getExpires();
            Date other$expires = other.getExpires();
            if (this$expires == null ? other$expires != null : !((Object)this$expires).equals(other$expires)) {
                return false;
            }
            Date this$created_at = this.getCreated_at();
            Date other$created_at = other.getCreated_at();
            if (this$created_at == null ? other$created_at != null : !((Object)this$created_at).equals(other$created_at)) {
                return false;
            }
            Date this$updated_at = this.getUpdated_at();
            Date other$updated_at = other.getUpdated_at();
            return !(this$updated_at == null ? other$updated_at != null : !((Object)this$updated_at).equals(other$updated_at));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserMute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            User $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
            Date $expires = this.getExpires();
            result = result * 59 + ($expires == null ? 43 : ((Object)$expires).hashCode());
            Date $created_at = this.getCreated_at();
            result = result * 59 + ($created_at == null ? 43 : ((Object)$created_at).hashCode());
            Date $updated_at = this.getUpdated_at();
            result = result * 59 + ($updated_at == null ? 43 : ((Object)$updated_at).hashCode());
            return result;
        }

        public String toString() {
            return "User.UserMute(user=" + this.getUser() + ", target=" + this.getTarget() + ", expires=" + this.getExpires() + ", created_at=" + this.getCreated_at() + ", updated_at=" + this.getUpdated_at() + ")";
        }
    }

    public static class OwnUser {
        @JsonProperty(value="id")
        @NotNull
        private String id;
        @JsonProperty(value="role")
        @Nullable
        private String role;
        @JsonProperty(value="roles")
        @Nullable
        private List<String> roles;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @NotNull
        private Date updatedAt;
        @JsonProperty(value="last_active")
        @NotNull
        private Date lastActive;
        @JsonProperty(value="deleted_at")
        @Nullable
        private Date deletedAt;
        @JsonProperty(value="deactivated_at")
        @Nullable
        private Date deactivatedAt;
        @JsonProperty(value="banned")
        @Nullable
        private Boolean banned;
        @JsonProperty(value="online")
        @Nullable
        private Boolean online;
        @JsonProperty(value="invisible")
        @Nullable
        private Boolean invisible;
        @JsonProperty(value="devices")
        @Nullable
        private List<Device> devices;
        @JsonProperty(value="mutes")
        @Nullable
        private List<UserMute> mutes;
        @JsonProperty(value="channel_mutes")
        @Nullable
        private List<ChannelMute> channelMutes;
        @JsonProperty(value="unread_count")
        @Nullable
        private Integer unreadCount;
        @JsonProperty(value="total_unread_count")
        @Nullable
        private Integer totalUnreadCount;
        @JsonProperty(value="unread_channels")
        @Nullable
        private Integer unreadChannels;
        @JsonProperty(value="language")
        @JsonDeserialize(using=LanguageDeserializer.class)
        @Nullable
        private Language language;
        @JsonProperty(value="teams")
        @Nullable
        private List<String> teams;
        @JsonProperty(value="latest_hidden_channels")
        @Nullable
        private List<String> latestHiddenChannels;
        @JsonIgnore
        @NotNull
        private Map<String, Object> additionalFields = new HashMap<String, Object>();

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getRole() {
            return this.role;
        }

        @Nullable
        public List<String> getRoles() {
            return this.roles;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @NotNull
        public Date getLastActive() {
            return this.lastActive;
        }

        @Nullable
        public Date getDeletedAt() {
            return this.deletedAt;
        }

        @Nullable
        public Date getDeactivatedAt() {
            return this.deactivatedAt;
        }

        @Nullable
        public Boolean getBanned() {
            return this.banned;
        }

        @Nullable
        public Boolean getOnline() {
            return this.online;
        }

        @Nullable
        public Boolean getInvisible() {
            return this.invisible;
        }

        @Nullable
        public List<Device> getDevices() {
            return this.devices;
        }

        @Nullable
        public List<UserMute> getMutes() {
            return this.mutes;
        }

        @Nullable
        public List<ChannelMute> getChannelMutes() {
            return this.channelMutes;
        }

        @Nullable
        public Integer getUnreadCount() {
            return this.unreadCount;
        }

        @Nullable
        public Integer getTotalUnreadCount() {
            return this.totalUnreadCount;
        }

        @Nullable
        public Integer getUnreadChannels() {
            return this.unreadChannels;
        }

        @Nullable
        public Language getLanguage() {
            return this.language;
        }

        @Nullable
        public List<String> getTeams() {
            return this.teams;
        }

        @Nullable
        public List<String> getLatestHiddenChannels() {
            return this.latestHiddenChannels;
        }

        @JsonProperty(value="id")
        public void setId(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }

        @JsonProperty(value="role")
        public void setRole(@Nullable String role) {
            this.role = role;
        }

        @JsonProperty(value="roles")
        public void setRoles(@Nullable List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@NotNull Date updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("updatedAt is marked non-null but is null");
            }
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="last_active")
        public void setLastActive(@NotNull Date lastActive) {
            if (lastActive == null) {
                throw new NullPointerException("lastActive is marked non-null but is null");
            }
            this.lastActive = lastActive;
        }

        @JsonProperty(value="deleted_at")
        public void setDeletedAt(@Nullable Date deletedAt) {
            this.deletedAt = deletedAt;
        }

        @JsonProperty(value="deactivated_at")
        public void setDeactivatedAt(@Nullable Date deactivatedAt) {
            this.deactivatedAt = deactivatedAt;
        }

        @JsonProperty(value="banned")
        public void setBanned(@Nullable Boolean banned) {
            this.banned = banned;
        }

        @JsonProperty(value="online")
        public void setOnline(@Nullable Boolean online) {
            this.online = online;
        }

        @JsonProperty(value="invisible")
        public void setInvisible(@Nullable Boolean invisible) {
            this.invisible = invisible;
        }

        @JsonProperty(value="devices")
        public void setDevices(@Nullable List<Device> devices) {
            this.devices = devices;
        }

        @JsonProperty(value="mutes")
        public void setMutes(@Nullable List<UserMute> mutes) {
            this.mutes = mutes;
        }

        @JsonProperty(value="channel_mutes")
        public void setChannelMutes(@Nullable List<ChannelMute> channelMutes) {
            this.channelMutes = channelMutes;
        }

        @JsonProperty(value="unread_count")
        public void setUnreadCount(@Nullable Integer unreadCount) {
            this.unreadCount = unreadCount;
        }

        @JsonProperty(value="total_unread_count")
        public void setTotalUnreadCount(@Nullable Integer totalUnreadCount) {
            this.totalUnreadCount = totalUnreadCount;
        }

        @JsonProperty(value="unread_channels")
        public void setUnreadChannels(@Nullable Integer unreadChannels) {
            this.unreadChannels = unreadChannels;
        }

        @JsonProperty(value="language")
        @JsonDeserialize(using=LanguageDeserializer.class)
        public void setLanguage(@Nullable Language language) {
            this.language = language;
        }

        @JsonProperty(value="teams")
        public void setTeams(@Nullable List<String> teams) {
            this.teams = teams;
        }

        @JsonProperty(value="latest_hidden_channels")
        public void setLatestHiddenChannels(@Nullable List<String> latestHiddenChannels) {
            this.latestHiddenChannels = latestHiddenChannels;
        }

        @JsonIgnore
        public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
            if (additionalFields == null) {
                throw new NullPointerException("additionalFields is marked non-null but is null");
            }
            this.additionalFields = additionalFields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OwnUser)) {
                return false;
            }
            OwnUser other = (OwnUser)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$banned = this.getBanned();
            Boolean other$banned = other.getBanned();
            if (this$banned == null ? other$banned != null : !((Object)this$banned).equals(other$banned)) {
                return false;
            }
            Boolean this$online = this.getOnline();
            Boolean other$online = other.getOnline();
            if (this$online == null ? other$online != null : !((Object)this$online).equals(other$online)) {
                return false;
            }
            Boolean this$invisible = this.getInvisible();
            Boolean other$invisible = other.getInvisible();
            if (this$invisible == null ? other$invisible != null : !((Object)this$invisible).equals(other$invisible)) {
                return false;
            }
            Integer this$unreadCount = this.getUnreadCount();
            Integer other$unreadCount = other.getUnreadCount();
            if (this$unreadCount == null ? other$unreadCount != null : !((Object)this$unreadCount).equals(other$unreadCount)) {
                return false;
            }
            Integer this$totalUnreadCount = this.getTotalUnreadCount();
            Integer other$totalUnreadCount = other.getTotalUnreadCount();
            if (this$totalUnreadCount == null ? other$totalUnreadCount != null : !((Object)this$totalUnreadCount).equals(other$totalUnreadCount)) {
                return false;
            }
            Integer this$unreadChannels = this.getUnreadChannels();
            Integer other$unreadChannels = other.getUnreadChannels();
            if (this$unreadChannels == null ? other$unreadChannels != null : !((Object)this$unreadChannels).equals(other$unreadChannels)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            List<String> this$roles = this.getRoles();
            List<String> other$roles = other.getRoles();
            if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            Date this$lastActive = this.getLastActive();
            Date other$lastActive = other.getLastActive();
            if (this$lastActive == null ? other$lastActive != null : !((Object)this$lastActive).equals(other$lastActive)) {
                return false;
            }
            Date this$deletedAt = this.getDeletedAt();
            Date other$deletedAt = other.getDeletedAt();
            if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
                return false;
            }
            Date this$deactivatedAt = this.getDeactivatedAt();
            Date other$deactivatedAt = other.getDeactivatedAt();
            if (this$deactivatedAt == null ? other$deactivatedAt != null : !((Object)this$deactivatedAt).equals(other$deactivatedAt)) {
                return false;
            }
            List<Device> this$devices = this.getDevices();
            List<Device> other$devices = other.getDevices();
            if (this$devices == null ? other$devices != null : !((Object)this$devices).equals(other$devices)) {
                return false;
            }
            List<UserMute> this$mutes = this.getMutes();
            List<UserMute> other$mutes = other.getMutes();
            if (this$mutes == null ? other$mutes != null : !((Object)this$mutes).equals(other$mutes)) {
                return false;
            }
            List<ChannelMute> this$channelMutes = this.getChannelMutes();
            List<ChannelMute> other$channelMutes = other.getChannelMutes();
            if (this$channelMutes == null ? other$channelMutes != null : !((Object)this$channelMutes).equals(other$channelMutes)) {
                return false;
            }
            Language this$language = this.getLanguage();
            Language other$language = other.getLanguage();
            if (this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language)) {
                return false;
            }
            List<String> this$teams = this.getTeams();
            List<String> other$teams = other.getTeams();
            if (this$teams == null ? other$teams != null : !((Object)this$teams).equals(other$teams)) {
                return false;
            }
            List<String> this$latestHiddenChannels = this.getLatestHiddenChannels();
            List<String> other$latestHiddenChannels = other.getLatestHiddenChannels();
            if (this$latestHiddenChannels == null ? other$latestHiddenChannels != null : !((Object)this$latestHiddenChannels).equals(other$latestHiddenChannels)) {
                return false;
            }
            Map<String, Object> this$additionalFields = this.getAdditionalFields();
            Map<String, Object> other$additionalFields = other.getAdditionalFields();
            return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OwnUser;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $banned = this.getBanned();
            result = result * 59 + ($banned == null ? 43 : ((Object)$banned).hashCode());
            Boolean $online = this.getOnline();
            result = result * 59 + ($online == null ? 43 : ((Object)$online).hashCode());
            Boolean $invisible = this.getInvisible();
            result = result * 59 + ($invisible == null ? 43 : ((Object)$invisible).hashCode());
            Integer $unreadCount = this.getUnreadCount();
            result = result * 59 + ($unreadCount == null ? 43 : ((Object)$unreadCount).hashCode());
            Integer $totalUnreadCount = this.getTotalUnreadCount();
            result = result * 59 + ($totalUnreadCount == null ? 43 : ((Object)$totalUnreadCount).hashCode());
            Integer $unreadChannels = this.getUnreadChannels();
            result = result * 59 + ($unreadChannels == null ? 43 : ((Object)$unreadChannels).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            List<String> $roles = this.getRoles();
            result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            Date $lastActive = this.getLastActive();
            result = result * 59 + ($lastActive == null ? 43 : ((Object)$lastActive).hashCode());
            Date $deletedAt = this.getDeletedAt();
            result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
            Date $deactivatedAt = this.getDeactivatedAt();
            result = result * 59 + ($deactivatedAt == null ? 43 : ((Object)$deactivatedAt).hashCode());
            List<Device> $devices = this.getDevices();
            result = result * 59 + ($devices == null ? 43 : ((Object)$devices).hashCode());
            List<UserMute> $mutes = this.getMutes();
            result = result * 59 + ($mutes == null ? 43 : ((Object)$mutes).hashCode());
            List<ChannelMute> $channelMutes = this.getChannelMutes();
            result = result * 59 + ($channelMutes == null ? 43 : ((Object)$channelMutes).hashCode());
            Language $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : ((Object)((Object)$language)).hashCode());
            List<String> $teams = this.getTeams();
            result = result * 59 + ($teams == null ? 43 : ((Object)$teams).hashCode());
            List<String> $latestHiddenChannels = this.getLatestHiddenChannels();
            result = result * 59 + ($latestHiddenChannels == null ? 43 : ((Object)$latestHiddenChannels).hashCode());
            Map<String, Object> $additionalFields = this.getAdditionalFields();
            result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
            return result;
        }

        public String toString() {
            return "User.OwnUser(id=" + this.getId() + ", role=" + this.getRole() + ", roles=" + this.getRoles() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", lastActive=" + this.getLastActive() + ", deletedAt=" + this.getDeletedAt() + ", deactivatedAt=" + this.getDeactivatedAt() + ", banned=" + this.getBanned() + ", online=" + this.getOnline() + ", invisible=" + this.getInvisible() + ", devices=" + this.getDevices() + ", mutes=" + this.getMutes() + ", channelMutes=" + this.getChannelMutes() + ", unreadCount=" + this.getUnreadCount() + ", totalUnreadCount=" + this.getTotalUnreadCount() + ", unreadChannels=" + this.getUnreadChannels() + ", language=" + this.getLanguage() + ", teams=" + this.getTeams() + ", latestHiddenChannels=" + this.getLatestHiddenChannels() + ", additionalFields=" + this.getAdditionalFields() + ")";
        }
    }

    public static class Ban {
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="expires")
        @Nullable
        private Date expires;
        @JsonProperty(value="reason")
        @Nullable
        private String reason;
        @JsonProperty(value="shadow")
        @Nullable
        private Boolean shadow;
        @JsonProperty(value="banned_by")
        @NotNull
        private User bannedBy;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @Nullable
        public User getUser() {
            return this.user;
        }

        @Nullable
        public Date getExpires() {
            return this.expires;
        }

        @Nullable
        public String getReason() {
            return this.reason;
        }

        @Nullable
        public Boolean getShadow() {
            return this.shadow;
        }

        @NotNull
        public User getBannedBy() {
            return this.bannedBy;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty(value="expires")
        public void setExpires(@Nullable Date expires) {
            this.expires = expires;
        }

        @JsonProperty(value="reason")
        public void setReason(@Nullable String reason) {
            this.reason = reason;
        }

        @JsonProperty(value="shadow")
        public void setShadow(@Nullable Boolean shadow) {
            this.shadow = shadow;
        }

        @JsonProperty(value="banned_by")
        public void setBannedBy(@NotNull User bannedBy) {
            if (bannedBy == null) {
                throw new NullPointerException("bannedBy is marked non-null but is null");
            }
            this.bannedBy = bannedBy;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ban)) {
                return false;
            }
            Ban other = (Ban)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$shadow = this.getShadow();
            Boolean other$shadow = other.getShadow();
            if (this$shadow == null ? other$shadow != null : !((Object)this$shadow).equals(other$shadow)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Date this$expires = this.getExpires();
            Date other$expires = other.getExpires();
            if (this$expires == null ? other$expires != null : !((Object)this$expires).equals(other$expires)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            User this$bannedBy = this.getBannedBy();
            User other$bannedBy = other.getBannedBy();
            if (this$bannedBy == null ? other$bannedBy != null : !((Object)this$bannedBy).equals(other$bannedBy)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ban;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $shadow = this.getShadow();
            result = result * 59 + ($shadow == null ? 43 : ((Object)$shadow).hashCode());
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Date $expires = this.getExpires();
            result = result * 59 + ($expires == null ? 43 : ((Object)$expires).hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            User $bannedBy = this.getBannedBy();
            result = result * 59 + ($bannedBy == null ? 43 : ((Object)$bannedBy).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            return result;
        }

        public String toString() {
            return "User.Ban(channel=" + this.getChannel() + ", user=" + this.getUser() + ", expires=" + this.getExpires() + ", reason=" + this.getReason() + ", shadow=" + this.getShadow() + ", bannedBy=" + this.getBannedBy() + ", createdAt=" + this.getCreatedAt() + ")";
        }
    }

    public static class ChannelMute {
        @JsonProperty(value="user")
        @NotNull
        private User user;
        @JsonProperty(value="channel")
        @NotNull
        private Channel channel;
        @JsonProperty(value="expires")
        @Nullable
        private Date expires;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @NotNull
        private Date updatedAt;

        @NotNull
        public User getUser() {
            return this.user;
        }

        @NotNull
        public Channel getChannel() {
            return this.channel;
        }

        @Nullable
        public Date getExpires() {
            return this.expires;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @JsonProperty(value="user")
        public void setUser(@NotNull User user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
        }

        @JsonProperty(value="channel")
        public void setChannel(@NotNull Channel channel) {
            if (channel == null) {
                throw new NullPointerException("channel is marked non-null but is null");
            }
            this.channel = channel;
        }

        @JsonProperty(value="expires")
        public void setExpires(@Nullable Date expires) {
            this.expires = expires;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@NotNull Date updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("updatedAt is marked non-null but is null");
            }
            this.updatedAt = updatedAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelMute)) {
                return false;
            }
            ChannelMute other = (ChannelMute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            Date this$expires = this.getExpires();
            Date other$expires = other.getExpires();
            if (this$expires == null ? other$expires != null : !((Object)this$expires).equals(other$expires)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelMute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            Date $expires = this.getExpires();
            result = result * 59 + ($expires == null ? 43 : ((Object)$expires).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            return result;
        }

        public String toString() {
            return "User.ChannelMute(user=" + this.getUser() + ", channel=" + this.getChannel() + ", expires=" + this.getExpires() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
        }
    }

    public static class Mute {
        @JsonProperty(value="user")
        @NotNull
        private User user;
        @JsonProperty(value="target")
        @NotNull
        private User target;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @NotNull
        private Date updatedAt;
        @JsonProperty(value="expires")
        @Nullable
        private Date expires;

        @NotNull
        public User getUser() {
            return this.user;
        }

        @NotNull
        public User getTarget() {
            return this.target;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @Nullable
        public Date getExpires() {
            return this.expires;
        }

        @JsonProperty(value="user")
        public void setUser(@NotNull User user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
        }

        @JsonProperty(value="target")
        public void setTarget(@NotNull User target) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.target = target;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@NotNull Date updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("updatedAt is marked non-null but is null");
            }
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="expires")
        public void setExpires(@Nullable Date expires) {
            this.expires = expires;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mute)) {
                return false;
            }
            Mute other = (Mute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            User this$target = this.getTarget();
            User other$target = other.getTarget();
            if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            Date this$expires = this.getExpires();
            Date other$expires = other.getExpires();
            return !(this$expires == null ? other$expires != null : !((Object)this$expires).equals(other$expires));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            User $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            Date $expires = this.getExpires();
            result = result * 59 + ($expires == null ? 43 : ((Object)$expires).hashCode());
            return result;
        }

        public String toString() {
            return "User.Mute(user=" + this.getUser() + ", target=" + this.getTarget() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", expires=" + this.getExpires() + ")";
        }
    }
}

