/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.PermissionService;
import io.getstream.chat.java.services.framework.Client;
import java.util.List;
import java.util.Map;
import shadowed.com.fasterxml.jackson.annotation.JsonProperty;
import shadowed.org.jetbrains.annotations.NotNull;
import shadowed.org.jetbrains.annotations.Nullable;
import shadowed.retrofit2.Call;

public class Permission {
    @JsonProperty(value="id")
    @NotNull
    private String id;
    @JsonProperty(value="name")
    @NotNull
    private String name;
    @JsonProperty(value="action")
    @NotNull
    private String action;
    @JsonProperty(value="owner")
    @Nullable
    private Boolean owner;
    @JsonProperty(value="same_team")
    @Nullable
    private Boolean sameTeam;
    @JsonProperty(value="custom")
    @NotNull
    private Boolean custom;
    @JsonProperty(value="condition")
    @Nullable
    private Condition condition;

    @NotNull
    public static PermissionCreateRequestData.PermissionCreateRequest create() {
        return new PermissionCreateRequestData.PermissionCreateRequest();
    }

    @NotNull
    public static PermissionGetRequest get(@NotNull String id) {
        return new PermissionGetRequest(id);
    }

    @NotNull
    public static PermissionUpdateRequestData.PermissionUpdateRequest update(@NotNull String id, @NotNull String name) {
        return new PermissionUpdateRequestData.PermissionUpdateRequest(id, name);
    }

    @NotNull
    public static PermissionDeleteRequest delete(@NotNull String id) {
        return new PermissionDeleteRequest(id);
    }

    @NotNull
    public static PermissionListRequest list() {
        return new PermissionListRequest();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getAction() {
        return this.action;
    }

    @Nullable
    public Boolean getOwner() {
        return this.owner;
    }

    @Nullable
    public Boolean getSameTeam() {
        return this.sameTeam;
    }

    @NotNull
    public Boolean getCustom() {
        return this.custom;
    }

    @Nullable
    public Condition getCondition() {
        return this.condition;
    }

    @JsonProperty(value="id")
    public void setId(@NotNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="name")
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @JsonProperty(value="action")
    public void setAction(@NotNull String action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.action = action;
    }

    @JsonProperty(value="owner")
    public void setOwner(@Nullable Boolean owner) {
        this.owner = owner;
    }

    @JsonProperty(value="same_team")
    public void setSameTeam(@Nullable Boolean sameTeam) {
        this.sameTeam = sameTeam;
    }

    @JsonProperty(value="custom")
    public void setCustom(@NotNull Boolean custom) {
        if (custom == null) {
            throw new NullPointerException("custom is marked non-null but is null");
        }
        this.custom = custom;
    }

    @JsonProperty(value="condition")
    public void setCondition(@Nullable Condition condition) {
        this.condition = condition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$owner = this.getOwner();
        Boolean other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Boolean this$sameTeam = this.getSameTeam();
        Boolean other$sameTeam = other.getSameTeam();
        if (this$sameTeam == null ? other$sameTeam != null : !((Object)this$sameTeam).equals(other$sameTeam)) {
            return false;
        }
        Boolean this$custom = this.getCustom();
        Boolean other$custom = other.getCustom();
        if (this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        Condition this$condition = this.getCondition();
        Condition other$condition = other.getCondition();
        return !(this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Permission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Boolean $sameTeam = this.getSameTeam();
        result = result * 59 + ($sameTeam == null ? 43 : ((Object)$sameTeam).hashCode());
        Boolean $custom = this.getCustom();
        result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        Condition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        return result;
    }

    public String toString() {
        return "Permission(id=" + this.getId() + ", name=" + this.getName() + ", action=" + this.getAction() + ", owner=" + this.getOwner() + ", sameTeam=" + this.getSameTeam() + ", custom=" + this.getCustom() + ", condition=" + this.getCondition() + ")";
    }

    public static class PermissionListResponse
    extends StreamResponseObject {
        @JsonProperty(value="permissions")
        @NotNull
        private List<Permission> permissions;

        @NotNull
        public List<Permission> getPermissions() {
            return this.permissions;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(@NotNull List<Permission> permissions) {
            if (permissions == null) {
                throw new NullPointerException("permissions is marked non-null but is null");
            }
            this.permissions = permissions;
        }

        @Override
        public String toString() {
            return "Permission.PermissionListResponse(permissions=" + this.getPermissions() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissionListResponse)) {
                return false;
            }
            PermissionListResponse other = (PermissionListResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Permission> this$permissions = this.getPermissions();
            List<Permission> other$permissions = other.getPermissions();
            return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PermissionListResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Permission> $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
            return result;
        }
    }

    public static class PermissionGetResponse
    extends StreamResponseObject {
        @JsonProperty(value="permission")
        @NotNull
        private Permission permission;

        @NotNull
        public Permission getPermission() {
            return this.permission;
        }

        @JsonProperty(value="permission")
        public void setPermission(@NotNull Permission permission) {
            if (permission == null) {
                throw new NullPointerException("permission is marked non-null but is null");
            }
            this.permission = permission;
        }

        @Override
        public String toString() {
            return "Permission.PermissionGetResponse(permission=" + this.getPermission() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissionGetResponse)) {
                return false;
            }
            PermissionGetResponse other = (PermissionGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Permission this$permission = this.getPermission();
            Permission other$permission = other.getPermission();
            return !(this$permission == null ? other$permission != null : !((Object)this$permission).equals(other$permission));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PermissionGetResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Permission $permission = this.getPermission();
            result = result * 59 + ($permission == null ? 43 : ((Object)$permission).hashCode());
            return result;
        }
    }

    public static class PermissionListRequest
    extends StreamRequest<PermissionListResponse> {
        @Override
        protected Call<PermissionListResponse> generateCall(Client client) {
            return client.create(PermissionService.class).list();
        }
    }

    public static class PermissionDeleteRequest
    extends StreamRequest<StreamResponseObject> {
        @NotNull
        private String id;

        @Override
        protected Call<StreamResponseObject> generateCall(Client client) {
            return client.create(PermissionService.class).delete(this.id);
        }

        public PermissionDeleteRequest(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }
    }

    public static class PermissionUpdateRequestData {
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="action")
        @Nullable
        private String action;
        @JsonProperty(value="owner")
        @Nullable
        private Boolean owner;
        @JsonProperty(value="same_team")
        @Nullable
        private Boolean sameTeam;
        @JsonProperty(value="condition")
        @Nullable
        private Map<String, Object> condition;

        PermissionUpdateRequestData(@Nullable String id, @Nullable String name, @Nullable String action, @Nullable Boolean owner, @Nullable Boolean sameTeam, @Nullable Map<String, Object> condition) {
            this.id = id;
            this.name = name;
            this.action = action;
            this.owner = owner;
            this.sameTeam = sameTeam;
            this.condition = condition;
        }

        public static class PermissionUpdateRequest
        extends StreamRequest<StreamResponseObject> {
            private String id;
            private String name;
            private String action;
            private Boolean owner;
            private Boolean sameTeam;
            private Map<String, Object> condition;

            private PermissionUpdateRequest(@NotNull String id, @NotNull String name) {
                this.id = id;
                this.name = name;
            }

            private PermissionUpdateRequest name(@NotNull String name) {
                throw new IllegalStateException("Should not use as it is only to hide builder method");
            }

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(PermissionService.class).update(this.id, this.internalBuild());
            }

            @JsonProperty(value="id")
            public PermissionUpdateRequest id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="action")
            public PermissionUpdateRequest action(@Nullable String action) {
                this.action = action;
                return this;
            }

            @JsonProperty(value="owner")
            public PermissionUpdateRequest owner(@Nullable Boolean owner) {
                this.owner = owner;
                return this;
            }

            @JsonProperty(value="same_team")
            public PermissionUpdateRequest sameTeam(@Nullable Boolean sameTeam) {
                this.sameTeam = sameTeam;
                return this;
            }

            @JsonProperty(value="condition")
            public PermissionUpdateRequest condition(@Nullable Map<String, Object> condition) {
                this.condition = condition;
                return this;
            }

            public PermissionUpdateRequestData internalBuild() {
                return new PermissionUpdateRequestData(this.id, this.name, this.action, this.owner, this.sameTeam, this.condition);
            }

            public String toString() {
                return "Permission.PermissionUpdateRequestData.PermissionUpdateRequest(id=" + this.id + ", name=" + this.name + ", action=" + this.action + ", owner=" + this.owner + ", sameTeam=" + this.sameTeam + ", condition=" + this.condition + ")";
            }
        }
    }

    public static class PermissionGetRequest
    extends StreamRequest<PermissionGetResponse> {
        @NotNull
        private String id;

        @Override
        protected Call<PermissionGetResponse> generateCall(Client client) {
            return client.create(PermissionService.class).get(this.id);
        }

        public PermissionGetRequest(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }
    }

    public static class PermissionCreateRequestData {
        @JsonProperty(value="id")
        @NotNull
        private String id;
        @JsonProperty(value="name")
        @NotNull
        private String name;
        @JsonProperty(value="action")
        @NotNull
        private String action;
        @JsonProperty(value="owner")
        @Nullable
        private Boolean owner;
        @JsonProperty(value="same_team")
        @Nullable
        private Boolean sameTeam;
        @JsonProperty(value="condition")
        @Nullable
        private Map<String, Object> condition;

        PermissionCreateRequestData(@NotNull String id, @NotNull String name, @NotNull String action, @Nullable Boolean owner, @Nullable Boolean sameTeam, @Nullable Map<String, Object> condition) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.id = id;
            this.name = name;
            this.action = action;
            this.owner = owner;
            this.sameTeam = sameTeam;
            this.condition = condition;
        }

        public static class PermissionCreateRequest
        extends StreamRequest<StreamResponseObject> {
            private String id;
            private String name;
            private String action;
            private Boolean owner;
            private Boolean sameTeam;
            private Map<String, Object> condition;

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(PermissionService.class).create(this.internalBuild());
            }

            PermissionCreateRequest() {
            }

            @JsonProperty(value="id")
            public PermissionCreateRequest id(@NotNull String id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                this.id = id;
                return this;
            }

            @JsonProperty(value="name")
            public PermissionCreateRequest name(@NotNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @JsonProperty(value="action")
            public PermissionCreateRequest action(@NotNull String action) {
                if (action == null) {
                    throw new NullPointerException("action is marked non-null but is null");
                }
                this.action = action;
                return this;
            }

            @JsonProperty(value="owner")
            public PermissionCreateRequest owner(@Nullable Boolean owner) {
                this.owner = owner;
                return this;
            }

            @JsonProperty(value="same_team")
            public PermissionCreateRequest sameTeam(@Nullable Boolean sameTeam) {
                this.sameTeam = sameTeam;
                return this;
            }

            @JsonProperty(value="condition")
            public PermissionCreateRequest condition(@Nullable Map<String, Object> condition) {
                this.condition = condition;
                return this;
            }

            public PermissionCreateRequestData internalBuild() {
                return new PermissionCreateRequestData(this.id, this.name, this.action, this.owner, this.sameTeam, this.condition);
            }

            public String toString() {
                return "Permission.PermissionCreateRequestData.PermissionCreateRequest(id=" + this.id + ", name=" + this.name + ", action=" + this.action + ", owner=" + this.owner + ", sameTeam=" + this.sameTeam + ", condition=" + this.condition + ")";
            }
        }
    }

    public static class Condition {
        @NotNull
        private String expression;

        @NotNull
        public String getExpression() {
            return this.expression;
        }

        public void setExpression(@NotNull String expression) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            this.expression = expression;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Condition)) {
                return false;
            }
            Condition other = (Condition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$expression = this.getExpression();
            String other$expression = other.getExpression();
            return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Condition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            return result;
        }

        public String toString() {
            return "Permission.Condition(expression=" + this.getExpression() + ")";
        }
    }
}

