/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.ModerationService;
import io.getstream.chat.java.services.framework.Client;
import java.util.Date;
import java.util.List;
import shadowed.com.fasterxml.jackson.annotation.JsonProperty;
import shadowed.org.jetbrains.annotations.NotNull;
import shadowed.org.jetbrains.annotations.Nullable;
import shadowed.retrofit2.Call;

public class Moderation {
    @NotNull
    public static UpsertConfigRequestData.UpsertConfigRequest upsertConfig(@NotNull String key) {
        return new UpsertConfigRequestData.UpsertConfigRequest(key);
    }

    @NotNull
    public static DeleteConfigRequest deleteConfig(@NotNull String key) {
        return new DeleteConfigRequest(key);
    }

    @NotNull
    public static ConfigGetRequest getConfig(@NotNull String key) {
        return new ConfigGetRequest(key);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Moderation)) {
            return false;
        }
        Moderation other = (Moderation)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Moderation;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "Moderation()";
    }

    public static class ConfigGetRequest
    extends StreamRequest<ConfigGetResponse> {
        @NotNull
        private String key;

        @Override
        protected Call<ConfigGetResponse> generateCall(Client client) {
            return client.create(ModerationService.class).getConfig(this.key);
        }

        public ConfigGetRequest(@NotNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
        }
    }

    public static class DeleteConfigRequest
    extends StreamRequest<StreamResponseObject> {
        @NotNull
        private String key;

        @Override
        protected Call<StreamResponseObject> generateCall(Client client) {
            return client.create(ModerationService.class).deleteConfig(this.key);
        }

        public DeleteConfigRequest(@NotNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
        }
    }

    public static class UpsertConfigResponse
    extends StreamResponseObject {
        @JsonProperty(value="config")
        @Nullable
        private Config config;

        @Nullable
        public Config getConfig() {
            return this.config;
        }

        @JsonProperty(value="config")
        public void setConfig(@Nullable Config config) {
            this.config = config;
        }

        @Override
        public String toString() {
            return "Moderation.UpsertConfigResponse(config=" + this.getConfig() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpsertConfigResponse)) {
                return false;
            }
            UpsertConfigResponse other = (UpsertConfigResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Config this$config = this.getConfig();
            Config other$config = other.getConfig();
            return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UpsertConfigResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Config $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
            return result;
        }
    }

    public static class UpsertConfigRequestData {
        @JsonProperty(value="key")
        @Nullable
        private String key;
        @JsonProperty(value="async")
        @Nullable
        private Boolean async;
        @JsonProperty(value="block_list_config")
        @Nullable
        private BlockListConfigRequestObject blockListConfig;

        UpsertConfigRequestData(@Nullable String key, @Nullable Boolean async, @Nullable BlockListConfigRequestObject blockListConfig) {
            this.key = key;
            this.async = async;
            this.blockListConfig = blockListConfig;
        }

        public static class UpsertConfigRequest
        extends StreamRequest<UpsertConfigResponse> {
            private Boolean async;
            private BlockListConfigRequestObject blockListConfig;
            @NotNull
            private String key;

            private UpsertConfigRequest(@NotNull String key) {
                this.key = key;
            }

            @Override
            protected Call<UpsertConfigResponse> generateCall(Client client) {
                return client.create(ModerationService.class).upsertConfig(this.key(this.key).internalBuild());
            }

            @JsonProperty(value="key")
            public UpsertConfigRequest key(@Nullable @NotNull String key) {
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                this.key = key;
                return this;
            }

            @JsonProperty(value="async")
            public UpsertConfigRequest async(@Nullable Boolean async) {
                this.async = async;
                return this;
            }

            @JsonProperty(value="block_list_config")
            public UpsertConfigRequest blockListConfig(@Nullable BlockListConfigRequestObject blockListConfig) {
                this.blockListConfig = blockListConfig;
                return this;
            }

            public UpsertConfigRequestData internalBuild() {
                return new UpsertConfigRequestData(this.key, this.async, this.blockListConfig);
            }

            public String toString() {
                return "Moderation.UpsertConfigRequestData.UpsertConfigRequest(key=" + this.key + ", async=" + this.async + ", blockListConfig=" + this.blockListConfig + ")";
            }
        }
    }

    public static class BlockListConfigRequestObject {
        @JsonProperty(value="async")
        @Nullable
        private Boolean async;
        @JsonProperty(value="rules")
        @NotNull
        private List<BlockListRule> rules;

        BlockListConfigRequestObject(@Nullable Boolean async, @NotNull List<BlockListRule> rules) {
            if (rules == null) {
                throw new NullPointerException("rules is marked non-null but is null");
            }
            this.async = async;
            this.rules = rules;
        }

        public static BlockListConfigRequestObjectBuilder builder() {
            return new BlockListConfigRequestObjectBuilder();
        }

        public static class BlockListConfigRequestObjectBuilder {
            private Boolean async;
            private List<BlockListRule> rules;

            BlockListConfigRequestObjectBuilder() {
            }

            @JsonProperty(value="async")
            public BlockListConfigRequestObjectBuilder async(@Nullable Boolean async) {
                this.async = async;
                return this;
            }

            @JsonProperty(value="rules")
            public BlockListConfigRequestObjectBuilder rules(@NotNull List<BlockListRule> rules) {
                if (rules == null) {
                    throw new NullPointerException("rules is marked non-null but is null");
                }
                this.rules = rules;
                return this;
            }

            public BlockListConfigRequestObject build() {
                return new BlockListConfigRequestObject(this.async, this.rules);
            }

            public String toString() {
                return "Moderation.BlockListConfigRequestObject.BlockListConfigRequestObjectBuilder(async=" + this.async + ", rules=" + this.rules + ")";
            }
        }
    }

    public static class BlockListRule {
        @JsonProperty(value="name")
        @NotNull
        private String name;
        @JsonProperty(value="action")
        @NotNull
        private Action action;

        public static BlockListRuleBuilder builder() {
            return new BlockListRuleBuilder();
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Action getAction() {
            return this.action;
        }

        @JsonProperty(value="name")
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @JsonProperty(value="action")
        public void setAction(@NotNull Action action) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockListRule)) {
                return false;
            }
            BlockListRule other = (BlockListRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Action this$action = this.getAction();
            Action other$action = other.getAction();
            return !(this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BlockListRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Action $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            return result;
        }

        public String toString() {
            return "Moderation.BlockListRule(name=" + this.getName() + ", action=" + this.getAction() + ")";
        }

        public BlockListRule() {
        }

        public BlockListRule(@NotNull String name, @NotNull Action action) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.name = name;
            this.action = action;
        }

        public static class BlockListRuleBuilder {
            private String name;
            private Action action;

            BlockListRuleBuilder() {
            }

            @JsonProperty(value="name")
            public BlockListRuleBuilder name(@NotNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @JsonProperty(value="action")
            public BlockListRuleBuilder action(@NotNull Action action) {
                if (action == null) {
                    throw new NullPointerException("action is marked non-null but is null");
                }
                this.action = action;
                return this;
            }

            public BlockListRule build() {
                return new BlockListRule(this.name, this.action);
            }

            public String toString() {
                return "Moderation.BlockListRule.BlockListRuleBuilder(name=" + this.name + ", action=" + this.action + ")";
            }
        }
    }

    public static enum Action {
        FLAG,
        SHADOW,
        REMOVE,
        BOUNCE,
        BOUNCE_FLAG,
        BOUNCE_REMOVE,
        UNKNOWN;

    }

    public static class BlockListConfig {
        @JsonProperty(value="async")
        @Nullable
        private Boolean async;
        @JsonProperty(value="enabled")
        @NotNull
        private Boolean enabled;
        @JsonProperty(value="rules")
        @NotNull
        private List<BlockListRule> rules;

        @Nullable
        public Boolean getAsync() {
            return this.async;
        }

        @NotNull
        public Boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public List<BlockListRule> getRules() {
            return this.rules;
        }

        @JsonProperty(value="async")
        public void setAsync(@Nullable Boolean async) {
            this.async = async;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(@NotNull Boolean enabled) {
            if (enabled == null) {
                throw new NullPointerException("enabled is marked non-null but is null");
            }
            this.enabled = enabled;
        }

        @JsonProperty(value="rules")
        public void setRules(@NotNull List<BlockListRule> rules) {
            if (rules == null) {
                throw new NullPointerException("rules is marked non-null but is null");
            }
            this.rules = rules;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockListConfig)) {
                return false;
            }
            BlockListConfig other = (BlockListConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$async = this.getAsync();
            Boolean other$async = other.getAsync();
            if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            List<BlockListRule> this$rules = this.getRules();
            List<BlockListRule> other$rules = other.getRules();
            return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BlockListConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $async = this.getAsync();
            result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            List<BlockListRule> $rules = this.getRules();
            result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
            return result;
        }

        public String toString() {
            return "Moderation.BlockListConfig(async=" + this.getAsync() + ", enabled=" + this.getEnabled() + ", rules=" + this.getRules() + ")";
        }
    }

    public static class Config {
        @JsonProperty(value="key")
        @Nullable
        private String key;
        @JsonProperty(value="async")
        @Nullable
        private Boolean async;
        @JsonProperty(value="block_list_config")
        @Nullable
        private BlockListConfig blockListConfig;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updatedAt;

        @Nullable
        public String getKey() {
            return this.key;
        }

        @Nullable
        public Boolean getAsync() {
            return this.async;
        }

        @Nullable
        public BlockListConfig getBlockListConfig() {
            return this.blockListConfig;
        }

        @Nullable
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @JsonProperty(value="key")
        public void setKey(@Nullable String key) {
            this.key = key;
        }

        @JsonProperty(value="async")
        public void setAsync(@Nullable Boolean async) {
            this.async = async;
        }

        @JsonProperty(value="block_list_config")
        public void setBlockListConfig(@Nullable BlockListConfig blockListConfig) {
            this.blockListConfig = blockListConfig;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$async = this.getAsync();
            Boolean other$async = other.getAsync();
            if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            BlockListConfig this$blockListConfig = this.getBlockListConfig();
            BlockListConfig other$blockListConfig = other.getBlockListConfig();
            if (this$blockListConfig == null ? other$blockListConfig != null : !((Object)this$blockListConfig).equals(other$blockListConfig)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $async = this.getAsync();
            result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            BlockListConfig $blockListConfig = this.getBlockListConfig();
            result = result * 59 + ($blockListConfig == null ? 43 : ((Object)$blockListConfig).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            return result;
        }

        public String toString() {
            return "Moderation.Config(key=" + this.getKey() + ", async=" + this.getAsync() + ", blockListConfig=" + this.getBlockListConfig() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
        }
    }

    public static class ConfigGetResponse
    extends StreamResponseObject {
        @JsonProperty(value="config")
        @Nullable
        private Config config;

        @Nullable
        public Config getConfig() {
            return this.config;
        }

        @JsonProperty(value="config")
        public void setConfig(@Nullable Config config) {
            this.config = config;
        }

        @Override
        public String toString() {
            return "Moderation.ConfigGetResponse(config=" + this.getConfig() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigGetResponse)) {
                return false;
            }
            ConfigGetResponse other = (ConfigGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Config this$config = this.getConfig();
            Config other$config = other.getConfig();
            return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ConfigGetResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Config $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
            return result;
        }
    }

    public static class ConfigGetRequestData {
        ConfigGetRequestData() {
        }

        public static class ConfigGetRequest
        extends StreamRequest<ConfigGetResponse> {
            @NotNull
            private String key;

            private ConfigGetRequest(@NotNull String key) {
                this.key = key;
            }

            @Override
            protected Call<ConfigGetResponse> generateCall(Client client) {
                return client.create(ModerationService.class).getConfig(this.key);
            }

            public ConfigGetRequestData internalBuild() {
                return new ConfigGetRequestData();
            }

            public String toString() {
                return "Moderation.ConfigGetRequestData.ConfigGetRequest()";
            }
        }
    }
}

