/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import io.getstream.chat.java.models.Channel;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.Reaction;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.RequestObjectBuilder;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.EventService;
import io.getstream.chat.java.services.framework.Client;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import shadowed.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadowed.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadowed.com.fasterxml.jackson.annotation.JsonIgnore;
import shadowed.com.fasterxml.jackson.annotation.JsonProperty;
import shadowed.org.jetbrains.annotations.NotNull;
import shadowed.org.jetbrains.annotations.Nullable;
import shadowed.retrofit2.Call;

public class Event {
    @JsonProperty(value="type")
    @Nullable
    private String type;
    @JsonProperty(value="connection_id")
    @Nullable
    private String connectionId;
    @JsonProperty(value="cid")
    @Nullable
    private String cid;
    @JsonProperty(value="channel_id")
    @Nullable
    private String channelId;
    @JsonProperty(value="channel_type")
    @Nullable
    private String channelType;
    @JsonProperty(value="message")
    @Nullable
    private Message message;
    @JsonProperty(value="reaction")
    @Nullable
    private Reaction reaction;
    @JsonProperty(value="channel")
    @Nullable
    private Channel channel;
    @JsonProperty(value="member")
    @Nullable
    private Channel.ChannelMember member;
    @JsonProperty(value="user")
    @Nullable
    private User user;
    @JsonProperty(value="user_id")
    @Nullable
    private String userId;
    @JsonProperty(value="me")
    @Nullable
    private User.OwnUser me;
    @JsonProperty(value="watcher_count")
    @Nullable
    private Integer watcherCount;
    @JsonProperty(value="reason")
    @Nullable
    private String reason;
    @JsonProperty(value="created_by")
    @Nullable
    private User createdBy;
    @JsonProperty(value="automoderation")
    @Nullable
    private Boolean automoderation;
    @JsonProperty(value="automoderation_scores")
    @Nullable
    private Message.Moderation automoderationScores;
    @JsonProperty(value="parent_id")
    @Nullable
    private String parentId;
    @JsonProperty(value="team")
    @Nullable
    private String team;
    @JsonProperty(value="created_at")
    @Nullable
    private Date createdAt;
    @JsonIgnore
    @NotNull
    private Map<String, Object> additionalFields = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    @JsonAnySetter
    public void setAdditionalField(String name, Object value) {
        this.additionalFields.put(name, value);
    }

    @NotNull
    public static EventSendRequestData.EventSendRequest send(@NotNull String channelType, @NotNull String channelId) {
        return new EventSendRequestData.EventSendRequest(channelType, channelId);
    }

    @NotNull
    public static EventSendUserCustomRequestData.EventSendUserCustomRequest sendUserCustom(@NotNull String userId) {
        return new EventSendUserCustomRequestData.EventSendUserCustomRequest(userId);
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getConnectionId() {
        return this.connectionId;
    }

    @Nullable
    public String getCid() {
        return this.cid;
    }

    @Nullable
    public String getChannelId() {
        return this.channelId;
    }

    @Nullable
    public String getChannelType() {
        return this.channelType;
    }

    @Nullable
    public Message getMessage() {
        return this.message;
    }

    @Nullable
    public Reaction getReaction() {
        return this.reaction;
    }

    @Nullable
    public Channel getChannel() {
        return this.channel;
    }

    @Nullable
    public Channel.ChannelMember getMember() {
        return this.member;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public User.OwnUser getMe() {
        return this.me;
    }

    @Nullable
    public Integer getWatcherCount() {
        return this.watcherCount;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Nullable
    public User getCreatedBy() {
        return this.createdBy;
    }

    @Nullable
    public Boolean getAutomoderation() {
        return this.automoderation;
    }

    @Nullable
    public Message.Moderation getAutomoderationScores() {
        return this.automoderationScores;
    }

    @Nullable
    public String getParentId() {
        return this.parentId;
    }

    @Nullable
    public String getTeam() {
        return this.team;
    }

    @Nullable
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="type")
    public void setType(@Nullable String type) {
        this.type = type;
    }

    @JsonProperty(value="connection_id")
    public void setConnectionId(@Nullable String connectionId) {
        this.connectionId = connectionId;
    }

    @JsonProperty(value="cid")
    public void setCid(@Nullable String cid) {
        this.cid = cid;
    }

    @JsonProperty(value="channel_id")
    public void setChannelId(@Nullable String channelId) {
        this.channelId = channelId;
    }

    @JsonProperty(value="channel_type")
    public void setChannelType(@Nullable String channelType) {
        this.channelType = channelType;
    }

    @JsonProperty(value="message")
    public void setMessage(@Nullable Message message) {
        this.message = message;
    }

    @JsonProperty(value="reaction")
    public void setReaction(@Nullable Reaction reaction) {
        this.reaction = reaction;
    }

    @JsonProperty(value="channel")
    public void setChannel(@Nullable Channel channel) {
        this.channel = channel;
    }

    @JsonProperty(value="member")
    public void setMember(@Nullable Channel.ChannelMember member) {
        this.member = member;
    }

    @JsonProperty(value="user")
    public void setUser(@Nullable User user) {
        this.user = user;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@Nullable String userId) {
        this.userId = userId;
    }

    @JsonProperty(value="me")
    public void setMe(@Nullable User.OwnUser me) {
        this.me = me;
    }

    @JsonProperty(value="watcher_count")
    public void setWatcherCount(@Nullable Integer watcherCount) {
        this.watcherCount = watcherCount;
    }

    @JsonProperty(value="reason")
    public void setReason(@Nullable String reason) {
        this.reason = reason;
    }

    @JsonProperty(value="created_by")
    public void setCreatedBy(@Nullable User createdBy) {
        this.createdBy = createdBy;
    }

    @JsonProperty(value="automoderation")
    public void setAutomoderation(@Nullable Boolean automoderation) {
        this.automoderation = automoderation;
    }

    @JsonProperty(value="automoderation_scores")
    public void setAutomoderationScores(@Nullable Message.Moderation automoderationScores) {
        this.automoderationScores = automoderationScores;
    }

    @JsonProperty(value="parent_id")
    public void setParentId(@Nullable String parentId) {
        this.parentId = parentId;
    }

    @JsonProperty(value="team")
    public void setTeam(@Nullable String team) {
        this.team = team;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@Nullable Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonIgnore
    public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
        if (additionalFields == null) {
            throw new NullPointerException("additionalFields is marked non-null but is null");
        }
        this.additionalFields = additionalFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$watcherCount = this.getWatcherCount();
        Integer other$watcherCount = other.getWatcherCount();
        if (this$watcherCount == null ? other$watcherCount != null : !((Object)this$watcherCount).equals(other$watcherCount)) {
            return false;
        }
        Boolean this$automoderation = this.getAutomoderation();
        Boolean other$automoderation = other.getAutomoderation();
        if (this$automoderation == null ? other$automoderation != null : !((Object)this$automoderation).equals(other$automoderation)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$connectionId = this.getConnectionId();
        String other$connectionId = other.getConnectionId();
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        String this$cid = this.getCid();
        String other$cid = other.getCid();
        if (this$cid == null ? other$cid != null : !this$cid.equals(other$cid)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$channelType = this.getChannelType();
        String other$channelType = other.getChannelType();
        if (this$channelType == null ? other$channelType != null : !this$channelType.equals(other$channelType)) {
            return false;
        }
        Message this$message = this.getMessage();
        Message other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        Reaction this$reaction = this.getReaction();
        Reaction other$reaction = other.getReaction();
        if (this$reaction == null ? other$reaction != null : !((Object)this$reaction).equals(other$reaction)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        Channel.ChannelMember this$member = this.getMember();
        Channel.ChannelMember other$member = other.getMember();
        if (this$member == null ? other$member != null : !((Object)this$member).equals(other$member)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        User.OwnUser this$me = this.getMe();
        User.OwnUser other$me = other.getMe();
        if (this$me == null ? other$me != null : !((Object)this$me).equals(other$me)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        User this$createdBy = this.getCreatedBy();
        User other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        Message.Moderation this$automoderationScores = this.getAutomoderationScores();
        Message.Moderation other$automoderationScores = other.getAutomoderationScores();
        if (this$automoderationScores == null ? other$automoderationScores != null : !((Object)this$automoderationScores).equals(other$automoderationScores)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        String this$team = this.getTeam();
        String other$team = other.getTeam();
        if (this$team == null ? other$team != null : !this$team.equals(other$team)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Map<String, Object> this$additionalFields = this.getAdditionalFields();
        Map<String, Object> other$additionalFields = other.getAdditionalFields();
        return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $watcherCount = this.getWatcherCount();
        result = result * 59 + ($watcherCount == null ? 43 : ((Object)$watcherCount).hashCode());
        Boolean $automoderation = this.getAutomoderation();
        result = result * 59 + ($automoderation == null ? 43 : ((Object)$automoderation).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $connectionId = this.getConnectionId();
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        String $cid = this.getCid();
        result = result * 59 + ($cid == null ? 43 : $cid.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $channelType = this.getChannelType();
        result = result * 59 + ($channelType == null ? 43 : $channelType.hashCode());
        Message $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        Reaction $reaction = this.getReaction();
        result = result * 59 + ($reaction == null ? 43 : ((Object)$reaction).hashCode());
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        Channel.ChannelMember $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : ((Object)$member).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        User.OwnUser $me = this.getMe();
        result = result * 59 + ($me == null ? 43 : ((Object)$me).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        User $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        Message.Moderation $automoderationScores = this.getAutomoderationScores();
        result = result * 59 + ($automoderationScores == null ? 43 : ((Object)$automoderationScores).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        String $team = this.getTeam();
        result = result * 59 + ($team == null ? 43 : $team.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Map<String, Object> $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        return result;
    }

    public String toString() {
        return "Event(type=" + this.getType() + ", connectionId=" + this.getConnectionId() + ", cid=" + this.getCid() + ", channelId=" + this.getChannelId() + ", channelType=" + this.getChannelType() + ", message=" + this.getMessage() + ", reaction=" + this.getReaction() + ", channel=" + this.getChannel() + ", member=" + this.getMember() + ", user=" + this.getUser() + ", userId=" + this.getUserId() + ", me=" + this.getMe() + ", watcherCount=" + this.getWatcherCount() + ", reason=" + this.getReason() + ", createdBy=" + this.getCreatedBy() + ", automoderation=" + this.getAutomoderation() + ", automoderationScores=" + this.getAutomoderationScores() + ", parentId=" + this.getParentId() + ", team=" + this.getTeam() + ", createdAt=" + this.getCreatedAt() + ", additionalFields=" + this.getAdditionalFields() + ")";
    }

    public static class EventSendResponse
    extends StreamResponseObject {
        @JsonProperty(value="event")
        @NotNull
        private Event event;

        @NotNull
        public Event getEvent() {
            return this.event;
        }

        @JsonProperty(value="event")
        public void setEvent(@NotNull Event event) {
            if (event == null) {
                throw new NullPointerException("event is marked non-null but is null");
            }
            this.event = event;
        }

        @Override
        public String toString() {
            return "Event.EventSendResponse(event=" + this.getEvent() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventSendResponse)) {
                return false;
            }
            EventSendResponse other = (EventSendResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Event this$event = this.getEvent();
            Event other$event = other.getEvent();
            return !(this$event == null ? other$event != null : !((Object)this$event).equals(other$event));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof EventSendResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Event $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
            return result;
        }
    }

    public static class EventSendUserCustomRequestData {
        @JsonProperty(value="event")
        @Nullable
        private EventUserCustomRequestObject event;
        @JsonProperty(value="target_user_id")
        @Nullable
        private String targetUserId;

        EventSendUserCustomRequestData(@Nullable EventUserCustomRequestObject event, @Nullable String targetUserId) {
            this.event = event;
            this.targetUserId = targetUserId;
        }

        public static class EventSendUserCustomRequest
        extends StreamRequest<StreamResponseObject> {
            private EventUserCustomRequestObject event;
            private String targetUserId;

            private EventSendUserCustomRequest(@NotNull String userId) {
                this.targetUserId = userId;
            }

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(EventService.class).sendUserCustom(this.targetUserId, this.internalBuild());
            }

            @JsonProperty(value="event")
            public EventSendUserCustomRequest event(@Nullable EventUserCustomRequestObject event) {
                this.event = event;
                return this;
            }

            @JsonProperty(value="target_user_id")
            public EventSendUserCustomRequest targetUserId(@Nullable String targetUserId) {
                this.targetUserId = targetUserId;
                return this;
            }

            public EventSendUserCustomRequestData internalBuild() {
                return new EventSendUserCustomRequestData(this.event, this.targetUserId);
            }

            public String toString() {
                return "Event.EventSendUserCustomRequestData.EventSendUserCustomRequest(event=" + this.event + ", targetUserId=" + this.targetUserId + ")";
            }
        }
    }

    public static class EventSendRequestData {
        @JsonProperty(value="event")
        @Nullable
        private EventRequestObject event;

        EventSendRequestData(@Nullable EventRequestObject event) {
            this.event = event;
        }

        public static class EventSendRequest
        extends StreamRequest<EventSendResponse> {
            private EventRequestObject event;
            @NotNull
            private String channelType;
            @NotNull
            private String channelId;

            private EventSendRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<EventSendResponse> generateCall(Client client) {
                return client.create(EventService.class).send(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="event")
            public EventSendRequest event(@Nullable EventRequestObject event) {
                this.event = event;
                return this;
            }

            public EventSendRequestData internalBuild() {
                return new EventSendRequestData(this.event);
            }

            public String toString() {
                return "Event.EventSendRequestData.EventSendRequest(event=" + this.event + ")";
            }
        }
    }

    public static class EventUserCustomRequestObject {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        EventUserCustomRequestObject(@Nullable String type, @Nullable Date createdAt, @Nullable Map<String, Object> additionalFields) {
            this.type = type;
            this.createdAt = createdAt;
            this.additionalFields = additionalFields;
        }

        public static EventUserCustomRequestObjectBuilder builder() {
            return new EventUserCustomRequestObjectBuilder();
        }

        public static class EventUserCustomRequestObjectBuilder {
            private String type;
            private Date createdAt;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            EventUserCustomRequestObjectBuilder() {
            }

            @JsonProperty(value="type")
            public EventUserCustomRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="created_at")
            public EventUserCustomRequestObjectBuilder createdAt(@Nullable Date createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            public EventUserCustomRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public EventUserCustomRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public EventUserCustomRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public EventUserCustomRequestObject build() {
                Map<String, Object> additionalFields;
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new EventUserCustomRequestObject(this.type, this.createdAt, additionalFields);
            }

            public String toString() {
                return "Event.EventUserCustomRequestObject.EventUserCustomRequestObjectBuilder(type=" + this.type + ", createdAt=" + this.createdAt + ", additionalFields$key=" + this.additionalFields$key + ", additionalFields$value=" + this.additionalFields$value + ")";
            }
        }
    }

    public static class EventRequestObject {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="connection_id")
        @Nullable
        private String connectionId;
        @JsonProperty(value="cid")
        @Nullable
        private String cid;
        @JsonProperty(value="channel_id")
        @Nullable
        private String channelId;
        @JsonProperty(value="channel_type")
        @Nullable
        private String channelType;
        @JsonProperty(value="message")
        @Nullable
        private Message.MessageRequestObject message;
        @JsonProperty(value="reaction")
        @Nullable
        private Reaction.ReactionRequestObject reaction;
        @JsonProperty(value="channel")
        @Nullable
        private Channel.ChannelRequestObject channel;
        @JsonProperty(value="member")
        @Nullable
        private Channel.ChannelMemberRequestObject member;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="me")
        @Nullable
        private User.OwnUserRequestObject me;
        @JsonProperty(value="watcher_count")
        @Nullable
        private Integer watcherCount;
        @JsonProperty(value="reason")
        @Nullable
        private String reason;
        @JsonProperty(value="created_by")
        @Nullable
        private User createdBy;
        @JsonProperty(value="automoderation")
        @Nullable
        private Boolean automoderation;
        @JsonProperty(value="automoderation_scores")
        @Nullable
        private Message.ModerationRequestObject automoderationScores;
        @JsonProperty(value="parent_id")
        @Nullable
        private String parentId;
        @JsonProperty(value="team")
        @Nullable
        private String team;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static EventRequestObject buildFrom(@Nullable Event event) {
            return RequestObjectBuilder.build(EventRequestObject.class, event);
        }

        EventRequestObject(@Nullable String type, @Nullable String connectionId, @Nullable String cid, @Nullable String channelId, @Nullable String channelType, @Nullable Message.MessageRequestObject message, @Nullable Reaction.ReactionRequestObject reaction, @Nullable Channel.ChannelRequestObject channel, @Nullable Channel.ChannelMemberRequestObject member, @Nullable User.UserRequestObject user, @Nullable String userId, @Nullable User.OwnUserRequestObject me, @Nullable Integer watcherCount, @Nullable String reason, @Nullable User createdBy, @Nullable Boolean automoderation, @Nullable Message.ModerationRequestObject automoderationScores, @Nullable String parentId, @Nullable String team, @Nullable Date createdAt, @Nullable Map<String, Object> additionalFields) {
            this.type = type;
            this.connectionId = connectionId;
            this.cid = cid;
            this.channelId = channelId;
            this.channelType = channelType;
            this.message = message;
            this.reaction = reaction;
            this.channel = channel;
            this.member = member;
            this.user = user;
            this.userId = userId;
            this.me = me;
            this.watcherCount = watcherCount;
            this.reason = reason;
            this.createdBy = createdBy;
            this.automoderation = automoderation;
            this.automoderationScores = automoderationScores;
            this.parentId = parentId;
            this.team = team;
            this.createdAt = createdAt;
            this.additionalFields = additionalFields;
        }

        public static EventRequestObjectBuilder builder() {
            return new EventRequestObjectBuilder();
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="connection_id")
        public void setConnectionId(@Nullable String connectionId) {
            this.connectionId = connectionId;
        }

        @JsonProperty(value="cid")
        public void setCid(@Nullable String cid) {
            this.cid = cid;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(@Nullable String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="channel_type")
        public void setChannelType(@Nullable String channelType) {
            this.channelType = channelType;
        }

        @JsonProperty(value="message")
        public void setMessage(@Nullable Message.MessageRequestObject message) {
            this.message = message;
        }

        @JsonProperty(value="reaction")
        public void setReaction(@Nullable Reaction.ReactionRequestObject reaction) {
            this.reaction = reaction;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel.ChannelRequestObject channel) {
            this.channel = channel;
        }

        @JsonProperty(value="member")
        public void setMember(@Nullable Channel.ChannelMemberRequestObject member) {
            this.member = member;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User.UserRequestObject user) {
            this.user = user;
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="me")
        public void setMe(@Nullable User.OwnUserRequestObject me) {
            this.me = me;
        }

        @JsonProperty(value="watcher_count")
        public void setWatcherCount(@Nullable Integer watcherCount) {
            this.watcherCount = watcherCount;
        }

        @JsonProperty(value="reason")
        public void setReason(@Nullable String reason) {
            this.reason = reason;
        }

        @JsonProperty(value="created_by")
        public void setCreatedBy(@Nullable User createdBy) {
            this.createdBy = createdBy;
        }

        @JsonProperty(value="automoderation")
        public void setAutomoderation(@Nullable Boolean automoderation) {
            this.automoderation = automoderation;
        }

        @JsonProperty(value="automoderation_scores")
        public void setAutomoderationScores(@Nullable Message.ModerationRequestObject automoderationScores) {
            this.automoderationScores = automoderationScores;
        }

        @JsonProperty(value="parent_id")
        public void setParentId(@Nullable String parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="team")
        public void setTeam(@Nullable String team) {
            this.team = team;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        public static class EventRequestObjectBuilder {
            private String type;
            private String connectionId;
            private String cid;
            private String channelId;
            private String channelType;
            private Message.MessageRequestObject message;
            private Reaction.ReactionRequestObject reaction;
            private Channel.ChannelRequestObject channel;
            private Channel.ChannelMemberRequestObject member;
            private User.UserRequestObject user;
            private String userId;
            private User.OwnUserRequestObject me;
            private Integer watcherCount;
            private String reason;
            private User createdBy;
            private Boolean automoderation;
            private Message.ModerationRequestObject automoderationScores;
            private String parentId;
            private String team;
            private Date createdAt;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            EventRequestObjectBuilder() {
            }

            @JsonProperty(value="type")
            public EventRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="connection_id")
            public EventRequestObjectBuilder connectionId(@Nullable String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            @JsonProperty(value="cid")
            public EventRequestObjectBuilder cid(@Nullable String cid) {
                this.cid = cid;
                return this;
            }

            @JsonProperty(value="channel_id")
            public EventRequestObjectBuilder channelId(@Nullable String channelId) {
                this.channelId = channelId;
                return this;
            }

            @JsonProperty(value="channel_type")
            public EventRequestObjectBuilder channelType(@Nullable String channelType) {
                this.channelType = channelType;
                return this;
            }

            @JsonProperty(value="message")
            public EventRequestObjectBuilder message(@Nullable Message.MessageRequestObject message) {
                this.message = message;
                return this;
            }

            @JsonProperty(value="reaction")
            public EventRequestObjectBuilder reaction(@Nullable Reaction.ReactionRequestObject reaction) {
                this.reaction = reaction;
                return this;
            }

            @JsonProperty(value="channel")
            public EventRequestObjectBuilder channel(@Nullable Channel.ChannelRequestObject channel) {
                this.channel = channel;
                return this;
            }

            @JsonProperty(value="member")
            public EventRequestObjectBuilder member(@Nullable Channel.ChannelMemberRequestObject member) {
                this.member = member;
                return this;
            }

            @JsonProperty(value="user")
            public EventRequestObjectBuilder user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="user_id")
            public EventRequestObjectBuilder userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="me")
            public EventRequestObjectBuilder me(@Nullable User.OwnUserRequestObject me) {
                this.me = me;
                return this;
            }

            @JsonProperty(value="watcher_count")
            public EventRequestObjectBuilder watcherCount(@Nullable Integer watcherCount) {
                this.watcherCount = watcherCount;
                return this;
            }

            @JsonProperty(value="reason")
            public EventRequestObjectBuilder reason(@Nullable String reason) {
                this.reason = reason;
                return this;
            }

            @JsonProperty(value="created_by")
            public EventRequestObjectBuilder createdBy(@Nullable User createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            @JsonProperty(value="automoderation")
            public EventRequestObjectBuilder automoderation(@Nullable Boolean automoderation) {
                this.automoderation = automoderation;
                return this;
            }

            @JsonProperty(value="automoderation_scores")
            public EventRequestObjectBuilder automoderationScores(@Nullable Message.ModerationRequestObject automoderationScores) {
                this.automoderationScores = automoderationScores;
                return this;
            }

            @JsonProperty(value="parent_id")
            public EventRequestObjectBuilder parentId(@Nullable String parentId) {
                this.parentId = parentId;
                return this;
            }

            @JsonProperty(value="team")
            public EventRequestObjectBuilder team(@Nullable String team) {
                this.team = team;
                return this;
            }

            @JsonProperty(value="created_at")
            public EventRequestObjectBuilder createdAt(@Nullable Date createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            public EventRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public EventRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public EventRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public EventRequestObject build() {
                Map<Object, Object> additionalFields;
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new EventRequestObject(this.type, this.connectionId, this.cid, this.channelId, this.channelType, this.message, this.reaction, this.channel, this.member, this.user, this.userId, this.me, this.watcherCount, this.reason, this.createdBy, this.automoderation, this.automoderationScores, this.parentId, this.team, this.createdAt, additionalFields);
            }

            public String toString() {
                return "Event.EventRequestObject.EventRequestObjectBuilder(type=" + this.type + ", connectionId=" + this.connectionId + ", cid=" + this.cid + ", channelId=" + this.channelId + ", channelType=" + this.channelType + ", message=" + this.message + ", reaction=" + this.reaction + ", channel=" + this.channel + ", member=" + this.member + ", user=" + this.user + ", userId=" + this.userId + ", me=" + this.me + ", watcherCount=" + this.watcherCount + ", reason=" + this.reason + ", createdBy=" + this.createdBy + ", automoderation=" + this.automoderation + ", automoderationScores=" + this.automoderationScores + ", parentId=" + this.parentId + ", team=" + this.team + ", createdAt=" + this.createdAt + ", additionalFields$key=" + this.additionalFields$key + ", additionalFields$value=" + this.additionalFields$value + ")";
            }
        }
    }
}

