/*
 * Decompiled with CFR 0.152.
 */
package shadowed.retrofit2.converter.jackson;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import shadowed.com.fasterxml.jackson.databind.JavaType;
import shadowed.com.fasterxml.jackson.databind.ObjectMapper;
import shadowed.com.fasterxml.jackson.databind.ObjectReader;
import shadowed.com.fasterxml.jackson.databind.ObjectWriter;
import shadowed.okhttp3.RequestBody;
import shadowed.okhttp3.ResponseBody;
import shadowed.retrofit2.Converter;
import shadowed.retrofit2.Retrofit;
import shadowed.retrofit2.converter.jackson.JacksonRequestBodyConverter;
import shadowed.retrofit2.converter.jackson.JacksonResponseBodyConverter;

public final class JacksonConverterFactory
extends Converter.Factory {
    private final ObjectMapper mapper;

    public static JacksonConverterFactory create() {
        return JacksonConverterFactory.create(new ObjectMapper());
    }

    public static JacksonConverterFactory create(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper == null");
        }
        return new JacksonConverterFactory(mapper);
    }

    private JacksonConverterFactory(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.readerFor(javaType);
        return new JacksonResponseBodyConverter(reader);
    }

    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectWriter writer = this.mapper.writerFor(javaType);
        return new JacksonRequestBodyConverter(writer);
    }
}

