/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.jackson.io;

import java.io.OutputStream;
import shadowed.com.fasterxml.jackson.core.JsonGenerator;
import shadowed.com.fasterxml.jackson.core.JsonParser;
import shadowed.com.fasterxml.jackson.databind.DeserializationFeature;
import shadowed.com.fasterxml.jackson.databind.Module;
import shadowed.com.fasterxml.jackson.databind.ObjectMapper;
import shadowed.com.fasterxml.jackson.databind.ObjectWriter;
import shadowed.com.fasterxml.jackson.databind.module.SimpleModule;
import shadowed.io.jsonwebtoken.io.AbstractSerializer;
import shadowed.io.jsonwebtoken.jackson.io.JacksonSupplierSerializer;
import shadowed.io.jsonwebtoken.lang.Assert;

public class JacksonSerializer<T>
extends AbstractSerializer<T> {
    static final String MODULE_ID = "jjwt-jackson";
    static final Module MODULE;
    static final ObjectMapper DEFAULT_OBJECT_MAPPER;
    protected final ObjectMapper objectMapper;

    static ObjectMapper newObjectMapper() {
        return new ObjectMapper().registerModule(MODULE).configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JacksonSerializer() {
        this(DEFAULT_OBJECT_MAPPER);
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        Assert.notNull(objectMapper, "ObjectMapper cannot be null.");
        this.objectMapper = objectMapper.registerModule(MODULE);
    }

    @Override
    protected void doSerialize(T t, OutputStream out) throws Exception {
        Assert.notNull(out, "OutputStream cannot be null.");
        ObjectWriter writer = this.objectMapper.writer().without(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        writer.writeValue(out, t);
    }

    static {
        SimpleModule module = new SimpleModule(MODULE_ID);
        module.addSerializer(JacksonSupplierSerializer.INSTANCE);
        MODULE = module;
        DEFAULT_OBJECT_MAPPER = JacksonSerializer.newObjectMapper();
    }
}

