/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.io;

import java.util.Arrays;
import shadowed.io.jsonwebtoken.io.DecodingException;

final class Base64 {
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] BASE64URL_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
    private static final int[] BASE64_IALPHABET = new int[256];
    private static final int[] BASE64URL_IALPHABET = new int[256];
    private static final int IALPHABET_MAX_INDEX = BASE64_IALPHABET.length - 1;
    static final Base64 DEFAULT;
    static final Base64 URL_SAFE;
    private final boolean urlsafe;
    private final char[] ALPHABET;
    private final int[] IALPHABET;

    private Base64(boolean urlsafe) {
        this.urlsafe = urlsafe;
        this.ALPHABET = urlsafe ? BASE64URL_ALPHABET : BASE64_ALPHABET;
        this.IALPHABET = urlsafe ? BASE64URL_IALPHABET : BASE64_IALPHABET;
    }

    private String getName() {
        return this.urlsafe ? "base64url" : "base64";
    }

    private char[] encodeToChar(byte[] sArr, boolean lineSep) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int left = sLen - eLen;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (lineSep ? (cCnt - 1) / 76 << 1 : 0);
        int padCount = 0;
        if (left == 2) {
            padCount = 1;
        } else if (left == 1) {
            padCount = 2;
        }
        char[] dArr = new char[this.urlsafe ? dLen - padCount : dLen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = this.ALPHABET[i >>> 18 & 0x3F];
            dArr[d++] = this.ALPHABET[i >>> 12 & 0x3F];
            dArr[d++] = this.ALPHABET[i >>> 6 & 0x3F];
            dArr[d++] = this.ALPHABET[i & 0x3F];
            if (!lineSep || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            dArr[dLen - 4] = this.ALPHABET[i >> 12];
            dArr[dLen - 3] = this.ALPHABET[i >>> 6 & 0x3F];
            if (left == 2) {
                dArr[dLen - 2] = this.ALPHABET[i & 0x3F];
            } else if (!this.urlsafe) {
                dArr[dLen - 2] = 61;
            }
            if (!this.urlsafe) {
                dArr[dLen - 1] = 61;
            }
        }
        return dArr;
    }

    private int ctoi(char c) {
        int i;
        int n = i = c > IALPHABET_MAX_INDEX ? -1 : this.IALPHABET[c];
        if (i < 0) {
            String msg = "Illegal " + this.getName() + " character: '" + c + "'";
            throw new DecodingException(msg);
        }
        return i;
    }

    byte[] decodeFast(CharSequence seq) throws DecodingException {
        int sIx;
        int sLen;
        int n = sLen = seq != null ? seq.length() : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && this.IALPHABET[seq.charAt(sIx)] < 0; ++sIx) {
        }
        while (eIx > 0 && this.IALPHABET[seq.charAt(eIx)] < 0) {
            --eIx;
        }
        int pad = seq.charAt(eIx) == '=' ? (seq.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (seq.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = this.ctoi(seq.charAt(sIx++)) << 18 | this.ctoi(seq.charAt(sIx++)) << 12 | this.ctoi(seq.charAt(sIx++)) << 6 | this.ctoi(seq.charAt(sIx++));
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= this.ctoi(seq.charAt(sIx++)) << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    String encodeToString(byte[] sArr, boolean lineSep) {
        return new String(this.encodeToChar(sArr, lineSep));
    }

    static {
        Arrays.fill(BASE64_IALPHABET, -1);
        System.arraycopy(BASE64_IALPHABET, 0, BASE64URL_IALPHABET, 0, BASE64_IALPHABET.length);
        int iS = BASE64_ALPHABET.length;
        for (int i = 0; i < iS; ++i) {
            Base64.BASE64_IALPHABET[Base64.BASE64_ALPHABET[i]] = i;
            Base64.BASE64URL_IALPHABET[Base64.BASE64URL_ALPHABET[i]] = i;
        }
        Base64.BASE64_IALPHABET[61] = 0;
        Base64.BASE64URL_IALPHABET[61] = 0;
        DEFAULT = new Base64(false);
        URL_SAFE = new Base64(true);
    }
}

