/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.security.Key;
import shadowed.io.jsonwebtoken.impl.lang.IdRegistry;
import shadowed.io.jsonwebtoken.impl.security.AbstractCurve;
import shadowed.io.jsonwebtoken.impl.security.ECCurve;
import shadowed.io.jsonwebtoken.impl.security.EdwardsCurve;
import shadowed.io.jsonwebtoken.lang.Collections;
import shadowed.io.jsonwebtoken.security.Curve;

public final class StandardCurves
extends IdRegistry<Curve> {
    public StandardCurves() {
        super("Elliptic Curve", Collections.of(ECCurve.P256, ECCurve.P384, ECCurve.P521, EdwardsCurve.X25519, EdwardsCurve.X448, EdwardsCurve.Ed25519, EdwardsCurve.Ed448));
    }

    public static Curve findByKey(Key key) {
        if (key == null) {
            return null;
        }
        AbstractCurve curve = ECCurve.findByKey(key);
        if (curve == null) {
            curve = EdwardsCurve.findByKey(key);
        }
        return curve;
    }
}

