/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import javax.crypto.SecretKey;
import shadowed.io.jsonwebtoken.impl.security.AbstractSecurityBuilder;
import shadowed.io.jsonwebtoken.impl.security.JcaTemplate;
import shadowed.io.jsonwebtoken.impl.security.Randoms;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.security.SecretKeyBuilder;

public class DefaultSecretKeyBuilder
extends AbstractSecurityBuilder<SecretKey, SecretKeyBuilder>
implements SecretKeyBuilder {
    protected final String JCA_NAME;
    protected final int BIT_LENGTH;

    public DefaultSecretKeyBuilder(String jcaName, int bitLength) {
        this.JCA_NAME = Assert.hasText(jcaName, "jcaName cannot be null or empty.");
        if (bitLength % 8 != 0) {
            String msg = "bitLength must be an even multiple of 8";
            throw new IllegalArgumentException(msg);
        }
        this.BIT_LENGTH = Assert.gt(bitLength, 0, "bitLength must be > 0");
        this.random(Randoms.secureRandom());
    }

    @Override
    public SecretKey build() {
        JcaTemplate template = new JcaTemplate(this.JCA_NAME, this.provider, this.random);
        return template.generateSecretKey(this.BIT_LENGTH);
    }
}

