/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.security.PublicKey;
import java.util.List;
import java.util.Set;
import shadowed.io.jsonwebtoken.impl.lang.Parameter;
import shadowed.io.jsonwebtoken.impl.lang.ParameterReadable;
import shadowed.io.jsonwebtoken.impl.lang.Parameters;
import shadowed.io.jsonwebtoken.impl.security.AbstractAsymmetricJwk;
import shadowed.io.jsonwebtoken.impl.security.AbstractPublicJwk;
import shadowed.io.jsonwebtoken.impl.security.DefaultEcPublicJwk;
import shadowed.io.jsonwebtoken.impl.security.JwkContext;
import shadowed.io.jsonwebtoken.lang.Collections;
import shadowed.io.jsonwebtoken.security.OctetPublicJwk;
import shadowed.io.jsonwebtoken.security.PublicJwk;

public class DefaultOctetPublicJwk<T extends PublicKey>
extends AbstractPublicJwk<T>
implements OctetPublicJwk<T> {
    static final String TYPE_VALUE = "OKP";
    static final Parameter<String> CRV = DefaultEcPublicJwk.CRV;
    static final Parameter<byte[]> X = (Parameter)Parameters.bytes("x", "The public key").build();
    static final Set<Parameter<?>> PARAMS = Collections.concat(AbstractAsymmetricJwk.PARAMS, CRV, X);
    static final List<Parameter<?>> THUMBPRINT_PARAMS = Collections.of(CRV, KTY, X);

    DefaultOctetPublicJwk(JwkContext<T> ctx) {
        super(ctx, THUMBPRINT_PARAMS);
    }

    static boolean equalsPublic(ParameterReadable self, Object candidate) {
        return Parameters.equals(self, candidate, CRV) && Parameters.equals(self, candidate, X);
    }

    @Override
    protected boolean equals(PublicJwk<?> jwk) {
        return jwk instanceof OctetPublicJwk && DefaultOctetPublicJwk.equalsPublic(this, jwk);
    }
}

