/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.security.Provider;
import java.security.SecureRandom;
import shadowed.io.jsonwebtoken.JweHeader;
import shadowed.io.jsonwebtoken.impl.security.DefaultRequest;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.security.AeadAlgorithm;
import shadowed.io.jsonwebtoken.security.KeyRequest;

public class DefaultKeyRequest<T>
extends DefaultRequest<T>
implements KeyRequest<T> {
    private final JweHeader header;
    private final AeadAlgorithm encryptionAlgorithm;

    public DefaultKeyRequest(T payload, Provider provider, SecureRandom secureRandom, JweHeader header, AeadAlgorithm encryptionAlgorithm) {
        super(payload, provider, secureRandom);
        this.header = Assert.notNull(header, "JweHeader/Builder cannot be null.");
        this.encryptionAlgorithm = Assert.notNull(encryptionAlgorithm, "AeadAlgorithm argument cannot be null.");
    }

    @Override
    public JweHeader getHeader() {
        return this.header;
    }

    @Override
    public AeadAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }
}

