/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shadowed.io.jsonwebtoken.impl.ParameterMap;
import shadowed.io.jsonwebtoken.impl.lang.Converter;
import shadowed.io.jsonwebtoken.impl.lang.Parameter;
import shadowed.io.jsonwebtoken.impl.lang.Parameters;
import shadowed.io.jsonwebtoken.impl.security.JwkConverter;
import shadowed.io.jsonwebtoken.lang.Collections;
import shadowed.io.jsonwebtoken.security.Jwk;
import shadowed.io.jsonwebtoken.security.JwkSet;

public class DefaultJwkSet
extends ParameterMap
implements JwkSet {
    private static final String NAME = "JWK Set";
    static final Parameter<Set<Jwk<?>>> KEYS = DefaultJwkSet.param(JwkConverter.ANY);

    static Parameter<Set<Jwk<?>>> param(Converter<Jwk<?>, ?> converter) {
        return (Parameter)Parameters.builder(JwkConverter.JWK_CLASS).setConverter(converter).set().setId("keys").setName("JSON Web Keys").setSecret(true).build();
    }

    public DefaultJwkSet(Parameter<Set<Jwk<?>>> param, Map<String, ?> src) {
        super(Parameters.registry(param), src);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Set<Jwk<?>> getKeys() {
        Set<Jwk<?>> jwks = this.get(KEYS);
        if (Collections.isEmpty(jwks)) {
            return Collections.emptySet();
        }
        return Collections.immutable(jwks);
    }

    @Override
    public Iterator<Jwk<?>> iterator() {
        return this.getKeys().iterator();
    }
}

