/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import shadowed.io.jsonwebtoken.impl.AbstractX509Context;
import shadowed.io.jsonwebtoken.impl.lang.Parameter;
import shadowed.io.jsonwebtoken.impl.lang.Parameters;
import shadowed.io.jsonwebtoken.impl.security.AbstractAsymmetricJwk;
import shadowed.io.jsonwebtoken.impl.security.AbstractJwk;
import shadowed.io.jsonwebtoken.impl.security.DefaultEcPrivateJwk;
import shadowed.io.jsonwebtoken.impl.security.DefaultEcPublicJwk;
import shadowed.io.jsonwebtoken.impl.security.DefaultOctetPrivateJwk;
import shadowed.io.jsonwebtoken.impl.security.DefaultRsaPrivateJwk;
import shadowed.io.jsonwebtoken.impl.security.DefaultSecretJwk;
import shadowed.io.jsonwebtoken.impl.security.JwkContext;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.lang.Collections;
import shadowed.io.jsonwebtoken.lang.Registry;
import shadowed.io.jsonwebtoken.lang.Strings;
import shadowed.io.jsonwebtoken.security.HashAlgorithm;
import shadowed.io.jsonwebtoken.security.Jwks;
import shadowed.io.jsonwebtoken.security.KeyOperation;

public class DefaultJwkContext<K extends Key>
extends AbstractX509Context<JwkContext<K>>
implements JwkContext<K> {
    private static final Set<Parameter<?>> DEFAULT_PARAMS;
    private K key;
    private PublicKey publicKey;
    private Provider provider;
    private SecureRandom random;
    private HashAlgorithm idThumbprintAlgorithm;

    public DefaultJwkContext() {
        this(DEFAULT_PARAMS);
    }

    public DefaultJwkContext(Set<Parameter<?>> params) {
        super(params);
    }

    public DefaultJwkContext(Set<Parameter<?>> params, JwkContext<?> other) {
        this(params, other, true);
    }

    public DefaultJwkContext(Set<Parameter<?>> params, JwkContext<?> other, K key) {
        this(params, other, key == null || key instanceof PublicKey);
        this.key = (Key)Assert.notNull(key, "Key cannot be null.");
    }

    public DefaultJwkContext(Set<Parameter<?>> params, JwkContext<?> other, boolean removePrivate) {
        super(Assert.notEmpty(params, "Parameters cannot be null or empty."));
        Assert.notNull(other, "JwkContext cannot be null.");
        Assert.isInstanceOf(DefaultJwkContext.class, other, "JwkContext must be a DefaultJwkContext instance.");
        DefaultJwkContext src = (DefaultJwkContext)other;
        this.provider = other.getProvider();
        this.random = other.getRandom();
        this.idThumbprintAlgorithm = other.getIdThumbprintAlgorithm();
        this.values.putAll(src.values);
        for (Map.Entry entry : src.idiomaticValues.entrySet()) {
            String id = (String)entry.getKey();
            Object value = entry.getValue();
            Parameter param = (Parameter)this.PARAMS.get(id);
            if (param != null && !param.supports(value)) {
                value = this.values.get(param.getId());
                this.put(param, value);
                continue;
            }
            this.idiomaticValues.put(id, value);
        }
        if (removePrivate) {
            for (Parameter param : src.PARAMS.values()) {
                if (!param.isSecret()) continue;
                this.remove(param.getId());
            }
        }
    }

    @Override
    public JwkContext<K> parameter(Parameter<?> param) {
        Registry<String, Parameter<?>> registry = Parameters.replace(this.PARAMS, param);
        LinkedHashSet params = new LinkedHashSet(registry.values());
        return this.key != null ? new DefaultJwkContext<K>(params, this, this.key) : new DefaultJwkContext<K>((Set<Parameter<?>>)params, (JwkContext<?>)this, false);
    }

    @Override
    public String getName() {
        String value = this.get(AbstractJwk.KTY);
        if ("oct".equals(value)) {
            value = "Secret";
        } else if ("OKP".equals(value)) {
            value = "Octet";
        }
        StringBuilder sb = value != null ? new StringBuilder(value) : new StringBuilder();
        K key = this.getKey();
        if (key instanceof PublicKey) {
            Strings.nespace(sb).append("Public");
        } else if (key instanceof PrivateKey) {
            Strings.nespace(sb).append("Private");
        }
        Strings.nespace(sb).append("JWK");
        return sb.toString();
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        Assert.notEmpty(m, "JWK values cannot be null or empty.");
        super.putAll(m);
    }

    @Override
    public String getAlgorithm() {
        return this.get(AbstractJwk.ALG);
    }

    @Override
    public JwkContext<K> setAlgorithm(String algorithm) {
        this.put(AbstractJwk.ALG, (Object)algorithm);
        return this;
    }

    @Override
    public String getId() {
        return this.get(AbstractJwk.KID);
    }

    @Override
    public JwkContext<K> setId(String id) {
        this.put(AbstractJwk.KID, (Object)id);
        return this;
    }

    @Override
    public JwkContext<K> setIdThumbprintAlgorithm(HashAlgorithm alg) {
        this.idThumbprintAlgorithm = alg;
        return this;
    }

    @Override
    public HashAlgorithm getIdThumbprintAlgorithm() {
        return this.idThumbprintAlgorithm;
    }

    @Override
    public Set<KeyOperation> getOperations() {
        return this.get(AbstractJwk.KEY_OPS);
    }

    @Override
    public JwkContext<K> setOperations(Collection<? extends KeyOperation> ops) {
        this.put(AbstractJwk.KEY_OPS, (Object)ops);
        return this;
    }

    @Override
    public String getType() {
        return this.get(AbstractJwk.KTY);
    }

    @Override
    public JwkContext<K> setType(String type) {
        this.put(AbstractJwk.KTY, (Object)type);
        return this;
    }

    @Override
    public String getPublicKeyUse() {
        return this.get(AbstractAsymmetricJwk.USE);
    }

    @Override
    public JwkContext<K> setPublicKeyUse(String use) {
        this.put(AbstractAsymmetricJwk.USE, (Object)use);
        return this;
    }

    @Override
    public boolean isSigUse() {
        if ("sig".equals(this.getPublicKeyUse())) {
            return true;
        }
        Set<KeyOperation> ops = this.getOperations();
        if (Collections.isEmpty(ops)) {
            return false;
        }
        return ops.contains(Jwks.OP.SIGN) || ops.contains(Jwks.OP.VERIFY);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public JwkContext<K> setKey(K key) {
        this.key = key;
        return this;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public JwkContext<K> setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public JwkContext<K> setProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public SecureRandom getRandom() {
        return this.random;
    }

    @Override
    public JwkContext<K> setRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    static {
        LinkedHashSet<Parameter<Object>> set = new LinkedHashSet<Parameter<Object>>();
        set.addAll(DefaultSecretJwk.PARAMS);
        set.addAll(DefaultEcPrivateJwk.PARAMS);
        set.addAll(DefaultRsaPrivateJwk.PARAMS);
        set.addAll(DefaultOctetPrivateJwk.PARAMS);
        set.remove(DefaultEcPublicJwk.X);
        set.remove(DefaultEcPrivateJwk.D);
        set.add(Parameters.string(DefaultEcPublicJwk.X.getId(), "Elliptic Curve public key X coordinate"));
        set.add((Parameter<Object>)Parameters.builder(String.class).setSecret(true).setId(DefaultEcPrivateJwk.D.getId()).setName("Elliptic Curve private key").build());
        DEFAULT_PARAMS = Collections.immutable(set);
    }
}

