/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Locale;
import shadowed.io.jsonwebtoken.impl.lang.CheckedFunction;
import shadowed.io.jsonwebtoken.impl.security.CryptoAlgorithm;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.security.HashAlgorithm;
import shadowed.io.jsonwebtoken.security.Request;
import shadowed.io.jsonwebtoken.security.VerifyDigestRequest;

public final class DefaultHashAlgorithm
extends CryptoAlgorithm
implements HashAlgorithm {
    public static final HashAlgorithm SHA1 = new DefaultHashAlgorithm("sha-1");

    DefaultHashAlgorithm(String id) {
        super(id, id.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public byte[] digest(Request<InputStream> request) {
        Assert.notNull(request, "Request cannot be null.");
        final InputStream payload = (InputStream)Assert.notNull(request.getPayload(), "Request payload cannot be null.");
        return this.jca(request).withMessageDigest(new CheckedFunction<MessageDigest, byte[]>(){

            @Override
            public byte[] apply(MessageDigest md) throws IOException {
                byte[] buf = new byte[1024];
                int len = 0;
                while (len != -1) {
                    len = payload.read(buf);
                    if (len <= 0) continue;
                    md.update(buf, 0, len);
                }
                return md.digest();
            }
        });
    }

    @Override
    public boolean verify(VerifyDigestRequest request) {
        Assert.notNull(request, "VerifyDigestRequest cannot be null.");
        byte[] digest = Assert.notNull(request.getDigest(), "Digest cannot be null.");
        byte[] computed = this.digest(request);
        return MessageDigest.isEqual(computed, digest);
    }
}

