/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Set;
import shadowed.io.jsonwebtoken.impl.lang.Parameter;
import shadowed.io.jsonwebtoken.impl.lang.Parameters;
import shadowed.io.jsonwebtoken.impl.security.AbstractPrivateJwk;
import shadowed.io.jsonwebtoken.impl.security.DefaultEcPublicJwk;
import shadowed.io.jsonwebtoken.impl.security.FieldElementConverter;
import shadowed.io.jsonwebtoken.impl.security.JwkContext;
import shadowed.io.jsonwebtoken.lang.Collections;
import shadowed.io.jsonwebtoken.security.EcPrivateJwk;
import shadowed.io.jsonwebtoken.security.EcPublicJwk;
import shadowed.io.jsonwebtoken.security.PrivateJwk;

class DefaultEcPrivateJwk
extends AbstractPrivateJwk<ECPrivateKey, ECPublicKey, EcPublicJwk>
implements EcPrivateJwk {
    static final Parameter<BigInteger> D = (Parameter)Parameters.bigInt("d", "ECC Private Key").setConverter(FieldElementConverter.B64URL_CONVERTER).setSecret(true).build();
    static final Set<Parameter<?>> PARAMS = Collections.concat(DefaultEcPublicJwk.PARAMS, D);

    DefaultEcPrivateJwk(JwkContext<ECPrivateKey> ctx, EcPublicJwk pubJwk) {
        super(ctx, DefaultEcPublicJwk.THUMBPRINT_PARAMS, pubJwk);
    }

    @Override
    protected boolean equals(PrivateJwk<?, ?, ?> jwk) {
        return jwk instanceof EcPrivateJwk && DefaultEcPublicJwk.equalsPublic(this, jwk) && Parameters.equals(this, jwk, D);
    }
}

