/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.io.OutputStream;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.security.AeadResult;
import shadowed.io.jsonwebtoken.security.DigestSupplier;
import shadowed.io.jsonwebtoken.security.IvSupplier;

public class DefaultAeadResult
implements AeadResult,
DigestSupplier,
IvSupplier {
    private final OutputStream out;
    private byte[] tag;
    private byte[] iv;

    public DefaultAeadResult(OutputStream out) {
        this.out = Assert.notNull(out, "OutputStream cannot be null.");
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public byte[] getDigest() {
        return this.tag;
    }

    @Override
    public AeadResult setTag(byte[] tag) {
        this.tag = Assert.notEmpty(tag, "Authentication Tag cannot be null or empty.");
        return this;
    }

    @Override
    public AeadResult setIv(byte[] iv) {
        this.iv = Assert.notEmpty(iv, "Initialization Vector cannot be null or empty.");
        return this;
    }

    @Override
    public byte[] getIv() {
        return this.iv;
    }
}

