/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.security;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import shadowed.io.jsonwebtoken.impl.lang.Bytes;
import shadowed.io.jsonwebtoken.impl.lang.CheckedFunction;
import shadowed.io.jsonwebtoken.impl.security.CryptoAlgorithm;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.security.SecurityException;
import shadowed.io.jsonwebtoken.security.UnsupportedKeyException;

final class ConcatKDF
extends CryptoAlgorithm {
    private static final long MAX_REP_COUNT = 0xFFFFFFFFL;
    private static final long MAX_HASH_INPUT_BYTE_LENGTH = Integer.MAX_VALUE;
    private static final long MAX_HASH_INPUT_BIT_LENGTH = 0x3FFFFFFF8L;
    private final int hashBitLength;
    private static final long MAX_DERIVED_KEY_BIT_LENGTH = 0x3FFFFFFF8L;

    ConcatKDF(String jcaName) {
        super("ConcatKDF", jcaName);
        int hashByteLength = this.jca().withMessageDigest(new CheckedFunction<MessageDigest, Integer>(){

            @Override
            public Integer apply(MessageDigest instance) {
                return instance.getDigestLength();
            }
        });
        this.hashBitLength = hashByteLength * 8;
        Assert.state(this.hashBitLength > 0, "MessageDigest length must be a positive value.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretKey deriveKey(final byte[] Z, final long derivedKeyBitLength, byte[] otherInfo) throws UnsupportedKeyException, SecurityException {
        Assert.notEmpty(Z, "Z cannot be null or empty.");
        Assert.isTrue(derivedKeyBitLength > 0L, "derivedKeyBitLength must be a positive integer.");
        if (derivedKeyBitLength > 0x3FFFFFFF8L) {
            String msg = "derivedKeyBitLength may not exceed " + Bytes.bitsMsg(0x3FFFFFFF8L) + ". Specified size: " + Bytes.bitsMsg(derivedKeyBitLength) + ".";
            throw new IllegalArgumentException(msg);
        }
        long derivedKeyByteLength = derivedKeyBitLength / 8L;
        final byte[] OtherInfo = otherInfo == null ? Bytes.EMPTY : otherInfo;
        double repsd = (double)derivedKeyBitLength / (double)this.hashBitLength;
        final long reps = (long)Math.ceil(repsd);
        final boolean kLastPartial = repsd != (double)reps;
        Assert.state(reps <= 0xFFFFFFFFL, "derivedKeyBitLength is too large.");
        final byte[] counter = new byte[]{0, 0, 0, 1};
        long inputBitLength = Bytes.bitLength(counter) + Bytes.bitLength(Z) + Bytes.bitLength(OtherInfo);
        Assert.state(inputBitLength <= 0x3FFFFFFF8L, "Hash input is too large.");
        final ClearableByteArrayOutputStream stream = new ClearableByteArrayOutputStream((int)derivedKeyByteLength);
        byte[] derivedKeyBytes = Bytes.EMPTY;
        try {
            derivedKeyBytes = this.jca().withMessageDigest(new CheckedFunction<MessageDigest, byte[]>(){

                @Override
                public byte[] apply(MessageDigest md) throws Exception {
                    for (long i = 1L; i <= reps; ++i) {
                        md.update(counter);
                        md.update(Z);
                        md.update(OtherInfo);
                        byte[] Ki = md.digest();
                        Bytes.increment(counter);
                        if (i == reps && kLastPartial) {
                            long leftmostBitLength = derivedKeyBitLength % (long)ConcatKDF.this.hashBitLength;
                            int leftmostByteLength = (int)(leftmostBitLength / 8L);
                            byte[] kLast = new byte[leftmostByteLength];
                            System.arraycopy(Ki, 0, kLast, 0, kLast.length);
                            Ki = kLast;
                        }
                        stream.write(Ki);
                    }
                    return stream.toByteArray();
                }
            });
            SecretKeySpec secretKeySpec = new SecretKeySpec(derivedKeyBytes, "AES");
            return secretKeySpec;
        }
        finally {
            Bytes.clear(derivedKeyBytes);
            Bytes.clear(counter);
            stream.reset();
        }
    }

    private static class ClearableByteArrayOutputStream
    extends ByteArrayOutputStream {
        public ClearableByteArrayOutputStream(int size) {
            super(size);
        }

        @Override
        public synchronized void reset() {
            super.reset();
            Bytes.clear(this.buf);
        }
    }
}

