/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.lang;

import shadowed.io.jsonwebtoken.Header;
import shadowed.io.jsonwebtoken.JwtException;
import shadowed.io.jsonwebtoken.MalformedJwtException;
import shadowed.io.jsonwebtoken.impl.lang.Nameable;
import shadowed.io.jsonwebtoken.impl.lang.Parameter;
import shadowed.io.jsonwebtoken.impl.lang.ParameterReadable;
import shadowed.io.jsonwebtoken.impl.security.JwkContext;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.security.Jwk;
import shadowed.io.jsonwebtoken.security.MalformedKeyException;

public class RequiredParameterReader
implements ParameterReadable {
    private final ParameterReadable src;

    public RequiredParameterReader(Header header) {
        this(Assert.isInstanceOf(ParameterReadable.class, header, "Header implementations must implement ParameterReadable: "));
    }

    public RequiredParameterReader(ParameterReadable src) {
        this.src = Assert.notNull(src, "Source ParameterReadable cannot be null.");
        Assert.isInstanceOf(Nameable.class, src, "ParameterReadable implementations must implement Nameable.");
    }

    private String name() {
        return ((Nameable)((Object)this.src)).getName();
    }

    private JwtException malformed(String msg) {
        if (this.src instanceof JwkContext || this.src instanceof Jwk) {
            return new MalformedKeyException(msg);
        }
        return new MalformedJwtException(msg);
    }

    @Override
    public <T> T get(Parameter<T> param) {
        T value = this.src.get(param);
        if (value == null) {
            String msg = this.name() + " is missing required " + param + " value.";
            throw this.malformed(msg);
        }
        return value;
    }
}

