/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl.lang;

import java.math.BigInteger;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import shadowed.io.jsonwebtoken.impl.io.Codec;
import shadowed.io.jsonwebtoken.impl.lang.BigIntegerUBytesConverter;
import shadowed.io.jsonwebtoken.impl.lang.CollectionConverter;
import shadowed.io.jsonwebtoken.impl.lang.CompoundConverter;
import shadowed.io.jsonwebtoken.impl.lang.Converter;
import shadowed.io.jsonwebtoken.impl.lang.EncodedObjectConverter;
import shadowed.io.jsonwebtoken.impl.lang.RequiredTypeConverter;
import shadowed.io.jsonwebtoken.impl.lang.UriStringConverter;
import shadowed.io.jsonwebtoken.impl.security.JwtX509StringConverter;

public final class Converters {
    public static final Converter<URI, Object> URI = Converters.forEncoded(URI.class, new UriStringConverter());
    public static final Converter<byte[], Object> BASE64URL_BYTES = Converters.forEncoded(byte[].class, Codec.BASE64URL);
    public static final Converter<X509Certificate, Object> X509_CERTIFICATE = Converters.forEncoded(X509Certificate.class, JwtX509StringConverter.INSTANCE);
    public static final Converter<BigInteger, byte[]> BIGINT_UBYTES = new BigIntegerUBytesConverter();
    public static final Converter<BigInteger, Object> BIGINT = Converters.forEncoded(BigInteger.class, Converters.compound(BIGINT_UBYTES, Codec.BASE64URL));

    private Converters() {
    }

    public static <T> Converter<T, Object> forType(Class<T> clazz) {
        return new RequiredTypeConverter<T>(clazz);
    }

    public static <T> Converter<Set<T>, Object> forSet(Converter<T, Object> elementConverter) {
        return CollectionConverter.forSet(elementConverter);
    }

    public static <T> Converter<List<T>, Object> forList(Converter<T, Object> elementConverter) {
        return CollectionConverter.forList(elementConverter);
    }

    public static <T> Converter<T, Object> forEncoded(Class<T> elementType, Converter<T, CharSequence> elementConverter) {
        return new EncodedObjectConverter<T>(elementType, elementConverter);
    }

    public static <A, B, C> Converter<A, C> compound(Converter<A, B> aConv, Converter<B, C> bConv) {
        return new CompoundConverter<A, B, C>(aConv, bConv);
    }
}

