/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl;

import java.security.MessageDigest;
import shadowed.io.jsonwebtoken.ProtectedHeader;
import shadowed.io.jsonwebtoken.ProtectedJwt;
import shadowed.io.jsonwebtoken.impl.DefaultJwt;
import shadowed.io.jsonwebtoken.io.Encoders;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.lang.Objects;

abstract class DefaultProtectedJwt<H extends ProtectedHeader, P>
extends DefaultJwt<H, P>
implements ProtectedJwt<H, P> {
    protected final byte[] digest;
    private final String digestName;

    protected DefaultProtectedJwt(H header, P payload, byte[] digest, String digestName) {
        super(header, payload);
        this.digest = Assert.notEmpty(digest, "Digest byte array cannot be null or empty.");
        this.digestName = Assert.hasText(digestName, "digestName cannot be null or empty.");
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    protected StringBuilder toStringBuilder() {
        String b64Url = Encoders.BASE64URL.encode(this.digest);
        return super.toStringBuilder().append(',').append(this.digestName).append('=').append(b64Url);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultProtectedJwt) {
            DefaultProtectedJwt pjwt = (DefaultProtectedJwt)obj;
            return super.equals(pjwt) && MessageDigest.isEqual(this.digest, pjwt.digest);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.nullSafeHashCode(this.getHeader(), this.getPayload(), this.digest);
    }
}

