/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import shadowed.io.jsonwebtoken.Header;
import shadowed.io.jsonwebtoken.Jwts;
import shadowed.io.jsonwebtoken.impl.DefaultHeader;
import shadowed.io.jsonwebtoken.impl.DefaultJweHeader;
import shadowed.io.jsonwebtoken.impl.DefaultJweHeaderBuilder;
import shadowed.io.jsonwebtoken.impl.DefaultJweHeaderMutator;
import shadowed.io.jsonwebtoken.impl.DefaultJwsHeader;
import shadowed.io.jsonwebtoken.impl.DefaultProtectedHeader;
import shadowed.io.jsonwebtoken.impl.ParameterMap;
import shadowed.io.jsonwebtoken.lang.Collections;

public class DefaultJwtHeaderBuilder
extends DefaultJweHeaderBuilder<Jwts.HeaderBuilder>
implements Jwts.HeaderBuilder {
    public DefaultJwtHeaderBuilder() {
    }

    public DefaultJwtHeaderBuilder(DefaultJweHeaderMutator<?> src) {
        super(src);
    }

    private static ParameterMap sanitizeCrit(ParameterMap m, boolean protectedHeader) {
        Set<String> crit = m.get(DefaultProtectedHeader.CRIT);
        if (crit == null) {
            return m;
        }
        m = new ParameterMap(DefaultJweHeader.PARAMS, m, true);
        m.remove(DefaultProtectedHeader.CRIT.getId());
        if (!protectedHeader) {
            return m;
        }
        LinkedHashSet<String> newCrit = new LinkedHashSet<String>(crit);
        for (String val : crit) {
            if (!DefaultJweHeader.PARAMS.containsKey(val) && m.containsKey(val)) continue;
            newCrit.remove(val);
        }
        if (!Collections.isEmpty(newCrit)) {
            m.put(DefaultProtectedHeader.CRIT, (Object)newCrit);
        }
        return m;
    }

    @Override
    public Header build() {
        this.x509.apply();
        ParameterMap m = (ParameterMap)this.DELEGATE;
        if (DefaultJweHeader.isCandidate(m)) {
            return new DefaultJweHeader(DefaultJwtHeaderBuilder.sanitizeCrit(m, true));
        }
        if (DefaultProtectedHeader.isCandidate(m)) {
            return new DefaultJwsHeader(DefaultJwtHeaderBuilder.sanitizeCrit(m, true));
        }
        return new DefaultHeader(DefaultJwtHeaderBuilder.sanitizeCrit(m, false));
    }
}

