/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl;

import java.util.Map;
import shadowed.io.jsonwebtoken.JweHeader;
import shadowed.io.jsonwebtoken.Jwts;
import shadowed.io.jsonwebtoken.impl.DefaultHeader;
import shadowed.io.jsonwebtoken.impl.DefaultProtectedHeader;
import shadowed.io.jsonwebtoken.impl.ParameterMap;
import shadowed.io.jsonwebtoken.impl.lang.Converters;
import shadowed.io.jsonwebtoken.impl.lang.Parameter;
import shadowed.io.jsonwebtoken.impl.lang.Parameters;
import shadowed.io.jsonwebtoken.impl.lang.PositiveIntegerConverter;
import shadowed.io.jsonwebtoken.impl.lang.RequiredBitLengthConverter;
import shadowed.io.jsonwebtoken.impl.security.JwkConverter;
import shadowed.io.jsonwebtoken.lang.Registry;
import shadowed.io.jsonwebtoken.lang.Strings;
import shadowed.io.jsonwebtoken.security.PublicJwk;

public class DefaultJweHeader
extends DefaultProtectedHeader
implements JweHeader {
    static final Parameter<String> ENCRYPTION_ALGORITHM = Parameters.string("enc", "Encryption Algorithm");
    public static final Parameter<PublicJwk<?>> EPK = (Parameter)Parameters.builder(JwkConverter.PUBLIC_JWK_CLASS).setId("epk").setName("Ephemeral Public Key").setConverter(JwkConverter.PUBLIC_JWK).build();
    static final Parameter<byte[]> APU = (Parameter)Parameters.bytes("apu", "Agreement PartyUInfo").build();
    static final Parameter<byte[]> APV = (Parameter)Parameters.bytes("apv", "Agreement PartyVInfo").build();
    public static final Parameter<byte[]> IV = (Parameter)Parameters.bytes("iv", "Initialization Vector").setConverter(new RequiredBitLengthConverter(Converters.BASE64URL_BYTES, 96)).build();
    public static final Parameter<byte[]> TAG = (Parameter)Parameters.bytes("tag", "Authentication Tag").setConverter(new RequiredBitLengthConverter(Converters.BASE64URL_BYTES, 128)).build();
    public static final Parameter<byte[]> P2S = (Parameter)Parameters.bytes("p2s", "PBES2 Salt Input").setConverter(new RequiredBitLengthConverter(Converters.BASE64URL_BYTES, 64, false)).build();
    public static final Parameter<Integer> P2C = (Parameter)Parameters.builder(Integer.class).setConverter(PositiveIntegerConverter.INSTANCE).setId("p2c").setName("PBES2 Count").build();
    static final Registry<String, Parameter<?>> PARAMS = Parameters.registry(DefaultProtectedHeader.PARAMS, ENCRYPTION_ALGORITHM, EPK, APU, APV, IV, TAG, P2S, P2C);

    static boolean isCandidate(ParameterMap map) {
        String id = map.get(DefaultHeader.ALGORITHM);
        return Strings.hasText(id) && !id.equalsIgnoreCase(Jwts.SIG.NONE.getId()) && Strings.hasText(map.get(ENCRYPTION_ALGORITHM));
    }

    public DefaultJweHeader(Map<String, ?> map) {
        super(PARAMS, map);
    }

    @Override
    public String getName() {
        return "JWE header";
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.get(ENCRYPTION_ALGORITHM);
    }

    @Override
    public PublicJwk<?> getEphemeralPublicKey() {
        return this.get(EPK);
    }

    @Override
    public byte[] getAgreementPartyUInfo() {
        return this.get(APU);
    }

    @Override
    public byte[] getAgreementPartyVInfo() {
        return this.get(APV);
    }

    @Override
    public byte[] getInitializationVector() {
        return this.get(IV);
    }

    @Override
    public byte[] getAuthenticationTag() {
        return this.get(TAG);
    }

    @Override
    public byte[] getPbes2Salt() {
        return this.get(P2S);
    }

    @Override
    public Integer getPbes2Count() {
        return this.get(P2C);
    }
}

