/*
 * Decompiled with CFR 0.152.
 */
package shadowed.io.jsonwebtoken.impl;

import java.security.MessageDigest;
import shadowed.io.jsonwebtoken.Jwe;
import shadowed.io.jsonwebtoken.JweHeader;
import shadowed.io.jsonwebtoken.JwtVisitor;
import shadowed.io.jsonwebtoken.impl.DefaultProtectedJwt;
import shadowed.io.jsonwebtoken.io.Encoders;
import shadowed.io.jsonwebtoken.lang.Assert;
import shadowed.io.jsonwebtoken.lang.Objects;

public class DefaultJwe<P>
extends DefaultProtectedJwt<JweHeader, P>
implements Jwe<P> {
    private static final String DIGEST_NAME = "tag";
    private final byte[] iv;

    public DefaultJwe(JweHeader header, P payload, byte[] iv, byte[] aadTag) {
        super(header, payload, aadTag, DIGEST_NAME);
        this.iv = Assert.notEmpty(iv, "Initialization vector cannot be null or empty.");
    }

    @Override
    public byte[] getInitializationVector() {
        return (byte[])this.iv.clone();
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(",iv=").append(Encoders.BASE64URL.encode(this.iv));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Jwe) {
            Jwe jwe = (Jwe)obj;
            return super.equals(jwe) && MessageDigest.isEqual(this.iv, jwe.getInitializationVector());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.nullSafeHashCode(this.getHeader(), this.getPayload(), this.iv, this.digest);
    }

    @Override
    public <T> T accept(JwtVisitor<T> v) {
        return v.visit(this);
    }
}

