/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.services.framework;

import io.getstream.chat.java.services.framework.ToJson;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import shadowed.com.fasterxml.jackson.databind.ObjectMapper;
import shadowed.retrofit2.Converter;
import shadowed.retrofit2.Retrofit;

public class QueryConverterFactory
extends Converter.Factory {
    public static QueryConverterFactory create() {
        return new QueryConverterFactory();
    }

    @Override
    public Converter<?, String> stringConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (type == Date.class) {
            return value -> DateTimeFormatter.ISO_INSTANT.format(((Date)value).toInstant());
        }
        if (!this.hasToJson(annotations)) {
            return super.stringConverter(type, annotations, retrofit);
        }
        return value -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ObjectMapper().writeValue(baos, value);
            return baos.toString("UTF-8");
        };
    }

    private boolean hasToJson(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ToJson)) continue;
            return true;
        }
        return false;
    }
}

