/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.services;

import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.framework.ToJson;
import shadowed.org.jetbrains.annotations.NotNull;
import shadowed.org.jetbrains.annotations.Nullable;
import shadowed.retrofit2.Call;
import shadowed.retrofit2.http.Body;
import shadowed.retrofit2.http.DELETE;
import shadowed.retrofit2.http.GET;
import shadowed.retrofit2.http.PATCH;
import shadowed.retrofit2.http.POST;
import shadowed.retrofit2.http.Path;
import shadowed.retrofit2.http.Query;

public interface UserService {
    @POST(value="users")
    public Call<User.UserUpsertResponse> upsert(@Body @NotNull User.UserUpsertRequestData var1);

    @GET(value="users")
    public Call<User.UserListResponse> list(@ToJson @Query(value="payload") @NotNull User.UserListRequestData var1);

    @PATCH(value="users")
    public Call<User.UserPartialUpdateResponse> partialUpdate(@Body @NotNull User.UserPartialUpdateRequestData var1);

    @GET(value="query_banned_users")
    public Call<User.UserQueryBannedResponse> queryBanned(@ToJson @Query(value="payload") @NotNull User.UserQueryBannedRequestData var1);

    @POST(value="moderation/ban")
    public Call<StreamResponseObject> ban(@Body @NotNull User.UserBanRequestData var1);

    @POST(value="users/{user_id}/deactivate")
    public Call<User.UserDeactivateResponse> deactivate(@Path(value="user_id") @NotNull String var1, @Body @NotNull User.UserDeactivateRequestData var2);

    @DELETE(value="users/{user_id}")
    public Call<User.UserDeleteResponse> delete(@Path(value="user_id") @NotNull String var1, @Query(value="mark_messages_deleted") @Nullable Boolean var2, @Query(value="hard_delete") @Nullable Boolean var3, @Query(value="delete_conversation_channels") @Nullable Boolean var4);

    @POST(value="users/delete")
    public Call<User.UserDeleteManyResponse> deleteMany(@Body @NotNull User.UserDeleteManyRequestData var1);

    @POST(value="users/{user_id}/reactivate")
    public Call<User.UserReactivateResponse> reactivate(@Path(value="user_id") @NotNull String var1, @Body @NotNull User.UserReactivateRequestData var2);

    @POST(value="moderation/mute")
    public Call<User.UserMuteResponse> mute(@Body @NotNull User.UserMuteRequestData var1);

    @POST(value="moderation/unmute")
    public Call<StreamResponseObject> unmute(@Body @NotNull User.UserUnmuteRequestData var1);

    @GET(value="users/{user_id}/export")
    public Call<User.UserExportResponse> export(@Path(value="user_id") @NotNull String var1);

    @POST(value="guest")
    public Call<User.UserCreateGuestResponse> createGuest(@Body @NotNull User.UserCreateGuestRequestData var1);

    @DELETE(value="moderation/ban")
    public Call<StreamResponseObject> unban(@Query(value="target_user_id") @NotNull String var1, @Query(value="type") @Nullable String var2, @Query(value="id") @Nullable String var3, @Query(value="shadow") @Nullable Boolean var4);
}

