/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models.framework;

import java.io.IOException;
import java.util.Date;
import shadowed.com.fasterxml.jackson.core.JsonParser;
import shadowed.com.fasterxml.jackson.core.JsonProcessingException;
import shadowed.com.fasterxml.jackson.databind.DeserializationContext;
import shadowed.com.fasterxml.jackson.databind.JsonDeserializer;

public class UnixTimestampDeserializer
extends JsonDeserializer<Date> {
    @Override
    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String jsonString = jsonParser.readValueAs(String.class);
        try {
            return new Date(Long.parseLong(jsonString) * 1000L);
        }
        catch (NumberFormatException e) {
            throw deserializationContext.instantiationException(Date.class, "Unparseable date for unix timestamp: " + jsonString);
        }
    }
}

