/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.Channel;
import io.getstream.chat.java.models.Flag;
import io.getstream.chat.java.models.Language;
import io.getstream.chat.java.models.Reaction;
import io.getstream.chat.java.models.Sort;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.DefaultFileHandler;
import io.getstream.chat.java.models.framework.FileHandler;
import io.getstream.chat.java.models.framework.RequestObjectBuilder;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponse;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.MessageService;
import io.getstream.chat.java.services.framework.Client;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import shadowed.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadowed.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadowed.com.fasterxml.jackson.annotation.JsonIgnore;
import shadowed.com.fasterxml.jackson.annotation.JsonProperty;
import shadowed.org.jetbrains.annotations.NotNull;
import shadowed.org.jetbrains.annotations.Nullable;
import shadowed.retrofit2.Call;

public class Message {
    public static Class<? extends FileHandler> fileHandlerClass = DefaultFileHandler.class;
    @JsonProperty(value="id")
    @NotNull
    private String id;
    @JsonProperty(value="text")
    @Nullable
    private String text;
    @JsonProperty(value="mml")
    @Nullable
    private String mml;
    @JsonProperty(value="command")
    @Nullable
    private String command;
    @JsonProperty(value="html")
    @Nullable
    private String html;
    @JsonProperty(value="type")
    @Nullable
    private MessageType type;
    @JsonProperty(value="silent")
    @Nullable
    private Boolean silent;
    @JsonProperty(value="user")
    @Nullable
    private User user;
    @JsonProperty(value="attachments")
    @Nullable
    private List<Attachment> attachments;
    @JsonProperty(value="latest_reactions")
    @Nullable
    private List<Reaction> latestReactions;
    @JsonProperty(value="own_reactions")
    @Nullable
    private List<Reaction> ownReactions;
    @JsonProperty(value="reaction_counts")
    @Nullable
    private Map<String, Integer> reactionCounts;
    @JsonProperty(value="reaction_scores")
    @Nullable
    private Map<String, Integer> reactionScores;
    @JsonProperty(value="parent_id")
    @Nullable
    private String parentId;
    @JsonProperty(value="show_in_channel")
    @Nullable
    private Boolean showInChannel;
    @JsonProperty(value="reply_count")
    @Nullable
    private Integer replyCount;
    @JsonProperty(value="deleted_reply_count")
    @Nullable
    private Integer deletedReplyCount;
    @JsonProperty(value="quoted_message_id")
    @Nullable
    private String quotedMessageId;
    @JsonProperty(value="quoted_message")
    @Nullable
    private Message quoted_message;
    @JsonProperty(value="thread_participants")
    @Nullable
    private List<User> threadParticipants;
    @JsonProperty(value="cid")
    @NotNull
    private String cid;
    @JsonProperty(value="mentioned_users")
    @Nullable
    private List<User> mentionedUsers;
    @JsonProperty(value="created_at")
    @Nullable
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Nullable
    private Date updatedAt;
    @JsonProperty(value="deleted_at")
    @Nullable
    private Date deletedAt;
    @JsonProperty(value="shadowed")
    @Nullable
    private Boolean shadowed;
    @JsonProperty(value="image_labels")
    @Nullable
    private Map<String, List<String>> imageLabels;
    @JsonProperty(value="i18n")
    @Nullable
    private Map<String, String> i18n;
    private Boolean before_message_send_failed;
    @JsonProperty(value="pinned")
    @Nullable
    private Boolean pinned;
    @JsonProperty(value="pin_expires")
    @Nullable
    private Date pinExpires;
    @JsonProperty(value="pinned_by")
    @Nullable
    private User pinnedBy;
    @JsonProperty(value="pinned_at")
    @Nullable
    private Date pinnedAt;
    @JsonIgnore
    @NotNull
    private Map<String, Object> additionalFields = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    @JsonAnySetter
    public void setAdditionalField(String name, Object value) {
        this.additionalFields.put(name, value);
    }

    @NotNull
    public static MessageSendRequestData.MessageSendRequest send(@NotNull String channelType, @NotNull String channelId) {
        return new MessageSendRequestData.MessageSendRequest(channelType, channelId);
    }

    @NotNull
    public static MessageGetRequest get(@NotNull String id) {
        return new MessageGetRequest(id);
    }

    @NotNull
    public static MessageUpdateRequestData.MessageUpdateRequest update(@NotNull String id) {
        return new MessageUpdateRequestData.MessageUpdateRequest(id);
    }

    @NotNull
    public static MessageDeleteRequest delete(@NotNull String id) {
        return new MessageDeleteRequest(id);
    }

    @NotNull
    public static MessageSearchRequestData.MessageSearchRequest search() {
        return new MessageSearchRequestData.MessageSearchRequest();
    }

    @NotNull
    public static MessageUploadFileRequest uploadFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @Nullable String contentType) {
        return new MessageUploadFileRequest(channelType, channelId, userId, contentType);
    }

    @NotNull
    public static MessageUploadImageRequest uploadImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String contentType) {
        return new MessageUploadImageRequest(channelType, channelId, userId, contentType);
    }

    @NotNull
    public static MessageDeleteFileRequest deleteFile(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
        return new MessageDeleteFileRequest(channelType, channelId, url);
    }

    @NotNull
    public static MessageDeleteImageRequest deleteImage(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
        return new MessageDeleteImageRequest(channelType, channelId, url);
    }

    @NotNull
    public static MessageGetManyRequest getMany(@NotNull String channelType, @NotNull String channelId, @NotNull List<String> messageIds) {
        return new MessageGetManyRequest(channelType, channelId, messageIds);
    }

    @NotNull
    public static MessageGetRepliesRequest getReplies(@NotNull String parentMessageId) {
        return new MessageGetRepliesRequest(parentMessageId);
    }

    @NotNull
    public static MessageRunCommandActionRequestData.MessageRunCommandActionRequest runCommandAction(@NotNull String messageId) {
        return new MessageRunCommandActionRequestData.MessageRunCommandActionRequest(messageId);
    }

    @NotNull
    public static MessageTranslateRequestData.MessageTranslateRequest translate(@NotNull String messageId) {
        return new MessageTranslateRequestData.MessageTranslateRequest(messageId);
    }

    @NotNull
    public static MessageCommitRequestData.MessageCommitRequest commit(@NotNull String messageId) {
        return new MessageCommitRequestData.MessageCommitRequest(messageId);
    }

    @NotNull
    public static Flag.FlagCreateRequestData.FlagCreateRequest flag(@NotNull String messageId) {
        return new Flag.FlagCreateRequestData.FlagCreateRequest().targetMessageId(messageId);
    }

    @NotNull
    public static Flag.FlagDeleteRequestData.FlagDeleteRequest unflag(@NotNull String messageId) {
        return new Flag.FlagDeleteRequestData.FlagDeleteRequest().targetMessageId(messageId);
    }

    @NotNull
    public static Flag.FlagMessageQueryRequestData.FlagMessageQueryRequest queryFlags() {
        return new Flag.FlagMessageQueryRequestData.FlagMessageQueryRequest();
    }

    @NotNull
    public static MessagePartialUpdateRequestData.MessagePartialUpdateRequest partialUpdate(@NotNull String id) {
        return new MessagePartialUpdateRequestData.MessagePartialUpdateRequest(id);
    }

    @NotNull
    public static MessagePartialUpdateRequestData.MessagePartialUpdateRequest pinMessage(@NotNull String id, @NotNull String userId) {
        return new MessagePartialUpdateRequestData.MessagePartialUpdateRequest(id).setValue("pinned", true).userId(userId);
    }

    @NotNull
    public static MessagePartialUpdateRequestData.MessagePartialUpdateRequest pinMessage(@NotNull String id, @NotNull String userId, @NotNull Date expiration) {
        return new MessagePartialUpdateRequestData.MessagePartialUpdateRequest(id).setValue("pinned", true).setValue("pin_expires", expiration).userId(userId);
    }

    @NotNull
    public static MessagePartialUpdateRequestData.MessagePartialUpdateRequest unpinMessage(@NotNull String id, @NotNull String userId) {
        return new MessagePartialUpdateRequestData.MessagePartialUpdateRequest(id).setValue("pinned", false).userId(userId);
    }

    @NotNull
    public static MessageUnblockRequestData.MessageUnblockRequest unblock(@NotNull String messageId) {
        return new MessageUnblockRequestData.MessageUnblockRequest().targetMessageId(messageId);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @Nullable
    public String getMml() {
        return this.mml;
    }

    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Nullable
    public String getHtml() {
        return this.html;
    }

    @Nullable
    public MessageType getType() {
        return this.type;
    }

    @Nullable
    public Boolean getSilent() {
        return this.silent;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    @Nullable
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Nullable
    public List<Reaction> getLatestReactions() {
        return this.latestReactions;
    }

    @Nullable
    public List<Reaction> getOwnReactions() {
        return this.ownReactions;
    }

    @Nullable
    public Map<String, Integer> getReactionCounts() {
        return this.reactionCounts;
    }

    @Nullable
    public Map<String, Integer> getReactionScores() {
        return this.reactionScores;
    }

    @Nullable
    public String getParentId() {
        return this.parentId;
    }

    @Nullable
    public Boolean getShowInChannel() {
        return this.showInChannel;
    }

    @Nullable
    public Integer getReplyCount() {
        return this.replyCount;
    }

    @Nullable
    public Integer getDeletedReplyCount() {
        return this.deletedReplyCount;
    }

    @Nullable
    public String getQuotedMessageId() {
        return this.quotedMessageId;
    }

    @Nullable
    public Message getQuoted_message() {
        return this.quoted_message;
    }

    @Nullable
    public List<User> getThreadParticipants() {
        return this.threadParticipants;
    }

    @NotNull
    public String getCid() {
        return this.cid;
    }

    @Nullable
    public List<User> getMentionedUsers() {
        return this.mentionedUsers;
    }

    @Nullable
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public Date getDeletedAt() {
        return this.deletedAt;
    }

    @Nullable
    public Boolean getShadowed() {
        return this.shadowed;
    }

    @Nullable
    public Map<String, List<String>> getImageLabels() {
        return this.imageLabels;
    }

    @Nullable
    public Map<String, String> getI18n() {
        return this.i18n;
    }

    public Boolean getBefore_message_send_failed() {
        return this.before_message_send_failed;
    }

    @Nullable
    public Boolean getPinned() {
        return this.pinned;
    }

    @Nullable
    public Date getPinExpires() {
        return this.pinExpires;
    }

    @Nullable
    public User getPinnedBy() {
        return this.pinnedBy;
    }

    @Nullable
    public Date getPinnedAt() {
        return this.pinnedAt;
    }

    @JsonProperty(value="id")
    public void setId(@NotNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="text")
    public void setText(@Nullable String text) {
        this.text = text;
    }

    @JsonProperty(value="mml")
    public void setMml(@Nullable String mml) {
        this.mml = mml;
    }

    @JsonProperty(value="command")
    public void setCommand(@Nullable String command) {
        this.command = command;
    }

    @JsonProperty(value="html")
    public void setHtml(@Nullable String html) {
        this.html = html;
    }

    @JsonProperty(value="type")
    public void setType(@Nullable MessageType type) {
        this.type = type;
    }

    @JsonProperty(value="silent")
    public void setSilent(@Nullable Boolean silent) {
        this.silent = silent;
    }

    @JsonProperty(value="user")
    public void setUser(@Nullable User user) {
        this.user = user;
    }

    @JsonProperty(value="attachments")
    public void setAttachments(@Nullable List<Attachment> attachments) {
        this.attachments = attachments;
    }

    @JsonProperty(value="latest_reactions")
    public void setLatestReactions(@Nullable List<Reaction> latestReactions) {
        this.latestReactions = latestReactions;
    }

    @JsonProperty(value="own_reactions")
    public void setOwnReactions(@Nullable List<Reaction> ownReactions) {
        this.ownReactions = ownReactions;
    }

    @JsonProperty(value="reaction_counts")
    public void setReactionCounts(@Nullable Map<String, Integer> reactionCounts) {
        this.reactionCounts = reactionCounts;
    }

    @JsonProperty(value="reaction_scores")
    public void setReactionScores(@Nullable Map<String, Integer> reactionScores) {
        this.reactionScores = reactionScores;
    }

    @JsonProperty(value="parent_id")
    public void setParentId(@Nullable String parentId) {
        this.parentId = parentId;
    }

    @JsonProperty(value="show_in_channel")
    public void setShowInChannel(@Nullable Boolean showInChannel) {
        this.showInChannel = showInChannel;
    }

    @JsonProperty(value="reply_count")
    public void setReplyCount(@Nullable Integer replyCount) {
        this.replyCount = replyCount;
    }

    @JsonProperty(value="deleted_reply_count")
    public void setDeletedReplyCount(@Nullable Integer deletedReplyCount) {
        this.deletedReplyCount = deletedReplyCount;
    }

    @JsonProperty(value="quoted_message_id")
    public void setQuotedMessageId(@Nullable String quotedMessageId) {
        this.quotedMessageId = quotedMessageId;
    }

    @JsonProperty(value="quoted_message")
    public void setQuoted_message(@Nullable Message quoted_message) {
        this.quoted_message = quoted_message;
    }

    @JsonProperty(value="thread_participants")
    public void setThreadParticipants(@Nullable List<User> threadParticipants) {
        this.threadParticipants = threadParticipants;
    }

    @JsonProperty(value="cid")
    public void setCid(@NotNull String cid) {
        if (cid == null) {
            throw new NullPointerException("cid is marked non-null but is null");
        }
        this.cid = cid;
    }

    @JsonProperty(value="mentioned_users")
    public void setMentionedUsers(@Nullable List<User> mentionedUsers) {
        this.mentionedUsers = mentionedUsers;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@Nullable Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(@Nullable Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="deleted_at")
    public void setDeletedAt(@Nullable Date deletedAt) {
        this.deletedAt = deletedAt;
    }

    @JsonProperty(value="shadowed")
    public void setShadowed(@Nullable Boolean shadowed) {
        this.shadowed = shadowed;
    }

    @JsonProperty(value="image_labels")
    public void setImageLabels(@Nullable Map<String, List<String>> imageLabels) {
        this.imageLabels = imageLabels;
    }

    @JsonProperty(value="i18n")
    public void setI18n(@Nullable Map<String, String> i18n) {
        this.i18n = i18n;
    }

    public void setBefore_message_send_failed(Boolean before_message_send_failed) {
        this.before_message_send_failed = before_message_send_failed;
    }

    @JsonProperty(value="pinned")
    public void setPinned(@Nullable Boolean pinned) {
        this.pinned = pinned;
    }

    @JsonProperty(value="pin_expires")
    public void setPinExpires(@Nullable Date pinExpires) {
        this.pinExpires = pinExpires;
    }

    @JsonProperty(value="pinned_by")
    public void setPinnedBy(@Nullable User pinnedBy) {
        this.pinnedBy = pinnedBy;
    }

    @JsonProperty(value="pinned_at")
    public void setPinnedAt(@Nullable Date pinnedAt) {
        this.pinnedAt = pinnedAt;
    }

    @JsonIgnore
    public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
        if (additionalFields == null) {
            throw new NullPointerException("additionalFields is marked non-null but is null");
        }
        this.additionalFields = additionalFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$silent = this.getSilent();
        Boolean other$silent = other.getSilent();
        if (this$silent == null ? other$silent != null : !((Object)this$silent).equals(other$silent)) {
            return false;
        }
        Boolean this$showInChannel = this.getShowInChannel();
        Boolean other$showInChannel = other.getShowInChannel();
        if (this$showInChannel == null ? other$showInChannel != null : !((Object)this$showInChannel).equals(other$showInChannel)) {
            return false;
        }
        Integer this$replyCount = this.getReplyCount();
        Integer other$replyCount = other.getReplyCount();
        if (this$replyCount == null ? other$replyCount != null : !((Object)this$replyCount).equals(other$replyCount)) {
            return false;
        }
        Integer this$deletedReplyCount = this.getDeletedReplyCount();
        Integer other$deletedReplyCount = other.getDeletedReplyCount();
        if (this$deletedReplyCount == null ? other$deletedReplyCount != null : !((Object)this$deletedReplyCount).equals(other$deletedReplyCount)) {
            return false;
        }
        Boolean this$shadowed = this.getShadowed();
        Boolean other$shadowed = other.getShadowed();
        if (this$shadowed == null ? other$shadowed != null : !((Object)this$shadowed).equals(other$shadowed)) {
            return false;
        }
        Boolean this$before_message_send_failed = this.getBefore_message_send_failed();
        Boolean other$before_message_send_failed = other.getBefore_message_send_failed();
        if (this$before_message_send_failed == null ? other$before_message_send_failed != null : !((Object)this$before_message_send_failed).equals(other$before_message_send_failed)) {
            return false;
        }
        Boolean this$pinned = this.getPinned();
        Boolean other$pinned = other.getPinned();
        if (this$pinned == null ? other$pinned != null : !((Object)this$pinned).equals(other$pinned)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$mml = this.getMml();
        String other$mml = other.getMml();
        if (this$mml == null ? other$mml != null : !this$mml.equals(other$mml)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        String this$html = this.getHtml();
        String other$html = other.getHtml();
        if (this$html == null ? other$html != null : !this$html.equals(other$html)) {
            return false;
        }
        MessageType this$type = this.getType();
        MessageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        List<Attachment> this$attachments = this.getAttachments();
        List<Attachment> other$attachments = other.getAttachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        List<Reaction> this$latestReactions = this.getLatestReactions();
        List<Reaction> other$latestReactions = other.getLatestReactions();
        if (this$latestReactions == null ? other$latestReactions != null : !((Object)this$latestReactions).equals(other$latestReactions)) {
            return false;
        }
        List<Reaction> this$ownReactions = this.getOwnReactions();
        List<Reaction> other$ownReactions = other.getOwnReactions();
        if (this$ownReactions == null ? other$ownReactions != null : !((Object)this$ownReactions).equals(other$ownReactions)) {
            return false;
        }
        Map<String, Integer> this$reactionCounts = this.getReactionCounts();
        Map<String, Integer> other$reactionCounts = other.getReactionCounts();
        if (this$reactionCounts == null ? other$reactionCounts != null : !((Object)this$reactionCounts).equals(other$reactionCounts)) {
            return false;
        }
        Map<String, Integer> this$reactionScores = this.getReactionScores();
        Map<String, Integer> other$reactionScores = other.getReactionScores();
        if (this$reactionScores == null ? other$reactionScores != null : !((Object)this$reactionScores).equals(other$reactionScores)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        String this$quotedMessageId = this.getQuotedMessageId();
        String other$quotedMessageId = other.getQuotedMessageId();
        if (this$quotedMessageId == null ? other$quotedMessageId != null : !this$quotedMessageId.equals(other$quotedMessageId)) {
            return false;
        }
        Message this$quoted_message = this.getQuoted_message();
        Message other$quoted_message = other.getQuoted_message();
        if (this$quoted_message == null ? other$quoted_message != null : !((Object)this$quoted_message).equals(other$quoted_message)) {
            return false;
        }
        List<User> this$threadParticipants = this.getThreadParticipants();
        List<User> other$threadParticipants = other.getThreadParticipants();
        if (this$threadParticipants == null ? other$threadParticipants != null : !((Object)this$threadParticipants).equals(other$threadParticipants)) {
            return false;
        }
        String this$cid = this.getCid();
        String other$cid = other.getCid();
        if (this$cid == null ? other$cid != null : !this$cid.equals(other$cid)) {
            return false;
        }
        List<User> this$mentionedUsers = this.getMentionedUsers();
        List<User> other$mentionedUsers = other.getMentionedUsers();
        if (this$mentionedUsers == null ? other$mentionedUsers != null : !((Object)this$mentionedUsers).equals(other$mentionedUsers)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Date this$deletedAt = this.getDeletedAt();
        Date other$deletedAt = other.getDeletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        Map<String, List<String>> this$imageLabels = this.getImageLabels();
        Map<String, List<String>> other$imageLabels = other.getImageLabels();
        if (this$imageLabels == null ? other$imageLabels != null : !((Object)this$imageLabels).equals(other$imageLabels)) {
            return false;
        }
        Map<String, String> this$i18n = this.getI18n();
        Map<String, String> other$i18n = other.getI18n();
        if (this$i18n == null ? other$i18n != null : !((Object)this$i18n).equals(other$i18n)) {
            return false;
        }
        Date this$pinExpires = this.getPinExpires();
        Date other$pinExpires = other.getPinExpires();
        if (this$pinExpires == null ? other$pinExpires != null : !((Object)this$pinExpires).equals(other$pinExpires)) {
            return false;
        }
        User this$pinnedBy = this.getPinnedBy();
        User other$pinnedBy = other.getPinnedBy();
        if (this$pinnedBy == null ? other$pinnedBy != null : !((Object)this$pinnedBy).equals(other$pinnedBy)) {
            return false;
        }
        Date this$pinnedAt = this.getPinnedAt();
        Date other$pinnedAt = other.getPinnedAt();
        if (this$pinnedAt == null ? other$pinnedAt != null : !((Object)this$pinnedAt).equals(other$pinnedAt)) {
            return false;
        }
        Map<String, Object> this$additionalFields = this.getAdditionalFields();
        Map<String, Object> other$additionalFields = other.getAdditionalFields();
        return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $silent = this.getSilent();
        result = result * 59 + ($silent == null ? 43 : ((Object)$silent).hashCode());
        Boolean $showInChannel = this.getShowInChannel();
        result = result * 59 + ($showInChannel == null ? 43 : ((Object)$showInChannel).hashCode());
        Integer $replyCount = this.getReplyCount();
        result = result * 59 + ($replyCount == null ? 43 : ((Object)$replyCount).hashCode());
        Integer $deletedReplyCount = this.getDeletedReplyCount();
        result = result * 59 + ($deletedReplyCount == null ? 43 : ((Object)$deletedReplyCount).hashCode());
        Boolean $shadowed = this.getShadowed();
        result = result * 59 + ($shadowed == null ? 43 : ((Object)$shadowed).hashCode());
        Boolean $before_message_send_failed = this.getBefore_message_send_failed();
        result = result * 59 + ($before_message_send_failed == null ? 43 : ((Object)$before_message_send_failed).hashCode());
        Boolean $pinned = this.getPinned();
        result = result * 59 + ($pinned == null ? 43 : ((Object)$pinned).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $mml = this.getMml();
        result = result * 59 + ($mml == null ? 43 : $mml.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        String $html = this.getHtml();
        result = result * 59 + ($html == null ? 43 : $html.hashCode());
        MessageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        List<Attachment> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        List<Reaction> $latestReactions = this.getLatestReactions();
        result = result * 59 + ($latestReactions == null ? 43 : ((Object)$latestReactions).hashCode());
        List<Reaction> $ownReactions = this.getOwnReactions();
        result = result * 59 + ($ownReactions == null ? 43 : ((Object)$ownReactions).hashCode());
        Map<String, Integer> $reactionCounts = this.getReactionCounts();
        result = result * 59 + ($reactionCounts == null ? 43 : ((Object)$reactionCounts).hashCode());
        Map<String, Integer> $reactionScores = this.getReactionScores();
        result = result * 59 + ($reactionScores == null ? 43 : ((Object)$reactionScores).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        String $quotedMessageId = this.getQuotedMessageId();
        result = result * 59 + ($quotedMessageId == null ? 43 : $quotedMessageId.hashCode());
        Message $quoted_message = this.getQuoted_message();
        result = result * 59 + ($quoted_message == null ? 43 : ((Object)$quoted_message).hashCode());
        List<User> $threadParticipants = this.getThreadParticipants();
        result = result * 59 + ($threadParticipants == null ? 43 : ((Object)$threadParticipants).hashCode());
        String $cid = this.getCid();
        result = result * 59 + ($cid == null ? 43 : $cid.hashCode());
        List<User> $mentionedUsers = this.getMentionedUsers();
        result = result * 59 + ($mentionedUsers == null ? 43 : ((Object)$mentionedUsers).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Date $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        Map<String, List<String>> $imageLabels = this.getImageLabels();
        result = result * 59 + ($imageLabels == null ? 43 : ((Object)$imageLabels).hashCode());
        Map<String, String> $i18n = this.getI18n();
        result = result * 59 + ($i18n == null ? 43 : ((Object)$i18n).hashCode());
        Date $pinExpires = this.getPinExpires();
        result = result * 59 + ($pinExpires == null ? 43 : ((Object)$pinExpires).hashCode());
        User $pinnedBy = this.getPinnedBy();
        result = result * 59 + ($pinnedBy == null ? 43 : ((Object)$pinnedBy).hashCode());
        Date $pinnedAt = this.getPinnedAt();
        result = result * 59 + ($pinnedAt == null ? 43 : ((Object)$pinnedAt).hashCode());
        Map<String, Object> $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        return result;
    }

    public String toString() {
        return "Message(id=" + this.getId() + ", text=" + this.getText() + ", mml=" + this.getMml() + ", command=" + this.getCommand() + ", html=" + this.getHtml() + ", type=" + this.getType() + ", silent=" + this.getSilent() + ", user=" + this.getUser() + ", attachments=" + this.getAttachments() + ", latestReactions=" + this.getLatestReactions() + ", ownReactions=" + this.getOwnReactions() + ", reactionCounts=" + this.getReactionCounts() + ", reactionScores=" + this.getReactionScores() + ", parentId=" + this.getParentId() + ", showInChannel=" + this.getShowInChannel() + ", replyCount=" + this.getReplyCount() + ", deletedReplyCount=" + this.getDeletedReplyCount() + ", quotedMessageId=" + this.getQuotedMessageId() + ", quoted_message=" + this.getQuoted_message() + ", threadParticipants=" + this.getThreadParticipants() + ", cid=" + this.getCid() + ", mentionedUsers=" + this.getMentionedUsers() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", deletedAt=" + this.getDeletedAt() + ", shadowed=" + this.getShadowed() + ", imageLabels=" + this.getImageLabels() + ", i18n=" + this.getI18n() + ", before_message_send_failed=" + this.getBefore_message_send_failed() + ", pinned=" + this.getPinned() + ", pinExpires=" + this.getPinExpires() + ", pinnedBy=" + this.getPinnedBy() + ", pinnedAt=" + this.getPinnedAt() + ", additionalFields=" + this.getAdditionalFields() + ")";
    }

    public static class MessagePartialUpdateResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessagePartialUpdateResponse(message=" + this.getMessage() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessagePartialUpdateResponse)) {
                return false;
            }
            MessagePartialUpdateResponse other = (MessagePartialUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessagePartialUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageTranslateResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageTranslateResponse(message=" + this.getMessage() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageTranslateResponse)) {
                return false;
            }
            MessageTranslateResponse other = (MessageTranslateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageTranslateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageRunCommandActionResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageRunCommandActionResponse(message=" + this.getMessage() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageRunCommandActionResponse)) {
                return false;
            }
            MessageRunCommandActionResponse other = (MessageRunCommandActionResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageRunCommandActionResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageGetRepliesResponse
    extends StreamResponseObject {
        @JsonProperty(value="messages")
        @NotNull
        private List<Message> messages;

        @NotNull
        public List<Message> getMessages() {
            return this.messages;
        }

        @JsonProperty(value="messages")
        public void setMessages(@NotNull List<Message> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
        }

        @Override
        public String toString() {
            return "Message.MessageGetRepliesResponse(messages=" + this.getMessages() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageGetRepliesResponse)) {
                return false;
            }
            MessageGetRepliesResponse other = (MessageGetRepliesResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Message> this$messages = this.getMessages();
            List<Message> other$messages = other.getMessages();
            return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageGetRepliesResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Message> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            return result;
        }
    }

    public static class MessageGetManyResponse
    extends StreamResponseObject {
        @JsonProperty(value="messages")
        @NotNull
        private List<Message> messages;

        @NotNull
        public List<Message> getMessages() {
            return this.messages;
        }

        @JsonProperty(value="messages")
        public void setMessages(@NotNull List<Message> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
        }

        @Override
        public String toString() {
            return "Message.MessageGetManyResponse(messages=" + this.getMessages() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageGetManyResponse)) {
                return false;
            }
            MessageGetManyResponse other = (MessageGetManyResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Message> this$messages = this.getMessages();
            List<Message> other$messages = other.getMessages();
            return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageGetManyResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Message> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            return result;
        }
    }

    public static class MessageUploadImageResponse
    implements StreamResponse {
        @JsonProperty(value="file")
        @NotNull
        private String file;
        @JsonProperty(value="duration")
        @NotNull
        private String duration;
        @JsonProperty(value="upload_sizes")
        @Nullable
        private List<ImageSize> uploadSizes;

        @NotNull
        public String getFile() {
            return this.file;
        }

        @Override
        @NotNull
        public String getDuration() {
            return this.duration;
        }

        @Nullable
        public List<ImageSize> getUploadSizes() {
            return this.uploadSizes;
        }

        @JsonProperty(value="file")
        public void setFile(@NotNull String file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
        }

        @Override
        @JsonProperty(value="duration")
        public void setDuration(@NotNull String duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        @JsonProperty(value="upload_sizes")
        public void setUploadSizes(@Nullable List<ImageSize> uploadSizes) {
            this.uploadSizes = uploadSizes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageUploadImageResponse)) {
                return false;
            }
            MessageUploadImageResponse other = (MessageUploadImageResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$file = this.getFile();
            String other$file = other.getFile();
            if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
                return false;
            }
            List<ImageSize> this$uploadSizes = this.getUploadSizes();
            List<ImageSize> other$uploadSizes = other.getUploadSizes();
            return !(this$uploadSizes == null ? other$uploadSizes != null : !((Object)this$uploadSizes).equals(other$uploadSizes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageUploadImageResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            List<ImageSize> $uploadSizes = this.getUploadSizes();
            result = result * 59 + ($uploadSizes == null ? 43 : ((Object)$uploadSizes).hashCode());
            return result;
        }

        public String toString() {
            return "Message.MessageUploadImageResponse(file=" + this.getFile() + ", duration=" + this.getDuration() + ", uploadSizes=" + this.getUploadSizes() + ")";
        }
    }

    public static class MessageUploadFileResponse
    implements StreamResponse {
        @JsonProperty(value="file")
        @NotNull
        private String file;
        @JsonProperty(value="duration")
        @NotNull
        private String duration;

        @NotNull
        public String getFile() {
            return this.file;
        }

        @Override
        @NotNull
        public String getDuration() {
            return this.duration;
        }

        @JsonProperty(value="file")
        public void setFile(@NotNull String file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
        }

        @Override
        @JsonProperty(value="duration")
        public void setDuration(@NotNull String duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageUploadFileResponse)) {
                return false;
            }
            MessageUploadFileResponse other = (MessageUploadFileResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$file = this.getFile();
            String other$file = other.getFile();
            if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            return !(this$duration == null ? other$duration != null : !this$duration.equals(other$duration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageUploadFileResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            return result;
        }

        public String toString() {
            return "Message.MessageUploadFileResponse(file=" + this.getFile() + ", duration=" + this.getDuration() + ")";
        }
    }

    public static class MessageSearchResponse
    extends StreamResponseObject {
        @JsonProperty(value="results")
        @NotNull
        private List<SearchResult> results;
        @JsonProperty(value="next")
        @Nullable
        private String next;
        @JsonProperty(value="previous")
        @Nullable
        private String previous;

        @NotNull
        public List<SearchResult> getResults() {
            return this.results;
        }

        @Nullable
        public String getNext() {
            return this.next;
        }

        @Nullable
        public String getPrevious() {
            return this.previous;
        }

        @JsonProperty(value="results")
        public void setResults(@NotNull List<SearchResult> results) {
            if (results == null) {
                throw new NullPointerException("results is marked non-null but is null");
            }
            this.results = results;
        }

        @JsonProperty(value="next")
        public void setNext(@Nullable String next) {
            this.next = next;
        }

        @JsonProperty(value="previous")
        public void setPrevious(@Nullable String previous) {
            this.previous = previous;
        }

        @Override
        public String toString() {
            return "Message.MessageSearchResponse(results=" + this.getResults() + ", next=" + this.getNext() + ", previous=" + this.getPrevious() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageSearchResponse)) {
                return false;
            }
            MessageSearchResponse other = (MessageSearchResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<SearchResult> this$results = this.getResults();
            List<SearchResult> other$results = other.getResults();
            if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
                return false;
            }
            String this$next = this.getNext();
            String other$next = other.getNext();
            if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
                return false;
            }
            String this$previous = this.getPrevious();
            String other$previous = other.getPrevious();
            return !(this$previous == null ? other$previous != null : !this$previous.equals(other$previous));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageSearchResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<SearchResult> $results = this.getResults();
            result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
            String $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : $next.hashCode());
            String $previous = this.getPrevious();
            result = result * 59 + ($previous == null ? 43 : $previous.hashCode());
            return result;
        }
    }

    public static class MessageDeleteResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageDeleteResponse(message=" + this.getMessage() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageDeleteResponse)) {
                return false;
            }
            MessageDeleteResponse other = (MessageDeleteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageDeleteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageCommitResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageCommitResponse(message=" + this.getMessage() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageCommitResponse)) {
                return false;
            }
            MessageCommitResponse other = (MessageCommitResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageCommitResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageUpdateResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageUpdateResponse(message=" + this.getMessage() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageUpdateResponse)) {
                return false;
            }
            MessageUpdateResponse other = (MessageUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageGetResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageGetResponse(message=" + this.getMessage() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageGetResponse)) {
                return false;
            }
            MessageGetResponse other = (MessageGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageGetResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageSendResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageSendResponse(message=" + this.getMessage() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageSendResponse)) {
                return false;
            }
            MessageSendResponse other = (MessageSendResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageSendResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageUnblockRequestData {
        @JsonProperty(value="target_message_id")
        @NotNull
        private String targetMessageId;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;

        MessageUnblockRequestData(@NotNull String targetMessageId, @Nullable String userId) {
            if (targetMessageId == null) {
                throw new NullPointerException("targetMessageId is marked non-null but is null");
            }
            this.targetMessageId = targetMessageId;
            this.userId = userId;
        }

        public static class MessageUnblockRequest
        extends StreamRequest<StreamResponseObject> {
            private String targetMessageId;
            private String userId;

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(MessageService.class).unblockMessage(this.internalBuild());
            }

            MessageUnblockRequest() {
            }

            @JsonProperty(value="target_message_id")
            public MessageUnblockRequest targetMessageId(@NotNull String targetMessageId) {
                if (targetMessageId == null) {
                    throw new NullPointerException("targetMessageId is marked non-null but is null");
                }
                this.targetMessageId = targetMessageId;
                return this;
            }

            @JsonProperty(value="user_id")
            public MessageUnblockRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            public MessageUnblockRequestData internalBuild() {
                return new MessageUnblockRequestData(this.targetMessageId, this.userId);
            }

            public String toString() {
                return "Message.MessageUnblockRequestData.MessageUnblockRequest(targetMessageId=" + this.targetMessageId + ", userId=" + this.userId + ")";
            }
        }
    }

    public static class MessagePartialUpdateRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="set")
        @Nullable
        private Map<String, Object> setValues;
        @JsonProperty(value="unset")
        @Nullable
        private List<String> unsetValues;

        MessagePartialUpdateRequestData(@Nullable String userId, @Nullable User.UserRequestObject user, @Nullable Map<String, Object> setValues, @Nullable List<String> unsetValues) {
            this.userId = userId;
            this.user = user;
            this.setValues = setValues;
            this.unsetValues = unsetValues;
        }

        public static class MessagePartialUpdateRequest
        extends StreamRequest<MessagePartialUpdateResponse> {
            private String userId;
            private User.UserRequestObject user;
            private ArrayList<String> setValues$key;
            private ArrayList<Object> setValues$value;
            private ArrayList<String> unsetValues;
            @NotNull
            private String id;

            private MessagePartialUpdateRequest(@NotNull String id) {
                this.id = id;
            }

            @Override
            protected Call<MessagePartialUpdateResponse> generateCall(Client client) {
                return client.create(MessageService.class).partialUpdate(this.id, this.internalBuild());
            }

            @JsonProperty(value="user_id")
            public MessagePartialUpdateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public MessagePartialUpdateRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public MessagePartialUpdateRequest setValue(String setValueKey, Object setValueValue) {
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                this.setValues$key.add(setValueKey);
                this.setValues$value.add(setValueValue);
                return this;
            }

            @JsonProperty(value="set")
            public MessagePartialUpdateRequest setValues(Map<? extends String, ? extends Object> setValues) {
                if (setValues == null) {
                    throw new NullPointerException("setValues cannot be null");
                }
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : setValues.entrySet()) {
                    this.setValues$key.add($lombokEntry.getKey());
                    this.setValues$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public MessagePartialUpdateRequest clearSetValues() {
                if (this.setValues$key != null) {
                    this.setValues$key.clear();
                    this.setValues$value.clear();
                }
                return this;
            }

            public MessagePartialUpdateRequest unsetValue(String unsetValue) {
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.add(unsetValue);
                return this;
            }

            @JsonProperty(value="unset")
            public MessagePartialUpdateRequest unsetValues(Collection<? extends String> unsetValues) {
                if (unsetValues == null) {
                    throw new NullPointerException("unsetValues cannot be null");
                }
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.addAll(unsetValues);
                return this;
            }

            public MessagePartialUpdateRequest clearUnsetValues() {
                if (this.unsetValues != null) {
                    this.unsetValues.clear();
                }
                return this;
            }

            public MessagePartialUpdateRequestData internalBuild() {
                List<String> unsetValues;
                Map<String, Object> setValues;
                switch (this.setValues$key == null ? 0 : this.setValues$key.size()) {
                    case 0: {
                        setValues = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        setValues = Collections.singletonMap(this.setValues$key.get(0), this.setValues$value.get(0));
                        break;
                    }
                    default: {
                        setValues = new LinkedHashMap(this.setValues$key.size() < 0x40000000 ? 1 + this.setValues$key.size() + (this.setValues$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.setValues$key.size(); ++$i) {
                            setValues.put(this.setValues$key.get($i), this.setValues$value.get($i));
                        }
                        setValues = Collections.unmodifiableMap(setValues);
                    }
                }
                switch (this.unsetValues == null ? 0 : this.unsetValues.size()) {
                    case 0: {
                        unsetValues = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        unsetValues = Collections.singletonList(this.unsetValues.get(0));
                        break;
                    }
                    default: {
                        unsetValues = Collections.unmodifiableList(new ArrayList<String>(this.unsetValues));
                    }
                }
                return new MessagePartialUpdateRequestData(this.userId, this.user, setValues, unsetValues);
            }

            public String toString() {
                return "Message.MessagePartialUpdateRequestData.MessagePartialUpdateRequest(userId=" + this.userId + ", user=" + this.user + ", setValues$key=" + this.setValues$key + ", setValues$value=" + this.setValues$value + ", unsetValues=" + this.unsetValues + ")";
            }
        }
    }

    public static class MessageCommitRequestData {
        MessageCommitRequestData() {
        }

        public static class MessageCommitRequest
        extends StreamRequest<MessageCommitResponse> {
            @NotNull
            private String messageId;

            public MessageCommitRequest(@NotNull String messageId) {
                this.messageId = messageId;
            }

            @Override
            protected Call<MessageCommitResponse> generateCall(Client client) {
                return client.create(MessageService.class).commit(this.messageId);
            }

            public MessageCommitRequestData internalBuild() {
                return new MessageCommitRequestData();
            }

            public String toString() {
                return "Message.MessageCommitRequestData.MessageCommitRequest()";
            }
        }
    }

    public static class MessageTranslateRequestData {
        @JsonProperty(value="language")
        @Nullable
        private Language language;

        MessageTranslateRequestData(@Nullable Language language) {
            this.language = language;
        }

        public static class MessageTranslateRequest
        extends StreamRequest<MessageTranslateResponse> {
            private Language language;
            @NotNull
            private String messageId;

            public MessageTranslateRequest(@NotNull String messageId) {
                this.messageId = messageId;
            }

            @Override
            protected Call<MessageTranslateResponse> generateCall(Client client) {
                return client.create(MessageService.class).translate(this.messageId, this.internalBuild());
            }

            @JsonProperty(value="language")
            public MessageTranslateRequest language(@Nullable Language language) {
                this.language = language;
                return this;
            }

            public MessageTranslateRequestData internalBuild() {
                return new MessageTranslateRequestData(this.language);
            }

            public String toString() {
                return "Message.MessageTranslateRequestData.MessageTranslateRequest(language=" + this.language + ")";
            }
        }
    }

    public static class MessageRunCommandActionRequestData {
        @JsonProperty(value="form_data")
        @Nullable
        private Map<String, String> formData;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        MessageRunCommandActionRequestData(@Nullable Map<String, String> formData, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.formData = formData;
            this.userId = userId;
            this.user = user;
        }

        public static class MessageRunCommandActionRequest
        extends StreamRequest<MessageRunCommandActionResponse> {
            private Map<String, String> formData;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String messageId;

            public MessageRunCommandActionRequest(@NotNull String messageId) {
                this.messageId = messageId;
            }

            @Override
            protected Call<MessageRunCommandActionResponse> generateCall(Client client) {
                return client.create(MessageService.class).runCommandAction(this.messageId, this.internalBuild());
            }

            @JsonProperty(value="form_data")
            public MessageRunCommandActionRequest formData(@Nullable Map<String, String> formData) {
                this.formData = formData;
                return this;
            }

            @JsonProperty(value="user_id")
            public MessageRunCommandActionRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public MessageRunCommandActionRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public MessageRunCommandActionRequestData internalBuild() {
                return new MessageRunCommandActionRequestData(this.formData, this.userId, this.user);
            }

            public String toString() {
                return "Message.MessageRunCommandActionRequestData.MessageRunCommandActionRequest(formData=" + this.formData + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class MessageGetRepliesRequest
    extends StreamRequest<MessageGetRepliesResponse> {
        @NotNull
        private String parentId;
        @Nullable
        private String idGte;
        @Nullable
        private String idGt;
        @Nullable
        private String idLte;
        @Nullable
        private String idLt;
        @Nullable
        private Date createdAtAfterOrEqual;
        @Nullable
        private Date createdAtAfter;
        @Nullable
        private Date createdAtBeforeOrEqual;
        @Nullable
        private Date createdAtBefore;
        @Nullable
        private Integer limit;
        @Nullable
        private Integer offset;

        @NotNull
        public MessageGetRepliesRequest idGte(@Nullable String idGte) {
            this.idGte = idGte;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest idGt(@Nullable String idGt) {
            this.idGt = idGt;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest idLte(@Nullable String idLte) {
            this.idLte = idLte;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest idLt(@Nullable String idLt) {
            this.idLt = idLt;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest createdAtAfterOrEqual(@Nullable Date createdAtAfterOrEqual) {
            this.createdAtAfterOrEqual = createdAtAfterOrEqual;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest createdAtAfter(@Nullable Date createdAtAfter) {
            this.createdAtAfter = createdAtAfter;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest createdAtBeforeOrEqual(@Nullable Date createdAtBeforeOrEqual) {
            this.createdAtBeforeOrEqual = createdAtBeforeOrEqual;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest createdAtBefore(@Nullable Date createdAtBefore) {
            this.createdAtBefore = createdAtBefore;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest limit(@NotNull Integer limit) {
            this.limit = limit;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest offset(@NotNull Integer offset) {
            this.offset = offset;
            return this;
        }

        @Override
        protected Call<MessageGetRepliesResponse> generateCall(Client client) {
            return client.create(MessageService.class).getReplies(this.parentId, this.idGte, this.idGt, this.idLte, this.idLt, this.createdAtAfterOrEqual, this.createdAtAfter, this.createdAtBeforeOrEqual, this.createdAtBefore);
        }

        public MessageGetRepliesRequest(@NotNull String parentId) {
            if (parentId == null) {
                throw new NullPointerException("parentId is marked non-null but is null");
            }
            this.parentId = parentId;
        }
    }

    public static class MessageGetManyRequest
    extends StreamRequest<MessageGetManyResponse> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @NotNull
        private List<String> messageIds;

        @Override
        protected Call<MessageGetManyResponse> generateCall(Client client) {
            return client.create(MessageService.class).getMany(this.channelType, this.channelId, String.join((CharSequence)",", this.messageIds));
        }

        public MessageGetManyRequest(@NotNull String channelType, @NotNull String channelId, @NotNull List<String> messageIds) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            if (messageIds == null) {
                throw new NullPointerException("messageIds is marked non-null but is null");
            }
            this.channelType = channelType;
            this.channelId = channelId;
            this.messageIds = messageIds;
        }
    }

    public static class MessageDeleteImageRequest
    extends FileRequest<StreamResponseObject> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @NotNull
        private String url;

        @Override
        @NotNull
        public StreamResponseObject request() throws StreamException {
            return this.getFileHandler().deleteImage(this.channelType, this.channelId, this.url);
        }

        public MessageDeleteImageRequest(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.channelType = channelType;
            this.channelId = channelId;
            this.url = url;
        }
    }

    public static class MessageDeleteFileRequest
    extends FileRequest<StreamResponseObject> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @NotNull
        private String url;

        @Override
        @NotNull
        public StreamResponseObject request() throws StreamException {
            return this.getFileHandler().deleteFile(this.channelType, this.channelId, this.url);
        }

        public MessageDeleteFileRequest(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.channelType = channelType;
            this.channelId = channelId;
            this.url = url;
        }
    }

    public static class MessageUploadImageRequest
    extends FileRequest<MessageUploadImageResponse> {
        @Nullable
        private File file;
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @NotNull
        private String userId;
        @NotNull
        private String contentType;
        @Nullable
        private List<ImageSizeRequestObject> uploadSizes;

        @NotNull
        public MessageUploadImageRequest file(@NotNull File file) {
            this.file = file;
            return this;
        }

        @NotNull
        public MessageUploadImageRequest uploadSizes(@NotNull List<ImageSizeRequestObject> uploadSizes) {
            this.uploadSizes = uploadSizes;
            return this;
        }

        @Override
        @NotNull
        public MessageUploadImageResponse request() throws StreamException {
            return this.getFileHandler().uploadImage(this.channelType, this.channelId, this.userId, this.file, this.contentType, this.uploadSizes);
        }

        public MessageUploadImageRequest(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String contentType) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            if (contentType == null) {
                throw new NullPointerException("contentType is marked non-null but is null");
            }
            this.channelType = channelType;
            this.channelId = channelId;
            this.userId = userId;
            this.contentType = contentType;
        }
    }

    public static class MessageUploadFileRequest
    extends FileRequest<MessageUploadFileResponse> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @NotNull
        private String userId;
        @Nullable
        private File file;
        @Nullable
        private String contentType;

        private MessageUploadFileRequest(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @Nullable String contentType) {
            this.channelType = channelType;
            this.channelId = channelId;
            this.userId = userId;
            this.contentType = contentType;
        }

        @NotNull
        public MessageUploadFileRequest file(@NotNull File file) {
            this.file = file;
            return this;
        }

        @Override
        @NotNull
        public MessageUploadFileResponse request() throws StreamException {
            return this.getFileHandler().uploadFile(this.channelType, this.channelId, this.userId, this.file, this.contentType);
        }
    }

    public static abstract class FileRequest<TResponse> {
        private FileHandler fileHandler;

        public FileRequest<TResponse> withFileHandler(FileHandler fileHandler) {
            this.fileHandler = fileHandler;
            return this;
        }

        public abstract TResponse request() throws StreamException;

        public void requestAsync(@Nullable Consumer<TResponse> onSuccess, @Nullable Consumer<StreamException> onError) {
            block3: {
                try {
                    TResponse response = this.request();
                    if (onSuccess == null) {
                        return;
                    }
                    onSuccess.accept(response);
                }
                catch (StreamException ex) {
                    if (onError == null) break block3;
                    onError.accept(ex);
                }
            }
        }

        @NotNull
        protected FileHandler getFileHandler() throws StreamException {
            FileHandler fh = this.fileHandler;
            if (fh != null) {
                return fh;
            }
            try {
                return fileHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw StreamException.build("Your file handler should have a public constructor with no argument");
            }
            catch (InvocationTargetException e) {
                throw StreamException.build(e);
            }
        }
    }

    public static class MessageSearchRequestData {
        @JsonProperty(value="query")
        @Nullable
        private String query;
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="message_filter_conditions")
        @Nullable
        private Map<String, Object> messageFilterConditions;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;
        @JsonProperty(value="next")
        @Nullable
        private String next;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;

        private MessageSearchRequestData(@Nullable String query, @Nullable Map<String, Object> filterConditions, @Nullable Map<String, Object> messageFilterConditions, @Nullable Integer limit, @Nullable Integer offset, @Nullable String next, @Nullable List<Sort> sorts) {
            if ((query == null || query.isEmpty()) && (messageFilterConditions == null || messageFilterConditions.isEmpty())) {
                throw new IllegalArgumentException("Must specify one of query and message filter conditions");
            }
            if (query != null && !query.isEmpty() && messageFilterConditions != null && !messageFilterConditions.isEmpty()) {
                throw new IllegalArgumentException("Can only specify one of query and message filter conditions");
            }
            if (offset != null && offset > 0 && next != null && !next.isEmpty()) {
                throw new IllegalArgumentException("Cannot use offset with next value");
            }
            this.query = query;
            this.filterConditions = filterConditions;
            this.messageFilterConditions = messageFilterConditions;
            this.limit = limit;
            this.offset = offset;
            this.next = next;
            this.sorts = sorts;
        }

        public static class MessageSearchRequest
        extends StreamRequest<MessageSearchResponse> {
            private String query;
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private ArrayList<String> messageFilterConditions$key;
            private ArrayList<Object> messageFilterConditions$value;
            private Integer limit;
            private Integer offset;
            private String next;
            private ArrayList<Sort> sorts;

            @Override
            protected Call<MessageSearchResponse> generateCall(Client client) {
                return client.create(MessageService.class).search(this.internalBuild());
            }

            MessageSearchRequest() {
            }

            @JsonProperty(value="query")
            public MessageSearchRequest query(@Nullable String query) {
                this.query = query;
                return this;
            }

            public MessageSearchRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public MessageSearchRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public MessageSearchRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            public MessageSearchRequest messageFilterCondition(String messageFilterConditionKey, Object messageFilterConditionValue) {
                if (this.messageFilterConditions$key == null) {
                    this.messageFilterConditions$key = new ArrayList();
                    this.messageFilterConditions$value = new ArrayList();
                }
                this.messageFilterConditions$key.add(messageFilterConditionKey);
                this.messageFilterConditions$value.add(messageFilterConditionValue);
                return this;
            }

            @JsonProperty(value="message_filter_conditions")
            public MessageSearchRequest messageFilterConditions(Map<? extends String, ? extends Object> messageFilterConditions) {
                if (messageFilterConditions == null) {
                    throw new NullPointerException("messageFilterConditions cannot be null");
                }
                if (this.messageFilterConditions$key == null) {
                    this.messageFilterConditions$key = new ArrayList();
                    this.messageFilterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : messageFilterConditions.entrySet()) {
                    this.messageFilterConditions$key.add($lombokEntry.getKey());
                    this.messageFilterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public MessageSearchRequest clearMessageFilterConditions() {
                if (this.messageFilterConditions$key != null) {
                    this.messageFilterConditions$key.clear();
                    this.messageFilterConditions$value.clear();
                }
                return this;
            }

            @JsonProperty(value="limit")
            public MessageSearchRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public MessageSearchRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            @JsonProperty(value="next")
            public MessageSearchRequest next(@Nullable String next) {
                this.next = next;
                return this;
            }

            public MessageSearchRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public MessageSearchRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public MessageSearchRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            public MessageSearchRequestData internalBuild() {
                List<Sort> sorts;
                Map<String, Object> messageFilterConditions;
                Map<Object, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                switch (this.messageFilterConditions$key == null ? 0 : this.messageFilterConditions$key.size()) {
                    case 0: {
                        messageFilterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        messageFilterConditions = Collections.singletonMap(this.messageFilterConditions$key.get(0), this.messageFilterConditions$value.get(0));
                        break;
                    }
                    default: {
                        messageFilterConditions = new LinkedHashMap(this.messageFilterConditions$key.size() < 0x40000000 ? 1 + this.messageFilterConditions$key.size() + (this.messageFilterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.messageFilterConditions$key.size(); ++$i) {
                            messageFilterConditions.put(this.messageFilterConditions$key.get($i), this.messageFilterConditions$value.get($i));
                        }
                        messageFilterConditions = Collections.unmodifiableMap(messageFilterConditions);
                    }
                }
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new MessageSearchRequestData(this.query, filterConditions, messageFilterConditions, this.limit, this.offset, this.next, sorts);
            }

            public String toString() {
                return "Message.MessageSearchRequestData.MessageSearchRequest(query=" + this.query + ", filterConditions$key=" + this.filterConditions$key + ", filterConditions$value=" + this.filterConditions$value + ", messageFilterConditions$key=" + this.messageFilterConditions$key + ", messageFilterConditions$value=" + this.messageFilterConditions$value + ", limit=" + this.limit + ", offset=" + this.offset + ", next=" + this.next + ", sorts=" + this.sorts + ")";
            }
        }
    }

    public static class MessageDeleteRequest
    extends StreamRequest<MessageDeleteResponse> {
        @NotNull
        private String id;
        @Nullable
        private Boolean hard;

        @NotNull
        public MessageDeleteRequest hard(@NotNull Boolean hard) {
            this.hard = hard;
            return this;
        }

        @Override
        protected Call<MessageDeleteResponse> generateCall(Client client) {
            return client.create(MessageService.class).delete(this.id, this.hard);
        }

        public MessageDeleteRequest(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }
    }

    public static class MessageUpdateRequestData {
        @JsonProperty(value="message")
        @Nullable
        private MessageRequestObject message;

        MessageUpdateRequestData(@Nullable MessageRequestObject message) {
            this.message = message;
        }

        public static class MessageUpdateRequest
        extends StreamRequest<MessageUpdateResponse> {
            private MessageRequestObject message;
            @NotNull
            private String id;

            private MessageUpdateRequest(@NotNull String id) {
                this.id = id;
            }

            @Override
            protected Call<MessageUpdateResponse> generateCall(Client client) {
                return client.create(MessageService.class).update(this.id, this.internalBuild());
            }

            @JsonProperty(value="message")
            public MessageUpdateRequest message(@Nullable MessageRequestObject message) {
                this.message = message;
                return this;
            }

            public MessageUpdateRequestData internalBuild() {
                return new MessageUpdateRequestData(this.message);
            }

            public String toString() {
                return "Message.MessageUpdateRequestData.MessageUpdateRequest(message=" + this.message + ")";
            }
        }
    }

    public static class MessageGetRequest
    extends StreamRequest<MessageGetResponse> {
        @NotNull
        private String id;
        @Nullable
        private Boolean showDeletedMessages;

        @NotNull
        public MessageGetRequest showDeletedMessages(@NotNull Boolean showDeletedMessages) {
            this.showDeletedMessages = showDeletedMessages;
            return this;
        }

        @Override
        protected Call<MessageGetResponse> generateCall(Client client) {
            return client.create(MessageService.class).get(this.id, this.showDeletedMessages);
        }

        public MessageGetRequest(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }
    }

    public static class MessageSendRequestData {
        @JsonProperty(value="message")
        @Nullable
        private MessageRequestObject message;
        @JsonProperty(value="skip_push")
        @Nullable
        private Boolean skipPush;
        @JsonProperty(value="is_pending_message")
        @Nullable
        private Boolean isPendingMessage;
        @JsonProperty(value="pending")
        @Nullable
        private Boolean pending;
        @JsonProperty(value="force_moderation")
        @Nullable
        private Boolean forceModeration;
        @JsonProperty(value="pending_message_metadata")
        @Nullable
        private Map<String, Object> pendingMessageMetadata;

        MessageSendRequestData(@Nullable MessageRequestObject message, @Nullable Boolean skipPush, @Nullable Boolean isPendingMessage, @Nullable Boolean pending, @Nullable Boolean forceModeration, @Nullable Map<String, Object> pendingMessageMetadata) {
            this.message = message;
            this.skipPush = skipPush;
            this.isPendingMessage = isPendingMessage;
            this.pending = pending;
            this.forceModeration = forceModeration;
            this.pendingMessageMetadata = pendingMessageMetadata;
        }

        public static class MessageSendRequest
        extends StreamRequest<MessageSendResponse> {
            private MessageRequestObject message;
            private Boolean skipPush;
            private Boolean isPendingMessage;
            private Boolean pending;
            private Boolean forceModeration;
            private Map<String, Object> pendingMessageMetadata;
            @NotNull
            private String channelId;
            @NotNull
            private String channelType;

            private MessageSendRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<MessageSendResponse> generateCall(Client client) {
                return client.create(MessageService.class).send(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="message")
            public MessageSendRequest message(@Nullable MessageRequestObject message) {
                this.message = message;
                return this;
            }

            @JsonProperty(value="skip_push")
            public MessageSendRequest skipPush(@Nullable Boolean skipPush) {
                this.skipPush = skipPush;
                return this;
            }

            @JsonProperty(value="is_pending_message")
            public MessageSendRequest isPendingMessage(@Nullable Boolean isPendingMessage) {
                this.isPendingMessage = isPendingMessage;
                return this;
            }

            @JsonProperty(value="pending")
            public MessageSendRequest pending(@Nullable Boolean pending) {
                this.pending = pending;
                return this;
            }

            @JsonProperty(value="force_moderation")
            public MessageSendRequest forceModeration(@Nullable Boolean forceModeration) {
                this.forceModeration = forceModeration;
                return this;
            }

            @JsonProperty(value="pending_message_metadata")
            public MessageSendRequest pendingMessageMetadata(@Nullable Map<String, Object> pendingMessageMetadata) {
                this.pendingMessageMetadata = pendingMessageMetadata;
                return this;
            }

            public MessageSendRequestData internalBuild() {
                return new MessageSendRequestData(this.message, this.skipPush, this.isPendingMessage, this.pending, this.forceModeration, this.pendingMessageMetadata);
            }

            public String toString() {
                return "Message.MessageSendRequestData.MessageSendRequest(message=" + this.message + ", skipPush=" + this.skipPush + ", isPendingMessage=" + this.isPendingMessage + ", pending=" + this.pending + ", forceModeration=" + this.forceModeration + ", pendingMessageMetadata=" + this.pendingMessageMetadata + ")";
            }
        }
    }

    public static class ModerationRequestObject {
        @JsonProperty(value="toxic")
        @Nullable
        private Integer toxic;
        @JsonProperty(value="explicit")
        @Nullable
        private Integer explicit;
        @JsonProperty(value="spam")
        @Nullable
        private Integer spam;

        @Nullable
        public static ModerationRequestObject buildFrom(@Nullable Moderation moderation) {
            return RequestObjectBuilder.build(ModerationRequestObject.class, moderation);
        }

        ModerationRequestObject(@Nullable Integer toxic, @Nullable Integer explicit, @Nullable Integer spam) {
            this.toxic = toxic;
            this.explicit = explicit;
            this.spam = spam;
        }

        public static ModerationRequestObjectBuilder builder() {
            return new ModerationRequestObjectBuilder();
        }

        @JsonProperty(value="toxic")
        public void setToxic(@Nullable Integer toxic) {
            this.toxic = toxic;
        }

        @JsonProperty(value="explicit")
        public void setExplicit(@Nullable Integer explicit) {
            this.explicit = explicit;
        }

        @JsonProperty(value="spam")
        public void setSpam(@Nullable Integer spam) {
            this.spam = spam;
        }

        public static class ModerationRequestObjectBuilder {
            private Integer toxic;
            private Integer explicit;
            private Integer spam;

            ModerationRequestObjectBuilder() {
            }

            @JsonProperty(value="toxic")
            public ModerationRequestObjectBuilder toxic(@Nullable Integer toxic) {
                this.toxic = toxic;
                return this;
            }

            @JsonProperty(value="explicit")
            public ModerationRequestObjectBuilder explicit(@Nullable Integer explicit) {
                this.explicit = explicit;
                return this;
            }

            @JsonProperty(value="spam")
            public ModerationRequestObjectBuilder spam(@Nullable Integer spam) {
                this.spam = spam;
                return this;
            }

            public ModerationRequestObject build() {
                return new ModerationRequestObject(this.toxic, this.explicit, this.spam);
            }

            public String toString() {
                return "Message.ModerationRequestObject.ModerationRequestObjectBuilder(toxic=" + this.toxic + ", explicit=" + this.explicit + ", spam=" + this.spam + ")";
            }
        }
    }

    public static class ImageSizeRequestObject {
        @JsonProperty(value="crop")
        @Nullable
        private Crop crop;
        @JsonProperty(value="resize")
        @Nullable
        private Resize resize;
        @JsonProperty(value="height")
        @Nullable
        private Integer height;
        @JsonProperty(value="width")
        @Nullable
        private Integer width;

        @Nullable
        public static ImageSizeRequestObject buildFrom(@Nullable ImageSize imageSize) {
            return RequestObjectBuilder.build(ImageSizeRequestObject.class, imageSize);
        }

        ImageSizeRequestObject(@Nullable Crop crop, @Nullable Resize resize, @Nullable Integer height, @Nullable Integer width) {
            this.crop = crop;
            this.resize = resize;
            this.height = height;
            this.width = width;
        }

        public static ImageSizeRequestObjectBuilder builder() {
            return new ImageSizeRequestObjectBuilder();
        }

        @JsonProperty(value="crop")
        public void setCrop(@Nullable Crop crop) {
            this.crop = crop;
        }

        @JsonProperty(value="resize")
        public void setResize(@Nullable Resize resize) {
            this.resize = resize;
        }

        @JsonProperty(value="height")
        public void setHeight(@Nullable Integer height) {
            this.height = height;
        }

        @JsonProperty(value="width")
        public void setWidth(@Nullable Integer width) {
            this.width = width;
        }

        public static class ImageSizeRequestObjectBuilder {
            private Crop crop;
            private Resize resize;
            private Integer height;
            private Integer width;

            ImageSizeRequestObjectBuilder() {
            }

            @JsonProperty(value="crop")
            public ImageSizeRequestObjectBuilder crop(@Nullable Crop crop) {
                this.crop = crop;
                return this;
            }

            @JsonProperty(value="resize")
            public ImageSizeRequestObjectBuilder resize(@Nullable Resize resize) {
                this.resize = resize;
                return this;
            }

            @JsonProperty(value="height")
            public ImageSizeRequestObjectBuilder height(@Nullable Integer height) {
                this.height = height;
                return this;
            }

            @JsonProperty(value="width")
            public ImageSizeRequestObjectBuilder width(@Nullable Integer width) {
                this.width = width;
                return this;
            }

            public ImageSizeRequestObject build() {
                return new ImageSizeRequestObject(this.crop, this.resize, this.height, this.width);
            }

            public String toString() {
                return "Message.ImageSizeRequestObject.ImageSizeRequestObjectBuilder(crop=" + this.crop + ", resize=" + this.resize + ", height=" + this.height + ", width=" + this.width + ")";
            }
        }
    }

    public static class FieldRequestObject {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="value")
        @Nullable
        private String value;
        @JsonProperty(value="short")
        @Nullable
        private Boolean shortField;

        @Nullable
        public static FieldRequestObject buildFrom(@Nullable Field field) {
            return RequestObjectBuilder.build(FieldRequestObject.class, field);
        }

        FieldRequestObject(@Nullable String type, @Nullable String value, @Nullable Boolean shortField) {
            this.type = type;
            this.value = value;
            this.shortField = shortField;
        }

        public static FieldRequestObjectBuilder builder() {
            return new FieldRequestObjectBuilder();
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="value")
        public void setValue(@Nullable String value) {
            this.value = value;
        }

        @JsonProperty(value="short")
        public void setShortField(@Nullable Boolean shortField) {
            this.shortField = shortField;
        }

        public static class FieldRequestObjectBuilder {
            private String type;
            private String value;
            private Boolean shortField;

            FieldRequestObjectBuilder() {
            }

            @JsonProperty(value="type")
            public FieldRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="value")
            public FieldRequestObjectBuilder value(@Nullable String value) {
                this.value = value;
                return this;
            }

            @JsonProperty(value="short")
            public FieldRequestObjectBuilder shortField(@Nullable Boolean shortField) {
                this.shortField = shortField;
                return this;
            }

            public FieldRequestObject build() {
                return new FieldRequestObject(this.type, this.value, this.shortField);
            }

            public String toString() {
                return "Message.FieldRequestObject.FieldRequestObjectBuilder(type=" + this.type + ", value=" + this.value + ", shortField=" + this.shortField + ")";
            }
        }
    }

    public static class ActionRequestObject {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="text")
        @Nullable
        private String text;
        @JsonProperty(value="style")
        @Nullable
        private String style;
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="value")
        @Nullable
        private String value;

        @Nullable
        public static ActionRequestObject buildFrom(@Nullable Action action) {
            return RequestObjectBuilder.build(ActionRequestObject.class, action);
        }

        ActionRequestObject(@Nullable String name, @Nullable String text, @Nullable String style, @Nullable String type, @Nullable String value) {
            this.name = name;
            this.text = text;
            this.style = style;
            this.type = type;
            this.value = value;
        }

        public static ActionRequestObjectBuilder builder() {
            return new ActionRequestObjectBuilder();
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="text")
        public void setText(@Nullable String text) {
            this.text = text;
        }

        @JsonProperty(value="style")
        public void setStyle(@Nullable String style) {
            this.style = style;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="value")
        public void setValue(@Nullable String value) {
            this.value = value;
        }

        public static class ActionRequestObjectBuilder {
            private String name;
            private String text;
            private String style;
            private String type;
            private String value;

            ActionRequestObjectBuilder() {
            }

            @JsonProperty(value="name")
            public ActionRequestObjectBuilder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="text")
            public ActionRequestObjectBuilder text(@Nullable String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="style")
            public ActionRequestObjectBuilder style(@Nullable String style) {
                this.style = style;
                return this;
            }

            @JsonProperty(value="type")
            public ActionRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="value")
            public ActionRequestObjectBuilder value(@Nullable String value) {
                this.value = value;
                return this;
            }

            public ActionRequestObject build() {
                return new ActionRequestObject(this.name, this.text, this.style, this.type, this.value);
            }

            public String toString() {
                return "Message.ActionRequestObject.ActionRequestObjectBuilder(name=" + this.name + ", text=" + this.text + ", style=" + this.style + ", type=" + this.type + ", value=" + this.value + ")";
            }
        }
    }

    public static class AttachmentRequestObject {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="fallback")
        @Nullable
        private String fallback;
        @JsonProperty(value="color")
        @Nullable
        private String color;
        @JsonProperty(value="pretext")
        @Nullable
        private String pretext;
        @JsonProperty(value="author_name")
        @Nullable
        private String authorName;
        @JsonProperty(value="author_link")
        @Nullable
        private String authorLink;
        @JsonProperty(value="author_icon")
        @Nullable
        private String authorIcon;
        @JsonProperty(value="title")
        @Nullable
        private String title;
        @JsonProperty(value="title_link")
        @Nullable
        private String titleLink;
        @JsonProperty(value="text")
        @Nullable
        private String text;
        @JsonProperty(value="image_url")
        @Nullable
        private String imageURL;
        @JsonProperty(value="thumb_url")
        @Nullable
        private String thumbURL;
        @JsonProperty(value="footer")
        @Nullable
        private String footer;
        @JsonProperty(value="footer_icon")
        @Nullable
        private String footerIcon;
        @JsonProperty(value="actions")
        @Nullable
        private List<ActionRequestObject> actions;
        @JsonProperty(value="fields")
        @Nullable
        private List<FieldRequestObject> fields;
        @JsonProperty(value="asset_url")
        @Nullable
        private String assetURL;
        @JsonProperty(value="og_scrape_url")
        @Nullable
        private String ogScrapeURL;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static AttachmentRequestObject buildFrom(@Nullable Attachment attachment) {
            return RequestObjectBuilder.build(AttachmentRequestObject.class, attachment);
        }

        AttachmentRequestObject(@Nullable String type, @Nullable String fallback, @Nullable String color, @Nullable String pretext, @Nullable String authorName, @Nullable String authorLink, @Nullable String authorIcon, @Nullable String title, @Nullable String titleLink, @Nullable String text, @Nullable String imageURL, @Nullable String thumbURL, @Nullable String footer, @Nullable String footerIcon, @Nullable List<ActionRequestObject> actions, @Nullable List<FieldRequestObject> fields, @Nullable String assetURL, @Nullable String ogScrapeURL, @Nullable Map<String, Object> additionalFields) {
            this.type = type;
            this.fallback = fallback;
            this.color = color;
            this.pretext = pretext;
            this.authorName = authorName;
            this.authorLink = authorLink;
            this.authorIcon = authorIcon;
            this.title = title;
            this.titleLink = titleLink;
            this.text = text;
            this.imageURL = imageURL;
            this.thumbURL = thumbURL;
            this.footer = footer;
            this.footerIcon = footerIcon;
            this.actions = actions;
            this.fields = fields;
            this.assetURL = assetURL;
            this.ogScrapeURL = ogScrapeURL;
            this.additionalFields = additionalFields;
        }

        public static AttachmentRequestObjectBuilder builder() {
            return new AttachmentRequestObjectBuilder();
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="fallback")
        public void setFallback(@Nullable String fallback) {
            this.fallback = fallback;
        }

        @JsonProperty(value="color")
        public void setColor(@Nullable String color) {
            this.color = color;
        }

        @JsonProperty(value="pretext")
        public void setPretext(@Nullable String pretext) {
            this.pretext = pretext;
        }

        @JsonProperty(value="author_name")
        public void setAuthorName(@Nullable String authorName) {
            this.authorName = authorName;
        }

        @JsonProperty(value="author_link")
        public void setAuthorLink(@Nullable String authorLink) {
            this.authorLink = authorLink;
        }

        @JsonProperty(value="author_icon")
        public void setAuthorIcon(@Nullable String authorIcon) {
            this.authorIcon = authorIcon;
        }

        @JsonProperty(value="title")
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty(value="title_link")
        public void setTitleLink(@Nullable String titleLink) {
            this.titleLink = titleLink;
        }

        @JsonProperty(value="text")
        public void setText(@Nullable String text) {
            this.text = text;
        }

        @JsonProperty(value="image_url")
        public void setImageURL(@Nullable String imageURL) {
            this.imageURL = imageURL;
        }

        @JsonProperty(value="thumb_url")
        public void setThumbURL(@Nullable String thumbURL) {
            this.thumbURL = thumbURL;
        }

        @JsonProperty(value="footer")
        public void setFooter(@Nullable String footer) {
            this.footer = footer;
        }

        @JsonProperty(value="footer_icon")
        public void setFooterIcon(@Nullable String footerIcon) {
            this.footerIcon = footerIcon;
        }

        @JsonProperty(value="actions")
        public void setActions(@Nullable List<ActionRequestObject> actions) {
            this.actions = actions;
        }

        @JsonProperty(value="fields")
        public void setFields(@Nullable List<FieldRequestObject> fields) {
            this.fields = fields;
        }

        @JsonProperty(value="asset_url")
        public void setAssetURL(@Nullable String assetURL) {
            this.assetURL = assetURL;
        }

        @JsonProperty(value="og_scrape_url")
        public void setOgScrapeURL(@Nullable String ogScrapeURL) {
            this.ogScrapeURL = ogScrapeURL;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        public static class AttachmentRequestObjectBuilder {
            private String type;
            private String fallback;
            private String color;
            private String pretext;
            private String authorName;
            private String authorLink;
            private String authorIcon;
            private String title;
            private String titleLink;
            private String text;
            private String imageURL;
            private String thumbURL;
            private String footer;
            private String footerIcon;
            private ArrayList<ActionRequestObject> actions;
            private ArrayList<FieldRequestObject> fields;
            private String assetURL;
            private String ogScrapeURL;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            AttachmentRequestObjectBuilder() {
            }

            @JsonProperty(value="type")
            public AttachmentRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="fallback")
            public AttachmentRequestObjectBuilder fallback(@Nullable String fallback) {
                this.fallback = fallback;
                return this;
            }

            @JsonProperty(value="color")
            public AttachmentRequestObjectBuilder color(@Nullable String color) {
                this.color = color;
                return this;
            }

            @JsonProperty(value="pretext")
            public AttachmentRequestObjectBuilder pretext(@Nullable String pretext) {
                this.pretext = pretext;
                return this;
            }

            @JsonProperty(value="author_name")
            public AttachmentRequestObjectBuilder authorName(@Nullable String authorName) {
                this.authorName = authorName;
                return this;
            }

            @JsonProperty(value="author_link")
            public AttachmentRequestObjectBuilder authorLink(@Nullable String authorLink) {
                this.authorLink = authorLink;
                return this;
            }

            @JsonProperty(value="author_icon")
            public AttachmentRequestObjectBuilder authorIcon(@Nullable String authorIcon) {
                this.authorIcon = authorIcon;
                return this;
            }

            @JsonProperty(value="title")
            public AttachmentRequestObjectBuilder title(@Nullable String title) {
                this.title = title;
                return this;
            }

            @JsonProperty(value="title_link")
            public AttachmentRequestObjectBuilder titleLink(@Nullable String titleLink) {
                this.titleLink = titleLink;
                return this;
            }

            @JsonProperty(value="text")
            public AttachmentRequestObjectBuilder text(@Nullable String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="image_url")
            public AttachmentRequestObjectBuilder imageURL(@Nullable String imageURL) {
                this.imageURL = imageURL;
                return this;
            }

            @JsonProperty(value="thumb_url")
            public AttachmentRequestObjectBuilder thumbURL(@Nullable String thumbURL) {
                this.thumbURL = thumbURL;
                return this;
            }

            @JsonProperty(value="footer")
            public AttachmentRequestObjectBuilder footer(@Nullable String footer) {
                this.footer = footer;
                return this;
            }

            @JsonProperty(value="footer_icon")
            public AttachmentRequestObjectBuilder footerIcon(@Nullable String footerIcon) {
                this.footerIcon = footerIcon;
                return this;
            }

            public AttachmentRequestObjectBuilder action(ActionRequestObject action) {
                if (this.actions == null) {
                    this.actions = new ArrayList();
                }
                this.actions.add(action);
                return this;
            }

            @JsonProperty(value="actions")
            public AttachmentRequestObjectBuilder actions(Collection<? extends ActionRequestObject> actions) {
                if (actions == null) {
                    throw new NullPointerException("actions cannot be null");
                }
                if (this.actions == null) {
                    this.actions = new ArrayList();
                }
                this.actions.addAll(actions);
                return this;
            }

            public AttachmentRequestObjectBuilder clearActions() {
                if (this.actions != null) {
                    this.actions.clear();
                }
                return this;
            }

            public AttachmentRequestObjectBuilder field(FieldRequestObject field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            @JsonProperty(value="fields")
            public AttachmentRequestObjectBuilder fields(Collection<? extends FieldRequestObject> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            public AttachmentRequestObjectBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            @JsonProperty(value="asset_url")
            public AttachmentRequestObjectBuilder assetURL(@Nullable String assetURL) {
                this.assetURL = assetURL;
                return this;
            }

            @JsonProperty(value="og_scrape_url")
            public AttachmentRequestObjectBuilder ogScrapeURL(@Nullable String ogScrapeURL) {
                this.ogScrapeURL = ogScrapeURL;
                return this;
            }

            public AttachmentRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public AttachmentRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public AttachmentRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public AttachmentRequestObject build() {
                Map<Object, Object> additionalFields;
                List<FieldRequestObject> fields;
                List<ActionRequestObject> actions;
                switch (this.actions == null ? 0 : this.actions.size()) {
                    case 0: {
                        actions = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        actions = Collections.singletonList(this.actions.get(0));
                        break;
                    }
                    default: {
                        actions = Collections.unmodifiableList(new ArrayList<ActionRequestObject>(this.actions));
                    }
                }
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        fields = Collections.singletonList(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = Collections.unmodifiableList(new ArrayList<FieldRequestObject>(this.fields));
                    }
                }
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new AttachmentRequestObject(this.type, this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageURL, this.thumbURL, this.footer, this.footerIcon, actions, fields, this.assetURL, this.ogScrapeURL, additionalFields);
            }

            public String toString() {
                return "Message.AttachmentRequestObject.AttachmentRequestObjectBuilder(type=" + this.type + ", fallback=" + this.fallback + ", color=" + this.color + ", pretext=" + this.pretext + ", authorName=" + this.authorName + ", authorLink=" + this.authorLink + ", authorIcon=" + this.authorIcon + ", title=" + this.title + ", titleLink=" + this.titleLink + ", text=" + this.text + ", imageURL=" + this.imageURL + ", thumbURL=" + this.thumbURL + ", footer=" + this.footer + ", footerIcon=" + this.footerIcon + ", actions=" + this.actions + ", fields=" + this.fields + ", assetURL=" + this.assetURL + ", ogScrapeURL=" + this.ogScrapeURL + ", additionalFields$key=" + this.additionalFields$key + ", additionalFields$value=" + this.additionalFields$value + ")";
            }
        }
    }

    public static class MessageRequestObject {
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="text")
        @Nullable
        private String text;
        @JsonProperty(value="type")
        @Nullable
        private MessageType type;
        @JsonProperty(value="mml")
        @Nullable
        private String mml;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="parent_id")
        @Nullable
        private String parentId;
        @JsonProperty(value="attachments")
        @Nullable
        private List<AttachmentRequestObject> attachments;
        @JsonProperty(value="show_in_channel")
        @Nullable
        private Boolean showInChannel;
        @JsonProperty(value="mentioned_users")
        @Nullable
        private List<String> mentionedUsers;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="html")
        @Nullable
        private String html;
        @JsonProperty(value="reaction_scores")
        @Nullable
        private Map<String, Integer> reactionScores;
        @JsonProperty(value="quoted_message_id")
        @Nullable
        private String quotedMessageId;
        @JsonProperty(value="cid")
        @Nullable
        private String cId;
        @JsonProperty(value="silent")
        @Nullable
        private Boolean silent;
        @JsonProperty(value="pinned")
        @Nullable
        private Boolean pinned;
        @JsonProperty(value="pin_expires")
        @Nullable
        private Date pinExpires;
        @JsonProperty(value="pinned_by")
        @Nullable
        private User.UserRequestObject pinnedBy;
        @JsonProperty(value="pinned_at")
        @Nullable
        private Date pinnedAt;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static MessageRequestObject buildFrom(@Nullable Message message) {
            return RequestObjectBuilder.build(MessageRequestObject.class, message);
        }

        MessageRequestObject(@Nullable String id, @Nullable String text, @Nullable MessageType type, @Nullable String mml, @Nullable User.UserRequestObject user, @Nullable String parentId, @Nullable List<AttachmentRequestObject> attachments, @Nullable Boolean showInChannel, @Nullable List<String> mentionedUsers, @Nullable String userId, @Nullable String html, @Nullable Map<String, Integer> reactionScores, @Nullable String quotedMessageId, @Nullable String cId, @Nullable Boolean silent, @Nullable Boolean pinned, @Nullable Date pinExpires, @Nullable User.UserRequestObject pinnedBy, @Nullable Date pinnedAt, @Nullable Map<String, Object> additionalFields) {
            this.id = id;
            this.text = text;
            this.type = type;
            this.mml = mml;
            this.user = user;
            this.parentId = parentId;
            this.attachments = attachments;
            this.showInChannel = showInChannel;
            this.mentionedUsers = mentionedUsers;
            this.userId = userId;
            this.html = html;
            this.reactionScores = reactionScores;
            this.quotedMessageId = quotedMessageId;
            this.cId = cId;
            this.silent = silent;
            this.pinned = pinned;
            this.pinExpires = pinExpires;
            this.pinnedBy = pinnedBy;
            this.pinnedAt = pinnedAt;
            this.additionalFields = additionalFields;
        }

        public static MessageRequestObjectBuilder builder() {
            return new MessageRequestObjectBuilder();
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="text")
        public void setText(@Nullable String text) {
            this.text = text;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable MessageType type) {
            this.type = type;
        }

        @JsonProperty(value="mml")
        public void setMml(@Nullable String mml) {
            this.mml = mml;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User.UserRequestObject user) {
            this.user = user;
        }

        @JsonProperty(value="parent_id")
        public void setParentId(@Nullable String parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="attachments")
        public void setAttachments(@Nullable List<AttachmentRequestObject> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="show_in_channel")
        public void setShowInChannel(@Nullable Boolean showInChannel) {
            this.showInChannel = showInChannel;
        }

        @JsonProperty(value="mentioned_users")
        public void setMentionedUsers(@Nullable List<String> mentionedUsers) {
            this.mentionedUsers = mentionedUsers;
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="html")
        public void setHtml(@Nullable String html) {
            this.html = html;
        }

        @JsonProperty(value="reaction_scores")
        public void setReactionScores(@Nullable Map<String, Integer> reactionScores) {
            this.reactionScores = reactionScores;
        }

        @JsonProperty(value="quoted_message_id")
        public void setQuotedMessageId(@Nullable String quotedMessageId) {
            this.quotedMessageId = quotedMessageId;
        }

        @JsonProperty(value="cid")
        public void setCId(@Nullable String cId) {
            this.cId = cId;
        }

        @JsonProperty(value="silent")
        public void setSilent(@Nullable Boolean silent) {
            this.silent = silent;
        }

        @JsonProperty(value="pinned")
        public void setPinned(@Nullable Boolean pinned) {
            this.pinned = pinned;
        }

        @JsonProperty(value="pin_expires")
        public void setPinExpires(@Nullable Date pinExpires) {
            this.pinExpires = pinExpires;
        }

        @JsonProperty(value="pinned_by")
        public void setPinnedBy(@Nullable User.UserRequestObject pinnedBy) {
            this.pinnedBy = pinnedBy;
        }

        @JsonProperty(value="pinned_at")
        public void setPinnedAt(@Nullable Date pinnedAt) {
            this.pinnedAt = pinnedAt;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        public static class MessageRequestObjectBuilder {
            private String id;
            private String text;
            private MessageType type;
            private String mml;
            private User.UserRequestObject user;
            private String parentId;
            private ArrayList<AttachmentRequestObject> attachments;
            private Boolean showInChannel;
            private List<String> mentionedUsers;
            private String userId;
            private String html;
            private ArrayList<String> reactionScores$key;
            private ArrayList<Integer> reactionScores$value;
            private String quotedMessageId;
            private String cId;
            private Boolean silent;
            private Boolean pinned;
            private Date pinExpires;
            private User.UserRequestObject pinnedBy;
            private Date pinnedAt;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            MessageRequestObjectBuilder() {
            }

            @JsonProperty(value="id")
            public MessageRequestObjectBuilder id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="text")
            public MessageRequestObjectBuilder text(@Nullable String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="type")
            public MessageRequestObjectBuilder type(@Nullable MessageType type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="mml")
            public MessageRequestObjectBuilder mml(@Nullable String mml) {
                this.mml = mml;
                return this;
            }

            @JsonProperty(value="user")
            public MessageRequestObjectBuilder user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="parent_id")
            public MessageRequestObjectBuilder parentId(@Nullable String parentId) {
                this.parentId = parentId;
                return this;
            }

            public MessageRequestObjectBuilder attachment(AttachmentRequestObject attachment) {
                if (this.attachments == null) {
                    this.attachments = new ArrayList();
                }
                this.attachments.add(attachment);
                return this;
            }

            @JsonProperty(value="attachments")
            public MessageRequestObjectBuilder attachments(Collection<? extends AttachmentRequestObject> attachments) {
                if (attachments == null) {
                    throw new NullPointerException("attachments cannot be null");
                }
                if (this.attachments == null) {
                    this.attachments = new ArrayList();
                }
                this.attachments.addAll(attachments);
                return this;
            }

            public MessageRequestObjectBuilder clearAttachments() {
                if (this.attachments != null) {
                    this.attachments.clear();
                }
                return this;
            }

            @JsonProperty(value="show_in_channel")
            public MessageRequestObjectBuilder showInChannel(@Nullable Boolean showInChannel) {
                this.showInChannel = showInChannel;
                return this;
            }

            @JsonProperty(value="mentioned_users")
            public MessageRequestObjectBuilder mentionedUsers(@Nullable List<String> mentionedUsers) {
                this.mentionedUsers = mentionedUsers;
                return this;
            }

            @JsonProperty(value="user_id")
            public MessageRequestObjectBuilder userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="html")
            public MessageRequestObjectBuilder html(@Nullable String html) {
                this.html = html;
                return this;
            }

            public MessageRequestObjectBuilder reactionScore(String reactionScoreKey, Integer reactionScoreValue) {
                if (this.reactionScores$key == null) {
                    this.reactionScores$key = new ArrayList();
                    this.reactionScores$value = new ArrayList();
                }
                this.reactionScores$key.add(reactionScoreKey);
                this.reactionScores$value.add(reactionScoreValue);
                return this;
            }

            @JsonProperty(value="reaction_scores")
            public MessageRequestObjectBuilder reactionScores(Map<? extends String, ? extends Integer> reactionScores) {
                if (reactionScores == null) {
                    throw new NullPointerException("reactionScores cannot be null");
                }
                if (this.reactionScores$key == null) {
                    this.reactionScores$key = new ArrayList();
                    this.reactionScores$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Integer> $lombokEntry : reactionScores.entrySet()) {
                    this.reactionScores$key.add($lombokEntry.getKey());
                    this.reactionScores$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public MessageRequestObjectBuilder clearReactionScores() {
                if (this.reactionScores$key != null) {
                    this.reactionScores$key.clear();
                    this.reactionScores$value.clear();
                }
                return this;
            }

            @JsonProperty(value="quoted_message_id")
            public MessageRequestObjectBuilder quotedMessageId(@Nullable String quotedMessageId) {
                this.quotedMessageId = quotedMessageId;
                return this;
            }

            @JsonProperty(value="cid")
            public MessageRequestObjectBuilder cId(@Nullable String cId) {
                this.cId = cId;
                return this;
            }

            @JsonProperty(value="silent")
            public MessageRequestObjectBuilder silent(@Nullable Boolean silent) {
                this.silent = silent;
                return this;
            }

            @JsonProperty(value="pinned")
            public MessageRequestObjectBuilder pinned(@Nullable Boolean pinned) {
                this.pinned = pinned;
                return this;
            }

            @JsonProperty(value="pin_expires")
            public MessageRequestObjectBuilder pinExpires(@Nullable Date pinExpires) {
                this.pinExpires = pinExpires;
                return this;
            }

            @JsonProperty(value="pinned_by")
            public MessageRequestObjectBuilder pinnedBy(@Nullable User.UserRequestObject pinnedBy) {
                this.pinnedBy = pinnedBy;
                return this;
            }

            @JsonProperty(value="pinned_at")
            public MessageRequestObjectBuilder pinnedAt(@Nullable Date pinnedAt) {
                this.pinnedAt = pinnedAt;
                return this;
            }

            public MessageRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public MessageRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public MessageRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public MessageRequestObject build() {
                Map<Object, Object> additionalFields;
                Map<Object, Object> reactionScores;
                List<AttachmentRequestObject> attachments;
                switch (this.attachments == null ? 0 : this.attachments.size()) {
                    case 0: {
                        attachments = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        attachments = Collections.singletonList(this.attachments.get(0));
                        break;
                    }
                    default: {
                        attachments = Collections.unmodifiableList(new ArrayList<AttachmentRequestObject>(this.attachments));
                    }
                }
                switch (this.reactionScores$key == null ? 0 : this.reactionScores$key.size()) {
                    case 0: {
                        reactionScores = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        reactionScores = Collections.singletonMap(this.reactionScores$key.get(0), this.reactionScores$value.get(0));
                        break;
                    }
                    default: {
                        reactionScores = new LinkedHashMap(this.reactionScores$key.size() < 0x40000000 ? 1 + this.reactionScores$key.size() + (this.reactionScores$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.reactionScores$key.size(); ++$i) {
                            reactionScores.put(this.reactionScores$key.get($i), this.reactionScores$value.get($i));
                        }
                        reactionScores = Collections.unmodifiableMap(reactionScores);
                    }
                }
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new MessageRequestObject(this.id, this.text, this.type, this.mml, this.user, this.parentId, attachments, this.showInChannel, this.mentionedUsers, this.userId, this.html, reactionScores, this.quotedMessageId, this.cId, this.silent, this.pinned, this.pinExpires, this.pinnedBy, this.pinnedAt, additionalFields);
            }

            public String toString() {
                return "Message.MessageRequestObject.MessageRequestObjectBuilder(id=" + this.id + ", text=" + this.text + ", type=" + this.type + ", mml=" + this.mml + ", user=" + this.user + ", parentId=" + this.parentId + ", attachments=" + this.attachments + ", showInChannel=" + this.showInChannel + ", mentionedUsers=" + this.mentionedUsers + ", userId=" + this.userId + ", html=" + this.html + ", reactionScores$key=" + this.reactionScores$key + ", reactionScores$value=" + this.reactionScores$value + ", quotedMessageId=" + this.quotedMessageId + ", cId=" + this.cId + ", silent=" + this.silent + ", pinned=" + this.pinned + ", pinExpires=" + this.pinExpires + ", pinnedBy=" + this.pinnedBy + ", pinnedAt=" + this.pinnedAt + ", additionalFields$key=" + this.additionalFields$key + ", additionalFields$value=" + this.additionalFields$value + ")";
            }
        }
    }

    public static class Moderation {
        @JsonProperty(value="toxic")
        @Nullable
        private Integer toxic;
        @JsonProperty(value="explicit")
        @Nullable
        private Integer explicit;
        @JsonProperty(value="spam")
        @Nullable
        private Integer spam;

        @Nullable
        public Integer getToxic() {
            return this.toxic;
        }

        @Nullable
        public Integer getExplicit() {
            return this.explicit;
        }

        @Nullable
        public Integer getSpam() {
            return this.spam;
        }

        @JsonProperty(value="toxic")
        public void setToxic(@Nullable Integer toxic) {
            this.toxic = toxic;
        }

        @JsonProperty(value="explicit")
        public void setExplicit(@Nullable Integer explicit) {
            this.explicit = explicit;
        }

        @JsonProperty(value="spam")
        public void setSpam(@Nullable Integer spam) {
            this.spam = spam;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Moderation)) {
                return false;
            }
            Moderation other = (Moderation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$toxic = this.getToxic();
            Integer other$toxic = other.getToxic();
            if (this$toxic == null ? other$toxic != null : !((Object)this$toxic).equals(other$toxic)) {
                return false;
            }
            Integer this$explicit = this.getExplicit();
            Integer other$explicit = other.getExplicit();
            if (this$explicit == null ? other$explicit != null : !((Object)this$explicit).equals(other$explicit)) {
                return false;
            }
            Integer this$spam = this.getSpam();
            Integer other$spam = other.getSpam();
            return !(this$spam == null ? other$spam != null : !((Object)this$spam).equals(other$spam));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Moderation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $toxic = this.getToxic();
            result = result * 59 + ($toxic == null ? 43 : ((Object)$toxic).hashCode());
            Integer $explicit = this.getExplicit();
            result = result * 59 + ($explicit == null ? 43 : ((Object)$explicit).hashCode());
            Integer $spam = this.getSpam();
            result = result * 59 + ($spam == null ? 43 : ((Object)$spam).hashCode());
            return result;
        }

        public String toString() {
            return "Message.Moderation(toxic=" + this.getToxic() + ", explicit=" + this.getExplicit() + ", spam=" + this.getSpam() + ")";
        }
    }

    public static enum Resize {
        CLIP,
        CROP,
        SCALE,
        FILL,
        UNKNOWN;

    }

    public static enum Crop {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        CENTER,
        UNKNOWN;

    }

    public static class ImageSize {
        @JsonProperty(value="crop")
        @Nullable
        private Crop crop;
        @JsonProperty(value="resize")
        @Nullable
        private Resize resize;
        @JsonProperty(value="height")
        @Nullable
        private Integer height;
        @JsonProperty(value="width")
        @Nullable
        private Integer width;

        @Nullable
        public Crop getCrop() {
            return this.crop;
        }

        @Nullable
        public Resize getResize() {
            return this.resize;
        }

        @Nullable
        public Integer getHeight() {
            return this.height;
        }

        @Nullable
        public Integer getWidth() {
            return this.width;
        }

        @JsonProperty(value="crop")
        public void setCrop(@Nullable Crop crop) {
            this.crop = crop;
        }

        @JsonProperty(value="resize")
        public void setResize(@Nullable Resize resize) {
            this.resize = resize;
        }

        @JsonProperty(value="height")
        public void setHeight(@Nullable Integer height) {
            this.height = height;
        }

        @JsonProperty(value="width")
        public void setWidth(@Nullable Integer width) {
            this.width = width;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageSize)) {
                return false;
            }
            ImageSize other = (ImageSize)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$height = this.getHeight();
            Integer other$height = other.getHeight();
            if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
                return false;
            }
            Integer this$width = this.getWidth();
            Integer other$width = other.getWidth();
            if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
                return false;
            }
            Crop this$crop = this.getCrop();
            Crop other$crop = other.getCrop();
            if (this$crop == null ? other$crop != null : !((Object)((Object)this$crop)).equals((Object)other$crop)) {
                return false;
            }
            Resize this$resize = this.getResize();
            Resize other$resize = other.getResize();
            return !(this$resize == null ? other$resize != null : !((Object)((Object)this$resize)).equals((Object)other$resize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImageSize;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $height = this.getHeight();
            result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
            Integer $width = this.getWidth();
            result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
            Crop $crop = this.getCrop();
            result = result * 59 + ($crop == null ? 43 : ((Object)((Object)$crop)).hashCode());
            Resize $resize = this.getResize();
            result = result * 59 + ($resize == null ? 43 : ((Object)((Object)$resize)).hashCode());
            return result;
        }

        public String toString() {
            return "Message.ImageSize(crop=" + this.getCrop() + ", resize=" + this.getResize() + ", height=" + this.getHeight() + ", width=" + this.getWidth() + ")";
        }
    }

    public static class SearchResultMessage
    extends Message {
        @JsonProperty(value="channel")
        @NotNull
        private Channel channel;

        @NotNull
        public Channel getChannel() {
            return this.channel;
        }

        @JsonProperty(value="channel")
        public void setChannel(@NotNull Channel channel) {
            if (channel == null) {
                throw new NullPointerException("channel is marked non-null but is null");
            }
            this.channel = channel;
        }

        @Override
        public String toString() {
            return "Message.SearchResultMessage(channel=" + this.getChannel() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchResultMessage)) {
                return false;
            }
            SearchResultMessage other = (SearchResultMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            return !(this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof SearchResultMessage;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            return result;
        }
    }

    public static class SearchResult {
        @JsonProperty(value="message")
        @NotNull
        private SearchResultMessage message;

        @NotNull
        public SearchResultMessage getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull SearchResultMessage message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchResult)) {
                return false;
            }
            SearchResult other = (SearchResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SearchResultMessage this$message = this.getMessage();
            SearchResultMessage other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SearchResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SearchResultMessage $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }

        public String toString() {
            return "Message.SearchResult(message=" + this.getMessage() + ")";
        }
    }

    public static class Field {
        @JsonProperty(value="type")
        @NotNull
        private String type;
        @JsonProperty(value="value")
        @NotNull
        private String value;
        @JsonProperty(value="short")
        @NotNull
        private Boolean shortField;

        @NotNull
        public String getType() {
            return this.type;
        }

        @NotNull
        public String getValue() {
            return this.value;
        }

        @NotNull
        public Boolean getShortField() {
            return this.shortField;
        }

        @JsonProperty(value="type")
        public void setType(@NotNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        @JsonProperty(value="value")
        public void setValue(@NotNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        @JsonProperty(value="short")
        public void setShortField(@NotNull Boolean shortField) {
            if (shortField == null) {
                throw new NullPointerException("shortField is marked non-null but is null");
            }
            this.shortField = shortField;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$shortField = this.getShortField();
            Boolean other$shortField = other.getShortField();
            if (this$shortField == null ? other$shortField != null : !((Object)this$shortField).equals(other$shortField)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Field;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $shortField = this.getShortField();
            result = result * 59 + ($shortField == null ? 43 : ((Object)$shortField).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "Message.Field(type=" + this.getType() + ", value=" + this.getValue() + ", shortField=" + this.getShortField() + ")";
        }
    }

    public static class Action {
        @JsonProperty(value="name")
        @NotNull
        private String name;
        @JsonProperty(value="text")
        @NotNull
        private String text;
        @JsonProperty(value="style")
        @NotNull
        private String style;
        @JsonProperty(value="type")
        @NotNull
        private String type;
        @JsonProperty(value="value")
        @NotNull
        private String value;

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getText() {
            return this.text;
        }

        @NotNull
        public String getStyle() {
            return this.style;
        }

        @NotNull
        public String getType() {
            return this.type;
        }

        @NotNull
        public String getValue() {
            return this.value;
        }

        @JsonProperty(value="name")
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @JsonProperty(value="text")
        public void setText(@NotNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
        }

        @JsonProperty(value="style")
        public void setStyle(@NotNull String style) {
            if (style == null) {
                throw new NullPointerException("style is marked non-null but is null");
            }
            this.style = style;
        }

        @JsonProperty(value="type")
        public void setType(@NotNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        @JsonProperty(value="value")
        public void setValue(@NotNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action other = (Action)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$style = this.getStyle();
            String other$style = other.getStyle();
            if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Action;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $style = this.getStyle();
            result = result * 59 + ($style == null ? 43 : $style.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "Message.Action(name=" + this.getName() + ", text=" + this.getText() + ", style=" + this.getStyle() + ", type=" + this.getType() + ", value=" + this.getValue() + ")";
        }
    }

    public static class Attachment {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="fallback")
        @Nullable
        private String fallback;
        @JsonProperty(value="color")
        @Nullable
        private String color;
        @JsonProperty(value="pretext")
        @Nullable
        private String pretext;
        @JsonProperty(value="author_name")
        @Nullable
        private String authorName;
        @JsonProperty(value="author_link")
        @Nullable
        private String authorLink;
        @JsonProperty(value="author_icon")
        @Nullable
        private String authorIcon;
        @JsonProperty(value="title")
        @Nullable
        private String title;
        @JsonProperty(value="title_link")
        @Nullable
        private String titleLink;
        @JsonProperty(value="text")
        @Nullable
        private String text;
        @JsonProperty(value="image_url")
        @Nullable
        private String imageURL;
        @JsonProperty(value="thumb_url")
        @Nullable
        private String thumbURL;
        @JsonProperty(value="footer")
        @Nullable
        private String footer;
        @JsonProperty(value="footer_icon")
        @Nullable
        private String footerIcon;
        @JsonProperty(value="actions")
        @Nullable
        private List<Action> actions;
        @JsonProperty(value="fields")
        @Nullable
        private List<Field> fields;
        @JsonProperty(value="asset_url")
        @Nullable
        private String assetURL;
        @JsonProperty(value="og_scrape_url")
        @Nullable
        private String ogScrapeURL;
        @JsonIgnore
        @NotNull
        private Map<String, Object> additionalFields = new HashMap<String, Object>();

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getFallback() {
            return this.fallback;
        }

        @Nullable
        public String getColor() {
            return this.color;
        }

        @Nullable
        public String getPretext() {
            return this.pretext;
        }

        @Nullable
        public String getAuthorName() {
            return this.authorName;
        }

        @Nullable
        public String getAuthorLink() {
            return this.authorLink;
        }

        @Nullable
        public String getAuthorIcon() {
            return this.authorIcon;
        }

        @Nullable
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public String getTitleLink() {
            return this.titleLink;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        @Nullable
        public String getImageURL() {
            return this.imageURL;
        }

        @Nullable
        public String getThumbURL() {
            return this.thumbURL;
        }

        @Nullable
        public String getFooter() {
            return this.footer;
        }

        @Nullable
        public String getFooterIcon() {
            return this.footerIcon;
        }

        @Nullable
        public List<Action> getActions() {
            return this.actions;
        }

        @Nullable
        public List<Field> getFields() {
            return this.fields;
        }

        @Nullable
        public String getAssetURL() {
            return this.assetURL;
        }

        @Nullable
        public String getOgScrapeURL() {
            return this.ogScrapeURL;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="fallback")
        public void setFallback(@Nullable String fallback) {
            this.fallback = fallback;
        }

        @JsonProperty(value="color")
        public void setColor(@Nullable String color) {
            this.color = color;
        }

        @JsonProperty(value="pretext")
        public void setPretext(@Nullable String pretext) {
            this.pretext = pretext;
        }

        @JsonProperty(value="author_name")
        public void setAuthorName(@Nullable String authorName) {
            this.authorName = authorName;
        }

        @JsonProperty(value="author_link")
        public void setAuthorLink(@Nullable String authorLink) {
            this.authorLink = authorLink;
        }

        @JsonProperty(value="author_icon")
        public void setAuthorIcon(@Nullable String authorIcon) {
            this.authorIcon = authorIcon;
        }

        @JsonProperty(value="title")
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty(value="title_link")
        public void setTitleLink(@Nullable String titleLink) {
            this.titleLink = titleLink;
        }

        @JsonProperty(value="text")
        public void setText(@Nullable String text) {
            this.text = text;
        }

        @JsonProperty(value="image_url")
        public void setImageURL(@Nullable String imageURL) {
            this.imageURL = imageURL;
        }

        @JsonProperty(value="thumb_url")
        public void setThumbURL(@Nullable String thumbURL) {
            this.thumbURL = thumbURL;
        }

        @JsonProperty(value="footer")
        public void setFooter(@Nullable String footer) {
            this.footer = footer;
        }

        @JsonProperty(value="footer_icon")
        public void setFooterIcon(@Nullable String footerIcon) {
            this.footerIcon = footerIcon;
        }

        @JsonProperty(value="actions")
        public void setActions(@Nullable List<Action> actions) {
            this.actions = actions;
        }

        @JsonProperty(value="fields")
        public void setFields(@Nullable List<Field> fields) {
            this.fields = fields;
        }

        @JsonProperty(value="asset_url")
        public void setAssetURL(@Nullable String assetURL) {
            this.assetURL = assetURL;
        }

        @JsonProperty(value="og_scrape_url")
        public void setOgScrapeURL(@Nullable String ogScrapeURL) {
            this.ogScrapeURL = ogScrapeURL;
        }

        @JsonIgnore
        public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
            if (additionalFields == null) {
                throw new NullPointerException("additionalFields is marked non-null but is null");
            }
            this.additionalFields = additionalFields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attachment)) {
                return false;
            }
            Attachment other = (Attachment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$fallback = this.getFallback();
            String other$fallback = other.getFallback();
            if (this$fallback == null ? other$fallback != null : !this$fallback.equals(other$fallback)) {
                return false;
            }
            String this$color = this.getColor();
            String other$color = other.getColor();
            if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
                return false;
            }
            String this$pretext = this.getPretext();
            String other$pretext = other.getPretext();
            if (this$pretext == null ? other$pretext != null : !this$pretext.equals(other$pretext)) {
                return false;
            }
            String this$authorName = this.getAuthorName();
            String other$authorName = other.getAuthorName();
            if (this$authorName == null ? other$authorName != null : !this$authorName.equals(other$authorName)) {
                return false;
            }
            String this$authorLink = this.getAuthorLink();
            String other$authorLink = other.getAuthorLink();
            if (this$authorLink == null ? other$authorLink != null : !this$authorLink.equals(other$authorLink)) {
                return false;
            }
            String this$authorIcon = this.getAuthorIcon();
            String other$authorIcon = other.getAuthorIcon();
            if (this$authorIcon == null ? other$authorIcon != null : !this$authorIcon.equals(other$authorIcon)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$titleLink = this.getTitleLink();
            String other$titleLink = other.getTitleLink();
            if (this$titleLink == null ? other$titleLink != null : !this$titleLink.equals(other$titleLink)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$imageURL = this.getImageURL();
            String other$imageURL = other.getImageURL();
            if (this$imageURL == null ? other$imageURL != null : !this$imageURL.equals(other$imageURL)) {
                return false;
            }
            String this$thumbURL = this.getThumbURL();
            String other$thumbURL = other.getThumbURL();
            if (this$thumbURL == null ? other$thumbURL != null : !this$thumbURL.equals(other$thumbURL)) {
                return false;
            }
            String this$footer = this.getFooter();
            String other$footer = other.getFooter();
            if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
                return false;
            }
            String this$footerIcon = this.getFooterIcon();
            String other$footerIcon = other.getFooterIcon();
            if (this$footerIcon == null ? other$footerIcon != null : !this$footerIcon.equals(other$footerIcon)) {
                return false;
            }
            List<Action> this$actions = this.getActions();
            List<Action> other$actions = other.getActions();
            if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
                return false;
            }
            List<Field> this$fields = this.getFields();
            List<Field> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            String this$assetURL = this.getAssetURL();
            String other$assetURL = other.getAssetURL();
            if (this$assetURL == null ? other$assetURL != null : !this$assetURL.equals(other$assetURL)) {
                return false;
            }
            String this$ogScrapeURL = this.getOgScrapeURL();
            String other$ogScrapeURL = other.getOgScrapeURL();
            if (this$ogScrapeURL == null ? other$ogScrapeURL != null : !this$ogScrapeURL.equals(other$ogScrapeURL)) {
                return false;
            }
            Map<String, Object> this$additionalFields = this.getAdditionalFields();
            Map<String, Object> other$additionalFields = other.getAdditionalFields();
            return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attachment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $fallback = this.getFallback();
            result = result * 59 + ($fallback == null ? 43 : $fallback.hashCode());
            String $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : $color.hashCode());
            String $pretext = this.getPretext();
            result = result * 59 + ($pretext == null ? 43 : $pretext.hashCode());
            String $authorName = this.getAuthorName();
            result = result * 59 + ($authorName == null ? 43 : $authorName.hashCode());
            String $authorLink = this.getAuthorLink();
            result = result * 59 + ($authorLink == null ? 43 : $authorLink.hashCode());
            String $authorIcon = this.getAuthorIcon();
            result = result * 59 + ($authorIcon == null ? 43 : $authorIcon.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $titleLink = this.getTitleLink();
            result = result * 59 + ($titleLink == null ? 43 : $titleLink.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $imageURL = this.getImageURL();
            result = result * 59 + ($imageURL == null ? 43 : $imageURL.hashCode());
            String $thumbURL = this.getThumbURL();
            result = result * 59 + ($thumbURL == null ? 43 : $thumbURL.hashCode());
            String $footer = this.getFooter();
            result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
            String $footerIcon = this.getFooterIcon();
            result = result * 59 + ($footerIcon == null ? 43 : $footerIcon.hashCode());
            List<Action> $actions = this.getActions();
            result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
            List<Field> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            String $assetURL = this.getAssetURL();
            result = result * 59 + ($assetURL == null ? 43 : $assetURL.hashCode());
            String $ogScrapeURL = this.getOgScrapeURL();
            result = result * 59 + ($ogScrapeURL == null ? 43 : $ogScrapeURL.hashCode());
            Map<String, Object> $additionalFields = this.getAdditionalFields();
            result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
            return result;
        }

        public String toString() {
            return "Message.Attachment(type=" + this.getType() + ", fallback=" + this.getFallback() + ", color=" + this.getColor() + ", pretext=" + this.getPretext() + ", authorName=" + this.getAuthorName() + ", authorLink=" + this.getAuthorLink() + ", authorIcon=" + this.getAuthorIcon() + ", title=" + this.getTitle() + ", titleLink=" + this.getTitleLink() + ", text=" + this.getText() + ", imageURL=" + this.getImageURL() + ", thumbURL=" + this.getThumbURL() + ", footer=" + this.getFooter() + ", footerIcon=" + this.getFooterIcon() + ", actions=" + this.getActions() + ", fields=" + this.getFields() + ", assetURL=" + this.getAssetURL() + ", ogScrapeURL=" + this.getOgScrapeURL() + ", additionalFields=" + this.getAdditionalFields() + ")";
        }
    }

    public static enum MessageType {
        REGULAR,
        EPHEMERAL,
        ERROR,
        REPLY,
        SYSTEM,
        DELETED,
        UNKNOWN;

    }
}

