/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.BlockUserService;
import io.getstream.chat.java.services.framework.Client;
import java.util.Date;
import java.util.List;
import shadowed.com.fasterxml.jackson.annotation.JsonProperty;
import shadowed.org.jetbrains.annotations.NotNull;
import shadowed.retrofit2.Call;

public class BlockUser {
    @NotNull
    public static BlockUserRequestData.BlockUserRequest blockUser() {
        return new BlockUserRequestData.BlockUserRequest();
    }

    @NotNull
    public static UnblockUserRequestData.UnblockUserRequest unblockUser() {
        return new UnblockUserRequestData.UnblockUserRequest();
    }

    @NotNull
    public static GetBlockedUsersRequestData.GetBlockedUsersRequest getBlockedUsers(String blockedByUserID) {
        return new GetBlockedUsersRequestData.GetBlockedUsersRequest(blockedByUserID);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockUser)) {
            return false;
        }
        BlockUser other = (BlockUser)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockUser;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BlockUser()";
    }

    public static class GetBlockedUsersRequestData {
        @JsonProperty(value="user_id")
        @NotNull
        private String blockedByUserID;

        GetBlockedUsersRequestData(@NotNull String blockedByUserID) {
            if (blockedByUserID == null) {
                throw new NullPointerException("blockedByUserID is marked non-null but is null");
            }
            this.blockedByUserID = blockedByUserID;
        }

        public static class GetBlockedUsersRequest
        extends StreamRequest<GetBlockedUsersResponse> {
            private String blockedByUserID;

            public GetBlockedUsersRequest(String blockedByUserID) {
                this.blockedByUserID = blockedByUserID;
            }

            @Override
            protected Call<GetBlockedUsersResponse> generateCall(Client client) {
                return client.create(BlockUserService.class).getBlockedUsers(this.blockedByUserID);
            }

            @JsonProperty(value="user_id")
            public GetBlockedUsersRequest blockedByUserID(@NotNull String blockedByUserID) {
                if (blockedByUserID == null) {
                    throw new NullPointerException("blockedByUserID is marked non-null but is null");
                }
                this.blockedByUserID = blockedByUserID;
                return this;
            }

            public GetBlockedUsersRequestData internalBuild() {
                return new GetBlockedUsersRequestData(this.blockedByUserID);
            }

            public String toString() {
                return "BlockUser.GetBlockedUsersRequestData.GetBlockedUsersRequest(blockedByUserID=" + this.blockedByUserID + ")";
            }
        }
    }

    public static class BlockedUserResponse {
        @JsonProperty(value="user")
        private User blockedByUser;
        @JsonProperty(value="user_id")
        private String blockedByUserID;
        @JsonProperty(value="blocked_user")
        private User blockedUser;
        @JsonProperty(value="blocked_user_id")
        private String blockedUserID;
        @JsonProperty(value="created_at")
        private Date createdAt;

        public User getBlockedByUser() {
            return this.blockedByUser;
        }

        public String getBlockedByUserID() {
            return this.blockedByUserID;
        }

        public User getBlockedUser() {
            return this.blockedUser;
        }

        public String getBlockedUserID() {
            return this.blockedUserID;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        @JsonProperty(value="user")
        public void setBlockedByUser(User blockedByUser) {
            this.blockedByUser = blockedByUser;
        }

        @JsonProperty(value="user_id")
        public void setBlockedByUserID(String blockedByUserID) {
            this.blockedByUserID = blockedByUserID;
        }

        @JsonProperty(value="blocked_user")
        public void setBlockedUser(User blockedUser) {
            this.blockedUser = blockedUser;
        }

        @JsonProperty(value="blocked_user_id")
        public void setBlockedUserID(String blockedUserID) {
            this.blockedUserID = blockedUserID;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(Date createdAt) {
            this.createdAt = createdAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockedUserResponse)) {
                return false;
            }
            BlockedUserResponse other = (BlockedUserResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            User this$blockedByUser = this.getBlockedByUser();
            User other$blockedByUser = other.getBlockedByUser();
            if (this$blockedByUser == null ? other$blockedByUser != null : !((Object)this$blockedByUser).equals(other$blockedByUser)) {
                return false;
            }
            String this$blockedByUserID = this.getBlockedByUserID();
            String other$blockedByUserID = other.getBlockedByUserID();
            if (this$blockedByUserID == null ? other$blockedByUserID != null : !this$blockedByUserID.equals(other$blockedByUserID)) {
                return false;
            }
            User this$blockedUser = this.getBlockedUser();
            User other$blockedUser = other.getBlockedUser();
            if (this$blockedUser == null ? other$blockedUser != null : !((Object)this$blockedUser).equals(other$blockedUser)) {
                return false;
            }
            String this$blockedUserID = this.getBlockedUserID();
            String other$blockedUserID = other.getBlockedUserID();
            if (this$blockedUserID == null ? other$blockedUserID != null : !this$blockedUserID.equals(other$blockedUserID)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BlockedUserResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            User $blockedByUser = this.getBlockedByUser();
            result = result * 59 + ($blockedByUser == null ? 43 : ((Object)$blockedByUser).hashCode());
            String $blockedByUserID = this.getBlockedByUserID();
            result = result * 59 + ($blockedByUserID == null ? 43 : $blockedByUserID.hashCode());
            User $blockedUser = this.getBlockedUser();
            result = result * 59 + ($blockedUser == null ? 43 : ((Object)$blockedUser).hashCode());
            String $blockedUserID = this.getBlockedUserID();
            result = result * 59 + ($blockedUserID == null ? 43 : $blockedUserID.hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            return result;
        }

        public String toString() {
            return "BlockUser.BlockedUserResponse(blockedByUser=" + this.getBlockedByUser() + ", blockedByUserID=" + this.getBlockedByUserID() + ", blockedUser=" + this.getBlockedUser() + ", blockedUserID=" + this.getBlockedUserID() + ", createdAt=" + this.getCreatedAt() + ")";
        }
    }

    public static class GetBlockedUsersResponse
    extends StreamResponseObject {
        @JsonProperty(value="blocks")
        private List<BlockedUserResponse> blockedUsers;

        public List<BlockedUserResponse> getBlockedUsers() {
            return this.blockedUsers;
        }

        @JsonProperty(value="blocks")
        public void setBlockedUsers(List<BlockedUserResponse> blockedUsers) {
            this.blockedUsers = blockedUsers;
        }

        @Override
        public String toString() {
            return "BlockUser.GetBlockedUsersResponse(blockedUsers=" + this.getBlockedUsers() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetBlockedUsersResponse)) {
                return false;
            }
            GetBlockedUsersResponse other = (GetBlockedUsersResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<BlockedUserResponse> this$blockedUsers = this.getBlockedUsers();
            List<BlockedUserResponse> other$blockedUsers = other.getBlockedUsers();
            return !(this$blockedUsers == null ? other$blockedUsers != null : !((Object)this$blockedUsers).equals(other$blockedUsers));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof GetBlockedUsersResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<BlockedUserResponse> $blockedUsers = this.getBlockedUsers();
            result = result * 59 + ($blockedUsers == null ? 43 : ((Object)$blockedUsers).hashCode());
            return result;
        }
    }

    public static class UnblockUserResponse
    extends StreamResponseObject {
        @Override
        public String toString() {
            return "BlockUser.UnblockUserResponse()";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnblockUserResponse)) {
                return false;
            }
            UnblockUserResponse other = (UnblockUserResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UnblockUserResponse;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class BlockUserResponse
    extends StreamResponseObject {
        @JsonProperty(value="blocked_by_user_id")
        private String blockedByUserID;
        @JsonProperty(value="blocked_user_id")
        private String blockedUserID;
        @JsonProperty(value="created_at")
        private Date createdAt;

        public String getBlockedByUserID() {
            return this.blockedByUserID;
        }

        public String getBlockedUserID() {
            return this.blockedUserID;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        @JsonProperty(value="blocked_by_user_id")
        public void setBlockedByUserID(String blockedByUserID) {
            this.blockedByUserID = blockedByUserID;
        }

        @JsonProperty(value="blocked_user_id")
        public void setBlockedUserID(String blockedUserID) {
            this.blockedUserID = blockedUserID;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(Date createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public String toString() {
            return "BlockUser.BlockUserResponse(blockedByUserID=" + this.getBlockedByUserID() + ", blockedUserID=" + this.getBlockedUserID() + ", createdAt=" + this.getCreatedAt() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockUserResponse)) {
                return false;
            }
            BlockUserResponse other = (BlockUserResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$blockedByUserID = this.getBlockedByUserID();
            String other$blockedByUserID = other.getBlockedByUserID();
            if (this$blockedByUserID == null ? other$blockedByUserID != null : !this$blockedByUserID.equals(other$blockedByUserID)) {
                return false;
            }
            String this$blockedUserID = this.getBlockedUserID();
            String other$blockedUserID = other.getBlockedUserID();
            if (this$blockedUserID == null ? other$blockedUserID != null : !this$blockedUserID.equals(other$blockedUserID)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BlockUserResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $blockedByUserID = this.getBlockedByUserID();
            result = result * 59 + ($blockedByUserID == null ? 43 : $blockedByUserID.hashCode());
            String $blockedUserID = this.getBlockedUserID();
            result = result * 59 + ($blockedUserID == null ? 43 : $blockedUserID.hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            return result;
        }
    }

    public static class UnblockUserRequestData {
        @JsonProperty(value="blocked_user_id")
        @NotNull
        private String blockedUserID;
        @JsonProperty(value="user_id")
        @NotNull
        private String userID;

        UnblockUserRequestData(@NotNull String blockedUserID, @NotNull String userID) {
            if (blockedUserID == null) {
                throw new NullPointerException("blockedUserID is marked non-null but is null");
            }
            if (userID == null) {
                throw new NullPointerException("userID is marked non-null but is null");
            }
            this.blockedUserID = blockedUserID;
            this.userID = userID;
        }

        public static class UnblockUserRequest
        extends StreamRequest<UnblockUserResponse> {
            private String blockedUserID;
            private String userID;

            @Override
            protected Call<UnblockUserResponse> generateCall(Client client) {
                UnblockUserRequestData data = this.internalBuild();
                return client.create(BlockUserService.class).unblockUser(data);
            }

            UnblockUserRequest() {
            }

            @JsonProperty(value="blocked_user_id")
            public UnblockUserRequest blockedUserID(@NotNull String blockedUserID) {
                if (blockedUserID == null) {
                    throw new NullPointerException("blockedUserID is marked non-null but is null");
                }
                this.blockedUserID = blockedUserID;
                return this;
            }

            @JsonProperty(value="user_id")
            public UnblockUserRequest userID(@NotNull String userID) {
                if (userID == null) {
                    throw new NullPointerException("userID is marked non-null but is null");
                }
                this.userID = userID;
                return this;
            }

            public UnblockUserRequestData internalBuild() {
                return new UnblockUserRequestData(this.blockedUserID, this.userID);
            }

            public String toString() {
                return "BlockUser.UnblockUserRequestData.UnblockUserRequest(blockedUserID=" + this.blockedUserID + ", userID=" + this.userID + ")";
            }
        }
    }

    public static class BlockUserRequestData {
        @JsonProperty(value="blocked_user_id")
        @NotNull
        private String blockedUserID;
        @JsonProperty(value="user_id")
        @NotNull
        private String userID;

        BlockUserRequestData(@NotNull String blockedUserID, @NotNull String userID) {
            if (blockedUserID == null) {
                throw new NullPointerException("blockedUserID is marked non-null but is null");
            }
            if (userID == null) {
                throw new NullPointerException("userID is marked non-null but is null");
            }
            this.blockedUserID = blockedUserID;
            this.userID = userID;
        }

        public static class BlockUserRequest
        extends StreamRequest<BlockUserResponse> {
            private String blockedUserID;
            private String userID;

            @Override
            protected Call<BlockUserResponse> generateCall(Client client) {
                BlockUserRequestData data = this.internalBuild();
                return client.create(BlockUserService.class).blockUser(data);
            }

            BlockUserRequest() {
            }

            @JsonProperty(value="blocked_user_id")
            public BlockUserRequest blockedUserID(@NotNull String blockedUserID) {
                if (blockedUserID == null) {
                    throw new NullPointerException("blockedUserID is marked non-null but is null");
                }
                this.blockedUserID = blockedUserID;
                return this;
            }

            @JsonProperty(value="user_id")
            public BlockUserRequest userID(@NotNull String userID) {
                if (userID == null) {
                    throw new NullPointerException("userID is marked non-null but is null");
                }
                this.userID = userID;
                return this;
            }

            public BlockUserRequestData internalBuild() {
                return new BlockUserRequestData(this.blockedUserID, this.userID);
            }

            public String toString() {
                return "BlockUser.BlockUserRequestData.BlockUserRequest(blockedUserID=" + this.blockedUserID + ", userID=" + this.userID + ")";
            }
        }
    }
}

